﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"];
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />


<script id="modal_select_equipment_list" type="text/x-handlebars-template">            

    <link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />    
    <link href="<%= ResolveUrl("~/app/templates/modal-select-equipment-list/modal-select-equipment-list.css")%>" rel="stylesheet" />

    <style type="text/css">        
        .new-metric{         
            width: 233px !important;
            padding-left: 10px !important;
            height: 30px !important;
            margin-left: -3px;
            border: 0.5px solid #ccc;
        }   
    </style>


    
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <span style="font-weight:bold;font-size: 22px;" data-bind="text: ModalTitle"> </span> 
    </div>
    <div style="height:580px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="min-height:530px;padding-bottom:0;" class="modal-body">      

            <div class="row-fluid" data-bind="classes: { hide: not(showPartList), }">
                
                
                <div class="row-fluid multipicker" data-bind="classes: { hide: any(not(subPartMode),spareMode) }">                    
                    <div class="span3">
                        <h4 class="details-labels">Part Type</h4>
                     </div>
                    <div class="span1">                    
                    </div>
                    <div class="span8" style="margin-left: -5px;">    
                        <div id="equipmentList2" style="margin-left:13px"></div>
                    </div>
                </div>
                

                <div class="row-fluid multipicker">                    
                    <div class="span3">
                        <h4 class="details-labels" data-bind="classes: { hide: not(selectMode), }"><asp:Localize runat=server meta:resourcekey=equipment_label/></h4>
                        <h4 class="details-labels" data-bind="classes: { hide: not(subPartMode), }">Part</h4>
                        
                        <h4 class="details-labels" data-bind="classes: { hide: any(not(addMode),spareMode), }"> <asp:Localize runat=server meta:resourcekey=part_type_label/></h4>
                        <h4 class="details-labels" data-bind="classes: { hide: not(fixMode), }"> <asp:Localize runat=server meta:resourcekey=metric_type_label/></h4>
                    </div>
                    <div class="span1">
                         <div data-bind="classes: { 'status-ok':       showStatusOk,     }"   style="float: left;margin-top: 10px !important;"></div>
                         <div data-bind="classes: { 'status-empty':    showStatusEmpty,  }"   style="float: left;margin-top: 10px !important;"></div>
                         <div data-bind="classes: { 'status-warning':  showStatusWarning,}"   style="float: left;margin-top: 10px !important;"></div>
                         <div data-bind="classes: { 'status-alert':    showStatusAlert,  }"   style="float: left;margin-top: 10px !important;"></div>
                    </div>
                    <div class="span8" style="margin-left: -5px;" data-bind="classes: { hide: spareMode }">       
                   
                        <div id="equipmentList" style="margin-left:13px"></div>
                    </div>
                </div>

                <hr data-bind="classes: { hide: any(selectMode,subPartMode), }"/>

                <div class="part-name row-fluid" data-bind="classes: { hide: any(selectMode,fixMode,subPartMode), }">
                    <div class="span3">
                        <h4 class="details-labels" data-bind="classes: { hide: not(addMode), }"> <asp:Localize runat=server meta:resourcekey=part_name_label/></h4>
                
                    </div>
                    <div class="span1"></div>
                    <div class="span8">
                        <input class="new-metric" id="newPartName" placeholder="New Part Name" data-bind="classes: { hide: not(addMode), }"/>
                    </div>
                </div>       

                <div class="metrics row-fluid" data-bind="classes: { hide: not(fixMode), }">
                    <div class="span3">
                        <h4 class="details-labels"> <asp:Localize runat=server meta:resourcekey=metric_label/></h4>
                
                    </div>
                    <div class="span1"></div>
                    <div class="span8">
                        <input class="new-metric" id="metric" placeholder="New Metric"/>
                    </div>
                </div>    




            </div>
            <hr  data-bind="classes: { hide: not(showPartList), }"/>
        </div>


        

        <div class="details-info" style="margin-top:-400px" data-bind="classes: { hide: any(not(hasData),isLoading, addMode,fixMode), nolistbox: not(showPartList)}">
            <div class="container-fluid">

                <div data-bind="classes: { 'status-ok':       showStatusOk,      strictHide: showPartList,}"           style="float: left;margin-top: 10px !important;"></div>
                <div data-bind="classes: { 'status-empty':    showStatusEmpty,   strictHide: showPartList,}"        style="float: left;margin-top: 10px !important;"></div>
                <div data-bind="classes: { 'status-warning':  showStatusWarning, strictHide: showPartList,}"      style="float: left;margin-top: 10px !important;"></div>
                <div data-bind="classes: { 'status-alert':    showStatusAlert,   strictHide: showPartList,}"        style="float: left;margin-top: 10px !important;"></div>
                <h4 data-bind="text: title,classes: { hide: showPartList, }" class="details-labels" ></h4>
                <hr data-bind="classes: { hide: showPartList, }"/>
                <div class="row-fluid"> 
                    <div class="main-info-grid-container grids-container"></div>
                </div>
               
            </div>
        
            <div class="container-fluid" style="margin-top:0vh !important;">
                <h4 class="details-labels">Metrics</h4>
                <hr />
                <%--<div class="row-fluid"> 
                    <div class="metrics-grid-container grids-container"></div>
                </div>--%>
                
                <div class="row-fluid">
                    <div class="grids-container">
                        <table class="grid-styles table">
                            <thead>
                           
                                <tr>
                                     <th rowspan="2" class="sortable renderable">
                                        <a>Metric</a>
                                        <b class="sort-caret"></b>
                                     </th>
                                    <th colspan="2" class="sortable renderable">
                                        <a>Campaign</a>
                                        <b class="sort-caret"></b>                            
                                    </th>
                                    <th colspan="2" class="sortable renderable">
                                        <a>Partial</a>
                                        <b class="sort-caret"></b>                            
                                    </th>
                                     <th colspan="2" class="sortable renderable">
                                        <a>Total</a>
                                        <b class="sort-caret"></b>                            
                                    </th>
                                </tr>
                                <tr>
                                     <th class="sortable renderable">
                                        <a>Current</a>
                                        <b class="sort-caret"></b>
                                    </th>
                                    <th class="sortable renderable">
                                        <a>Limits</a>
                                        <b class="sort-caret"></b>
                                    </th>
                                    <th class="sortable renderable">
                                        <a>Current</a>
                                        <b class="sort-caret"></b>
                                    </th>
                                    <th class="sortable renderable">
                                        <a>Limits</a>
                                        <b class="sort-caret"></b>
                                    </th>
                                    <th class="sortable renderable">
                                        <a>Current</a>
                                        <b class="sort-caret"></b>
                                    </th>
                                    <th class="sortable renderable">
                                        <a>Limits</a>
                                        <b class="sort-caret"></b>
                                    </th>
                                </tr>
                            </thead>
                            <tbody data-bind="collection: $metricsTableColl, itemView: 'metricsTableView'">
                
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="container-fluid" style="margin-top:0vh !important;">            
                <h4 class="details-labels">History</h4>
                <hr />
                <div class="row-fluid"> 
                    <div class="metrics-history-grid-container grids-container"></div>
                </div>
            </div>
      
        </div>

        <div class="pull-left" style="width:100%;margin-left:0;margin-top:-450px" data-bind="classes: { hide: any(addMode,fixMode), }">  
            <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:200px;">
                <div class="row-fluid" style="position:relative;top:100px;">
                    <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
                </div>
                <div class="row-fluid" style="position:relative;top:115px;">
                    <h3 style="font-size:50px;">
                        <asp:localize runat="server" meta:resourcekey="no_data_available" />
                    </h3>
                </div>
            </div>
            <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:200px;">
                <div class="row-fluid" style="position:relative;top:100px;">
                    <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                </div>
                <div class="row-fluid" style="position:relative;top:115px;">
                    <h3 style="font-size:50px;">
                        <asp:localize runat="server" meta:resourcekey="loading_data" />
                    </h3>
                </div>
            </div>
        </div>


        <div class="pull-left" style="width:100%;margin-left:0;margin-top:-350px" data-bind="classes: { hide: any(not(addMode),not(fixMode)), }">  
           
            <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:200px;">
                <div class="row-fluid" style="position:relative;top:100px;">
                    <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                </div>
                <div class="row-fluid" style="position:relative;top:115px;">
                    <h3 style="font-size:50px;">
                        <asp:localize runat="server" meta:resourcekey="loading_data" />
                    </h3>
                </div>
            </div>
        </div>


    </div>
    <div class="modal-footer">
         <button id="acceptBtn" class="btn btn-primary pull-left" style="width:200px;height:50px;" data-bind="classes: { hide: not(selectMode), }, disabled: any(isLoading,not(hasData))">
            <asp:Localize runat='server' meta:resourcekey='save_btn_label' />
        </button>
        <button id="acceptBtn" class="btn btn-primary pull-left" style="width:200px;height:50px;" data-bind="classes: { hide: not(subPartMode), }, disabled: any(isLoading,not(hasData))">
            <asp:Localize runat='server' meta:resourcekey='save_btn_label' />
        </button>
        <button id="acceptBtn" class="btn btn-danger pull-left" style="width:200px;height:50px;" data-bind="classes: { hide: not(removeMode), }, disabled: any(isLoading,not(hasData))">
            <asp:Localize runat='server' meta:resourcekey='remove_btn_label' />
        </button>
        <button id="acceptBtn" class="btn btn-danger pull-left" style="width:200px;height:50px;" data-bind="classes: { hide: not(resetMode), }, disabled: any(isLoading,not(hasData))">
            <asp:Localize runat='server' meta:resourcekey='reset_btn_label' />
        </button>
         <button id="acceptBtn" class="btn btn-primary pull-left" style="width:200px;height:50px;" data-bind="classes: { hide: any(not(addMode),spareMode), }, disabled: any(isLoading,not(hasData),isPartNameEmpty)">
            <asp:Localize runat='server' meta:resourcekey='save_part_btn_label' />
        </button>
        <button id="acceptBtn" class="btn btn-primary pull-left" style="width:200px;height:50px;" data-bind="classes: { hide: not(spareMode), }, disabled: any(isPartNameEmpty)">
            <asp:Localize runat='server' meta:resourcekey='save_part_btn_label' />
        </button>
        <button id="acceptBtn" class="btn btn-primary pull-left" style="width:200px;height:50px;" data-bind="classes: { hide: not(fixMode), }, disabled: any(isLoading,not(hasData),isMetricEmpty)">
            <asp:Localize runat='server' meta:resourcekey='save_metric_label' />
        </button>
        <button id="cancelBtn" class="btn btn-secondary" data-dismiss="modal" style="height:50px">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>
    </div>


    <script id="metricsTableViewTemplate" type="text/x-handlebars-template">
        <td class="spanrow1 gray-style" data-bind="text:metric"></td>
        <td class="spanrow2" data-bind="text:campaignCurrent, classes: { 'metric-status-alert': campaignStatusAlert, 'metric-status-warning':campaignStatusWarning }"></td>
        <td data-bind="text:campaignLimit,classes: { 'limit-max': limitMax, 'limit-min':limitMin }" class="gray-style"></td>
        <td class="spanrow3" data-bind="text:partialCurrent, classes: { 'metric-status-alert': partialStatusAlert, 'metric-status-warning':partialStatusWarning }"></td>
        <td data-bind="text:partialLimit,classes: { 'limit-max': limitMax, 'limit-min':limitMin }" class="gray-style"></td>
        <td class="spanrow4" data-bind="text:totalCurrent, classes: { 'metric-status-alert': totalStatusAlert, 'metric-status-warning':totalStatusWarning }"></td>
        <td data-bind="text:totalLimit,classes: { 'limit-max': limitMax, 'limit-min':limitMin }" class="gray-style"></td>
      
    </script>
    
</script>
