﻿define([
    "app-config",
    "jed", 
], function (app_config, Jed) {
    var landing = {
        i18n: {
            global: null
        }, //i18n: using jed.js for internationalization client side (using gettext)
        //i18n: will contain translation jed objects for every view.
    }; 

    landing.getI18NJed = function (ins, templateName, onSuccess, hasI18N, customPath) {
        //scoped this
        var that = this;

        //default values
        hasI18N = typeof hasI18N !== 'undefined' ? hasI18N : true;
        customPath = typeof customPath !== 'undefined' ? customPath : null;

        var templateID = (customPath) ? customPath + templateName : templateName;

        if ((!this.i18n[templateID]) && hasI18N) {
            var urlForI18N = app_config.foldersRoot + '/app/i18n/resx2json.aspx?path=' + templateName + ((customPath) ? "&customPath=" + customPath : "");
            $.ajax({
                url: urlForI18N,
                dataType: "json",
                success: function (data) {
                    if (data) {
                        var i18nJED = new Jed({
                            // You can choose to set the domain at instantiation time
                            // If you don't, then "messages" will be used by default
                            "domain": "messages",
                            // This callback is called when a key is missing
                            "missing_key_callback": function (key) {
                                // Do something with the missing key
                                // e.g. send key to web service or
                                console.error(key)
                            },

                            // This is the translation data, which is often generated by
                            // a po2json converter. You would ideally have one per locale
                            // and only pull in the locale_data that you need.
                            "locale_data": data
                        });
                        //storing jed object for cache
                        that.i18n[templateID] = i18nJED;

                        onSuccess(that.i18n[templateID]);
                    } else {
                        //if (onFailure) onFailure();
                    }
                },
                async: false,
            });
        } else if (this.i18n[templateID]) {
            onSuccess(this.i18n[templateID]);
        } else if (!hasI18N) {
            onSuccess(this.i18n.default_jed);
        }
    };

    return landing; 
}); 