﻿/// <reference path="../../assets/libs/jam/jquery/dist/jquery.js" />
///
require(["app-config"], function (app_config) {
    $().ready(function () {
        // carousel demo
        $('#shop_carousel').carousel({ interval: 3000 });

        initCart(); 
    });

    function initCart() {
        simpleCart({
            update: refreshCart
        });

        $(".empty-cart").click(emptyCart); 
        $(".add-to-cart-btn").click(addItem);

        refreshCart(); 
    };

    function emptyCart() {
        animate = true; 
        simpleCart.empty(); 
    }

    function _s(str){
        return (str != null && str != undefined && (Object.prototype.toString.call(str) === '[object String]') &&
            str.trim() != ""); 
    }

    function addItem(e) {
        animate = true;
        var $target = $(e.target);
        var $item = $(e.target).parents("[data-item]"); 
        var $cart = $(".shopping-cart-icon"); 

        if ($target && $item.length > 0 && ($item = $($item.get(0)))) {
            if (_s($item.data("itemname")) && _s($item.data("itemprice"))
                && _s($item.data("itemtype"))) {
                var item = {
                    name: $item.data("itemname")
                    , price: parseFloat($item.data("itemprice"))
                    , quantity: 1
                    , id: $item.data("itemid")
                    //, maxQuantity: null
                    , item_number: parseInt($item.data("itemnumber"))
                    , type: $item.data("itemtype")
                    , checkoutCustomParams: null
                };

                simpleCart.add(item);
            } else {
                throw "missing data attributes"; 
            }
        }
    }

    var animate = false; 
    function refreshCart() {
        var quantity = simpleCart.quantity();
        var total = simpleCart.total();

        if (animate) {
            $(".cart-count-bubble").removeClass("spin-it").outerWidth($(".cart-count-bubble").outerWidth()).addClass("spin-it");
            $(".shopping-cart-icon").removeClass("rubberBand").outerWidth($(".shopping-cart-icon").outerWidth()).addClass("rubberBand");
        }

        $(".cart-count-bubble").text(quantity);
        $(".cart-total-items").text(quantity);
        $(".cart-total").text(total); 
    }; 

    function a(){

        $('.add-to-cart').on('click', function () {
            var cart = $('.shopping-cart');
            var imgtodrag = $(this).parent('.item').find("img").eq(0);
            if (imgtodrag) {
                var imgclone = imgtodrag.clone()
                    .offset({
                        top: imgtodrag.offset().top,
                        left: imgtodrag.offset().left
                    })
                    .css({
                        'opacity': '0.5',
                        'position': 'absolute',
                        'height': '150px',
                        'width': '150px',
                        'z-index': '100'
                    })
                    .appendTo($('body'))
                    .animate({
                        'top': cart.offset().top + 10,
                        'left': cart.offset().left + 10,
                        'width': 75,
                        'height': 75
                    }, 1000, 'easeInOutExpo');

                setTimeout(function () {
                    cart.effect("shake", {
                        times: 2
                    }, 200);
                }, 1500);

                imgclone.animate({
                    'width': 0,
                    'height': 0
                }, function () {
                    $(this).detach()
                });
            }
        });

    }

}); 