using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Globalization;
using System.IO;
using System.Reflection;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.ServiceModel.Web;
using System.Text;
using System.Web.Script.Serialization;
using System.Net;
using System.Web;
using System.Web.Security;
using log4net;
using Helpers.Log;

[ServiceContract]
public interface ILogService
{   
    [OperationContract, WebInvoke(Method="POST", UriTemplate = "Debug", ResponseFormat=WebMessageFormat.Json)]
    LogResponse Debug(LogParams parameters);

    [OperationContract, WebInvoke(Method = "POST", UriTemplate = "Error", ResponseFormat=WebMessageFormat.Json)]
    LogResponse Error(LogParams parameters);
}

public class LogParams{
    public String msg { get; set; }
    public String loggerName { get; set; }
}

public class LogResponse
{
    public Boolean success { get; set; }
    public String exception { get; set; }
}

[System.ServiceModel.Activation.AspNetCompatibilityRequirements(RequirementsMode = System.ServiceModel.Activation.AspNetCompatibilityRequirementsMode.Allowed)]
public partial class LogService : ILogService
{
    private ILog classLoger = Logger.GetLogger(MethodBase.GetCurrentMethod().DeclaringType.Name);
    /// <summary>
    /// </summary>
    public LogResponse Debug(LogParams parameters)
    {
        try
        {
            ILog logger = Logger.GetLogger(parameters.loggerName);
            logger.Debug(parameters.msg); 
            return new LogResponse() { success = true }; 
        }
        catch (Exception ex)
        {
            this.classLoger.Error(ex); 
            return new LogResponse() { success = false, exception = ex.Message.ToString() }; 
        }
    }

    public LogResponse Error(LogParams parameters)
    {
        try
        {
            ILog logger = Logger.GetLogger(parameters.loggerName);
            logger.Error(parameters.msg);
            return new LogResponse() { success = true }; 
        }
        catch (Exception ex)
        {
            this.classLoger.Error(ex);
            return new LogResponse() { success = false, exception = ex.Message.ToString() }; 
        }
    }
}