//Version: 1.0.0
//This code fix the issue on IE when a textbox does not fire the change event when enter key is pressed.

define(['jquery'], function (jQuery) {

!function($){

    'use strict';

    function versionIE () {
        var ua = window.navigator.userAgent;

        var msie = ua.indexOf('MSIE ');
        if (msie > 0) {
            // IE 10 or older => return version number
            return parseInt(ua.substring(msie + 5, ua.indexOf('.', msie)), 10);
        }

        var trident = ua.indexOf('Trident/');
        if (trident > 0) {
            // IE 11 => return version number
            var rv = ua.indexOf('rv:');
            return parseInt(ua.substring(rv + 3, ua.indexOf('.', rv)), 10);
        }

        var edge = ua.indexOf('Edge/');
        if (edge > 0) {
            // Edge (IE 12+) => return version number
            return parseInt(ua.substring(edge + 5, ua.indexOf('.', edge)), 10);
        }

        // other browser
        return false;
    }

    // Fix lack of a change event on Enter in oldIE
    if (!window.changeOnEnter) {
        window.changeOnEnter = true;

        var ieVersion = versionIE();

        if ((ieVersion) && (ieVersion < 12)) {
            $(document)
                .on('change input[type=text]', function (e) {
                    try {
                        var target$ = $(e.target);

                        target$.data('value', target$.val());
                    }
                    catch (Error) { console.error(Error.stack); }
                })
                .on('keyup input[type=text]', function (e) {
                    try {
                        var target$ = $(e.target);

                        if (e.which === 13 && target$.val() != target$.data('value')) {
                            target$.trigger('change');
                        }
                    }
                    catch (Error) { console.error(Error.stack); }
                });
        }
    }

}(jQuery);

});