﻿using Helpers.Log;
using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Web;
using System.Web.Script.Serialization;
using System.Web.UI;
using System.IO;
using System.Web.UI.WebControls;
using System.Xml.Linq;

public partial class app_custom_screens_IHConfiguration_data_sources_configuration_v2_api_local_agents : System.Web.UI.Page
{
    private JavaScriptSerializer jss = new JavaScriptSerializer();
    private ILog logger = Logger.GetLogger(MethodBase.GetCurrentMethod().DeclaringType.Name);
    
    protected void Page_Load(object sender, EventArgs e)
    {
        object response = null;

        try
        {
            string action = Request.Form["action"];
            string accountNumber = Request.Form["accountNumber"]; 

            if (action != null)
            {
                switch (action.ToString().ToUpper())
                {
                    case "REMOVE_OEE_DEMO":
                        this.RemoveOEEAgent();
                        response = new Response();
                        break; 
                    case "ADD_LOCAL_PLC":
                        string name1 = Request.Form["AgentName"];
                        this.AddLocalPLC(name1);
                        response = new Response();
                        break;
                    case "REMOVE_LOCAL_PLC":
                        string name2 = Request.Form["AgentName"];
                        this.RemoveLocalPLC(name2);
                        response = new Response();
                        break;
                }
            }
            else
            {
                response = new Response
                {
                    Success = false,
                    Message = "Parameter 'Action' can not be empty or null.",
                };
            }
        }
        catch (Exception ex)
        {
            response = new Response
            {
                Success = false,
                Message = ex.Message,
            };

            this.logger.Error(ex);
        }

        Response.Clear();
        Response.ContentType = "application/json; charset=utf-8";
        Response.Write(jss.Serialize(response));
        Response.End();
    }

    private void RemoveOEEAgent()
    {
        IhBoxSystemtConfiguration.RemoveOEEAgent(); 
    }

    private void AddLocalPLC(string name, string accountNumber = "100020")
    {
        IhBoxSystemtConfiguration.AddLocalPLC(name, accountNumber); 
    }

    private void RemoveLocalPLC(string name)
    {
        IhBoxSystemtConfiguration.RemoveLocalPLC(name);
    }
}