﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<% 
    if (Session["SecurityData"] == null)
    {
        Session["SecurityData"] = WebApp.GetSecurityData();
    }
    WebApp.SecurityData securityData = (WebApp.SecurityData) Session["SecurityData"];
    bool writePermission = securityData.GetModuleActionValue("ihconfiguration_security_profiles", "write"); 
%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/IHConfiguration/security/profiles/profiles.css") %>" rel="stylesheet" />
<style>
    
</style>

<div class="container-fluid">
    <div class="row-fluid profileWrapper">
        <div class="span5">
            <div class="row-fluid titleProfile" style="display:inline-block;">
                <h4 style="display:inline-block"><asp:localize runat="server" meta:resourcekey="profiles_label" /></h4>
                <% if (writePermission){ %>
               <button class="addProfile btn btn-primary" style="" label="addNew" btn="">Add New</button>
                <% } %>
            </div>
            <div class="row-fluid">
                <div class="profiles-grid-container span8">
                    <div class="tableProfileContainer"></div>
                </div>
                <div class="span4 modules-actions-tree-view-container">
                    <div class="searchPermissionInput" data-bind="classes: { hide: not(showFilterPerm) },">
                    <input type="text" id="searchPermissionInput" placeholder="Search for permissions..." >
                        </div>
                </div>  
            </div>
        </div>
        <div class="span7">
        </div>
    </div>

</div>


<script id="actions_cell_template" type="text/x-handlebars-template">
    <div style="text-align:right;">
        <% if (writePermission){ %>
        {{HBExp '#ifEquals mode "NEW"'}}
            <button data-preventclick="true" data-toggle="tooltip" data-placement="bottom" data-cell-action="SAVECHANGES" title="<asp:Localize runat=server meta:resourcekey=save_changes_title />" class="btn btn-cell-action btn-small btn-save-changes"><i class="fa fa-floppy-o"></i></button>
            <button data-preventclick="true" data-toggle="tooltip" data-placement="bottom" data-cell-action="DISCARDCHANGES" title="<asp:Localize runat=server meta:resourcekey=discard_changes_title />" class="btn btn-cell-action btn-small btn-discard-changes"><i class="fa fa-times"></i></button>
        {{HBExp '/ifEquals'}}
        {{HBExp '#ifEquals mode "EDIT"'}}
            <button data-preventclick="true" data-toggle="tooltip" data-placement="bottom" data-cell-action="DISCARDCHANGES" title="<asp:Localize runat=server meta:resourcekey=discard_changes_title />" class="btn btn-cell-action btn-small btn-discard-changes"><i class="fa fa-times"></i></button>
        {{HBExp '/ifEquals'}}
        {{HBExp '#ifEquals mode "READ"'}}
            <button data-preventclick="true" data-toggle="tooltip" data-placement="bottom" data-cell-action="EDIT" title="<asp:Localize runat=server meta:resourcekey=edit_row_title />" class="btn btn-cell-action btn-small btn-remove"><i class="fa fa-pencil-square-o"></i></button>    
            <button data-preventclick="true" data-toggle="tooltip" data-placement="bottom" data-cell-action="DELETE" title="<asp:Localize runat=server meta:resourcekey=remove_row_title />" class="btn btn-cell-action btn-small btn-remove"><i class="fa fa-trash-o"></i></button>
        {{HBExp '/ifEquals'}}
        <% } %>
    </div>
</script>

<script id="modules_actions_tree_view" type="text/x-handlebars-template">
    <div class="modules-actions-tree-container">
    </div>
</script>

<script id="module_actions_configuration" type="text/x-handlebars-template">
    <div class="container-fluid">
        <div class="actions-grid-container">
        </div>
    </div>
</script>

<script id="custom_module_action_configuration" type="text/x-handlebars-template">
    <div class="control-group" style="margin-bottom:5px !important;">
        <label class="control-label mini-control-label" data-bind="text: name"></label>
        <div class="controls mini-controls">
            <input type="checkbox" data-bind="checked: value, attr: { value: id }" />
        </div>
    </div>
</script>