﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<style>

    .backgrid th{
        font-size:10px !important;
    }

    .backgrid tr{
        font-size:10px !important;
    }

        .backgrid tr td{
            /*overflow:visible !important;*/
        }

        .backgrid tr td button{
            font-size:12px !important;
        }

        .commands-grid .backgrid th.response,
        .commands-grid .backgrid td.response {
            overflow: hidden;
            white-space: nowrap;
            max-width: 335px;
        }
    

</style>

<div class="container-fluid">
    <div class="row-fluid">
        <h3>Send command</h3>
    </div>
    <div class="row-fluid">
        <h4>Agent</h4>
        <form class="form-horizontal">
            <select data-bind="value: integer(agentId), options: agentsList" class="agents"></select>
            <input autofocus class="input-large command-text" type="text" data-bind="value: commandText" />
            <button class="btn btn-send-command">Send Command</button>
            <button class="btn btn-clear-command">Clear</button>
        </form>
    </div>
    <div class="row-fluid">
        <h4>DOT</h4><label style="width:150px;"><input type="checkbox" data-bind="checked: dotmChecked" /> Mesh Command</label>
        <form class="form-horizontal">
            <select data-bind="value: integer(dotId), options: dotsList" class="dots"></select>
            <input class="input-large dot-command-text" type="text" data-bind="value: dotCommandText" />
            <button class="btn btn-send-dot-command">Send Command</button>
            <button class="btn btn-clear-dot-command">Clear</button>
        </form>
    </div>
    <div>
        <button data-command-text="0308" class="btn btn-dot-command btn-medium btn-success">Run 0308</button>
        <button data-command-text="0300" class="btn btn-dot-command btn-medium btn-danger">Stop 0300</button>
        <button data-command-text="04" class="btn btn-dot-command btn-medium btn-warning">Error 04</button>
    </div>
    <hr />
    <div class="row-fluid">
        <div class="span12 commands-grid"></div>
    </div>
</div>

<script id="command_cell_template" type="text/x-handlebars-template">
    <div style="width:100px;" class="row-fluid">
        <div class="span4">
            <div class="btn-group">
                {{HBExp '#ifEqualsAny status "SCHD" "SENT"'}}
                <button class="action-source-btn btn dropdown-toggle" data-toggle="dropdown" data-open="false">
                    <i style="font-size:16px;position:relative;top:3px;" class="fa fa-ellipsis-h"></i>
                </button>
                <ul class="dropdown-menu action-source-dropdown" style="font-size: 12px;">
                    <li style="cursor:pointer;"><a class="btn-dropdown-action-option" data-option="cmd-cancel">Cancel</a></li>
                </ul>
                {{HBExp '/ifEqualsAny'}}
            </div>
        </div>
    </div>
</script>