﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />


<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(not(hasData), not(isLoading), isNull(itemId))), }," style="height:500px;">
    <div class="row-fluid" style="position:relative;top:100px;">
        <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:115px;">
        <h3 style="font-size:50px;">
            <asp:localize runat=server meta:resourcekey="no_data_available" />
        </h3>
    </div>
</div>
<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(isLoading, isNull(itemId))), }," style="height:500px;">
    <div class="row-fluid" style="position:relative;top:100px;">
        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:115px;">
        <h3 style="font-size:50px;">
            <asp:localize runat=server meta:resourcekey="loading_data" />
        </h3>
    </div>
</div>
<div class="row-fluid items-grid-container infinite-container" data-bind="classes: { hide: not(all(hasData, not(isLoading), isNull(itemId))), },"></div>

<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(not(isLoadingItemData), not(hasItemData), isNotNull(itemId))), }," style="height:500px;">
    <div class="row-fluid" style="position:relative;top:100px;">
        <i class="fa fa-times fw-icon-4x" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:115px;">
        <h3 style="font-size:50px;">
            <asp:localize runat=server meta:resourcekey="item_not_exist" />
        </h3>
    </div>
</div>
<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(isLoadingItemData, isNotNull(itemId))), }," style="height:250px;">
    <div class="row-fluid" style="position:relative;top:30px;">
        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:50px;">
        <h3 style="font-size:50px;">
            <asp:localize runat=server meta:resourcekey="loading_data" />
        </h3>
    </div>
</div>
<div class="row-fluid" data-bind="classes: { hide: not(all(not(isLoadingItemData), hasItemData, isNotNull(itemId))), },">
    <div class="row-fluid">
        <div class="form-horizontal row-fluid form-info">
            <div class="form-data-row">
                <div class="form-data-group">
                    <label class="control-label form-field-label"><asp:Localize runat=server meta:resourcekey=item_name_label /></label>
                    <input type="text" readonly="readonly" class="form-field-value" data-bind="value: trim(item_name)," />
                </div>
            </div>
        </div>
    </div>
    <div class="row-fluid">
        <div class="row-fluid chemistry-grid-container"></div>
</div>

<script id="actions_cell_template" type="text/x-handlebars-template">
    <div class="text-center">
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="SAVE" title="<asp:Localize runat=server meta:resourcekey=save_title />" class="btn btn-cell-action btn-small btn-save hide"><i class="fa fa-floppy-o"></i></button>
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DISCARD" title="<asp:Localize runat=server meta:resourcekey=discard_title />" class="btn btn-cell-action btn-small btn-discard hide"><i class="fa fa-times"></i></button>
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="EDIT_DETAILS" title="<asp:Localize runat=server meta:resourcekey=edit_details_title />" class="btn btn-cell-action btn-small btn-edit-details"><i class="fa fa-pencil-square-o"></i></button>
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DELETE" title="<asp:Localize runat=server meta:resourcekey=remove_batch_title />" class="btn btn-cell-action btn-small btn-remove"><i class="fa fa-trash-o"></i></button>
    </div>
</script>

<script id="subnavbar_controls" type="text/x-handlebars-template">
    <div class="span12">
        <div class="subnavbar-toolbar form-inline">
            <button class="btn add-item" style="margin:0;" data-bind="classes: { hide: not(not(itemId)), },">
                <asp:Localize runat=server meta:resourcekey=add_item_btn_label />
            </button>
            <label class="control-label" data-bind="classes: { hide: not(isNull(itemId)), },">
                <asp:localize runat=server meta:resourcekey="search_label" />
                <input type="text" id="searchTbx" class="input-big clear-search" data-bind="value: trim(search)," placeholder="<asp:Localize runat=server meta:resourcekey=search_place_holder />" />
            </label>
            <button id="cancelBtn" data-bind="classes: { hide: not(isNotNull(itemId)), }," class="btn pull-right">
                <asp:localize runat=server meta:resourcekey=cancel_item_details_edition_btn_label />
            </button>
            <button id="saveBtn" data-bind="enabled: hasItemData, classes: { hide: not(isNotNull(itemId)), }," class="btn btn-primary pull-right">
                <asp:localize runat=server meta:resourcekey=save_item_details_edition_btn_label />
            </button>
        </div>
    </div>
</script>