-------------
-- ROLES
-------------
	USE [IHBoxSystem]
	GO
	CREATE ROLE casterequipmentstree_read AUTHORIZATION dbo 
	GO  

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'casterequipmentstree_read', 'admin'
	GO

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'casterequipmentstree_read', 'SDI/australtek'
	GO


	CREATE ROLE casterequipmentstree_readWrite AUTHORIZATION dbo 
	GO  

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'casterequipmentstree_readWrite', 'admin'
	GO

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'casterequipmentstree_readWrite', 'SDI/australtek'
	GO


-------------------
-- Menu and Route
-------------------
	declare @parent int, @result_routeId INT
	select @parent=id from [FrontEnd].[Menu] where [Name] = 'Caster' and Parent is null

	INSERT INTO [FrontEnd].[Routes]
			   ([Route]
			   ,[ModuleName]
			   ,[ModulePath]
			   ,[RequiredRole]
		   )
		 VALUES 
			   (
			   '!/caster-equipments-tree(/)'
			   ,  'caster-equipments-tree'
			   , 'custom-screens/caster-equipments-tree/'
			   , 'casterequipmentstree_read'           
			   )
			   SET @result_routeId = @@IDENTITY
	INSERT INTO [FrontEnd].[Menu]
			   ([Parent]
			   ,[Name]
			   ,[RouteID]
			   ,[SortOrder]
			   ,[Enabled]
			   ,[Visible]
			   ,[RequiredRole]
			   ,[Group]
			  )
		 VALUES
			   (
			   @parent
			   ,'Equipments Tree'
			   ,@result_routeId 
			   ,1
			   ,1
			   ,1
			   ,'casterequipmentstree_read'
			   ,NULL
			 )
	GO


-------------------
-- SP Permissions
-------------------
EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_readWrite] -- The role
,@name = N'securedsp-EQP.GetPartsTree' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_read] -- The role
,@name = N'securedsp-EQP.GetPartsTree' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_readWrite] -- The role
,@name = N'securedsp-EQP.GetPartMetrics' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_read] -- The role
,@name = N'securedsp-EQP.GetPartMetrics' -- the procedure
,@value = N'' 
GO



EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_readWrite] -- The role
,@name = N'securedsp-EQP.MovePart' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_read] -- The role
,@name = N'securedsp-EQP.MovePart' -- the procedure
,@value = N'' 
GO


EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_readWrite] -- The role
,@name = N'securedsp-EQP.RemovePart' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_read] -- The role
,@name = N'securedsp-EQP.RemovePart' -- the procedure
,@value = N'' 
GO



EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_readWrite] -- The role
,@name = N'securedsp-EQP.ResetPart' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_read] -- The role
,@name = N'securedsp-EQP.ResetPart' -- the procedure
,@value = N'' 
GO


EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_readWrite] -- The role
,@name = N'securedsp-EQP.GetPartDetails' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_read] -- The role
,@name = N'securedsp-EQP.GetPartDetails' -- the procedure
,@value = N'' 
GO



EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_readWrite] -- The role
,@name = N'securedsp-EQP.GetAvailableParts' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_read] -- The role
,@name = N'securedsp-EQP.GetAvailableParts' -- the procedure
,@value = N'' 
GO



EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_readWrite] -- The role
,@name = N'securedsp-EQP.GetCurrentPartsTreeWeb' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_read] -- The role
,@name = N'securedsp-EQP.GetCurrentPartsTreeWeb' -- the procedure
,@value = N'' 
GO


EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_readWrite] -- The role
,@name = N'securedsp-EQP.CreatePartWeb' -- the procedure
,@value = N'' 
GO

--EXECUTE sys.sp_addextendedproperty 
--@level0type = N'USER' -- The object type
--,@level0name = [casterequipmentstree_read] -- The role
--,@name = N'securedsp-EQP.CreatePartWeb' -- the procedure
--,@value = N'' 
--GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_readWrite] -- The role
,@name = N'securedsp-EQP.GetMetricTypes' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_read] -- The role
,@name = N'securedsp-EQP.GetMetricTypes' -- the procedure
,@value = N'' 
GO


EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_readWrite] -- The role
,@name = N'securedsp-EQP.FixPartialMetric' -- the procedure
,@value = N'' 
GO

--EXECUTE sys.sp_addextendedproperty 
--@level0type = N'USER' -- The object type
--,@level0name = [casterequipmentstree_read] -- The role
--,@name = N'securedsp-EQP.FixPartialMetric' -- the procedure
--,@value = N'' 
--GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_readWrite] -- The role
,@name = N'securedsp-EQP.GetPartTypes' -- the procedure
,@value = N'' 
GO


EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [casterequipmentstree_read] -- The role
,@name = N'securedsp-EQP.GetPartTypes' -- the procedure
,@value = N'' 
GO






-------------------
--	Profiles
-------------------
	USE [IHBoxSystem]
	GO

	DECLARE @ModuleId INT

	INSERT INTO [SECURITY].[Modules]([Code],[Name])
	VALUES('caster_equipments_tree','Caster Equipments Tree')

	SET @ModuleId = @@IDENTITY

	INSERT INTO [SECURITY].[ModuleActions]([ModuleId],[Code],[Name],[Role])
	VALUES(@ModuleId,'readWrite','Read/Write','casterequipmentstree_readWrite')


	INSERT INTO [SECURITY].ModuleActions(ModuleId,Code,[Name],[Role])
	VALUES (@ModuleId,'read','Read','casterequipmentstree_read')




	---------------
	---- METRICS
	---------------

		declare @Metrics	  table ([Type] char(1)		 ,[Metric] varchar(10),[PartialCurrent] float,[TotalCurrent] float, [PartialStatus] char(1), [TotalStatus] char(1))
		declare @MetricLimits table ([MetricType] char(1),[PartialLimit] float,[TotalLimit] float,[LimitType] CHAR(3))

		insert into @Metrics
		values
		 ('H','Heats',365,580,'O','O')
		,('T','Tons',365,580,'W','A')
		,('C','Contact',365,580,'A','W')
		,('L','Length',365,580,'W','A')

		insert into @MetricLimits
		values
		 ('H',100,500,'MAX')  --Heats Limit : Max
		,('H',50,250 ,'MIN')	--Heats Limit : Min	
		,('T',100,500,'MAX')  --Tons Limit : Max
		,('T',50,250 ,'MIN')	--Tons Limit : Min		
		,('C',100,500,'MAX')	--Contact Limit : Max
		,('C',50,250 ,'MIN')	--Contact Limit : Min		
		,('L',100,500,'MAX')	--Length Limit : Max
		,('L',50,250 ,'MIN')	--Length Limit : Min	


		select * from @Metrics
		select * from @MetricLimits


