﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
   
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
 
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<link href="<%= ResolveUrl("~/assets/libs/js/select2/select2.min.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/select2/select2totree.css") %>" rel="stylesheet" />

<%-- SCREEN --%>
<div class="subnavbar fixed-subnavbar" style="width:70%;margin-top: -10px;">
    <div class="form-inline">    
         <button class="formbold-btn shift-nav-btn" id="backNavBtn" data-bind="disabled: isLoading" >                
           <i class="fa fa-arrow-circle-left" aria-hidden="true"></i>
            Previous Shift
        </button>
        <label for="date" class="shift-nav-label" style="margin-top:10px;margin-left:10px;margin-right:10px;"> Date </label>
        <label class="input-prepend" id="date" >
            <span class="add-on" style="height:30px;line-height:30px;"><i class="icon-calendar"></i></span>
            <input type="text" id="productionDateTbx" class="input-date picker-input-date" style="height:30px;text-align: center;width:75px;z-index:1000;" data-bind="value: productionDate, disabled: isLoading ">
        </label>
       
        
        <label for="shift" class="shift-nav-label" style="margin-top:10px;margin-left:10px;margin-right:10px;cursor: pointer;"> Shift </label>
        <div class="shift-input">
            <input id="shift" type="text" style="width:30px; text-align:center;height:30px;margin-right:10px;cursor: pointer;" data-bind="value:shiftId, disabled: isLoading"  readonly />
        
            <%--<span class="tooltip-shift" data-bind="classes: { hideTooltip: (enableForm), }">Click to change</span>--%>
        </div>
        
         <button class="formbold-btn shift-nav-btn" id="forwardNavBtn" data-bind="disabled: isLoading">
                Next Shift
                <i class="fa fa-arrow-circle-right" aria-hidden="true"></i>
            </button>
     
        
    </div>
</div>

<%-- LOADING and NO DATA AVAILABLE --%>
<div class="row-fluid screen-content">
    <div class="no-data-poster row-fluid text-center animated fadeIn " data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:200px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:215px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div> 
    <div class="no-data-poster row-fluid text-center animated fadeIn " data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:200px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:215px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
</div>

<script id="TimelineViewTemplate" type="text/x-handlebars-template">
    <label data-bind="text:Timestamp" class="time"></label>
    <label data-bind="text:TruncatedTitle" class="title"></label>
    <label data-bind="text:TruncatedDescription" class="description"></label>
</script>




<%-- SCREEN CONTENT --%>
<div class=" screen-content" >   
    <div class="split-left left  left-content" style="margin-top:5.2%">
        <div class="no-data-poster row-fluid text-center animated fadeIn " data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
            <div class="row-fluid" style="position:relative;top:100px;">
                <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
            </div>
            <div class="row-fluid" style="position:relative;top:115px;">
                <h3 style="font-size:50px;">
                    <asp:localize runat="server" meta:resourcekey="no_data_available" />
                </h3>
            </div>
        </div>
        <div class="no-data-poster row-fluid text-center animated fadeIn " data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
            <div class="row-fluid" style="position:relative;top:100px;">
                <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
            </div>
            <div class="row-fluid" style="position:relative;top:115px;">
                <h3 style="font-size:50px;">
                    <asp:localize runat="server" meta:resourcekey="loading_data" />
                </h3>
            </div>
        </div>   
        <div class="timeline" data-bind="classes: { hide: any(not(hasData), isLoading), }">
            <div class="row-fluid">
                <div class="span6">
                    <div class="caster1-items-grid-container  items-grid-container" ></div>
                </div> 
                <div class="span6" >     
                        <div class="caster2-items-grid-container  items-grid-container" ></div>           
                </div> 
            </div>                    
        </div>
        
        <div class="floating-button" id="createNewEntryBtn" data-bind="classes: { hide: isLoading }">
            +
            <span class="tooltip">Add New Entry</span>
        </div>
    </div> 

      
    <div class="split-right right container-form" style="margin-top:2.1%" > 
       <%-- <div class="container-form-tooltip" data-bind="classes: { hideTooltip: (enableForm), }">
           <div class="tooltip-form"> 
               <i class="fa fa-arrow-circle-left" aria-hidden="true"></i>
               Select an entry 
           </div>
        </div>--%>
        <div class="formbold-main-wrapper" id="myReusableCode">
            <div class="formbold-form-wrapper">
                
                <form id="logbook-form">  

                    <div class="formbold-form-step-1 ">

                        <div class="titleContainer">
                            <label for="title" class="formbold-form-label"> Title </label>
                            <input
                                type="text"
                                name="title"
                                id="title"
                                placeholder="Add Title"
                                class="formbold-form-input title-input"
                                data-bind="value: itemTitle,disabled: not(enableForm)"
                            />
                        </div>
                       
                        <div class="equipment-tree-select">
                            <div>
                                <label class="formbold-form-label"> Equipment </label>
                                <select 
                                    id="treeSelectContainer" 
                                    class="formbold-form-select"                                    
                              
                                    >
                                </select>
                            </div>
                        </div>
                      
                        <div class="formbold-input-flex">
                        <div class="formbold-input-group">
                            <label class="formbold-form-label"> Status </label>
                            <select 
                                id="status" 
                                name="status" 
                                class="formbold-form-select"            
                                >
                            </select>
                        </div>
                        <div class="formbold-input-group">
                            <label class="formbold-form-label"> Type </label>                            
                            <select 
                                id="type" 
                                name="type" 
                                class="formbold-form-select"
                                >
                            </select>
                        </div>
                      </div>
               

                        <div class="formbold-input-flex">
                            <div class="formbold-input-flex">
                                <div>
                                    <label class="formbold-form-label"> Date </label>
                                    <label class="input-prepend">
                                        <span class="add-on" style="height:38px;line-height:38px;"><i class="icon-calendar"></i></span>
                                        <input 
                                            type="text" 
                                            id="dateForm" 
                                            class="input-date"
                                            style="height: 38px;text-align: center;width: 75px;z-index: 1000;"
                                            data-bind="value: itemDate, disabled: not(enableForm)"
                                            />
                                    </label>   
                                </div>
                                <div>
                                    <label class="formbold-form-label"> Time </label>
                                    <div class="input-group bootstrap-timepicker timepicker">
                                         <label class="input-prepend"> 
                                             <span class="add-on" style="height:38px;line-height:38px;"><i class="icon-time"></i></span>
                                            <input 
                                                id="timeForm" 
                                                type="text" 
                                                class="form-control input-small" 
                                                style=" height: 38px;text-align: center;width: 60px;"
                                                data-bind="value: itemTime, disabled: not(enableForm)"
                                                
                                                />
                                         </label>                        
                                    </div>
                                </div>
                            </div>
                            <div class="formbold-input-flex">
                                <div style="width:140px">                                
                                    <label for="author" class="formbold-form-label"> Author </label>
                                     <input
                                        type="text"
                                        name="author"
                                        id="author"
                                        placeholder="No Author"
                                        class="formbold-form-input"
                                        autocomplete="off"
                                        data-bind="value: itemAuthor"
                                        readonly
                                        />

                                </div>
                                <div>                                
                                    <label for="itemCrew" class="formbold-form-label"> Crew </label>
                                    <input 
                                        type="text" 
                                        class="input-crew"
                                        style="width:30px;text-align: center; height: 38px;margin-right: 10px;"
                                        data-bind="value:itemCrew" 
                                        readonly
                                        />
                                </div>
                            </div>   

                        </div>
                    </div>

                    <div class="formbold-form-step-2 " >
                      <div>
                        <label for="description" class="formbold-form-label"> Description </label>
                        <textarea
                          rows="15"
                          name="description"
                          id="description"
                          placeholder="Add a Description"
                          class="formbold-form-input-textarea"
                          data-bind="value: itemDescription, disabled: not(enableForm)"
                        ></textarea>
                      </div>
                    </div>

                                    
                    <div class="formbold-form-step-3">
                      <div class="formbold-form-confirm">
                        <div>
                          <button class="formbold-confirm-btn w-full save-button" id="saveBtn" type="submit"  data-bind="disabled: not(enableSaveChangesBtn)">
                            <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="11" cy="11" r="10.5" fill="white" stroke="#DDE3EC"/>
                            <g clip-path="url(#clip0_1667_1314)">
                            <path d="M9.83343 12.8509L15.1954 7.48828L16.0208 8.31311L9.83343 14.5005L6.12109 10.7882L6.94593 9.96336L9.83343 12.8509Z" fill="#536387"/>
                            </g>
                            <defs>
                            <clipPath id="clip0_1667_1314">
                            <rect width="14" height="14" fill="white" transform="translate(4 4)"/>
                            </clipPath>
                            </defs>
                            </svg>
                            Save Changes
                          </button>

                       
                        </div>
                      </div>
                    </div>

                    <div class="formbold-form-btn-wrapper ">
                           <button class="formbold-confirm-btn delete-btn" id="deleteBtn" data-bind="disabled: not(enableForm)">
                            <svg
                                width="17"
                                height="17"
                                viewBox="0 0 17 17"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                              >
                                <path
                                  fill-rule="evenodd"
                                  clip-rule="evenodd"
                                  d="M0.474874 0.474874C1.10804 -0.158291 2.1346 -0.158291 2.76777 0.474874L16.5251 14.2322C17.1583 14.8654 17.1583 15.892 16.5251 16.5251C15.892 17.1583 14.8654 17.1583 14.2322 16.5251L0.474874 2.76777C-0.158291 2.1346 -0.158291 1.10804 0.474874 0.474874Z"
                                  fill="white"
                                />
                                <path
                                  fill-rule="evenodd"
                                  clip-rule="evenodd"
                                  d="M0.474874 16.5251C-0.158291 15.892 -0.158291 14.8654 0.474874 14.2322L14.2322 0.474874C14.8654 -0.158292 15.892 -0.158291 16.5251 0.474874C17.1583 1.10804 17.1583 2.1346 16.5251 2.76777L2.76777 16.5251C2.1346 17.1583 1.10804 17.1583 0.474874 16.5251Z"
                                  fill="white"
                                />
                              </svg>
                            Delete Entry
                          </button>
                    </div>
                </form>
            </div>
        </div>
    </div>   
   
</div>






<script id="create_new_entry_modal" type="text/x-handlebars-template">
    <div class="modal-header" style="min-width:700px !important;height: 30px;">    
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times; </button>
        <h3>Create new entry</h3>
    </div>
    <div style="padding-bottom:0;padding-top:0; min-width:700px;max-height:unset;height:650px" class="modal-body">   
        <div class="formbold-main-wrapper-modal" >
                <div class="formbold-form-wrapper">                
                    <form id="logbook-form-modal">  

                    <div class="formbold-form-step-1 ">

                        <div>
                            <label for="title" class="formbold-form-label"> Title </label>
                            <input
                                type="text"
                                name="title"
                                id="titleModal"
                                placeholder="Add Title"
                                class="formbold-form-input title-input"
                                data-bind="value: itemTitle"
                            />
                        </div>
                       
                        <div class="equipment-tree-select">
                            <div>
                                <label class="formbold-form-label"> Equipment </label>
                                <select 
                                    id="treeSelectContainerModal" 
                                    class="formbold-form-select"                                    
                              
                                    >
                                </select>
                            </div>
                        </div>
                      
                        <div class="formbold-input-flex">
                        <div class="formbold-input-group">
                            <label class="formbold-form-label"> Status </label>
                            <select 
                                id="statusModal" 
                                name="status" 
                                class="formbold-form-select"            
                                >
                            </select>
                        </div>
                        <div class="formbold-input-group">
                            <label class="formbold-form-label"> Type </label>                            
                            <select 
                                id="typeModal" 
                                name="type" 
                                class="formbold-form-select"
                                >
                            </select>
                        </div>
                      </div>
               

                        <div class="formbold-input-flex">
                            <div class="formbold-input-flex">
                                <div>
                                    <label class="formbold-form-label"> Date </label>
                                    <label class="input-prepend">
                                        <span class="add-on" style="height:38px;line-height:38px;"><i class="icon-calendar"></i></span>
                                        <input 
                                            type="text" 
                                            id="dateFormModal" 
                                            class="input-date-modal"
                                            style="height: 38px;text-align: center;width: 75px; z-index: 5000 !important;"
                                            data-bind="value: itemDate"
                                            />
                                    </label>   
                                </div>
                                <div>
                                    <label class="formbold-form-label"> Time </label>
                                    <div class="input-group bootstrap-timepicker timepicker">
                                         <label class="input-prepend"> 
                                             <span class="add-on" style="height:38px;line-height:38px;"><i class="icon-time"></i></span>
                                            <input 
                                                id="timeFormModal" 
                                                type="text" 
                                                class="form-control input-small" 
                                                style=" height: 38px;text-align: center;width: 60px;"
                                                data-bind="value: itemTime"
                                                
                                                />
                                         </label>                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="formbold-form-step-2 " >
                      <div>
                        <label for="description" class="formbold-form-label"> Description </label>
                        <textarea
                          rows="10"
                          name="description"
                          id="descriptionModal"
                          placeholder="Add a Description"
                          class="formbold-form-input-textarea-modal"
                          data-bind="value: itemDescription"
                        ></textarea>
                      </div>
                    </div>

                                    
                </form>
                </div>
        </div>
           
    </div>
    <div class="modal-footer row-fluid" style="min-width:700px;">
        <div class="span10">
              <button class="formbold-confirm-btn w-full save-button" id="saveBtnModal" type="submit"  data-bind="disabled: not(enableCreateEntryBtn)">
            <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
            <circle cx="11" cy="11" r="10.5" fill="white" stroke="#DDE3EC"/>
            <g clip-path="url(#clip01_1667_1314)">
            <path d="M9.83343 12.8509L15.1954 7.48828L16.0208 8.31311L9.83343 14.5005L6.12109 10.7882L6.94593 9.96336L9.83343 12.8509Z" fill="#536387"/>
            </g>
            <defs>
            <clipPath id="clip01_1667_1314">
            <rect width="14" height="14" fill="white" transform="translate(4 4)"/>
            </clipPath>
            </defs>
            </svg>
            Create New Entry
        </button>

        </div>
      
        <div class="span2">
            <button id="cancelBtn" class="btn" data-dismiss="modal">
                Cancel
            </button>

        </div>     
    </div>
</script>


