﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/codemirror-5.22.0/lib/codemirror.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/codemirror-5.22.0/addon/lint/lint.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/codemirror-5.22.0/addon/hint/show-hint.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/dmt/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<style type="text/css">
    .blocking-screen-poster {
        position:absolute;
        width:100%;
        height:100%;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        background-color:rgba(247, 247, 247, 0.7);
        z-index: 10;
    }
</style>

<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }," style="height:500px;">
    <div class="row-fluid" style="position:relative;top:100px;">
        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:115px;">
        <h3 style="font-size:50px;">
            <asp:localize runat="server" meta:resourcekey="loading_data" />
        </h3>
    </div>
</div>

<div class="row-fluid" data-bind="classes: { hide: isLoading, }">
    <div class="blocking-screen-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(fullLocked), },">
        <div class="row-fluid" style="position:relative;top:250px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:265px;">
            <h1 style="font-size:50px;">
                <asp:localize runat=server meta:resourcekey=blocking_poster_uploading_script_message />
            </h1>
        </div>
    </div>
    <%--<div class="blocking-screen-poster no-text-select hide" data-bind="classes: { hide: not(fullLocked), },">
        <div class="block-poster with-opacity"></div>
        <div class="block-poster">
            <div class="text-center" style="margin-top:5%;font-family:Arial;">
                <div class="row-fluid" style="position:relative;top:100px;">
                    <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                </div>
                <div class="row-fluid" style="position:relative;top:115px;">
                    <h1 style="font-size:50px;">
                        <asp:localize runat=server meta:resourcekey=blocking_poster_uploading_script_message />
                    </h1>
                </div>
            </div>
        </div>
    </div>--%>
    <div class="row-fluid">
        <div class="span9" style="float:left; margin-left:0px;">
            <div class="row-fluid" style="border-left: solid 1px #ddd; border-top-left-radius:5px;">
                <div class="row-fluid">
                    <ul class="nav nav-tabs" id="Ul1" style="margin:0px; border-bottom: none;">
                        <li id="tabSource" style="margin:0px; width:20%;" class="active unselectable" data-bind="clickSet: 'currentTab', clickSetValue: 'source', classes: { 'selected-tab': equals(currentTab, 'source'), 'non-selected-tab': not(equals(currentTab, 'source')), }">
                            <a data-target="#source" data-toggle="tab" style="background:#fff;margin:0px;border-bottom:solid 1px #fff;border-left:none;border-top:solid 1px #ddd;border-right:solid 1px #ddd;">
                                <asp:localize runat=server meta:resourcekey=source_code_label />
                                <div class="not-checked-icon-popover popover-on-icon" style="display:inline-block;margin-left:5px;">
                                    <i style="font-size:18px;" data-bind="attr: { title: select(source_equalsOnline, '<asp:localize runat=server meta:resourcekey=source_equals_online_label />', '<asp:localize runat=server meta:resourcekey=source_not_equals_online_label />') }, classes: { hide: any(not(source_idOnline), not(equals(source_name, source_nameOnline))), 'fa-exclamation-triangle': not(source_equalsOnline), 'yellow': not(source_equalsOnline), 'fa-check': source_equalsOnline, 'green': source_equalsOnline, }" class="fa hide"></i>
                                </div>
                            </a>
                        </li>
                        <li id="tabOnline" style="margin:0px;width:20%;" class="unselectable" data-bind="clickSet: 'currentTab', clickSetValue: 'online', classes: { 'selected-tab': equals(currentTab, 'online'), 'non-selected-tab': not(equals(currentTab, 'online')), }">
                            <a data-target="#online" data-toggle="tab" style="background:#ddd;margin:0px;border:solid 1px #ddd;">
                                <asp:localize runat=server meta:resourcekey=online_code_label />
                                <div class="not-checked-icon-popover popover-on-icon dmt-script" style="display:inline-block;">
                                    <i title='<asp:localize runat=server meta:resourcekey=new_status_label />' style="font-size:18px;" class="fa fa-circle new" data-bind="classes: { hide: notEquals(source_scriptStatusCode, 'NEW'), }"></i>
                                    <i title='<asp:localize runat=server meta:resourcekey=running_status_label />' style="font-size:18px;" class="fa fa-circle running" data-bind="classes: { hide: notEquals(source_scriptStatusCode, 'RUNNING'), }"></i>
                                    <i title='<asp:localize runat=server meta:resourcekey=paused_status_label />' style="font-size:18px;" class="fa fa-circle paused" data-bind="classes: { hide: notEquals(source_scriptStatusCode, 'PAUSED'), }"></i>
                                    <i title='<asp:localize runat=server meta:resourcekey=stopped_status_label />' style="font-size:18px;" class="fa fa-circle stopped" data-bind="classes: { hide: notEquals(source_scriptStatusCode, 'STOPPED'), }"></i>
                                </div>
                                <div data-bind="classes: { hide: not(source_idOnline), }" style="display:inline-block;margin-left:5px;" data-content="{{HBExp 'errorStatus'}}">
                                <%--    <i style="font-size:18px;" class="status-error fa" data-bind="attr: { title: select(source_scriptErrorStatusDescription, select(notEquals(source_scriptErrorStatusDescription, 'TIMEOUT'), format('<asp:localize runat=server meta:resourcekey=status_error_description_label />', source_scriptErrorStatusDescription), '<asp:localize runat=server meta:resourcekey=status_timeout_description_label />'), '<asp:localize runat=server meta:resourcekey=status_ok_description_label />')}, classes: { hide: not(source_scriptErrorStatus), 'fa-check-circle': equals(source_scriptErrorStatus, 'OK'), 'green': equals(source_scriptErrorStatus, 'OK'), 'fa-exclamation-circle': equals(source_scriptErrorStatus, 'WARNING'), 'yellow': equals(source_scriptErrorStatus, 'WARNING'), 'fa-times-circle': equals(source_scriptErrorStatus, 'ERROR'), 'red': equals(source_scriptErrorStatus, 'ERROR'), }"></i>
                                --%>
                                    <i style="font-size:18px;" class="status-error fa" data-bind="attr: { title: select(source_scriptErrorStatusDescription, select(equals(source_scriptErrorStatus, 'ERROR'), format('<asp:localize runat=server meta:resourcekey=status_error_description_label />', source_scriptErrorStatusDescription), select(equals(source_scriptErrorStatus, 'WARNING'), format('<asp:localize runat=server meta:resourcekey=status_warning_description_label />', source_scriptErrorStatusDescription))), '<asp:localize runat=server meta:resourcekey=status_ok_description_label />')}, classes: { hide: not(source_scriptErrorStatus), 'fa-check-circle': equals(source_scriptErrorStatus, 'OK'), 'green': equals(source_scriptErrorStatus, 'OK'), 'fa-exclamation-circle': equals(source_scriptErrorStatus, 'WARNING'), 'yellow': equals(source_scriptErrorStatus, 'WARNING'), 'fa-times-circle': equals(source_scriptErrorStatus, 'ERROR'), 'red': equals(source_scriptErrorStatus, 'ERROR'), }"></i>
                                </div>
                            </a>
                        </li>
                        <li style="margin:0px;float:right;width:60%;border-bottom:solid 1px #ddd">
                            <div id="source-buttons" class="controls" style="font-size:12px;margin:0px;">
                                <div class="btn-group unselectable" style="float:right;margin:4px;">
                                    <button id="uploadBtn" class="btn" data-bind="enabled: all(source_id, not(enqueuedCommand), not(onlineLocked)), html: select(notEquals(currentLock, 'DMTSCRIPTSET'), '<asp:localize runat=server meta:resourcekey=upload_btn_label />', '<img class=\'loading-state\' style=\'width:20px;height:20px;\' src=\'<%= ResolveUrl("~/assets/img/spinner20.gif") %>\' />'), attr: { title: select(not(onlineLocked), '', '<asp:localize runat=server meta:resourcekey=processing_command_label />'), }" style="font-size:12px;">
                                        <asp:Localize runat="server" meta:resourcekey="upload_button_label" />
                                    </button>
                                    <button id="editDropdownMenu" data-bind="enabled: all(source_idOnline, not(enqueuedCommand), not(onlineLocked))" class="configure-source-btn btn dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" data-open="false" style="font-size:12px;outline:none;">
                                        <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu" style="font-size: 12px;">
                                        <li style="cursor: pointer;">
                                            <button style="width:100%; text-align:left;" class="blankBtn unselectable btn-get-logs" data-bind="classes: { inactive: equals(currentLock, 'DMTSCRIPTGETLOGS') }, enabled: all(source_codeOnline, not(enqueuedCommand), not(onlineLocked)), html: select(notEquals(currentLock, 'DMTSCRIPTGETLOGS'), '<asp:localize runat=server meta:resourcekey=get_logs_btn_label />', '<img class=\'loading-state\' style=\'width:20px;height:20px;\' src=\'<%= ResolveUrl("~/assets/img/spinner20.gif") %>\' />'), attr: { title: select(not(onlineLocked), '', '<asp:localize runat=server meta:resourcekey=processing_command_label />'), }" style="float:right; margin-left:5px;"><asp:Localize runat=server meta:resourcekey=get_logs_btn_label /></button>
                                        </li>
                                        <li style="cursor: pointer;">
                                            <button style="width:100%; text-align:left;" class="blankBtn unselectable" id="runBtn" data-bind="classes: { inactive: equals(currentLock, 'DMTSCRIPTRUN')}, enabled: all(source_codeOnline, not(enqueuedCommand), not(equals(source_scriptStatusCode, 'RUNNING')), not(onlineLocked)), html: select(notEquals(currentLock, 'DMTSCRIPTRUN'), '<asp:localize runat=server meta:resourcekey=run_btn_label />', '<img class=\'loading-state\' style=\'width:20px;height:20px;\' src=\'<%= ResolveUrl("~/assets/img/spinner20.gif") %>\' />'), attr: { title: select(not(onlineLocked), '', '<asp:localize runat=server meta:resourcekey=processing_command_label />'), }" style="float:right; margin-left:5px;"></button>
                                        </li>                                        
                                        <li style="cursor: pointer;">
                                            <button style="width:100%; text-align:left;" class="blankBtn unselectable" id="pauseBtn" data-bind="classes: { inactive: equals(currentLock, 'DMTSCRIPTPAUSE') }, enabled: all(source_codeOnline, not(enqueuedCommand), not(equals(source_scriptStatusCode, 'PAUSED')), not(equals(source_scriptStatusCode, 'STOPPED')), not(equals(source_scriptStatusCode, 'NEW')), not(onlineLocked)), html: select(notEquals(currentLock, 'DMTSCRIPTPAUSE'), '<asp:localize runat=server meta:resourcekey=pause_btn_label />', '<img class=\'loading-state\' style=\'width:20px;height:20px;\' src=\'<%= ResolveUrl("~/assets/img/spinner20.gif") %>\' />'), attr: { title: select(not(onlineLocked), '', '<asp:localize runat=server meta:resourcekey=processing_command_label />'), }" style="float:right; margin-left:5px;"></button>
                                        </li>
                                        <li style="cursor: pointer; ">
                                            <button style="width:100%; text-align:left;" class="blankBtn unselectable" id="stopBtn" data-bind="classes: { inactive: equals(currentLock, 'DMTSCRIPTSTOP') }, enabled: all(source_codeOnline, not(enqueuedCommand), not(equals(source_scriptStatusCode, 'STOPPED')), not(equals(source_scriptStatusCode, 'NEW')), not(onlineLocked)), html: select(notEquals(currentLock, 'DMTSCRIPTSTOP'), '<asp:localize runat=server meta:resourcekey=stop_btn_label />', '<img class=\'loading-state\' style=\'width:20px;height:20px;\' src=\'<%= ResolveUrl("~/assets/img/spinner20.gif") %>\' />'), attr: { title: select(not(onlineLocked), '', '<asp:localize runat=server meta:resourcekey=processing_command_label />'), }" style="float:right; margin-left:5px;"></button>
                                        </li>
                                    </ul>
                                </div>
                                <div class="btn-group unselectable" style="float:right;margin:4px;">
                                    <button id="download" class="configure-source-btn btn dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" data-open="false" style="color:#000;font-size:12px;outline:none;" data-bind="enabled: not(downloading), html: select(not(downloading), '<asp:localize runat=server meta:resourcekey=download_button_label />', '<img class=\'loading-state\' style=\'width:20px;height:20px;\' src=\'<%= ResolveUrl("~/assets/img/spinner20.gif") %>\' />'), ">
                                        <asp:Localize runat="server" meta:resourcekey="download_button_label" />
                                    </button>
                                    <ul class="dropdown-menu" style="font-size: 12px;">
                                        <li style="cursor: pointer;">
                                            <button style="width:100%; text-align:left;" class="blankBtn unselectable" id="downloadSourceBtn" data-bind="enabled: all(source_id, not(enqueuedCommand)), "><asp:localize runat=server meta:resourcekey=download_source_label /></button>
                                        </li>
                                        <li style="cursor: pointer;">
                                            <button style="width:100%; text-align:left;" class="blankBtn unselectable" id="downloadOnlineBtn" data-bind="enabled: source_idOnline,"><asp:Localize runat=server meta:resourcekey=download_online_label /></button>
                                        </li>
                                    </ul>
                                </div>
                                <button class="btn unselectable" id="saveAsBtn" data-bind="enabled: source_id, " style="float:right; margin:4px;font-size:12px;"><asp:localize runat=server meta:resourcekey=save_as_button_label /></button>
                                <button class="btn unselectable" id="saveBtn" data-bind="enabled: all(source_id, source_modified, not(saving)), html: select(not(saving), '<asp:localize runat=server meta:resourcekey=save_button_label />', '<img class=\'loading-state\' style=\'width:20px;height:20px;\' src=\'<%= ResolveUrl("~/assets/img/spinner20.gif") %>\' />'), " style="float:right; margin:4px;font-size:12px;"><asp:localize runat=server meta:resourcekey=save_button_label /></button>
                                <button class="btn unselectable" id="browseBtn" data-bind="enabled: source_id, " style="float:right; margin:4px;font-size:12px;"><asp:localize runat=server meta:resourcekey=browse_button_label /></button>
                            </div>
                        </li>
                    </ul>
                </div>
            
                <div class="tab-content" style="overflow:hidden;padding-bottom:2px;">
                    <div id="source" class="active tab-pane">
                        <div class="row-fluid resize-height-to-fit editor-container section-normal"> <!-- source code section -->
                        </div>
                    </div>
                    <div id="online" class="tab-pane">
                        <div class="row-fluid resize-height-to-fit online-container section-normal" style="background-color:#ddd;"> <!-- online code section -->
                        </div>
                    </div>
                </div>
            </div>

            <div class="row-fluid messages-container editor-section section-normal" data-bind="collection: $messages, itemView: 'messagesView'" style="margin-top:10px; border:1px solid silver; overflow-y:scroll;">
            </div>
        </div>
        <div class="span3 no-pointer unselectable screen-sidebar" style="float:right;cursor:default;position:relative;">
            <div class="row-fluid" style="padding:3px;">
                <div class="control-label" style="display:table-row;">
                    <label class="control-label" style="display:table-cell;text-align:right;" data-bind="text: '<asp:Localize runat=server meta:resourcekey=script_label />:&nbsp;',"></label>
                    <label class="control-label" style="font-weight:bold; display:table-cell;" data-bind=" text: coalesce(source_scriptName, '-'), "></label>
                </div>
                <div style="display:table-row;" data-bind="classes: { hide: not(equals(currentTab, 'source')) }">
                    <label class="control-label" style="display:table-cell;text-align:right;" data-bind="text: '<asp:Localize runat=server meta:resourcekey=source_label />:&nbsp;',"></label>
                    <label class="control-label" style="font-weight:bold; display:table-cell;" data-bind="text: coalesce(source_name, '-'), "></label>
                </div>
                <div style="display:table-row;" data-bind="classes: { hide: not(equals(currentTab, 'online')) }">
                    <label class="control-label" style="display:table-cell;text-align:right;" data-bind="text: '<asp:Localize runat=server meta:resourcekey=source_label />:&nbsp;',"></label>
                    <label class="control-label" style="font-weight:bold; display:table-cell;" data-bind="text: coalesce(source_nameOnline, '-'), "></label>
                </div>
                <div style="display:table-row;" class="control-label">
                    <label class="control-label" style="display:table-cell;text-align:right;" data-bind="text: '<asp:Localize runat=server meta:resourcekey=agent_label />:&nbsp;',"></label>
                    <label class="control-label" style="font-weight:bold; display:table-cell;" data-bind=" text: coalesce(source_agentName, '-'), "></label>
                </div>
            </div>
            <div class="row-fluid resize-height-source-files">
                <div>
                    <label class="control-label" style="padding:6px;"><asp:Localize runat=server meta:resourcekey=files_label/></label>
                </div>
                <div style="height:85%;">
                    <select multiple data-bind="options: sourceFilesBinding, classes: { hide: not(equals(currentTab, 'source')) }" style="width:100%;height:100%;bottom:0px;" class="input-large files-select"></select>
                    <select multiple data-bind="options: onlineFilesBinding, classes: { hide: not(equals(currentTab, 'online')) }" style="width:100%;height:100%;bottom:0px;" class="input-large files-select"></select>
                </div>
            </div>
            <div class="controls" data-bind="classes: { hide: not(equals(currentTab, 'source')) }">
                <div class="row-fluid" style="margin-top:0px;">
                    <div class="add-file-form">
                        <form enctype="multipart/form-data">
                            <label style="margin-top:5px;" class="btn btn-success">
                                <i class="glyphicon glyphicon-plus"></i>
                                <span><asp:Localize runat="server" meta:resourcekey="add_file_btn_label" /></span>
                                <input type="file" multiple name="files[]" class="files-input" style="position:absolute;top:-100px;" >
                            </label>
                            <button style="margin-top:5px;" disabled="disabled" type="button" class="btn btn-danger btn-remove-file"><asp:Localize runat="server" meta:resourcekey="remove_file_btn_label" /></button>
                        </form>
                    </div>
                    <div class="row-fluid review-file-form hide">
                        <div class="span6">
                            <input class="input-file-filename span12" type="text" disabled="disabled" />
                        </div>
                        <div class="span6">
                            <button type="button" class="btn btn-success span6 btn-upload-file"><asp:Localize runat=server meta:resourcekey=upload_btn_label /></button>
                            <button type="button" class="btn btn-default span6 btn-cancel-upload-file"><asp:Localize runat=server meta:resourcekey=upload_cancel_btn_label /></button>
                        </div>
                    </div>
                    <div class="row-fluid file-upload-progress hide">
                        <div class="row-fluid">
                            <div class="span6">
                                <div class="progress progress-info progress-striped active">
                                    <div class="bar file-upload-progress-bar" style="width: 0%"></div>
                                </div>
                            </div>
                        </div>
                        <div class="row-fluid">
                            <p class="text-info"><asp:Localize runat=server meta:resourcekey=file_uploading_message /></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="online-data" style="position:absolute;padding-top:10px;padding-bottom:10px;bottom:10px;border-top:1px solid silver;width:100%;">
                <div class="row-fluid" style="padding:3px;">
                    <div class="row-fluid" style="display:table-row;padding:2px;">
                        <label class="control-label" style="display:table-cell;text-align:right;" data-bind="text: '<asp:Localize runat=server meta:resourcekey=last_scan_rate_label />:&nbsp;',"></label>
                        <label class="control-label" style="font-weight:bold; display:table-cell;" data-bind="text: concat(coalesce(decimalFixed(source_lastScanCycleTime, 3), '-'), ' ms'), "></label>
                    </div>
                    <div class="row-fluid" style="display:table-row;padding:2px;">
                        <label class="control-label" style="display:table-cell;text-align:right;" data-bind="text: '<asp:Localize runat=server meta:resourcekey=scan_rate_label />:&nbsp;',"></label>
                        <label class="control-label" style="font-weight:bold; display:table-cell;" data-bind="text: concat(coalesce(source_scanCycleTime, '-'), ' ms'), "></label>
                    </div>
                    <div class="row-fluid" style="display:table-row;padding:2px;">
                        <label class="control-label" style="display:table-cell;text-align:right;" data-bind="text: '<asp:Localize runat=server meta:resourcekey=timeout_label />:&nbsp;',"></label>
                        <label class="control-label" style="font-weight:bold; display:table-row;" data-bind="text: concat(coalesce(source_timeout, '-'), ' ms'), "></label>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script id="browse_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat=server meta:resourcekey=browse_modal_title /></h3>
    </div>
    <div style="max-height:600px;height:450px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:500px;padding-bottom:0;" class="modal-body">
            <ul class="nav nav-tabs" id="Ul2" style="margin:0px;margin-bottom:5px;border:none;">
                <li class="active unselectable" style="width:20%;">
                    <a data-target="#sources" data-toggle="tab" style="background:#fff;margin:0px;border-top:solid 1px #ddd;border-right:solid 1px #ddd;border-left:solid 1px #ddd;">
                        <asp:localize runat=server meta:resourcekey=sources_label />
                    </a>
                </li>
                <li class="unselectable" style="width:20%;">
                    <a data-target="#examples" data-toggle="tab" style="background:#fff;margin:0px;border-top:solid 1px #ddd;border-right:solid 1px #ddd;border-left:solid 1px #ddd;">
                        <asp:localize runat=server meta:resourcekey=examples_label />
                    </a>
                </li>
                <li class="unselectable" style="width:60%;border-bottom:solid 1px #ddd">
                    <a style="cursor:default;margin:0px;border:0px;border-bottom:solid 1px #fff !important;background:#fff">
                        &nbsp;
                    </a>
                </li>
            </ul>
            <div class="tab-content" style="overflow:hidden;padding-bottom:2px; border:solid 1px #ddd;">
                <div id="sources" class="row-fluid active tab-pane" style="max-height:350px;min-height:350px;overflow-y:auto;">
                    <div class="sources-grid-container"></div>
                </div>
                <div id="examples" class="row-fluid tab-pane" style="max-height:350px;min-height:350px;overflow-y:auto;">
                    <div class="examples-grid-container"></div>
                </div>
            </div>
        </div>
    </div>
</script>

<script id="actions_cell_template" type="text/x-handlebars-template">
    {{HBExp '#ifEquals editing true'}}
    <div class="row-fluid">
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="SAVE" title="<asp:Localize runat=server meta:resourcekey=save_title />" class="btn btn-cell-action btn-small btn-save"><i class="fa fa-floppy-o"></i></button>
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DISCARD" title="<asp:Localize runat=server meta:resourcekey=discard_title />" class="btn btn-cell-action btn-small btn-discard"><i class="fa fa-times"></i></button>
    </div>
    {{HBExp 'else'}}
    <div class="row-fluid">
        <div class="span4" style="width:100%;">
            <div class="btn-group" style="float:left">
                {{HBExp '#ifEquals id idOnline'}}
                <button class="btn dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" data-open="false" style="font-size:12px; outline:none;">
                    <asp:Localize runat="server" meta:resourcekey="options_button_label" />&nbsp;<span class="caret"></span>
                </button>
                {{HBExp 'else'}}
                <a href="!/ih/dmt/editor/{{HBExp 'id'}}" data-dismiss="modal" class="configure-source-btn btn" style="font-size:12px;">
                    <asp:Localize runat="server" meta:resourcekey="edit_button_label" />
                </a>
                <button class="configure-source-btn btn dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" data-open="false" style="font-size:12px; outline:none;">
                    <span class="caret"></span>
                </button>
                {{HBExp '/ifEquals'}}
                <ul class="dropdown-menu pull-right" style="font-size: 12px;">
                    {{HBExp '#ifEquals hasUnsavedClone true'}}
                    <li class="disabled">
                        <a class="btn-dropdown-config-option">
                            <asp:Localize runat="server" meta:resourcekey="clone_button_label" />
                        </a>
                    </li>
                    {{HBExp 'else'}}
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-clone">
                            <asp:Localize runat="server" meta:resourcekey="clone_button_label" />
                        </a>
                    </li>
                    {{HBExp '/ifEquals'}}
                    {{HBExp '#ifEquals id idOnline'}}
                    {{HBExp 'else'}}
                        <%--{HBExp '#ifEquals name nameOnline'}}
                        <li class="disabled">
                            <a class="btn-dropdown-config-option">
                                <asp:Localize runat="server" meta:resourcekey="delete_button_label" />
                            </a>
                        </li>
                        {HBExp 'else'}}--%>
                            {{HBExp '#ifEquals id curSourceId'}}
                            <li class="disabled">
                                <a class="btn-dropdown-config-option">
                                    <asp:Localize runat="server" meta:resourcekey="delete_button_label" />
                                </a>
                            </li>
                            {{HBExp 'else'}}
                            <li style="cursor: pointer;">
                                <a class="btn-dropdown-config-option" data-option="opt-delete">
                                    <asp:Localize runat="server" meta:resourcekey="delete_button_label" />
                                </a>
                            </li>
                            {{HBExp '/ifEquals'}}
                        <%--{HBExp '/ifEquals'}}--%>
                    {{HBExp '/ifEquals'}}
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-download">
                            <asp:Localize runat="server" meta:resourcekey="download_button_label" />
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    {{HBExp '/ifEquals'}}
</script>

<script id="create_from_example_cell_template" type="text/x-handlebars-template">
    <div class="row-fluid">
        {{HBExp '#ifEquals hasUnsavedClone true'}}
            <button data-toggle="tooltip" data-placement="bottom" class="btn btn-success" style="font-size:12px;" disabled><asp:Localize runat=server meta:resourcekey=clone_button_label/></button>
        {{HBExp 'else'}}
            <button id="createBtn" data-toggle="tooltip" data-placement="bottom" class="btn btn-success" style="font-size:12px;"><asp:Localize runat=server meta:resourcekey=clone_button_label/></button>
        {{HBExp '/ifEquals'}}
        <button id="downloadBtn" data-toggle="tooltip" data-placement="bottom" class="btn" style="font-size:12px;"><asp:Localize runat=server meta:resourcekey=download_button_label/></button>
    </div>
</script>