﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/dmt/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(not(hasData), not(isLoading))), }," style="height:500px;">
    <div class="row-fluid" style="position:relative;top:100px;">
        <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:115px;">
        <h3 style="font-size:50px;">
            <asp:localize runat="server" meta:resourcekey="no_data_available" />
        </h3>
    </div>
</div>

<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }," style="height:500px;">
    <div class="row-fluid" style="position:relative;top:100px;">
        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:115px;">
        <h3 style="font-size:50px;">
            <asp:localize runat="server" meta:resourcekey="loading_data" />
        </h3>
    </div>
</div>

<div class="row-fluid items-grid-container infinite-container" data-bind="classes: { hide: any(not(hasData), isLoading), },"></div>

<script id="actions_cell_template" type="text/x-handlebars-template">
    {{HBExp '#ifEquals editing true'}}
    <div class="row-fluid">
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="SAVE" title="<asp:Localize runat=server meta:resourcekey=save_title />" class="btn btn-cell-action btn-small btn-save"><i class="fa fa-floppy-o"></i></button>
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DISCARD" title="<asp:Localize runat=server meta:resourcekey=discard_title />" class="btn btn-cell-action btn-small btn-discard"><i class="fa fa-times"></i></button>
    </div>
    {{HBExp 'else'}}
    <div class="row-fluid">
        <div class="span4" style="width:100%;">
            {{HBExp '#ifEquals isLoading true'}}
            <div class="popover-on-icon" style="float:left;margin-left:15px;height:31px;cursor:default;"><img style="width:30px;height:30px;" src="<%= ResolveUrl("~/assets/img/spinner22.gif")%>" /></div>
            {{HBExp 'else'}}
            <div class="btn-group" style="float:left">
                <!--<button type="button" class="configure-source-btn btn"></button>-->
                {{HBExp '#if activeSourceId includeZero=true'}}
                <a href="!/ih/dmt/editor/{{HBExp 'activeSourceId'}}" class="configure-source-btn btn" style="font-size: 12px;">
                    <asp:Localize runat="server" meta:resourcekey="edit_button_label" />
                </a>
                {{HBExp 'else'}}
                <a href="!/ih/dmt/editor/{{HBExp 'lastModifiedSourceId'}}" class="configure-source-btn btn" style="font-size: 12px;">
                    <asp:Localize runat="server" meta:resourcekey="edit_button_label" />
                </a>
                {{HBExp '/if'}}
                <button id="editDropdownMenu" class="configure-source-btn btn dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" data-open="false" style="font-size: 12px;">
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu" style="font-size: 12px;">
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-clone">
                            <asp:Localize runat="server" meta:resourcekey="clone_button_label" />
                        </a>
                    </li>
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-delete">
                            <asp:Localize runat="server" meta:resourcekey="delete_button_label" />
                        </a>
                    </li>
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-download">
                            <asp:Localize runat="server" meta:resourcekey="download_button_label" />
                        </a>
                    </li>
                    {{HBExp '#ifEquals statusCode \'NEW\''}}
                        {{HBExp '#if onlineSourceId includeZero=true'}}
                        <li style="cursor: pointer;" class="getLogsBtn">
                            <a class="btn-dropdown-config-option" data-option="opt-get-logs">
                                <asp:Localize runat="server" meta:resourcekey="get_logs_button_label" />
                            </a>
                        </li>
                        {{HBExp 'else'}}
                        <li class="getLogsBtn disabled">
                            <a class="btn-dropdown-config-option">
                                <asp:Localize runat="server" meta:resourcekey="get_logs_button_label" />
                            </a>
                        </li>    
                        {{HBExp '/if'}}
                    <li class="goToTrendingBtn disabled">
                        <a class="btn-dropdown-config-option" style="font-size: 12px;">
                            <asp:Localize runat="server" meta:resourcekey="trending_button_label" />
                        </a>
                    </li>
                    {{HBExp 'else'}}
                    <li style="cursor: pointer;" class="getLogsBtn">
                        <a class="btn-dropdown-config-option" data-option="opt-get-logs">
                            <asp:Localize runat="server" meta:resourcekey="get_logs_button_label" />
                        </a>
                    </li>
                        {{HBExp '#if trendingViewName includeZero=true'}}
                        <li style="cursor: pointer;" class="goToTrendingBtn">
                            <a href="!/trending/custom/view=DMT-{{HBExp 'trendingViewName'}}" class="btn-dropdown-config-option" style="font-size: 12px;">
                                <asp:Localize runat="server" meta:resourcekey="trending_button_label" />
                            </a>
                        </li>
                        {{HBExp 'else'}}
                        <li style="cursor: pointer;" class="goToTrendingBtn disabled">
                            <a class="btn-dropdown-config-option" style="font-size: 12px;">
                                <asp:Localize runat="server" meta:resourcekey="trending_button_label" />
                            </a>
                        </li>
                        {{HBExp '/if'}}
                    {{HBExp '/ifEquals'}}
                </ul>
            </div>
            <div class="btn-group" style="float:left">
                <button class="configure-source-btn btn dropdown-toggle" data-toggle="dropdown" data-open="false" style="font-size: 12px;">
                    <i style="font-size:16px;position:relative;top:3px;" class="fa fa-ellipsis-h"></i>
                </button>
                <ul class="dropdown-menu" style="font-size: 12px;">
                    {{HBExp '#if onlineSourceId includeZero=true'}}
                        {{HBExp '#ifEquals statusCode \'RUNNING\''}}
                        <li class="disabled">
                            <a class="btn-dropdown-config-option">
                                <asp:Localize runat="server" meta:resourcekey="run_button_label" />
                            </a>
                        </li>
                        {{HBExp 'else'}}
                        <li style="cursor: pointer;">
                            <a class="btn-dropdown-config-option" data-option="opt-run">
                                <asp:Localize runat="server" meta:resourcekey="run_button_label" />
                            </a>
                        </li>
                        {{HBExp '/ifEquals'}}
                        {{HBExp '#ifEquals statusCode \'NEW\''}}
                        <li class="disabled">
                            <a class="btn-dropdown-config-option">
                                <asp:Localize runat="server" meta:resourcekey="pause_button_label" />
                            </a>
                        </li>
                        {{HBExp 'else'}}
                            {{HBExp '#ifEquals statusCode \'PAUSED\''}}
                            <li class="disabled">
                                <a class="btn-dropdown-config-option">
                                    <asp:Localize runat="server" meta:resourcekey="pause_button_label" />
                                </a>
                            </li>
                            {{HBExp 'else'}}
                                {{HBExp '#ifEquals statusCode \'STOPPED\''}}
                                <li class="disabled">
                                    <a class="btn-dropdown-config-option">
                                        <asp:Localize runat="server" meta:resourcekey="pause_button_label" />
                                    </a>
                                </li>
                                {{HBExp 'else'}}
                                <li style="cursor: pointer;">
                                    <a class="btn-dropdown-config-option" data-option="opt-pause">
                                        <asp:Localize runat="server" meta:resourcekey="pause_button_label" />
                                    </a>
                                </li>
                                {{HBExp '/ifEquals'}}
                            {{HBExp '/ifEquals'}}
                        {{HBExp '/ifEquals'}}
                        {{HBExp '#ifEquals statusCode \'NEW\''}}
                        <li class="disabled">
                            <a class="btn-dropdown-config-option">
                                <asp:Localize runat="server" meta:resourcekey="stop_button_label" />
                            </a>
                        </li>
                        {{HBExp 'else'}}
                            {{HBExp '#ifEquals statusCode \'STOPPED\''}}
                            <li class="disabled">
                                <a class="btn-dropdown-config-option">
                                    <asp:Localize runat="server" meta:resourcekey="stop_button_label" />
                                </a>
                            </li>
                            {{HBExp 'else'}}
                            <li style="cursor: pointer;">
                                <a class="btn-dropdown-config-option" data-option="opt-stop">
                                    <asp:Localize runat="server" meta:resourcekey="stop_button_label" />
                                </a>
                            </li>
                            {{HBExp '/ifEquals'}}
                        {{HBExp '/ifEquals'}}
                    {{HBExp 'else'}}
                    <li class="disabled">
                        <a class="btn-dropdown-config-option">
                            <asp:Localize runat="server" meta:resourcekey="run_button_label" />
                        </a>
                    </li>
                    <li class="disabled">
                        <a class="btn-dropdown-config-option">
                            <asp:Localize runat="server" meta:resourcekey="pause_button_label" />
                        </a>
                    </li>
                    <li class="disabled">
                        <a class="btn-dropdown-config-option">
                            <asp:Localize runat="server" meta:resourcekey="stop_button_label" />
                        </a>
                    </li>
                    {{HBExp '/if'}}
                </ul>
            </div>
            {{HBExp '/ifEquals'}}
        </div>
    </div>
    {{HBExp '/ifEquals'}}
</script>

<script id="status_cell_template" type="text/x-handlebars-template">
    <div class="not-checked-icon-popover popover-on-icon pull-left" style="height:21px;">
        <i style="font-size:20px;" class="fa fa-circle"></i>
    </div>

    {{HBExp '#ifEquals errorStatus \'OK\''}}
    <div class="status-error pull-left" style="height:21px;margin-left:5px;" data-content='<asp:Localize runat="server" meta:resourcekey="status_ok_description_label" />'>
        <i style="font-size:20px;" class="status-error fa fa-check-circle green"></i>
    </div>
    {{HBExp 'else'}}
        {{HBExp '#ifEquals errorStatus \'WARNING\''}}
        <div class="status-error pull-left" style="height:21px;margin-left:5px;" data-content="{{HBExp 'errorStatusDescription'}}">
            <i style="font-size:20px;" class="status-error fa fa-exclamation-circle yellow"></i>
        </div>
        {{HBExp 'else'}}
            {{HBExp '#ifEquals errorStatus \'ERROR\''}}
            <div class="status-error pull-left" style="height:21px;margin-left:5px;" data-content="{{HBExp 'errorStatusDescription'}}">
                <i style="font-size:20px;" class="status-error fa fa-times-circle red"></i>
            </div>
            {{HBExp '/ifEquals'}}
        {{HBExp '/ifEquals'}}
    {{HBExp '/ifEquals'}}
    
</script>

<script id="subnavbar_controls" type="text/x-handlebars-template">
    <div class="span12">
        <div class="subnavbar-toolbar form-inline">
            <button class="btn add-item" data-bind="enabled: hasAgents" style="margin:0; float:left; margin-left:10px; margin-top:5px;">
                <asp:Localize runat="server" meta:resourcekey="add_item_btn_label" />
            </button>
            <div style="position: relative; top: 10px; float:left; margin-left:10px;">
                <label class="checkbox"><input id="show_running_checkbox" data-bind='checked:showRunning, ' type="checkbox"> 
                    <asp:Localize runat="server" meta:resourcekey="show_running_checkbox_label" />
                </label>
            </div>
            <div style="position: relative; top: 10px; float:left; margin-left:10px;">
                <label class="checkbox"><input id="show_paused_tags_checkbox" data-bind='checked: showPaused, ' type="checkbox"> 
                    <asp:Localize runat="server" meta:resourcekey="show_paused_checkbox_label" />
                </label>
            </div>
            <div style="position: relative; top: 10px; float:left; margin-left:10px;">
                <label class="checkbox"><input id="show_stopped_checkbox" data-bind='checked: showStopped, ' type="checkbox"> 
                    <asp:Localize runat="server" meta:resourcekey="show_stopped_checkbox_label" />
                </label>
            </div>
            <div style="position: relative; top: 10px; float:left; margin-left:10px;">
                <label class="checkbox"><input id="show_new_checkbox" data-bind='checked: showNew, ' type="checkbox"> 
                    <asp:Localize runat="server" meta:resourcekey="show_new_checkbox_label" />
                </label>
            </div>
        </div>
        <div class="subnavbar-toolbar form-inline">
            <div style="margin-left:10px; margin-top: 5px; float:right;" class="control-group form-inline">
               <select style="width:200px;" data-bind="value: integer(agentId), options: agents, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=agent_combo_all_opt />', value: 0 }, enabled: hasAgents,"></select>
            </div>
            <div id="cg_search" style="margin-top: 5px; float:right;" class="control-group form-inline">
                <label class="control-label" style="margin-right:2px;" for="searchTerm_input">
                    <asp:Localize runat="server" meta:resourcekey="search_input_label" />
                </label>
                <input type="text" id="searchTbx" data-bind="value: trim(search), events: ['change', 'keyup']," class="input-medium">
            </div>
        </div>
    </div>
</script>
