﻿//SCREEN-BOILERPLATE
//this boilerplate builds screens that are gonna be shown in the <div class='content'> tag of our main HTML.
//do not build app components with this boilerplate, only screens (reports)

define([
  // Application variable, always include it to have access to app methods.
  'app',

  //templates-loader: this loads templates async.
  'js/templates-loader',
  'backgrid',
  'moment',
  'backgrid/moment-cell'

],
function (app, T, Backgrid, moment) {

    var Screen = { Models: {}, Views: {}, Collections: {} }

    Screen.Models.Main = Backbone.Epoxy.Model.extend({
        defaults: {
            furnaceCode: 1,
            furnaces: [{ label: 'A', value: 1 }, { label: 'B', value: 2 }],

            hasData: false,
            isLoading: false,
        },
    });

    Screen.Models.Item = Backbone.Epoxy.Model.extend({
        parse: function (obj) {
            var result = {
                LocationName: obj.LocationName ? obj.LocationName : '',
                EquipmentLocationId: obj.EquipmentLocationId,
                EquipmentId : obj.EquipmentId, 
                EquipmentTypeName: obj.EquipmentTypeName ? obj.EquipmentTypeName : '',
                EquipmentTypeId: obj.EquipmentTypeId,
                EquipmentName: obj.EquipmentName,
                LastChange: (new moment(obj.LastChange)).isValid() ? new moment(obj.LastChange).format('YYYY-MM-DD HH:mm:ss') : null,
                CounterColumn : obj.CounterColumn,
                Comments : obj.Comments, 
                Counter: obj.Counter,
                FurnaceCode: obj.FurnaceCode,
                DaysSinceLastChange: obj.DaysSinceLastChange,
            };

            return result;
        }
    })

    Screen.Collections.Items = Backbone.Collection.extend({
        model: Screen.Models.Item,
       
        fetch(params) {
            var that = this;
            var qp = new Core.Database.QueryParameters();

            if (params.furnaceCode) {
                qp.Add('@FurnaceCode', 'INT', params.furnaceCode)
            }

            // mandatory parameters
            qp.Add('@timezoneCode', 'VARCHAR', app.models.user.get("timezoneCode"));


            Core.Json.CallProcedure(
                app.DatabaseNames.MES + '.EAF.GetComponentsWeb',
                qp,
                {
                    onSuccess: function (resp) {
                        try {

                            if ((resp) && (resp.Table)) {
                                var records = resp.Table,
                                    newColl;

                                newColl = _.map(records, that.model.prototype.parse);
                                that.set(newColl).trigger('fetch', that, records);
                            }
                            else {
                                if ((resp) && (resp.Message))
                                    console.error(resp.Message);
                                else
                                    console.error('Server response not valid.');
                            }
                        }
                        catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                    },
                    Secured: true,
                },
                app.ConnectionStrings.app
            );

            return this;
        },
        insert: function (params) {
            var that = this;
            var qp = new Core.Database.QueryParameters();
            qp.Add('@datetime', 'DATETIME', params.datetime);
            qp.Add('@FurnaceCode', 'INT', params.furnaceCode);
            qp.Add('@EquipmentId', 'INT', params.equipmentId);
            qp.Add('@Comments', 'VARCHAR(MAX)', params.comments);
            qp.Add('@EquipmentLocationId', 'INT', params.equipmentLocationId);

            Core.Json.CallProcedure(
                app.DatabaseNames.MES + '.EAF.ChangeComponentWeb',
                qp,
                {
                    onSuccess: function (resp) {
                        try {

                            if ((resp) && !(resp.Message)) {
                                app.views.topMessages.showMessage('A new equipment change was saved', { stay: 5000, });
                                that.trigger('insert');
                            }
                            else {
                                if ((resp) && (resp.Message)) {
                                    app.views.topMessages.showMessage(resp.Message, { stay: 5000, });
                                    console.error(resp.Message);
                                }
                                else {
                                    console.error('Server response not valid.');
                                    app.views.topMessages.showMessage('Server response not valid.', { stay: 5000, });

                                }
                            }
                        }
                        catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                    },
                    Secured: true,
                },
                app.ConnectionStrings.app
            );

            return this;
        }
    })

    Screen.Views.Main = Backbone.Epoxy.View.extend({
        template: 'eaf-change-equipment',
        id: 'eaf-change-equipment',
        title: 'EAF Change Equipment',
        events: function () {
            return {
                'click #refreshBtn': this.refreshBtn_click,
            };
        },
        bindings: 'data-bind',

        initialize: function () {
            this.options.state = app.view_states.loading;
            this.options.onappend = (_.isFunction(this.options.onappend)) ? this.options.onappend : function () { };

            var that = this;
            this.model = new Screen.Models.Main();
            this.items = new Screen.Collections.Items();

            this.bus = _.extend({}, Backbone.Events);
            this.bus.on("modalAcceptBtn", this.onModalAcceptBtn, this);
            this.bindEvents();
        },
        
        bindEvents: function () {
            this.listenTo(this.items, 'fetch', this.items_fetched);
            this.listenTo(this.items, 'insert', this.item_inserted);
        
        },

        item_inserted: function () {
            try {
                var that = this;
                setTimeout(
                    function () {
                        that.refresh();
                    },
                    100
                );
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },

        render: function (container, urlParams) {
            var that = this;
            var thatContainer = (this.options.container) ? this.options.container : container;
            this.options.container = thatContainer;

            var customPath = '/app/custom-screens/' + this.template + '/';

            T.render.call(
                this,
                this.template,
                function (tmp) {
                    if (!that.options.i18n) that.options.i18n = {};

                    app.getI18NJed(
                        that,
                        that.template,
                        function (i18nJED) {
                            that.options.i18n[that.template] = i18nJED;
                            that.$el.html(tmp());
                            that.applyBindings();

                            that.$el.find('.input-date').datepicker();
                            var columns = [
                                {
                                    name: 'LocationName',
                                    label: app.translate(that, 'item_LocationName_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell twenty-percent',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'EquipmentName',
                                    label: app.translate(that, 'item_EquipmentName_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell twenty-percent',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'CounterColumn',
                                    label: app.translate(that, 'item_CounterColumn_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell ten-percent',
                                    }),
                                    editable: false,
                                },

                                {
                                    name: 'Counter',
                                    label: app.translate(that, 'item_Counter_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell ten-percent',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'LastChange',
                                    label: app.translate(that, 'item_LastChange_col_label'),
                                    cell: Backgrid.Extension.MomentCell.extend({
                                        className: 'moment-cell align-center-cell ten-percent',
                                        modelFormat: 'YYYY-MM-DD HH:mm:ss',
                                        displayFormat: 'YYYY-MM-DD HH:mm:ss',
                                        

                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'DaysSinceLastChange',
                                    label: app.translate(that, 'item_DaysSinceLastChange_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell ten-percent',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'Comments',
                                    label: app.translate(that, 'item_Comments_col_label'),
                                    cell: Backgrid.StringCell.extend({
                                        className: 'string-cell align-center-cell twenty-percent',
                                    }),
                                    editable: false,
                                },
                                {
                                    name: 'Actions',
                                    label: '',
                                    editable: false,
                                    sortable: false,
                                    cell: Backgrid.Cell.extend({
                                        template: Handlebars.compile(that.$el.find('#actions_cell_template').html()),
                                        className: 'actions-cell',
                                        events: {
                                            'click .btn-cell-action': 'cellActionClick'
                                        },

                                        initialize: function () {
                                            Backgrid.Cell.prototype.initialize.apply(this, arguments);
                                        },
                                        render: function () {
                                            this.$el.html(this.template());

                                            this.$el.find('[data-toggle="tooltip"]').tooltip();
                                            this.delegateEvents();
                                            return this;
                                        },
                                        cellActionClick: function (e) {
                                            try {
                                                var target = $(e.target);
                                                var actionData = target.closest('[data-cell-action]').data('cell-action');

                                                if (actionData) {
                                                    that.actionOnRow(this.model);
                                                }
                                            }
                                            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                                        },
                                    }),
                                },

                            ];

                            var grid = new Backgrid.Grid({
                                className: 'backgrid table table-hover table-condensed production-table',
                                collection: that.items,
                                columns: columns,
                            });

                            //container.append(grid.render().el);
                            that.$el.find('.items-grid-container').append(grid.render().el);

                                                       
                            //appending view to the main container
                            that.append(thatContainer, that.$el);

                            var fixedParams = _.extend({}, urlParams);
                            that.model.set(fixedParams);

                            that.refresh(); 
                                                       
                        },
                        true,
                        customPath
                    );
                },
                customPath
            );
        },

        onModalAcceptBtn: function (params) {
            this.items.insert(params);
        },
        actionOnRow: function (model) {
            var params = this.model.toJSON();
            var modal = new Screen.Views.DelaysModal({
                furnaceCode: params.furnaceCode,
                row: model,
                bus: this.bus,
            });
            modal.show();
        },

        refresh: function () {
            this.model.set({
                isLoading: true,
                hasData: false,
            });
            params = this.model.toJSON();
            this.items.fetch(params);

        },
        UpdateURL: function () {
            try {
                var params = this.model.toJSON();
                app.router.navigate(
                    app.router.resolveURL(
                        app.router.currentModule,
                        _.extend(
                            {},
                            params,
                            {
                                furnaceCode: params.furnaceCode,
                            }
                        ),
                        false
                    ),
                    { trigger: false, }
                );
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },

        refreshBtn_click: function (e) {
            this.UpdateURL();
            this.refresh();
        },


        items_fetched: function () {
            try {
                var that = this;
                setTimeout(
                    function () {
                        that.model.set({
                            hasData: (that.items.length > 0),
                            isLoading: false,
                        });

                    },
                    100
                );
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },

        append: function (container, el) {
            el = (el != null && el != undefined) ? el : this.$el;

            if (this.options.state == app.view_states.loading
                || this.options.state == app.view_states.shown) {
                //appending view to the main container and set state to shown

                this.options.state = app.view_states.shown;
                container.append(el);

                this.options.onappend(this);
            }

            if (this.options.state == app.view_states.hidden) {
                //append and remain hidden
                container.append(el);
            }

            if (this.options.state == app.view_states.closed) {
                //return without appending.
                return;
            }
        },
        bindViewScopedEvents: function () {
            var that = this;
        },
        unbindViewScopedEvents: function () {

        },
        close: function () {
            this.options.state = app.view_states.closed;
            
            this.closeSubviews();
            this.remove();
            this.unbindViewScopedEvents();
            this.unbind();
        },
        closeSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.close();
            });
        },
        show: function () {
            this.options.state = app.view_states.shown;

            this.showSubviews();
            this.bindEvents();
            this.$el.show();
        },
        showSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.show();
            });
        },
        hide: function () {
            this.options.state = app.view_states.hidden;

            this.hideSubviews();

            this.$el.hide();
            this.unbind();
            this.stopListening();
        },
        hideSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.hide();
            });
        },
        preRender: function () {
            app.models.subnavbar.set("subnavbar", false);
        },
        reRender: function (urlParams) {
            try {
                this.refresh(viewParams);
            } catch (Error) { }
        },

    });

    Screen.Models.DelaysModalMain = Backbone.Epoxy.Model.extend({
        defaults: {
            errorMsg: '',
            processing: false,
            equipments: {},
            equipmentId: null,
            row: {},
            comments: null,
            equipmentTypeId: null,
            equipmentTypeName: null,
            equipmentName: null,
            lastChange: null,
            furnaceCode: null,
            counts: null,
            equipmentLocationId: null,
            equipmentsLength: null,
            dateModal: new moment().format('MM/DD/YYYY'),
            timeModal: new moment().format('HH:mm:ss'),
            title:'',
        },
        computeds: {
            hasEquipmentTypeId: {
                deps: ['equipmentTypeId'],
                get: function (value) {
                    return value;
                }
            },
        },
        fetchSpares: function (params) {
            var that = this;
            if (params.equipmentTypeId) {
                var qp = new Core.Database.QueryParameters();
                qp.Add('@EquipmentTypeId', 'INT', params.equipmentTypeId);
                Core.Json.CallProcedure(
                    app.DatabaseNames.MES + '.EAF.GetAvailableSparesWeb',
                    qp,
                    {
                        onSuccess: function (resp) {
                            try {

                                if ((resp) && (resp.Table)) {
                                    var records = resp.Table,
                                        newColl;
                                    newColl = _.map(records, function (obj) {
                                        return {
                                            label: obj.Name,
                                            value: obj.Id,
                                        }
                                    });
                                    that.set('equipments', newColl);
                                }
                                else {
                                    if ((resp) && (resp.Message))
                                        console.error(resp.Message);
                                    else
                                        console.error('Server response not valid.');
                                }
                            }
                            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                        },
                        Secured: true,
                        Async: false,
                    },
                    app.ConnectionStrings.app
                );

                return this;
            };
        }

    });

    Screen.Views.DelaysModal = Backbone.Epoxy.View.extend({
        template: "eaf-change-equipment",
        id: "delays-modal",
        className: "modal modal-delays hide fade",
        bindings: "data-bind",
        isCacheable: true,
        events: function () {
            return {
                "click #acceptBtn": this.acceptBtn_click,
                "click #cancelBtn": this.cancelBtn_click,
                "submit form": this.form_submit,
                "keypress": this.modal_keypress,
                "show.bs.modal": this.modal_show,
                "shown.bs.modal": this.modal_shown,
                "hidden.bs.modal": this.modal_hidden,
            };
        },

        container: null,
        disposed: false,
        isRendered: false,
        preventDispose: false,
        visible: false,

        initialize: function (options) {
            _.extend(this, options);
            if (!this.model) {
                this.model = new Screen.Models.DelaysModalMain();
            }

            this.model.fetchSpares({ equipmentTypeId: options.row.attributes.EquipmentTypeId });
            this.model.set({
                equipmentsLength: this.model.get('equipments') ? (this.model.get('equipments').length == 0 ? null : this.model.get('equipments').length) : null,
                row: options.row,
                equipmentLocationId: options.row.attributes.EquipmentLocationId,
                locationName: options.row.attributes.LocationName,
                equipmentTypeName: options.row.attributes.EquipmentTypeName,
                equipmentTypeId: options.row.attributes.EquipmentTypeId,
                equipmentName: options.row.attributes.EquipmentName,
                lastChange: options.row.attributes.LastChange ? options.row.attributes.LastChange : '',
                counts: options.row.attributes.Counter,
                furnaceCode: options.furnaceCode == 1 ? 'A' : 'B',
                dateModal : new moment().format('MM/DD/YYYY'),
                timeModal: new moment().format('HH:mm:ss'),
                
            });
            this.model.set({
                title: "Furnace " + this.model.get("furnaceCode") + " - " + this.model.get("locationName"),
            })

            this.bus = options.bus;

            this.bindEvents();

            return this;
        },

        hide: function (preventDispose) {
            this.preventDispose = (preventDispose);

            this.$el.modal('hide');
        },
        render: function (container) {
            if (container)
                this.container = container;

            var that = this;
            var customPath = '/app/custom-screens/' + this.template + '/';
            T.render.call(this, this.template, function (tmp) {
                if (!that.i18n) that.i18n = {};
                app.getI18NJed(that, that.template, function (i18nJED) {
                    that.i18n[that.template] = i18nJED;
                    that.$el.html(tmp(that.model.toJSON()));
                    that.applyBindings();

                    that.isRendered = true;

                    that.$el.find('#dateModal').datepicker();
                    that.$el.find('#timeModal').timepicker({
                        showMeridian: false,
                        secondStep: 1,
                        minuteStep: 1,
                        showSeconds: true,
                    });


                    that.trigger("render");
                    if (!that.model.get("equipmentsLength")) {
                        that.$el.find('#spares').attr("disabled", true); 
                    }
                    

                }, true, customPath);

            }, customPath, "delays_declare_modal");

        },
        show: function () {
            if (!this.isRendered) {
                this.render();
            }
            else {
                this.$el.modal({
                    keyboard: true,
                    backdrop: 'both',
                });
            }

            return this;
        },

        bindEvents: function () {
            this.listenToOnce(this, "render", this.view_render);
        },

        close: function () {
            if (this.disposed == false) {
                if (this.visible == true) {
                    this.hide();
                }
                else {
                    this.trigger('close');

                    this.remove();
                    this.unbind();

                    this.disposed = true;
                }
            }
        },
        preRender: function () {
            app.models.subnavbar.set("dateControl", false);
        },
        reRender: function () {
        },

        acceptBtn_click: function (e) {
            try {
                var that = this,
                    attrs = that.row.attributes,
                    modelAttrs = this.model.toJSON();
                var params = {
                    furnaceCode: modelAttrs.furnaceCode == "A" ? 1 : 2,
                    equipmentId: (modelAttrs.equipmentId == "null" || modelAttrs.equipmentId == "" ) ? null : modelAttrs.equipmentId,
                    equipmentLocationId: attrs.EquipmentLocationId,
                    comments: modelAttrs.comments,
                    datetime: new moment(modelAttrs.dateModal, 'MM/DD/YYYY').format('YYYY-MM-DD') + ' ' + new moment(modelAttrs.timeModal, 'HH:mm:ss').format('HH:mm:ss'),
                }

                this.bus.trigger("modalAcceptBtn",params);

                this.close();
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },
        form_submit: function (e) {
            try {
                e.preventDefault();
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },
        modal_hidden: function (e) {
            try {
                this.visible = false;

                if (!this.preventDispose)
                    this.close();
                else
                    this.preventDispose = false;
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },
        modal_show: function (e) {
            try {
                this.visible = true;
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },
        modal_shown: function (e) {
            try {
                this.$el.find(".autofocus").focus();
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },
        view_render: function () {
            try {
                this.show();
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },
       
    });


    // Required, return the module for AMD compliance.
    return Screen;
});