﻿//SCREEN-BOILERPLATE

//this boilerplate builds screens that are gonna be shown in the <div class='content'> tag of our main HTML.
//do not build app components with this boilerplate, only screens (reports)

define([
  // Application variable, always include it to have access to app methods.
  'app',

  //templates-loader: this loads templates async.
  'js/templates-loader',
  'backgrid',
  'moment',
    'js/jquery.clearsearch/jquery.clearsearch',
    'backgrid/grouped-columns',
],

 function (app, T, Backgrid,moment) {

    var Screen = { Models: {}, Views: {}, Collections: {} }


    Screen.Models.Item = Backbone.Epoxy.Model.extend({
        defaults: {  
            SundayCompleteDate   : null,
            SundayTotalTons      : null,
            SundayTotalTonsAM    : null,
            SundayTonsCaster1AM  : null,
            SundayTonsCaster2AM  : null,
            SundaySizesCaster1AM : null,
            SundaySizesCaster2AM : null,
            SundayTotalTonsPM   :   null,
            SundayTonsCaster1PM : null,
            SundayTonsCaster2PM : null,
            SundaySizesCaster1PM: null,
            SundaySizesCaster2PM: null,

            MondayCompleteDate  :null,
            MondayTotalTons     :null,
            MondayTotalTonsAM   :null,
            MondayTonsCaster1AM :null,
            MondayTonsCaster2AM :null,
            MondaySizesCaster1AM:null,
            MondaySizesCaster2AM: null,
            MondayTotalTonsPM   :null,
            MondayTonsCaster1PM :null,
            MondayTonsCaster2PM :null,
            MondaySizesCaster1PM:null,
            MondaySizesCaster2PM: null,

            TuesdayCompleteDate   : null,
            TuesdayTotalTons      : null,
            TuesdayTotalTonsAM    : null,
            TuesdayTonsCaster1AM  : null,
            TuesdayTonsCaster2AM  : null,
            TuesdaySizesCaster1AM : null,
            TuesdaySizesCaster2AM: null,
            TuesdayTotalTonsPM:     null,
            TuesdayTonsCaster1PM:   null,
            TuesdayTonsCaster2PM:   null,
            TuesdaySizesCaster1PM: null,
            TuesdaySizesCaster2PM: null,

            WednesdayCompleteDate  :null,
            WednesdayTotalTons     :null,
            WednesdayTotalTonsAM   :null,
            WednesdayTonsCaster1AM :null,
            WednesdayTonsCaster2AM :null,
            WednesdaySizesCaster1AM:null,
            WednesdaySizesCaster2AM: null,
            WednesdayTotalTonsPM:   null,
            WednesdayTonsCaster1PM: null,
            WednesdayTonsCaster2PM: null,
            WednesdaySizesCaster1PM: null,
            WednesdaySizesCaster2PM: null,


            ThursdayCompleteDate   : null,
            ThursdayTotalTons      : null,
            ThursdayTotalTonsAM    : null,
            ThursdayTonsCaster1AM  : null,
            ThursdayTonsCaster2AM  : null,
            ThursdaySizesCaster1AM : null,
            ThursdaySizesCaster2AM : null,
            ThursdayTotalTonsPM:    null,
            ThursdayTonsCaster1PM:  null,
            ThursdayTonsCaster2PM:  null,
            ThursdaySizesCaster1PM: null,
            ThursdaySizesCaster2PM: null,

            FridayCompleteDate   : null,   
            FridayTotalTons      : null,   
            FridayTotalTonsAM    : null,   
            FridayTonsCaster1AM  : null,   
            FridayTonsCaster2AM  : null,   
            FridaySizesCaster1AM : null,   
            FridaySizesCaster2AM:  null,   
            FridayTotalTonsPM:   null,
            FridayTonsCaster1PM: null,
            FridayTonsCaster2PM: null,
            FridaySizesCaster1PM: null,
            FridaySizesCaster2PM: null,   

            SaturdayCompleteDate    : null,
            SaturdayTotalTons       : null,
            SaturdayTotalTonsAM     : null,
            SaturdayTonsCaster1AM   : null,
            SaturdayTonsCaster2AM   : null,
            SaturdaySizesCaster1AM  : null,
            SaturdaySizesCaster2AM  : null,
            SaturdayTotalTonsPM     : null,
            SaturdayTonsCaster1PM   : null,
            SaturdayTonsCaster2PM   : null,
            SaturdaySizesCaster1PM  : null,
            SaturdaySizesCaster2PM  : null,




            //
            SundayMoldsCaster1AM: null,
            SundayMoldsCaster2AM: null,
            SundayMoldsCaster1PM: null,
            SundayMoldsCaster2PM: null,
            MondayMoldsCaster1AM: null,
            MondayMoldsCaster2AM: null,
            MondayMoldsCaster1PM: null,
            MondayMoldsCaster2PM: null,
            TuesdayMoldsCaster1AM: null,
            TuesdayMoldsCaster2AM: null,
            TuesdayMoldsCaster1PM: null,
            TuesdayMoldsCaster2PM: null,
            WednesdayMoldsCaster1AM: null,
            WednesdayMoldsCaster2AM: null,
            WednesdayMoldsCaster1PM: null,
            WednesdayMoldsCaster2PM: null,
            ThursdayMoldsCaster1AM: null,
            ThursdayMoldsCaster2AM: null,
            ThursdayMoldsCaster1PM: null,
            ThursdayMoldsCaster2PM: null,
            FridayMoldsCaster1AM: null,
            FridayMoldsCaster2AM: null,
            FridayMoldsCaster1PM: null,
            FridayMoldsCaster2PM: null,
            SaturdayMoldsCaster1AM: null,
            SaturdayMoldsCaster2AM: null,
            SaturdayMoldsCaster1PM: null,
            SaturdayMoldsCaster2PM: null,
        },
        isNull: function (val) {
            val = +val || 0
            return val;
        },
        parse: function (objs) {
            var result = {};

            var that = this;
            if (objs) {
                _.each(objs, function (obj) {

                    if (obj.ShiftId === 'D') {
                        switch (obj.Day) {
                            case 'Sunday':
                                result.SundayCompleteDate   = 'Sunday ' + obj.Date;
                                result.SundayTotalTons = obj.isPastData || result.SundayTotalTons > 0 ? that.isNull(result.SundayTotalTons) + that.isNull(obj.ActualTonsCaster1) + that.isNull(obj.ActualTonsCaster2) : 0;
                                result.SundayTotalTonsAM = obj.isPastData ? (obj.ActualTonsCaster1 + obj.ActualTonsCaster2) : '0';
                                result.SundayTonsCaster1AM  = obj.isPastData ? obj.ActualTonsCaster1 : '0';
                                result.SundayTonsCaster2AM  = obj.isPastData ? obj.ActualTonsCaster2 : '0';
                                result.SundaySizesCaster1AM = obj.isPastData ? obj.ActualSizesCaster1 : obj.ProjectedSizesCaster1;
                                result.SundaySizesCaster2AM = obj.isPastData ? obj.ActualSizesCaster2 : obj.ProjectedSizesCaster2;   
                                result.SundayMoldsCaster1AM = obj.isPastData ? obj.ActualMoldsCaster1 : obj.ProjectedMoldsCaster1;
                                result.SundayMoldsCaster2AM = obj.isPastData ? obj.ActualMoldsCaster2 : obj.ProjectedMoldsCaster2; 
                               
                                break;
                            case 'Monday':
                                result.MondayCompleteDate   = 'Monday ' + obj.Date;
                                result.MondayTotalTons = obj.isPastData || result.MondayTotalTons > 0 ? that.isNull(result.MondayTotalTons) + that.isNull(obj.ActualTonsCaster1) + that.isNull(obj.ActualTonsCaster2) : 0;
                                result.MondayTotalTonsAM = obj.isPastData ? (obj.ActualTonsCaster1 + obj.ActualTonsCaster2) : '0';
                                result.MondayTonsCaster1AM  = obj.isPastData ? obj.ActualTonsCaster1 : '0';
                                result.MondayTonsCaster2AM  = obj.isPastData ? obj.ActualTonsCaster2 : '0';
                                result.MondaySizesCaster1AM = obj.isPastData ? obj.ActualSizesCaster1 : obj.ProjectedSizesCaster1;
                                result.MondaySizesCaster2AM = obj.isPastData ? obj.ActualSizesCaster2 : obj.ProjectedSizesCaster2;
                                result.MondayMoldsCaster1AM = obj.isPastData ? obj.ActualMoldsCaster1 : obj.ProjectedMoldsCaster1;
                                result.MondayMoldsCaster2AM = obj.isPastData ? obj.ActualMoldsCaster2 : obj.ProjectedMoldsCaster2; 
                                break;
                            case 'Tuesday':
                                result.TuesdayCompleteDate      = 'Tuesday ' + obj.Date;
                                result.TuesdayTotalTons         = obj.isPastData || result.TuesdayTotalTons > 0 ? that.isNull(result.TuesdayTotalTons) + that.isNull(obj.ActualTonsCaster1) + that.isNull(obj.ActualTonsCaster2) : 0;
                                result.TuesdayTotalTonsAM = obj.isPastData ? (obj.ActualTonsCaster1 + obj.ActualTonsCaster2) : '0';
                                result.TuesdayTonsCaster1AM     = obj.isPastData ? obj.ActualTonsCaster1 : '0';
                                result.TuesdayTonsCaster2AM     = obj.isPastData ? obj.ActualTonsCaster2 : '0';
                                result.TuesdaySizesCaster1AM    = obj.isPastData ? obj.ActualSizesCaster1 : obj.ProjectedSizesCaster1;
                                result.TuesdaySizesCaster2AM    = obj.isPastData ? obj.ActualSizesCaster2 : obj.ProjectedSizesCaster2;  
                                result.TuesdayMoldsCaster1AM    = obj.isPastData ? obj.ActualMoldsCaster1 : obj.ProjectedMoldsCaster1;
                                result.TuesdayMoldsCaster2AM    = obj.isPastData ? obj.ActualMoldsCaster2 : obj.ProjectedMoldsCaster2;       
                                break;
                            case 'Wednesday':
                                result.WednesdayCompleteDate    = 'Wednesday ' + obj.Date;
                                result.WednesdayTotalTons = obj.isPastData || result.WednesdayTotalTons > 0 ? that.isNull(result.WednesdayTotalTons) + that.isNull(obj.ActualTonsCaster1) + that.isNull(obj.ActualTonsCaster2) : 0;
                                result.WednesdayTotalTonsAM = obj.isPastData ? (obj.ActualTonsCaster1 + obj.ActualTonsCaster2) : '0';
                                result.WednesdayTonsCaster1AM   = obj.isPastData ? obj.ActualTonsCaster1 : '0';
                                result.WednesdayTonsCaster2AM   = obj.isPastData ? obj.ActualTonsCaster2 : '0';
                                result.WednesdaySizesCaster1AM  = obj.isPastData ? obj.ActualSizesCaster1 : obj.ProjectedSizesCaster1;
                                result.WednesdaySizesCaster2AM  = obj.isPastData ? obj.ActualSizesCaster2 : obj.ProjectedSizesCaster2; 
                                result.WednesdayMoldsCaster1AM  = obj.isPastData ? obj.ActualMoldsCaster1 : obj.ProjectedMoldsCaster1;
                                result.WednesdayMoldsCaster2AM  = obj.isPastData ? obj.ActualMoldsCaster2 : obj.ProjectedMoldsCaster2; 
                                break;
                            case 'Thursday':
                                result.ThursdayCompleteDate     = 'Thursday ' + obj.Date;
                                result.ThursdayTotalTons = obj.isPastData || result.ThursdayTotalTons > 0 ? that.isNull(result.ThursdayTotalTons) + that.isNull(obj.ActualTonsCaster1) + that.isNull(obj.ActualTonsCaster2) : 0;
                                result.ThursdayTotalTonsAM = obj.isPastData ? (obj.ActualTonsCaster1 + obj.ActualTonsCaster2) : '0';
                                result.ThursdayTonsCaster1AM    = obj.isPastData ? obj.ActualTonsCaster1 : '0';
                                result.ThursdayTonsCaster2AM    = obj.isPastData ? obj.ActualTonsCaster2 : '0';
                                result.ThursdaySizesCaster1AM   = obj.isPastData ? obj.ActualSizesCaster1 : obj.ProjectedSizesCaster1;
                                result.ThursdaySizesCaster2AM   = obj.isPastData ? obj.ActualSizesCaster2 : obj.ProjectedSizesCaster2; 
                                result.ThursdayMoldsCaster1AM   = obj.isPastData ? obj.ActualMoldsCaster1 : obj.ProjectedMoldsCaster1;
                                result.ThursdayMoldsCaster2AM   = obj.isPastData ? obj.ActualMoldsCaster2 : obj.ProjectedMoldsCaster2;  
                                break;
                            case 'Friday':
                                result.FridayCompleteDate       = 'Friday ' + obj.Date;
                                result.FridayTotalTons = obj.isPastData || result.FridayTotalTons > 0 ? that.isNull(result.FridayTotalTons) + that.isNull(obj.ActualTonsCaster1) + that.isNull(obj.ActualTonsCaster2) : 0;
                                result.FridayTotalTonsAM = obj.isPastData ? (obj.ActualTonsCaster1 + obj.ActualTonsCaster2) : '0';
                                result.FridayTonsCaster1AM      = obj.isPastData ? obj.ActualTonsCaster1 : '0';
                                result.FridayTonsCaster2AM      = obj.isPastData ? obj.ActualTonsCaster2 : '0';
                                result.FridaySizesCaster1AM     = obj.isPastData ? obj.ActualSizesCaster1 : obj.ProjectedSizesCaster1;
                                result.FridaySizesCaster2AM     = obj.isPastData ? obj.ActualSizesCaster2 : obj.ProjectedSizesCaster2; 
                                result.FridayMoldsCaster1AM     = obj.isPastData ? obj.ActualMoldsCaster1 : obj.ProjectedMoldsCaster1;
                                result.FridayMoldsCaster2AM     = obj.isPastData ? obj.ActualMoldsCaster2 : obj.ProjectedMoldsCaster2; 
                                break;
                            case 'Saturday':
                                result.SaturdayCompleteDate     = 'Saturday ' + obj.Date;
                                result.SaturdayTotalTons = obj.isPastData || result.SaturdayTotalTons > 0 ? that.isNull(result.SaturdayTotalTons) + that.isNull(obj.ActualTonsCaster1) + that.isNull(obj.ActualTonsCaster2) : 0;
                                result.SaturdayTotalTonsAM = obj.isPastData ? (obj.ActualTonsCaster1 + obj.ActualTonsCaster2) : '0';
                                result.SaturdayTonsCaster1AM    = obj.isPastData ? obj.ActualTonsCaster1: '0';
                                result.SaturdayTonsCaster2AM    = obj.isPastData ? obj.ActualTonsCaster2: '0';
                                result.SaturdaySizesCaster1AM   = obj.isPastData ? obj.ActualSizesCaster1 : obj.ProjectedSizesCaster1;
                                result.SaturdaySizesCaster2AM   = obj.isPastData ? obj.ActualSizesCaster2 : obj.ProjectedSizesCaster2; 
                                result.SaturdayMoldsCaster1AM   = obj.isPastData ? obj.ActualMoldsCaster1 : obj.ProjectedMoldsCaster1;
                                result.SaturdayMoldsCaster2AM   = obj.isPastData ? obj.ActualMoldsCaster2 : obj.ProjectedMoldsCaster2; 
                                break;
                        };

                    } else {
                        switch (obj.Day) {
                            case 'Sunday':
                                result.SundayCompleteDate = 'Sunday ' + obj.Date;
                                result.SundayTotalTons = obj.isPastData || result.SundayTotalTons > 0 ? that.isNull(result.SundayTotalTons) + that.isNull(obj.ActualTonsCaster1) + that.isNull(obj.ActualTonsCaster2) : 0;
                                result.SundayTotalTonsPM = obj.isPastData ? (obj.ActualTonsCaster1 + obj.ActualTonsCaster2) : '0';
                                result.SundayTonsCaster1PM = obj.isPastData ? obj.ActualTonsCaster1 : '0';
                                result.SundayTonsCaster2PM = obj.isPastData ? obj.ActualTonsCaster2 : '0';
                                result.SundaySizesCaster1PM = obj.isPastData ? obj.ActualSizesCaster1 : obj.ProjectedSizesCaster1;
                                result.SundaySizesCaster2PM = obj.isPastData ? obj.ActualSizesCaster2 : obj.ProjectedSizesCaster2;
                                result.SundayMoldsCaster1PM = obj.isPastData ? obj.ActualMoldsCaster1 : obj.ProjectedMoldsCaster1;
                                result.SundayMoldsCaster2PM = obj.isPastData ? obj.ActualMoldsCaster2 : obj.ProjectedMoldsCaster2;

                                break;
                            case 'Monday':
                                result.MondayCompleteDate = 'Monday ' + obj.Date;
                                result.MondayTotalTons = obj.isPastData || result.MondayTotalTons > 0 ? that.isNull(result.MondayTotalTons) + that.isNull(obj.ActualTonsCaster1) + that.isNull(obj.ActualTonsCaster2) : 0;
                                result.MondayTotalTonsPM = obj.isPastData ? (obj.ActualTonsCaster1 + obj.ActualTonsCaster2) : '0';
                                result.MondayTonsCaster1PM = obj.isPastData ? obj.ActualTonsCaster1 : '0';
                                result.MondayTonsCaster2PM = obj.isPastData ? obj.ActualTonsCaster2 : '0';
                                result.MondaySizesCaster1PM = obj.isPastData ? obj.ActualSizesCaster1 : obj.ProjectedSizesCaster1;
                                result.MondaySizesCaster2PM = obj.isPastData ? obj.ActualSizesCaster2 : obj.ProjectedSizesCaster2;
                                result.MondayMoldsCaster1PM = obj.isPastData ? obj.ActualMoldsCaster1 : obj.ProjectedMoldsCaster1;
                                result.MondayMoldsCaster2PM = obj.isPastData ? obj.ActualMoldsCaster2 : obj.ProjectedMoldsCaster2;
                                break;
                            case 'Tuesday':
                                result.TuesdayCompleteDate = 'Tuesday ' + obj.Date;    
                                result.TuesdayTotalTons = obj.isPastData || result.TuesdayTotalTons > 0 ? that.isNull(result.TuesdayTotalTons) + that.isNull(obj.ActualTonsCaster1) + that.isNull(obj.ActualTonsCaster2) : 0;
                                result.TuesdayTotalTonsPM = obj.isPastData ? (obj.ActualTonsCaster1 + obj.ActualTonsCaster2) : '0';
                                result.TuesdayTonsCaster1PM = obj.isPastData ? obj.ActualTonsCaster1 : '0';
                                result.TuesdayTonsCaster2PM = obj.isPastData ? obj.ActualTonsCaster2 : '0';
                                result.TuesdaySizesCaster1PM = obj.isPastData ? obj.ActualSizesCaster1 : obj.ProjectedSizesCaster1;
                                result.TuesdaySizesCaster2PM = obj.isPastData ? obj.ActualSizesCaster2 : obj.ProjectedSizesCaster2;
                                result.TuesdayMoldsCaster1PM = obj.isPastData ? obj.ActualMoldsCaster1 : obj.ProjectedMoldsCaster1;
                                result.TuesdayMoldsCaster2PM = obj.isPastData ? obj.ActualMoldsCaster2 : obj.ProjectedMoldsCaster2;
                                break;
                            case 'Wednesday':
                                result.WednesdayCompleteDate = 'Wednesday ' + obj.Date;
                                result.WednesdayTotalTons = obj.isPastData || result.WednesdayTotalTons > 0 ? that.isNull(result.WednesdayTotalTons) + that.isNull(obj.ActualTonsCaster1) + that.isNull(obj.ActualTonsCaster2) : 0;
                                result.WednesdayTotalTonsPM = obj.isPastData ? (obj.ActualTonsCaster1 + obj.ActualTonsCaster2) : '0';
                                result.WednesdayTonsCaster1PM = obj.isPastData ? obj.ActualTonsCaster1 : '0';
                                result.WednesdayTonsCaster2PM = obj.isPastData ? obj.ActualTonsCaster2 : '0';
                                result.WednesdaySizesCaster1PM = obj.isPastData ? obj.ActualSizesCaster1 : obj.ProjectedSizesCaster1;
                                result.WednesdaySizesCaster2PM = obj.isPastData ? obj.ActualSizesCaster2 : obj.ProjectedSizesCaster2;
                                result.WednesdayMoldsCaster1PM = obj.isPastData ? obj.ActualMoldsCaster1 : obj.ProjectedMoldsCaster1;
                                result.WednesdayMoldsCaster2PM = obj.isPastData ? obj.ActualMoldsCaster2 : obj.ProjectedMoldsCaster2;
                                break;
                            case 'Thursday':
                                result.ThursdayCompleteDate = 'Thursday ' + obj.Date;
                                result.ThursdayTotalTons = obj.isPastData || result.ThursdayTotalTons > 0 ? that.isNull(result.ThursdayTotalTons) + that.isNull(obj.ActualTonsCaster1) + that.isNull(obj.ActualTonsCaster2) : 0;
                                result.ThursdayTotalTonsPM = obj.isPastData ? (obj.ActualTonsCaster1 + obj.ActualTonsCaster2) : '0';
                                result.ThursdayTonsCaster1PM = obj.isPastData ? obj.ActualTonsCaster1 : '0';
                                result.ThursdayTonsCaster2PM = obj.isPastData ? obj.ActualTonsCaster2 : '0';
                                result.ThursdaySizesCaster1PM = obj.isPastData ? obj.ActualSizesCaster1 : obj.ProjectedSizesCaster1;
                                result.ThursdaySizesCaster2PM = obj.isPastData ? obj.ActualSizesCaster2 : obj.ProjectedSizesCaster2;
                                result.ThursdayMoldsCaster1PM = obj.isPastData ? obj.ActualMoldsCaster1 : obj.ProjectedMoldsCaster1;
                                result.ThursdayMoldsCaster2PM = obj.isPastData ? obj.ActualMoldsCaster2 : obj.ProjectedMoldsCaster2;
                                break;
                            case 'Friday':
                                result.FridayCompleteDate = 'Friday ' + obj.Date;
                                result.FridayTotalTons = obj.isPastData || result.FridayTotalTons > 0 ? that.isNull(result.FridayTotalTons) + that.isNull(obj.ActualTonsCaster1) + that.isNull(obj.ActualTonsCaster2) : 0;
                                result.FridayTotalTonsPM = obj.isPastData ? (obj.ActualTonsCaster1 + obj.ActualTonsCaster2) : '0';
                                result.FridayTonsCaster1PM = obj.isPastData ? obj.ActualTonsCaster1 : '0';
                                result.FridayTonsCaster2PM = obj.isPastData ? obj.ActualTonsCaster2 : '0';
                                result.FridaySizesCaster1PM = obj.isPastData ? obj.ActualSizesCaster1 : obj.ProjectedSizesCaster1;
                                result.FridaySizesCaster2PM = obj.isPastData ? obj.ActualSizesCaster2 : obj.ProjectedSizesCaster2;
                                result.FridayMoldsCaster1PM = obj.isPastData ? obj.ActualMoldsCaster1 : obj.ProjectedMoldsCaster1;
                                result.FridayMoldsCaster2PM = obj.isPastData ? obj.ActualMoldsCaster2 : obj.ProjectedMoldsCaster2;
                                break;
                            case 'Saturday':
                                result.SaturdayCompleteDate = 'Saturday ' + obj.Date;
                                result.SaturdayTotalTons = obj.isPastData || result.SaturdayTotalTons > 0 ? that.isNull(result.SaturdayTotalTons) + that.isNull(obj.ActualTonsCaster1) + that.isNull(obj.ActualTonsCaster2) : 0;
                                result.SaturdayTotalTonsPM = obj.isPastData ? (obj.ActualTonsCaster1 + obj.ActualTonsCaster2) : '0';
                                result.SaturdayTonsCaster1PM = obj.isPastData ? obj.ActualTonsCaster1 : '0';
                                result.SaturdayTonsCaster2PM = obj.isPastData ? obj.ActualTonsCaster2 : '0';
                                result.SaturdaySizesCaster1PM = obj.isPastData ? obj.ActualSizesCaster1 : obj.ProjectedSizesCaster1;
                                result.SaturdaySizesCaster2PM = obj.isPastData ? obj.ActualSizesCaster2 : obj.ProjectedSizesCaster2;
                                result.SaturdayMoldsCaster1PM = obj.isPastData ? obj.ActualMoldsCaster1 : obj.ProjectedMoldsCaster1;
                                result.SaturdayMoldsCaster2PM = obj.isPastData ? obj.ActualMoldsCaster2 : obj.ProjectedMoldsCaster2;
                                break;
                        };
                    }
                   
                });
            }

            return result;
        },
    });

     Screen.Collections.Items = Backbone.Collection.extend({
         model: Screen.Models.Item,
         setDataColl: function (data) {
             var newColl,
                 that = this;
             newColl = that.model.prototype.parse(data);
             that.set(newColl);
         },
     });

    Screen.Models.Main = Backbone.Epoxy.Model.extend({
        defaults: {
            items: null,

            hasData: false,
            isLoading: true,

            fileName: '',
            tonsCastedPreviousMonth: '',
            tonsCastedCurrentMonth: '',             
            tonsCastedPreviousWeek: '',
            tonsCastedCurrentWeek: '',

        },
        initialize: function () {

            this.itemsPreviousWeek  = new Screen.Collections.Items();
            this.itemsCurrentWeek   = new Screen.Collections.Items();
            this.itemsNextWeek      = new Screen.Collections.Items();
        },
        fetch: function () {
            var that = this,
                qp = new Core.Database.QueryParameters();
    
            Core.Json.CallProcedure(
                app.DatabaseNames.MES + '.MES.GetRunSchedule',
                qp,
                {
                    onSuccess: function (resp) {
                        try {
                            if ((resp) && (resp.Table)) {                                
                           
                                that.itemsPreviousWeek.setDataColl(_.where(resp.Table, { Week: 'Previous' }));

                                that.itemsCurrentWeek.setDataColl(_.where(resp.Table, { Week: 'Current' }));
                                that.itemsNextWeek.setDataColl(_.where(resp.Table, { Week: 'Next' }));

                               
                                if (resp.Table1 && resp.Table1[0]) {
                                    var sumData = resp.Table1[0];
                                    that.set({
                                        tonsCastedCurrentMonth: `Tons Cast for Previous Month ( ${sumData.PreviousMonth} ) : ${sumData.PreviousMonthTons} | Tons Cast for Current Month ( ${sumData.CurrentMonth} ) : ${sumData.CurrentMonthTons}`,                                        
                                        tonsCastedPreviousWeek: `Tons Cast For Previous Week Of ${sumData.PreviousWeekDate}: ${sumData.PreviousWeekTons}`,
                                        tonsCastedCurrentWeek: `Tons Cast For Current Week Of ${sumData.CurrentWeekDate}: ${sumData.CurrentWeekTons}`,
                                    })
                                }

                        
                               
                                that.trigger('fetch', that);
                            }
                            else {
                                if ((resp) && (resp.Message))
                                    console.error(new Error(resp.Message).stack);
                                else
                                    console.error(new Error('SERVER_RESPONSE_NOT_VALID').stack);
                            }
                        }
                        catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
                    },
                    onFailure: function (resp) {
                        console.error(resp);
                    },
                    Secured: true,
                    Async: true,
                },
                app.ConnectionStrings.app
            );

            return this;
        },

        fetchPickers: function (params, options) {
            var that = this,
                qp = new Core.Database.QueryParameters(),
                opt = _.extend({ async: true, }, options);

            Core.Json.CallProcedure(
                app.DatabaseNames.MES + '.CAT.GetGradeGroups',
                qp,
                {
                    onSuccess: function (resp) {
                        try {
                            if ((resp) && (resp.Table)) {
                                that.set('gradeGroups', _.map(resp.Table, function (obj) {
                                    return { value: obj.Id, label: obj.Name, abbrev: obj.Abbrev };
                                }));
                            }
                            else {
                                if ((resp) && (resp.Message))
                                    console.error(new Error(resp.Message).stack);
                                else
                                    console.error(new Error('SERVER_RESPONSE_NOT_VALID').stack);
                            }
                        }
                        catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
                    },
                    onFailure: function (resp) {
                        console.error(resp);
                    },
                    Secured: true,
                    Async: false,
                },
                app.ConnectionStrings.app
            );

            return this;
        },

    });


    //the generate id method is called everytime a view is going to be shown by the router and returns and id that
    //is used by the router to store in cache (if it is cacheable) and to know the current shown view.
    //this is useful in case your view is reusable, and displays different data depending on url parameters 
    //(such as a catalog view, or a report that doesnt change in terms of UI but it does change in terms of data)
    //so you can always use the same view on the router but the cache can tell which view is which by using differents ids.
    Screen.generateID = function (viewParams) {
        try {
            //if the viewparams change the view id, then evaluate the viewparams here
            //and return the appropiate id.
            return 'forecast-run-schedule';
        } catch (Error) { }
    }

     Screen.Views.Main = Backbone.Epoxy.View.extend({
         template: 'forecast-run-schedule',
         id: 'forecast-run-schedule',
         title: 'Forecast Run Schedule',
         //default not cacheable, change this if you want the view to be cacheable
         // if the view is set as cacheable should also have a refresh method to reset the view without erasing the DOM.
         isCacheable: false,
         events: function () {
             return {
                 'click #redirect': this.redirect_click,
                 'click #refreshBtn': this.refreshBtn_click,
             };
         },
         autoRefresh: null,
         subviews: null,
         viewParams: null,

         initialize: function () {
             this.options.state = app.view_states.loading;
             this.options.onappend = (_.isFunction(this.options.onappend)) ? this.options.onappend : function () { };

             var that = this;

             this.autoRefresh = {
                 enabled: null
                 , toid: null
                 , every: 5 * 1000
             };

             this.model = new Screen.Models.Main();


             this.previousWeekColl = new (Backbone.Collection.extend({
                 model: Backbone.Model.extend({
                     idAttribute: 'order',
                 }),
                 comparator: 'order',
             }))();

             this.currentWeekColl = new (Backbone.Collection.extend({
                 model: Backbone.Model.extend({
                     idAttribute: 'order',
                 }),
                 comparator: 'order',
             }))();

             this.nextWeekColl = new (Backbone.Collection.extend({
                 model: Backbone.Model.extend({
                     idAttribute: 'order',
                 }),
                 comparator: 'order',
             }))();

             this.subviews = {};


             this.bindEvents();
         },
         redirect_click: function () {
             Backbone.history.navigate('!/ih/configuration/forecast-run-schedule-configuration', { trigger: true });
         },
         render: function (container, viewParams) {
             var that = this;

             this.viewParams = viewParams;

             var thatContainer = (this.options.container) ? this.options.container : container;
             this.options.container = thatContainer;

             //the screens have a custompath, so it has to be specified in the customPath variable that is
             //then sent to the template loader.
             var customPath = '/app/custom-screens/' + this.template + '/';

             T.render.call(
                 this,
                 this.template,
                 function (tmp) {
                     if (!that.options.i18n) that.options.i18n = {};

                     app.getI18NJed(
                         that,
                         that.template,
                         function (i18nJED) {
                             //storing internationalization data
                             that.options.i18n[that.template] = i18nJED;

                             //loading the view and appeding it to the views's $el.
                             that.$el.html(tmp());
                             that.applyBindings();

                             //start: the view was already loaded an is on a div element, but not appended to the main container
                             //here you can perform anything you want DOM related, by getting the dom element via that.$el.find('#id')
                             //or this.$('#id')

                             var columnsLayout =[
                                 {
                                     name: 'label',
                                     label: 'Day',
                                     editable: false,
                                     sortable: false,
                                     cell: Backgrid.StringCell.extend({
                                         className: 'string-cell align-center-cell',
                                         render: function () {
                                             Backgrid.StringCell.prototype.render.apply(this, arguments);

                                             this.$el.addClass('date-row-header');

                                             return this;
                                         },
                                     }),
                                 },                                
                                 {
                                     name: 'SundayAM',
                                     label: 'AM',
                                     editable: false,
                                     sortable: false,
                                     cell: Backgrid.StringCell.extend({
                                         className: function () {
                                             var model = this.model.toJSON();
                                             if (model.SundayAM === 'DOWN DAY' || model.SundayAM === 'Down Day' || model.SundayAM === 'Down') return 'down-day string-cell align-center-cell word-wrap-cell';
                                             else return 'string-cell align-center-cell word-wrap-cell';
                                         },
                                     }),
                                 },
                                 {
                                     name: 'SundayPM',
                                     label: 'PM',
                                     editable: false,
                                     sortable: false,
                                     cell: Backgrid.StringCell.extend({
                                         className: function () {
                                             var model = this.model.toJSON();
                                             if (model.SundayPM === 'DOWN DAY' || model.SundayPM === 'Down Day' || model.SundayPM === 'Down') return 'down-day string-cell align-center-cell word-wrap-cell';
                                             else return 'string-cell align-center-cell word-wrap-cell';
                                         },
                                     }),
                                 },
                                 {
                                     name: 'MondayAM',
                                     label: 'AM',
                                     editable: false,
                                     sortable: false,
                                     cell: Backgrid.StringCell.extend({
                                         className: function () {
                                             var model = this.model.toJSON();
                                             if (model.MondayAM === 'DOWN DAY' || model.MondayAM === 'Down Day' || model.MondayAM === 'Down') return 'down-day string-cell align-center-cell word-wrap-cell';
                                             else return 'string-cell align-center-cell word-wrap-cell';
                                         },
                                     }),
                                 },
                                 {
                                     name: 'MondayPM',
                                     label: 'PM',
                                     editable: false,
                                     sortable: false,
                                     cell: Backgrid.StringCell.extend({
                                         className: function () {
                                             var model = this.model.toJSON();
                                             if (model.MondayPM === 'DOWN DAY' || model.MondayPM === 'Down Day' || model.MondayPM === 'Down') return 'down-day string-cell align-center-cell word-wrap-cell';
                                             else return 'string-cell align-center-cell word-wrap-cell';
                                         },
                                     }),
                                 },
                                 {
                                     name: 'TuesdayAM',
                                     label: 'AM',
                                     editable: false,
                                     sortable: false,
                                     cell: Backgrid.StringCell.extend({
                                         className: function () {
                                             var model = this.model.toJSON();
                                             if (model.TuesdayAM === 'DOWN DAY' || model.TuesdayAM === 'Down Day' || model.TuesdayAM === 'Down') return 'down-day string-cell align-center-cell word-wrap-cell';
                                             else return 'string-cell align-center-cell word-wrap-cell';
                                         },
                                     }),
                                 },
                                 {
                                     name: 'TuesdayPM',
                                     label: 'PM',
                                     editable: false,
                                     sortable: false,
                                     cell: Backgrid.StringCell.extend({
                                         className: function () {
                                             var model = this.model.toJSON();
                                             if (model.TuesdayPM === 'DOWN DAY' || model.TuesdayPM === 'Down Day' || model.TuesdayPM === 'Down') return 'down-day string-cell align-center-cell word-wrap-cell';
                                             else return 'string-cell align-center-cell word-wrap-cell';
                                         },
                                     }),
                                 },
                                 {
                                     name: 'WednesdayAM',
                                     label: 'AM',
                                     editable: false,
                                     sortable: false,
                                     cell: Backgrid.StringCell.extend({
                                         className: function () {
                                             var model = this.model.toJSON();
                                             if (model.WednesdayAM === 'DOWN DAY' || model.WednesdayAM === 'Down Day' || model.WednesdayAM === 'Down') return 'down-day string-cell align-center-cell word-wrap-cell';
                                             else return 'string-cell align-center-cell word-wrap-cell';
                                         },
                                     }),
                                 },
                                 {
                                     name: 'WednesdayPM',
                                     label: 'PM',
                                     editable: false,
                                     sortable: false,
                                     cell: Backgrid.StringCell.extend({
                                         className: function () {
                                             var model = this.model.toJSON();
                                             if (model.WednesdayPM === 'DOWN DAY' || model.WednesdayPM === 'Down Day' || model.WednesdayPM === 'Down') return 'down-day string-cell align-center-cell word-wrap-cell';
                                             else return 'string-cell align-center-cell word-wrap-cell';
                                         },
                                     }),
                                 },
                                 {
                                     name: 'ThursdayAM',
                                     label: 'AM',
                                     editable: false,
                                     sortable: false,
                                     cell: Backgrid.StringCell.extend({
                                         className: function () {
                                             var model = this.model.toJSON();
                                             if (model.ThursdayAM === 'DOWN DAY' || model.ThursdayAM === 'Down Day' || model.ThursdayAM === 'Down') return 'down-day string-cell align-center-cell word-wrap-cell';
                                             else return 'string-cell align-center-cell word-wrap-cell';
                                         },
                                     }),
                                 },
                                 {
                                     name: 'ThursdayPM',
                                     label: 'PM',
                                     editable: false,
                                     sortable: false,
                                     cell: Backgrid.StringCell.extend({
                                         className: function () {
                                             var model = this.model.toJSON();
                                             if (model.ThursdayPM === 'DOWN DAY' || model.ThursdayPM === 'Down Day' || model.ThursdayPM === 'Down') return 'down-day string-cell align-center-cell word-wrap-cell';
                                             else return 'string-cell align-center-cell word-wrap-cell';
                                         },
                                     }),
                                 },
                                 {
                                     name: 'FridayAM',
                                     label: 'AM',
                                     editable: false,
                                     sortable: false,
                                     cell: Backgrid.StringCell.extend({
                                         className: function () {
                                             var model = this.model.toJSON();
                                             if (model.FridayAM === 'DOWN DAY' || model.FridayAM === 'Down Day' || model.FridayAM === 'Down') return 'down-day string-cell align-center-cell word-wrap-cell';
                                             else return 'string-cell align-center-cell word-wrap-cell';
                                         },
                                     }),
                                 },
                                 {
                                     name: 'FridayPM',
                                     label: 'PM',
                                     editable: false,
                                     sortable: false,
                                     cell: Backgrid.StringCell.extend({
                                         className: function () {
                                             var model = this.model.toJSON();
                                             if (model.FridayPM === 'DOWN DAY' || model.FridayPM === 'Down Day' || model.FridayPM === 'Down') return 'down-day string-cell align-center-cell word-wrap-cell';
                                             else return 'string-cell align-center-cell word-wrap-cell';
                                         },
                                     }),
                                 },
                                 {
                                     name: 'SaturdayAM',
                                     label: 'AM',
                                     editable: false,
                                     sortable: false,
                                     cell: Backgrid.StringCell.extend({
                                         className: function () {
                                             var model = this.model.toJSON();
                                             if (model.SaturdayAM === 'DOWN DAY' || model.SaturdayAM === 'Down Day' || model.SaturdayAM === 'Down') return 'down-day string-cell align-center-cell word-wrap-cell';
                                             else return 'string-cell align-center-cell word-wrap-cell';
                                         },
                                     }),
                                 },
                                 {
                                     name: 'SaturdayPM',
                                     label: 'PM',
                                     editable: false,
                                     sortable: false,
                                     cell: Backgrid.StringCell.extend({
                                         className: function () {
                                             var model = this.model.toJSON();
                                             if (model.SaturdayPM === 'DOWN DAY' || model.SaturdayPM === 'Down Day' || model.SaturdayPM === 'Down') return 'down-day string-cell align-center-cell word-wrap-cell';
                                             else return 'string-cell align-center-cell word-wrap-cell';
                                         },
                                     }),
                                 },
                               
                             ];


                             var header = Backgrid.Extension.GroupedHeader.extend({
                                 columnLayout:
                                     [
                                         {
                                             name: 'label'
                                         },
                                         {
                                             name: 'Sunday', children:
                                                 [
                                                     { name: 'AM', children: [{ name: 'SundayAM' }, { name: 'SundayPM' }] }
                                                     , { name: 'Tons', children: [{ name: 'SundayAM' }, { name: 'SundayPM' }] }
                                                 ]
                                         },
                                         {
                                             name: 'Monday', children:
                                                 [
                                                     { name: 'AM', children: [{ name: 'MondayAM' }, { name: 'MondayPM' }] }
                                                     , { name: 'Tons', children: [{ name: 'MondayAM' }, { name: 'MondayPM' }] }
                                                 ]
                                         },
                                         {
                                             name: 'Tuesday', children:
                                                 [
                                                     { name: 'AM', children: [{ name: 'TuesdayAM' }, { name: 'TuesdayPM' }] }
                                                     , { name: 'Tons', children: [{ name: 'TuesdayAM' }, { name: 'TuesdayPM' }] }
                                                 ]
                                         },

                                         {
                                             name: 'Wednesday', children:
                                                 [
                                                     { name: 'AM', children: [{ name: 'WednesdayAM' }, { name: 'WednesdayPM' }] }
                                                     , { name: 'Tons', children: [{ name: 'WednesdayAM' }, { name: 'WednesdayPM' }] }
                                                 ]
                                         },

                                         {
                                             name: 'Thursday', children:
                                                 [
                                                     { name: 'AM', children: [{ name: 'ThursdayAM' }, { name: 'ThursdayPM' }] }
                                                     , { name: 'Tons', children: [{ name: 'ThursdayAM' }, { name: 'ThursdayPM' }] }
                                                 ]
                                         },
                                         {
                                             name: 'Friday', children:
                                                 [
                                                     { name: 'AM', children: [{ name: 'FridayAM' }, { name: 'FridayPM' }] }
                                                     , { name: 'Tons', children: [{ name: 'FridayAM' }, { name: 'FridayPM' }] }
                                                 ]
                                         },
                                         {
                                             name: 'Saturday', children:
                                                 [
                                                     { name: 'AM', children: [{ name: 'SaturdayAM' }, { name: 'SaturdayPM' }] }
                                                     , { name: 'Tons', children: [{ name: 'SaturdayAM' }, { name: 'SaturdayPM' }] }
                                                 ]
                                         },
                                     ],
                                 initialize: function (options) {
                                     Backgrid.Extension.GroupedHeader.prototype.initialize.apply(this, arguments);
                                     this.listenTo(this.collection, 'backgrid:sort', this.collection_backgrid_sort);
                                 },
                                 render: function () {
                                     var that = this;
                                     Backgrid.Extension.GroupedHeader.prototype.render.apply(this, arguments);
                                     //_.each(this.columns.models, function (modelValue) {
                                     //    //if (modelValue.get('toolTip')) that.$el.find('.' + modelValue.get('name')).attr('title', modelValue.get('toolTip'))
                                     //});
                                     return this;
                                 },                                
                             });


                             var grid1 = that.options.itemsGrid = new Backgrid.Grid({
                                 className: 'backgrid table table-hover',
                                 columns: columnsLayout,
                                 header:header,
                                 collection: that.previousWeekColl,
                             });
                             that.$el.find('.items-grid-contaner-previous').append(grid1.render().el);

                             var grid2 = that.options.itemsGrid = new Backgrid.Grid({
                                 className: 'backgrid table table-hover',
                                 columns: columnsLayout,
                                 header: header,
                                 collection: that.currentWeekColl,
                             });
                             that.$el.find('.items-grid-contaner-current').append(grid2.render().el);

                             var grid3 = that.options.itemsGrid = new Backgrid.Grid({
                                 className: 'backgrid table table-hover',
                                 columns: columnsLayout,
                                 header: header,
                                 collection: that.nextWeekColl,
                             });
                             that.$el.find('.items-grid-contaner-next').append(grid3.render().el);


                             var fixedParams = _.extend({}, viewParams);

                             that.model.set('gradeGroupAbbrev', fixedParams.sectionParam1);
                             //end

                             //appending view to the main container
                             that.append(thatContainer, that.$el);

                             //Call first refresh.
                             that.autoRefresh.enabled = false;
                            // that._refresh()
                             that.refresh();
                         },
                         true,
                         customPath
                     );
                 },
                 customPath
             );
         },
         refreshBtn_click: function () {
             this.previousWeekColl.reset();
             this.currentWeekColl.reset();
             this.nextWeekColl.reset();
             this.model.set({ hasData: false, isLoading: true });
             this.model.fetch();
         },
         refresh: function () {
             this.model.fetch();
         },
         bindEvents: function () {
             this.listenTo(this.model, 'fetch', this.collection_fetch);
         },

         setTotalTons: function () {
             var aTags = document.getElementsByClassName("Tons");

             var prev = this.model.itemsPreviousWeek.models[0].toJSON();
             var curr = this.model.itemsCurrentWeek.models[0].toJSON();

             aTags[0].innerText = prev.SundayTotalTons;
             aTags[1].innerText = prev.MondayTotalTons;
             aTags[2].innerText = prev.TuesdayTotalTons;
             aTags[3].innerText = prev.WednesdayTotalTons;
             aTags[4].innerText = prev.ThursdayTotalTons;
             aTags[5].innerText = prev.FridayTotalTons;
             aTags[6].innerText = prev.SaturdayTotalTons;

             aTags[7].innerText =  curr.SundayTotalTons;
             aTags[8].innerText =  curr.MondayTotalTons;
             aTags[9].innerText =  curr.TuesdayTotalTons;
             aTags[10].innerText = curr.WednesdayTotalTons;
             aTags[11].innerText = curr.ThursdayTotalTons;
             aTags[12].innerText = curr.FridayTotalTons;
             aTags[13].innerText = curr.SaturdayTotalTons;

             aTags[14].innerText = '0'
             aTags[15].innerText = '0'
             aTags[16].innerText = '0'
             aTags[17].innerText = '0'
             aTags[18].innerText = '0'
             aTags[19].innerText = '0'
             aTags[20].innerText = '0'

         },

         setDates: function () {
             var days = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
             var aTags = {};
             var prev = this.model.itemsPreviousWeek.models[0].toJSON();
             var curr = this.model.itemsCurrentWeek.models[0].toJSON();
             var next = this.model.itemsNextWeek.models[0].toJSON();

           

             _.each(days, function (day) { 
                 aTags = document.getElementsByClassName(day);
                 if (day === "Sunday") {
                    aTags[0].innerText = prev.SundayCompleteDate;
                    aTags[1].innerText = curr.SundayCompleteDate;
                    aTags[2].innerText = next.SundayCompleteDate;
                 }
                 if (day === "Monday") {
                     aTags[0].innerText = prev.MondayCompleteDate;
                     aTags[1].innerText = curr.MondayCompleteDate;
                     aTags[2].innerText = next.MondayCompleteDate;
                 }
                 if (day === "Tuesday") {
                     aTags[0].innerText = prev.TuesdayCompleteDate;
                     aTags[1].innerText = curr.TuesdayCompleteDate;
                     aTags[2].innerText = next.TuesdayCompleteDate;
                 }
                 if (day === "Wednesday") {
                     aTags[0].innerText = prev.WednesdayCompleteDate;
                     aTags[1].innerText = curr.WednesdayCompleteDate;
                     aTags[2].innerText = next.WednesdayCompleteDate;
                 }
                 if (day === "Thursday") {
                     aTags[0].innerText = prev.ThursdayCompleteDate;
                     aTags[1].innerText = curr.ThursdayCompleteDate;
                     aTags[2].innerText = next.ThursdayCompleteDate;
                 }
                 if (day === "Friday") {
                     aTags[0].innerText = prev.FridayCompleteDate;
                     aTags[1].innerText = curr.FridayCompleteDate;
                     aTags[2].innerText = next.FridayCompleteDate;
                 }
                 if (day === "Saturday") {
                     aTags[0].innerText = prev.SaturdayCompleteDate;
                     aTags[1].innerText = curr.SaturdayCompleteDate;
                     aTags[2].innerText = next.SaturdayCompleteDate;
                 }
             });
            
            
         },

         spanDayCell: function () {
             let th = null;
             let th1 = null;
             let th_children = null;
             const label = document.getElementsByClassName('label');

             if (label[0].getAttribute("rowspan") === "3") {
                label[2].setAttribute("rowspan", "1");
                label[1].setAttribute("rowspan", "1");
                label[0].setAttribute("rowspan", "1");
                var headerTags = document.getElementsByTagName('thead');
                _.each(headerTags, function (header, i) {
                    if (i < 3) {
                         th_children = header.children;
                         th = document.createElement('th');
                         th1 = document.createElement('th');
                         $(th).addClass('renderable label');
                         $(th1).addClass('renderable label');
                         th1.setAttribute("colspan", "1");
                         th1.setAttribute("rowspan", "1");
                         th1.innerHTML = 'Shift';
                         th.setAttribute("colspan", "1");
                         th.setAttribute("rowspan", "1");
                         th.innerHTML = 'Total Tons';
                         th_children[2].insertBefore(th1, th_children[2].firstChild);                    
                         th_children[1].insertBefore(th, th_children[1].firstChild);                    
                    }
                });          

             }
         },

         spanDownDayCell: function () {
             const label = document.getElementsByClassName('down-day');
         
         },

         spanProductCell: function () {
             const label = document.getElementsByClassName('date-row-header');
             const tds = document.getElementsByTagName('td');

             //Next Week table       
             label[19].setAttribute("rowspan", "2");
             label[20].remove();

             label[16].setAttribute("rowspan", "2");
             label[17].remove();

             //Current Week table
             label[12].setAttribute("rowspan", "2");
             label[13].remove();

             label[9].setAttribute("rowspan", "2");
             label[10].remove();

            
             //Previous Week table
             label[5].setAttribute("rowspan", "2");
             label[6].remove();
             label[2].setAttribute("rowspan", "2");
             label[3].remove();





             for (let i = 46; i < 60; i++) {
                 $(tds[i]).addClass('remove-bottom-border');
             }

             for (let i = 90; i < 104; i++) {
                 $(tds[i]).addClass('remove-bottom-border');
             }
             for (let i = 149; i < 163; i++) {
                 $(tds[i]).addClass('remove-bottom-border');
             }
             for (let i = 193; i < 207; i++) {
                 $(tds[i]).addClass('remove-bottom-border');
             }

             for (let i = 252; i < 266; i++) {
                 $(tds[i]).addClass('remove-bottom-border');
             }
             for (let i = 296; i < 310; i++) {
                 $(tds[i]).addClass('remove-bottom-border');
             }


           
             
         },

         setRowBackgroundColors: function () {

             const tds = document.getElementsByTagName('td');
             // Previous Week Table
             for (let i = 16; i < 30; i++) {
                 $(tds[i]).addClass('header-cell');
             }
             for (let i = 31; i < 74; i++) {
                 $(tds[i]).addClass('tons-cell');
             }
             for (let i = 75; i < 118; i++) {
                 $(tds[i]).addClass('sizes-cell');
             }

             // Current Week Table
             for (let i = 16 + 103; i < 30 + 103; i++) {
                 $(tds[i]).addClass('header-cell');
             }
             for (let i = 31 + 103; i < 74 + 103; i++) {
                 $(tds[i]).addClass('tons-cell');
             }
             for (let i = 75 + 103; i < 118 + 103; i++) {
                 $(tds[i]).addClass('sizes-cell');
             }


             // Next Week Table
             for (let i = 16 + 103 + 103; i < 30 + 103 + 103; i++) {
                 $(tds[i]).addClass('header-cell');
             }
             for (let i = 31 + 103 + 103; i < 74 + 103 + 103; i++) {
                 $(tds[i]).addClass('tons-cell');
             }
             for (let i = 75 + 103 + 103; i < 118 + 103 + 103; i++) {
                 $(tds[i]).addClass('sizes-cell');
             }


           

         },

         addTableBorders: function (table) {

             const trs = table.getElementsByTagName('tr');
             $(trs[9]).addClass('border-row-2 border-row-3');
             $(trs[8]).addClass('border-row-2');
             $(trs[7]).addClass('border-row-1');
             $(trs[6]).addClass('border-row-2');
             $(trs[5]).addClass('border-row-2');
             $(trs[4]).addClass('border-row-1');
             $(trs[3]).addClass('border-row-2');
             $(trs[2]).addClass('border-row-1');
             $(trs[1]).addClass('border-row-2');
             $(trs[0]).addClass('border-row-1');
         },


         addTableThBorders: function (table) {
             const ths = table.getElementsByTagName('th');
             for (var i = 0; i <= 15; i++) {
                $(ths[i]).addClass('border-row-4');
             }
             for (var i = 16; i <= 30; i+=2) {
                 $(ths[i]).addClass('border-row-4');
             }

             const tds = table.getElementsByTagName('td');
             for (var i = 0; i <= 14; i += 2) {
                 $(tds[i]).addClass('border-row-4');
             }
             for (var i = 15; i <= 29; i += 2) {
                 $(tds[i]).addClass('border-row-4');
             }
         
             for (var i = 30; i <= 44; i += 2) {
                 $(tds[i]).addClass('border-row-4');
             }
             for (var i = 46; i <= 58; i += 2) {
                 $(tds[i]).addClass('border-row-4');
             }
             for (var i = 59; i <= 73; i += 2) {
                 $(tds[i]).addClass('border-row-4');
             }
             for (var i = 74; i <= 88; i += 2) {
                 $(tds[i]).addClass('border-row-4');
             }
             for (var i = 90; i <= 102; i += 2) {
                 $(tds[i]).addClass('border-row-4');
             }

          
         },


         customizeCells: function () {           
            this.spanDayCell();
            this.spanProductCell();
            this.setRowBackgroundColors();    

             const prev = document.getElementsByClassName('items-grid-contaner-previous')[0];
             const curr = document.getElementsByClassName('items-grid-contaner-current')[0];
             const next = document.getElementsByClassName('items-grid-contaner-next')[0];
             this.addTableBorders(next);
             this.addTableThBorders(next);
             this.addTableBorders(curr);
             this.addTableThBorders(curr);
             this.addTableBorders(prev);
             this.addTableThBorders(prev);
             //this.spanDownDayCell();


           
        },



         getWeekData: function (obj) {
             var data = [
                 {
                     label: 'Shift Total',
                     order: 1,
                     SundayAM: obj.SundayTotalTonsAM,
                     SundayPM: obj.SundayTotalTonsPM,                  
                     MondayAM: obj.MondayTotalTonsAM,
                     MondayPM: obj.MondayTotalTonsPM,
                     TuesdayAM: obj.TuesdayTotalTonsAM,
                     TuesdayPM: obj.TuesdayTotalTonsPM,   
                     WednesdayAM: obj.WednesdayTotalTonsAM,
                     WednesdayPM: obj.WednesdayTotalTonsPM,   
                     ThursdayAM: obj.ThursdayTotalTonsAM,
                     ThursdayPM: obj.ThursdayTotalTonsPM,  
                     FridayAM: obj.FridayTotalTonsAM,
                     FridayPM: obj.FridayTotalTonsPM,  
                     SaturdayAM: obj.SaturdayTotalTonsAM,
                     SaturdayPM: obj.SaturdayTotalTonsPM,   

                 },
                 {
                     label: 'Caster 1 Tons',
                     order: 2,
                     SundayAM: obj.SundayTonsCaster1AM,
                     SundayPM: obj.SundayTonsCaster1PM,
                     MondayAM: obj.MondayTonsCaster1AM,
                     MondayPM: obj.MondayTonsCaster1PM,
                     TuesdayAM: obj.TuesdayTonsCaster1AM,
                     TuesdayPM: obj.TuesdayTonsCaster1PM,
                     WednesdayAM: obj.WednesdayTonsCaster1AM,
                     WednesdayPM: obj.WednesdayTonsCaster1PM,
                     ThursdayAM: obj.ThursdayTonsCaster1AM,
                     ThursdayPM: obj.ThursdayTonsCaster1PM,
                     FridayAM: obj.FridayTonsCaster1AM,
                     FridayPM: obj.FridayTonsCaster1PM,
                     SaturdayAM: obj.SaturdayTonsCaster1AM,
                     SaturdayPM: obj.SaturdayTonsCaster1PM,
                 },
                 {
                     label: 'Caster 1 Product',
                     order: 3,

                     SundayAM: obj.SundayMoldsCaster1AM,
                     SundayPM: obj.SundayMoldsCaster1PM,
                     MondayAM: obj.MondayMoldsCaster1AM,
                     MondayPM: obj.MondayMoldsCaster1PM,
                     TuesdayAM: obj.TuesdayMoldsCaster1AM,
                     TuesdayPM: obj.TuesdayMoldsCaster1PM,
                     WednesdayAM: obj.WednesdayMoldsCaster1AM,
                     WednesdayPM: obj.WednesdayMoldsCaster1PM,
                     ThursdayAM: obj.ThursdayMoldsCaster1AM,
                     ThursdayPM: obj.ThursdayMoldsCaster1PM,
                     FridayAM: obj.FridayMoldsCaster1AM,
                     FridayPM: obj.FridayMoldsCaster1PM,
                     SaturdayAM: obj.SaturdayMoldsCaster1AM,
                     SaturdayPM: obj.SaturdayMoldsCaster1PM,


                 },
                 {
                     label: 'Caster 1 Product',
                     order: 4,

                     SundayAM: obj.SundaySizesCaster1AM,
                     SundayPM: obj.SundaySizesCaster1PM,
                     MondayAM: obj.MondaySizesCaster1AM,
                     MondayPM: obj.MondaySizesCaster1PM,
                     TuesdayAM: obj.TuesdaySizesCaster1AM,
                     TuesdayPM: obj.TuesdaySizesCaster1PM,
                     WednesdayAM: obj.WednesdaySizesCaster1AM,
                     WednesdayPM: obj.WednesdaySizesCaster1PM,
                     ThursdayAM: obj.ThursdaySizesCaster1AM,
                     ThursdayPM: obj.ThursdaySizesCaster1PM,
                     FridayAM: obj.FridaySizesCaster1AM,
                     FridayPM: obj.FridaySizesCaster1PM,
                     SaturdayAM: obj.SaturdaySizesCaster1AM,
                     SaturdayPM: obj.SaturdaySizesCaster1PM,


                 },
                 {
                     label: 'Caster 2 Tons',
                     order: 5,
                     SundayAM: obj.SundayTonsCaster2AM,
                     SundayPM: obj.SundayTonsCaster2PM,
                     MondayAM: obj.MondayTonsCaster2AM,
                     MondayPM: obj.MondayTonsCaster2PM,
                     TuesdayAM: obj.TuesdayTonsCaster2AM,
                     TuesdayPM: obj.TuesdayTonsCaster2PM,
                     WednesdayAM: obj.WednesdayTonsCaster2AM,
                     WednesdayPM: obj.WednesdayTonsCaster2PM,
                     ThursdayAM: obj.ThursdayTonsCaster2AM,
                     ThursdayPM: obj.ThursdayTonsCaster2PM,
                     FridayAM: obj.FridayTonsCaster2AM,
                     FridayPM: obj.FridayTonsCaster2PM,
                     SaturdayAM: obj.SaturdayTonsCaster2AM,
                     SaturdayPM: obj.SaturdayTonsCaster2PM,

                 },
              
                 {
                     label: 'Caster 2 Product',
                     order: 6,
                     SundayAM: obj.SundayMoldsCaster2AM,
                     SundayPM: obj.SundayMoldsCaster2PM,
                     MondayAM: obj.MondayMoldsCaster2AM,
                     MondayPM: obj.MondayMoldsCaster2PM,
                     TuesdayAM: obj.TuesdayMoldsCaster2AM,
                     TuesdayPM: obj.TuesdayMoldsCaster2PM,
                     WednesdayAM: obj.WednesdayMoldsCaster2AM,
                     WednesdayPM: obj.WednesdayMoldsCaster2PM,
                     ThursdayAM: obj.ThursdayMoldsCaster2AM,
                     ThursdayPM: obj.ThursdayMoldsCaster2PM,
                     FridayAM: obj.FridayMoldsCaster2AM,
                     FridayPM: obj.FridayMoldsCaster2PM,
                     SaturdayAM: obj.SaturdayMoldsCaster2AM,
                     SaturdayPM: obj.SaturdayMoldsCaster2PM,
              

                 },
                 {
                     label: 'Caster 2 Product',
                     order: 7,
                     SundayAM: obj.SundaySizesCaster2AM,
                     SundayPM: obj.SundaySizesCaster2PM,
                     MondayAM: obj.MondaySizesCaster2AM,
                     MondayPM: obj.MondaySizesCaster2PM,
                     TuesdayAM: obj.TuesdaySizesCaster2AM,
                     TuesdayPM: obj.TuesdaySizesCaster2PM,
                     WednesdayAM: obj.WednesdaySizesCaster2AM,
                     WednesdayPM: obj.WednesdaySizesCaster2PM,
                     ThursdayAM: obj.ThursdaySizesCaster2AM,
                     ThursdayPM: obj.ThursdaySizesCaster2PM,
                     FridayAM: obj.FridaySizesCaster2AM,
                     FridayPM: obj.FridaySizesCaster2PM,
                     SaturdayAM: obj.SaturdaySizesCaster2AM,
                     SaturdayPM: obj.SaturdaySizesCaster2PM,


                 },
             ];
             return data;
         },


         collection_fetch: function () {
             try {

                 var previousWeekData   = this.getWeekData(this.model.itemsPreviousWeek.first().toJSON());
                 var currentWeekData    = this.getWeekData(this.model.itemsCurrentWeek.first().toJSON());
                 var nextWeekData       = this.getWeekData(this.model.itemsNextWeek.first().toJSON());

                 this.previousWeekColl.set(previousWeekData);
                 this.currentWeekColl.set(currentWeekData);
                 this.nextWeekColl.set(nextWeekData);

                 this.model.set({
                     hasData: (this.model.itemsPreviousWeek.length > 0) || (this.model.itemsCurrentWeek.length > 0) || (this.model.itemsNextWeek.length > 0),
                     isLoading: false,
                 });
                 this.setTotalTons();
                 this.setDates();
                 this.customizeCells();

             }
             catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
         },

     


        // Common functions

        append: function (container, el) {
            el = (el != null && el != undefined) ? el : this.$el;

            if (this.options.state == app.view_states.loading
                || this.options.state == app.view_states.shown) {
                //appending view to the main container and set state to shown

                this.options.state = app.view_states.shown;
                container.append(el);

                this.options.onappend(this);
            }

            if (this.options.state == app.view_states.hidden) {
                //append and remain hidden
                container.append(el);
            }

            if (this.options.state == app.view_states.closed) {
                //return without appending.
                return;
            }
        },
        startAutoRefresh: function () {
            try {
                if (this.autoRefresh.enabled !== true) {
                    var that = this;

                    if (this.autoRefresh.toid != null) {
                        clearTimeout(this.autoRefresh.toid);
                        this.autoRefresh.toid = null;
                    }

                    this.autoRefresh.enabled = true;

                    //use a timeout to execute the first refresh to return the handle to the start function caller.
                    //So when the caller finish it will do the first refresh.
                    this.autoRefresh.toid = setTimeout(
                        function () { that._refresh(); },
                        1
                    );
                }
            } catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
        },
        stopAutoRefresh: function () {
            if (this.autoRefresh.toid != null) {
                clearTimeout(this.autoRefresh.toid);
                this.autoRefresh.toid = null;
            }
            this.autoRefresh.enabled = false;
        },
        bindViewScopedEvents: function () {
        },
        unbindViewScopedEvents: function () {
        },
        close: function () {
            this.options.state = app.view_states.closed;
            this.stopAutoRefresh();
            this.closeSubviews();
            this.remove();
            this.unbindViewScopedEvents();
            this.unbind();
        },
        closeSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.close();
            });
        },
        show: function () {
            this.options.state = app.view_states.shown;

            this.showSubviews();
            this.bindEvents();
            this.$el.show();
        },
        showSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.show();
            });
        },
        hide: function () {
            this.options.state = app.view_states.hidden;

            this.hideSubviews();
            this.stopAutoRefresh();

            this.$el.hide();
            this.unbind();
            this.stopListening();
        },
        hideSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.hide();
            });
        },
        preRender: function () {
            app.models.subnavbar.setAll(false);
            app.models.subnavbar.set('sections', '12');
            app.models.subnavbar.set('subnavbar', true);
        },
        reRender: function () {
            this.startAutoRefresh();
        },

        
    });

    //subview for the subnavbar controls
    Screen.Views.SubnavBarControls = Backbone.Epoxy.View.extend({
        id: 'forecast-run-schedule-subnavbar-controls',
        title: '',
        template: 'forecast-run-schedule',

        initialize: function () {
            this.options.state = app.view_states.loading;
            this.options.onappend = (_.isFunction(this.options.onappend)) ? this.options.onappend : function () { };

            this.bindEvents();
        },
        render: function (container, onComplete) {
            var that = this;
            var thatContainer = (container) ? container : (this.options.container) ? this.options.container : null;
            var onViewComplete = (onComplete) ? onComplete : function () { };

            //the screens have a custompath, so it has to be specified in the customPath variable that is
            //then sent to the template loader.
            var customPath = '/app/custom-screens/forecast-run-schedule/';

            T.render.call(this, this.template, function (tmp) {
                if (!that.options.i18n) that.options.i18n = {};
                app.getI18NJed(that, that.template, function (i18nJED) {
                    //storing internationalization data
                    that.options.i18n[that.template] = i18nJED;

                    var ctx = {
                        editable: (($.inArray('AdminUserRole', app.models.user.get('roles')) != -1
                            || $.inArray('SupervisorUserRole', app.models.user.get('roles')) != -1) ? true : false),
                    };

                    //loading the view and appeding it to the views's $el.
                    that.$el.html(tmp(
                        _.extend({}, ctx, (that.model) ? that.model.toJSON() : {})
                    ));

                    that.applyBindings();

                    that.append(thatContainer, that.$el);

                }, true, customPath);
            }, customPath, 'subnavbar_controls');

        },
        bindEvents: function () {
            //this function should be in every view that uses listenTo anywhere
            //all the model bindings or view-model binding should be here, to manage
            //the show/hide view easily
        },

        append: function (container, el) {
            el = (el != null && el != undefined) ? el : this.$el;

            if (this.options.state == app.view_states.loading
                || this.options.state == app.view_states.shown) {
                //appending view to the main container and set state to shown

                this.options.state = app.view_states.shown;
                container.append(el);

                this.options.onappend(this);
            }

            if (this.options.state == app.view_states.hidden) {
                //append and remain hidden
                container.append(el);
            }

            if (this.options.state == app.view_states.closed) {
                //return without appending.
                return;
            }
        },
        close: function () {
            this.options.state = app.view_states.closed;

            this.remove();
            this.unbind();
        },
        show: function () {
            this.options.state = app.view_states.shown;

            this.bindEvents();
            this.$el.show();
        },
        hide: function () {
            this.options.state = app.view_states.hidden;

            this.$el.hide();
            this.unbind();
            this.stopListening();
        },
    });

    // Required, return the module for AMD compliance.
    return Screen;

});
