﻿//SCREEN-BOILERPLATE

//this boilerplate builds screens that are gonna be shown in the <div class='content'> tag of our main HTML.
//do not build app components with this boilerplate, only screens (reports)

define([
  // Application variable, always include it to have access to app methods.
  'app',

  //templates-loader: this loads templates async.
  'js/templates-loader',
  'backgrid',
  'modules/modal',
  'js/jquery.clearsearch/jquery.clearsearch',
],

function (app, T, Backgrid, Modal) {

    var Screen = { Models: {}, Views: {}, Collections: {} }


    Screen.Models.GradeGroups = Backbone.Epoxy.Model.extend({
        defaults: {
            id: null,
            name: null,
            abbrev: null,
            active: null,
            smartId: null,
            //recipeId: null,
            //recipeName : null,
        },

        parse: function (obj) {
            var result = {
                id: obj.Id,
                name: obj.Name,
                abbrev: obj.Abbrev,
                active: obj.Active,
                smartId: obj.SmartFurnaceProfileId,
                //recipeId: obj.RecipeId,
                //recipeName: obj.RecipeName,
            };

            return result;
        }
    })


    Screen.Collections.Items = Backbone.Collection.extend({
        model: Screen.Models.GradeGroups,

        fetch: function (opt) {
            var that = this,
                qp = new Core.Database.QueryParameters();
            //qp.Add('@onlyActives', 'BIT', false);


            Core.Json.CallProcedure(
                app.DatabaseNames.MES + '.CAT.GetGradeGroups',
                qp,
                {
                    onSuccess: function (resp) {
                        try {
                            if ((resp) && (resp.Table)) {
                                var records = resp.Table,
                                    newColl;
                                newColl = _.map(records, that.model.prototype.parse);
                                that.set(newColl);
                                that.trigger('fetch', that, records);

                            }
                            else {
                                if ((resp) && (resp.Message))
                                    console.error(resp.Message);
                                else
                                    console.error('Server response not valid.');
                            }
                        }
                        catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                    },
                    Async: true,
                    Secured: true,
                },
                app.ConnectionStrings.app
            );

            return this;
        },
        
        upsertItem: function (id, props, success, error) {
            var that = this;
            var QP = new QueryParameters();

            for (var q in props) {
                QP.Add(props[q].name, props[q].type, props[q].value);
            }
            Core.Json.CallProcedure(app.DatabaseNames.MES + '.CAT.UpsertGradeGroups', QP, {
                onSuccess: function (data) {
                    if (data && data.Table && data.Table.length > 0) {
                        var data = data.Table;

                        if (!data[0].Message) {
                            var ids = _.pluck(data, 'Id');

                            if (success != null && _.isFunction(success))
                                success.call(this, that, ids);
                        }
                        else {
                            error.call(this, that, data[0].Message);
                        }
                    } else {
                        if (data.Message)
                            error.call(this, that, data.Message);
                        else
                            error.call(this, that);
                    }
                },
                onError: function (data) {
                    if (error != null && _.isFunction(error))
                        error.call(this, that);
                },
                Async: true,
                Secured: true,
            }, app.ConnectionStrings.app);
        },
        removeItem: function (id, success, error) {
            var model = this.get(id);
            if (model) {
                var that = this;
                var QP = new QueryParameters();

                QP.Add('@id', 'INT', id);

                Core.Json.CallProcedure(app.DatabaseNames.MES + '.CAT.RemoveGradeGroup', QP, {
                    onSuccess: function (data) {
                        if (data && data.Table && data.Table.length > 0) {
                            var data = data.Table[0];

                            if (data.Id) {
                                if (success != null && _.isFunction(success))
                                    success.call(this, that, data.Id);
                            }
                            else {
                                if (data.Message)
                                    error.call(this, that, data.Message);
                                else
                                    error.call(this, that);
                            }
                        } else {
                            error.call(this, that);
                        }
                    },
                    onError: function (data) {
                        if (error != null && _.isFunction(error))
                            error.call(this, that);
                    },
                    Async: true,
                    Secured: true,
                }, app.ConnectionStrings.app);
            }
        },
    });

    Screen.Models.Main = Backbone.Epoxy.Model.extend({
        defaults: {
            items: null,
            itemId: null,
            search: '',

            hasData: false,
            hasItemData: false,
            hasItemSpecData: false,
            isLoading: true,
            isLoadingItemData: false,
            isLoadingItemSpecData: false,

        },

        initialize: function () {
            this.attributes.items = new Screen.Collections.Items();
            this.smartArcs = this.fetchSmartArcs();
            //this.recipes = this.fetchRecipes();
        },
        fetchSmartArcs: function () {
            var that = this,
                qp = new Core.Database.QueryParameters();

            var array = [];
            Core.Json.CallProcedure(
                app.DatabaseNames.MES + '.CAT.GetSmartFurnaceProfiles',
                qp,
                {
                    onSuccess: function (resp) {
                        try {
                            if ((resp) && (resp.Table)) {
                                array = resp;
                            }
                            else {
                                if ((resp) && (resp.Message))
                                    console.error(resp.Message);
                                else
                                    console.error('Server response not valid.');
                            }
                        }
                        catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                    },
                    Async: false,
                    Secured: true,
                },
                app.ConnectionStrings.app
            );

            return array;
        },
        //fetchRecipes: function () {
        //    var that = this,
        //        qp = new Core.Database.QueryParameters();

        //    var array = [];
        //    Core.Json.CallProcedure(
        //        app.DatabaseNames.MES + '.CAT.GetScrapRecipes',
        //        qp,
        //        {
        //            onSuccess: function (resp) {
        //                try {
        //                    if ((resp) && (resp.Table)) {
        //                        array = resp;
        //                    }
        //                    else {
        //                        if ((resp) && (resp.Message))
        //                            console.error(resp.Message);
        //                        else
        //                            console.error('Server response not valid.');
        //                    }
        //                }
        //                catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
        //            },
        //            Async: false,
        //            Secured: true,
        //        },
        //        app.ConnectionStrings.app
        //    );

        //    return array;
        //},
    });

    //the generate id method is called everytime a view is going to be shown by the router and returns and id that
    //is used by the router to store in cache (if it is cacheable) and to know the current shown view.
    //this is useful in case your view is reusable, and displays different data depending on url parameters 
    //(such as a catalog view, or a report that doesnt change in terms of UI but it does change in terms of data)
    //so you can always use the same view on the router but the cache can tell which view is which by using differents ids.
    Screen.generateID = function (viewParams) {
        try {
            //if the viewparams change the view id, then evaluate the viewparams here
            //and return the appropiate id.
            return 'grade-groups';
        } catch (Error) { }
    }

    Screen.Views.Main = Backbone.Epoxy.View.extend({
        template: 'grade-groups',
        id: 'grade-groups',
        title: 'Grade Groups',
        //default not cacheable, change this if you want the view to be cacheable
        // if the view is set as cacheable should also have a refresh method to reset the view without erasing the DOM.
        isCacheable: false,
        events: function () {
            return {
            };
        },
        autoRefresh: null,
        subviews: null,
        viewParams: null,

        item: null,
        //specsColl: null,

        initialize: function () {
            this.options.state = app.view_states.loading;
            this.options.onappend = (_.isFunction(this.options.onappend)) ? this.options.onappend : function () { };

            var that = this;

            this.autoRefresh = {
                enabled: null
                , toid: null
                , every: 5 * 1000
            };

            this.model = new Screen.Models.Main();

            var array = [];
            _.each(this.model.smartArcs.Table, function (obj, i) {
                array[i] = [obj.Name, obj.Id];
            });
            this.smartArcs = array;

            //var array2 = [];
            //array2[0] = ['', null];
            //_.each(this.model.recipes.Table, function (obj, i) {
            //     i = i + 1;
            //    array2[i] = [obj.Name, obj.Id];
            //});
            //this.recipes = array2;

            //var array3 = [];
            //array3[0] = ['', null];
            //_.each(this.model.recipes.Table, function (obj, i) {
            //     i = i + 1;
            //    array3[i] = [obj.Name, obj.Name];
            //});
            //this.recipeNames = array3;

            


            this.subviews = {
                subnavbarControls: new Screen.Views.SubnavBarControls({
                    model: this.model,
                    bindingSources: this.bindingSources,
                    parent: this,
                    container: app.views.subnavbar.getSectionContainer(1, 12),
                    events: function () {
                        return {
                            'click .add-item': _.bind(that.addNewBtn_click, that),
                            'click #refreshBtn': _.bind(that.refreshBtn_click, that),
                        };
                    },
                }),
            };


            this.bindEvents();
        },
        render: function (container, viewParams) {
            var that = this;

            this.viewParams = viewParams;

            var thatContainer = (this.options.container) ? this.options.container : container;
            this.options.container = thatContainer;

            //the screens have a custompath, so it has to be specified in the customPath variable that is
            //then sent to the template loader.
            var customPath = '/app/custom-screens/' + this.template + '/';

            T.render.call(
                this,
                this.template,
                function (tmp) {
                    if (!that.options.i18n) that.options.i18n = {};

                    app.getI18NJed(
                        that,
                        that.template,
                        function (i18nJED) {
                            //storing internationalization data
                            that.options.i18n[that.template] = i18nJED;

                            //loading the view and appeding it to the views's $el.
                            that.$el.html(tmp());
                            that.applyBindings();

                            //start: the view was already loaded an is on a div element, but not appended to the main container
                            //here you can perform anything you want DOM related, by getting the dom element via that.$el.find('#id')
                            //or this.$('#id')

                            that.subviews.subnavbarControls.render();

                            var grid = that.options.itemsGrid = new Backgrid.Grid({
                                className: 'backgrid table table-hover',
                                columns: [
                                    {
                                        name: 'name',
                                        label: app.translate(that, 'name_col'),
                                        editable: true,
                                        sortable: false,
                                        cell: Backgrid.StringCell.extend({
                                            orderSeparator: '',
                                            className: 'string-cell align-center-cell',
                                        }),
                                    },
                                    {
                                        name: 'smartId',
                                        label: app.translate(that, 'smart_furnace_col'),
                                        editable: true,
                                        sortable: false,
                                        cell: Backgrid.SelectCell.extend({
                                            optionValues: function () {
                                                return that.smartArcs;
                                            },
                                            className: 'string-cell align-center-cell',
                                        }) 
                                    },
                                    //{
                                    //    name: 'recipeId',
                                    //    label: app.translate(that, 'recipe_col'),
                                    //    editable: true,
                                    //    sortable: false,
                                    //    cell: Backgrid.SelectCell.extend({
                                    //        optionValues: function () {
                                    //            return that.recipes;
                                    //        },
                                    //        className: 'string-cell align-center-cell',
                                    //    })
                                    //},
                                    //   {
                                    //    name: 'recipeName',
                                    //    label: app.translate(that, 'recipe_col'),
                                    //    editable: true,
                                    //    sortable: false,
                                    //    cell: Backgrid.SelectCell.extend({
                                    //        optionValues: function () {
                                    //            return that.recipeNames;
                                    //        },
                                    //        className: 'string-cell align-center-cell',
                                    //    })
                                    //},
                                    {
                                        name: 'active',
                                        label: app.translate(that, 'active_col'),
                                        editable: true,
                                        sortable: false,
                                        cell: 'boolean',
                                    },
                                    {
                                        name: 'actions',
                                        label: '',
                                        editable: false,
                                        sortable: false,
                                        cell: Backgrid.Cell.extend({
                                            template: Handlebars.compile(that.$el.find('#actions_cell_template2').html()),
                                            className: 'actions-cell',
                                            events: {
                                                'click .btn-cell-action': 'cellActionClick'
                                            },

                                            initialize: function () {
                                                Backgrid.Cell.prototype.initialize.apply(this, arguments);

                                                this.bindEvents();
                                            },
                                            render: function () {
                                                this.$el.html(this.template());

                                                this.$el.find('[data-toggle="tooltip"]').tooltip();

                                                this.checkMode();
                                                this.delegateEvents();
                                                return this;
                                            },
                                            bindEvents: function () {
                                                this.listenTo(this.model, 'change:isNew', this.checkMode);
                                            },

                                            checkMode: function () {
                                                var newRow = this.model.get('isNew');
                                                if (newRow) this.setNewRowMode(true);
                                                else this.setNewRowMode(false);
                                            },
                                            setNewRowMode: function (val) {
                                                var btnRemove = this.$el.find('.btn-remove');
                                                var btnSave = this.$el.find('.btn-save');
                                                var btnDiscard = this.$el.find('.btn-discard');
                                                if (val) {
                                                    btnRemove.addClass('hide');
                                                    btnSave.removeClass('hide');
                                                    btnDiscard.removeClass('hide');
                                                } else {
                                                    btnRemove.removeClass('hide');
                                                    btnSave.addClass('hide');
                                                    btnDiscard.addClass('hide');
                                                }
                                            },

                                            cellActionClick: function (e) {
                                                try {
                                                    var target = $(e.target);
                                                    var actionData = target.closest('[data-cell-action]').data('cell-action');
                                                    if (actionData) {
                                                        that.actionOnRow(this.model, actionData);
                                                    }
                                                }
                                                catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                                            },
                                        }),
                                    },
                                ],
                                collection: that.model.get('items'),
                            });
                            that.$el.find('.items-grid-container').append(grid.render().el);

                            //appending view to the main container
                            that.append(thatContainer, that.$el);


                            //Call first refresh.
                            //that.startAutoRefresh();
                            that._refresh();
                        },
                        true,
                        customPath
                    );
                },
                customPath
            );
        },

        refreshBtn_click: function () {
            this.model.set({
                hasData: false,
                isLoading: true,
            });
            this._refresh();
        },
        bindEvents: function () {
            this.listenTo(this.model, 'change:search', this.model_change_pickers)
                .listenTo(this.model.get('items'), 'change', this.collection_changed)
                .listenTo(this.model.get('items'), 'fetch', this.collection_fetch);
        },
        _refresh: function (opt) {
            if (this.autoRefresh.toid != null) {
                clearTimeout(this.autoRefresh.toid);
                this.autoRefresh.toid = null;
            }

            this.refreshItemsColl(opt);

            if (this.autoRefresh.enabled == true) {
                var that = this;

                this.autoRefresh.toid = setTimeout(
                    function () { that._refresh(); },
                    this.autoRefresh.every
                );
            }
        },
        refresh: function (viewParams) {
            if (viewParams.sectionParam1)
                viewParams.sectionParam1 = parseInt(viewParams.sectionParam1, 10);
            else
                viewParams.sectionParam1 = Screen.Models.Main.prototype.defaults.itemId;

        },
        refreshItemsColl: function (options) {
            var that = this,
                itemsColl = this.model.get('items'),
                opt = _.extend({}, options, { params: {}, refresh: true, });

            if (opt.reset == true)
                this.model.set('isLoading', true);

            var that = this,
                modelAttrs = this.model.toJSON();

            itemsColl.fetch(_.extend(
                opt,
                {
                    params: _.extend(
                        modelAttrs,
                        opt.params,
                        {
                            refresh: opt.refresh,
                            reset: opt.reset,
                        }
                    ),
                }
            ));
        },
        addNew: function () {

            this.model.get('items').unshift({
                id: -1,
                isNew: true,
            });
        },
        discardRow: function (m) {
            //to discard just remove the model from the collection.
            m.collection.remove(m);
        },
        removeRow: function (model) {
            var that = this;
            model.collection.removeItem(
                model.get('id')
                , function (coll, data) {
                    that._refresh();
                }
                , function (coll, msg) {
                    app.views.topMessages.showMessage(app.translate(app, msg), { stay: 10000, });
                    that._refresh();
                }
            );
        },
        saveRow: function (m) {
            var that = this;
            m.collection.upsertItem(null, [  
                { name: 'active', type: 'BIT', value: m.get('active') },
                { name: 'name', type: 'VARCHAR', value: m.get('name') },
                { name: 'smartId', type: 'INT', value: Number(m.get('smartId')) == 0 ? null : Number(m.get('smartId')) },
                //{ name: 'recipeId', type: 'INT', value: Number(m.get('recipeId')) == 0 ? null : Number(m.get('recipeId')) },
                //{ name: 'recipeName', type: 'VARCHAR(MAX)', value: m.get('recipeName') ? m.get('recipeName') : null },
            ], function (ref, ids) {
                m.set({ id: ids[0], isNew: false }, { avoidSync: true });
            }, function (coll, msg) {
               app.views.topMessages.showMessage(app.translate(app, msg), { stay: 10000, });
                that._refresh();
            });
        },
        append: function (container, el) {
            el = (el != null && el != undefined) ? el : this.$el;

            if (this.options.state == app.view_states.loading
                || this.options.state == app.view_states.shown) {
                //appending view to the main container and set state to shown

                this.options.state = app.view_states.shown;
                container.append(el);

                this.options.onappend(this);
            }

            if (this.options.state == app.view_states.hidden) {
                //append and remain hidden
                container.append(el);
            }

            if (this.options.state == app.view_states.closed) {
                //return without appending.
                return;
            }
        },
        startAutoRefresh: function () {
            try {
                if (this.autoRefresh.enabled !== true) {
                    var that = this;

                    if (this.autoRefresh.toid != null) {
                        clearTimeout(this.autoRefresh.toid);
                        this.autoRefresh.toid = null;
                    }

                    this.autoRefresh.enabled = true;

                    //use a timeout to execute the first refresh to return the handle to the start function caller.
                    //So when the caller finish it will do the first refresh.
                    this.autoRefresh.toid = setTimeout(
                        function () { that._refresh(); },
                        1
                    );
                }
            } catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
        },
        stopAutoRefresh: function () {
            if (this.autoRefresh.toid != null) {
                clearTimeout(this.autoRefresh.toid);
                this.autoRefresh.toid = null;
            }
            this.autoRefresh.enabled = false;
        },
        bindViewScopedEvents: function () {
        },
        unbindViewScopedEvents: function () {
        },
        close: function () {
            this.options.state = app.view_states.closed;

            this.stopAutoRefresh();
            this.closeSubviews();
            this.remove();
            this.unbindViewScopedEvents();
            this.unbind();
        },
        closeSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.close();
            });
        },
        show: function () {
            this.options.state = app.view_states.shown;

            this.showSubviews();
            this.bindEvents();
            this.$el.show();
        },
        showSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.show();
            });
        },
        hide: function () {
            this.options.state = app.view_states.hidden;

            this.hideSubviews();
            this.stopAutoRefresh();

            this.$el.hide();
            this.unbind();
            this.stopListening();
        },
        hideSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.hide();
            });
        },
        preRender: function () {
            app.models.subnavbar.setAll(false);
            app.models.subnavbar.set('sections', '12');
            app.models.subnavbar.set('subnavbar', true);
        },
        reRender: function () {
            this.startAutoRefresh();
        },

        actionOnRow: function (model, action) {
            try {
                switch (action.toUpperCase()) {
                    case 'DELETE':
                        var that = this,
                            modal = new Modal.Views.Main({
                                focusOk: false,
                                focusSelector: '#btn-cancel',
                                title: app.translate([this, app], "delete_item_modal_confirm_title"),
                                message: app.translate([this, app], "delete_item_modal_confirm_message"),
                                buttons_type: "CONTINUE-CANCEL",
                            });

                        this.listenToOnce(modal, "continue", function (modal) {
                            try {
                                that.removeRow(model);
                            }
                            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                        });

                        modal.show();
                        break;
                    case 'SAVE':
                        this.saveRow(model);
                        break;
                    case 'DISCARD':
                        this.discardRow(model);
                        break;
                }
            }
            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
        },
        addNewBtn_click: function (e) {
            try {
                this.addNew();
            }
            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
        },
        collection_changed: function (m, b, c) {
            var that = this;
            var fromFetch = (b && b.from == 'fetch') ? true : false;
            var avoidSync = (b && b.avoidSync) ? b.avoidSync : false;
            var isNewRow = m.get('isNew');
            
            if (!fromFetch && !isNewRow && !avoidSync) {
                m.collection.upsertItem(m.get('id'), [
                { name: 'id', type: 'INT', value: m.get('id') },
                { name: 'active', type: 'BIT', value: m.get('active') },
                { name: 'name', type: 'VARCHAR', value: m.get('name') },
                { name: 'smartId', type: 'INT', value: Number(m.get('smartId')) == 0 ? null : Number(m.get('smartId')) },
                //{ name: 'recipeId', type: 'INT', value: Number(m.get('recipeId')) == 0 ? null : Number(m.get('recipeId')) },
                //{ name: 'recipeName', type: 'VARCHAR(MAX)', value: m.get('recipeName') ? m.get('recipeName') : null },
                ], function (ref, ids) {
                }, function (coll, msg) {
                    app.views.topMessages.showMessage(app.translate(app, msg), { stay: 10000, });
                    that._refresh();
                });
            }
        },
        collection_fetch: function (coll, resp) {
            try {
                this.model.set({
                    hasData: (this.model.get('items').length > 0),
                    isLoading: false,
                });
            }
            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
        },
        item_fetch: function (model, resp) {
            try {
                this.model.set({
                    isLoadingItemData: false,
                    hasItemData: this.item.get('id'),
                });
            }
            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
        },
        model_change_pickers: function (model, value, opt) {
            try {
                var params = this.model.toJSON();

                this.refreshItemsColl({
                    reset: true,
                    params: _.extend(
                        {},
                        params,
                        {}
                    ),
                });
            }
            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
        },
      
    });

    //subview for the subnavbar controls
    Screen.Views.SubnavBarControls = Backbone.Epoxy.View.extend({
        id: 'grade-groups-subnavbar-controls',
        title: '',
        template: 'grade-groups',

        initialize: function () {
            this.options.state = app.view_states.loading;
            this.options.onappend = (_.isFunction(this.options.onappend)) ? this.options.onappend : function () { };

            this.bindEvents();
        },
        render: function (container, onComplete) {
            var that = this;
            var thatContainer = (container) ? container : (this.options.container) ? this.options.container : null;
            var onViewComplete = (onComplete) ? onComplete : function () { };

            //the screens have a custompath, so it has to be specified in the customPath variable that is
            //then sent to the template loader.
            var customPath = '/app/custom-screens/grade-groups/';

            T.render.call(this, this.template, function (tmp) {
                if (!that.options.i18n) that.options.i18n = {};
                app.getI18NJed(that, that.template, function (i18nJED) {
                    //storing internationalization data
                    that.options.i18n[that.template] = i18nJED;

                    var ctx = {
                        editable: (($.inArray('AdminUserRole', app.models.user.get('roles')) != -1
                            || $.inArray('SupervisorUserRole', app.models.user.get('roles')) != -1) ? true : false),
                    };

                    //loading the view and appeding it to the views's $el.
                    that.$el.html(tmp(
                        _.extend({}, ctx, (that.model) ? that.model.toJSON() : {})
                    ));

                    that.$el.find('.clear-search').clearSearch();

                    that.applyBindings();

                    that.append(thatContainer, that.$el);

                }, true, customPath);
            }, customPath, 'subnavbar_controls');

        },
        bindEvents: function () {
            //this function should be in every view that uses listenTo anywhere
            //all the model bindings or view-model binding should be here, to manage
            //the show/hide view easily
        },

        append: function (container, el) {
            el = (el != null && el != undefined) ? el : this.$el;

            if (this.options.state == app.view_states.loading
                || this.options.state == app.view_states.shown) {
                //appending view to the main container and set state to shown

                this.options.state = app.view_states.shown;
                container.append(el);

                this.options.onappend(this);
            }

            if (this.options.state == app.view_states.hidden) {
                //append and remain hidden
                container.append(el);
            }

            if (this.options.state == app.view_states.closed) {
                //return without appending.
                return;
            }
        },
        close: function () {
            this.options.state = app.view_states.closed;

            this.remove();
            this.unbind();
        },
        show: function () {
            this.options.state = app.view_states.shown;

            this.bindEvents();
            this.$el.show();
        },
        hide: function () {
            this.options.state = app.view_states.hidden;

            this.$el.hide();
            this.unbind();
            this.stopListening();
        },
    });

    // Required, return the module for AMD compliance.
    return Screen;

});
