﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/IndustrialGantt/Styles/IndustrialGantt.css?v=" + version) %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar">
    <div class="row-fluid form-inline">
        
        <div class="input-prepend input-append pull-left" style="margin-left:25px;">
            <button type="button" id="getPreviousDateBtn" class="btn btn-search-prev" data-bind-heat-picker="disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=heat_picker_btn_previous_title />"><i class="fa fa-play fa-rotate-180"></i></button>
            <input type="text" id="dateTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(date$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
            <%--<label class="btn btn-search-show" id="showSearchItemsBtn" for="searchTbx"><i class="fa fa-caret-down"></i></label>--%>
            <button type="button" id="getNextDateBtn" class="btn btn-search-next" data-bind-heat-picker="disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=heat_picker_btn_next_title />"><i class="fa fa-play"></i></button>
            <button type="button" id="getCurrentDateBtn" class="btn" data-bind-heat-picker="disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=heat_picker_btn_current_title />"><i class="fa fa-step-forward"></i></button>
        </div>
        <%--<button id="refreshBtn" class="btn btn-primary" style="margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
            <i class="fa fa-refresh"></i>
        </button>--%>
        <div class="input-prepend input-append pull-right">
            <button style="margin-top:0;margin-right:25px;" class="btn btn-export-to-excel" type="button">
                <span class="excel-export-state fa fa-file-excel-o"></span>
                <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
            </button>
        </div>
    </div>
</div>
<div class="row-fluid screen-content">
    <div class="row-fluid" style="margin-top:20px; display: flex;align-items: center;justify-content: center;">
        <div id="linesGanttContainer" class="row-fluid" style="height:600px;width:98%;"></div>
    </div>
    <div class="row-fluid processes-grids-container">
        <div class="row-fluid">
            <h5><asp:Localize runat=server meta:resourcekey=eaf_processes_grid_title /></h5>
            <div class="processes-grid-container eaf-processes-grid-container  infinite-container"></div>
        </div>
    </div>
    <div class="row-fluid processes-grids-container">
        <div class="row-fluid">
            <h5><asp:Localize runat=server meta:resourcekey=lf_processes_grid_title /></h5>
            <div class="processes-grid-container lf-processes-grid-container infinite-container"></div>
        </div>
    </div>
</div>