﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(not(hasData), not(isLoading))), }," style="height: 500px;">
    <div class="row-fluid" style="position: relative; top: 100px;">
        <i class="fw-icon-circle-blank fw-icon-4x" style="font-size: 115px;"></i>
    </div>
    <div class="row-fluid" style="position: relative; top: 115px;">
        <h3 style="font-size: 50px;">
            <asp:localize runat="server" meta:resourcekey="no_data_available" />
        </h3>
    </div>
</div>

<div class="row-fluid subnavbar fixed-subnavbar">
    <div class="row-fluid form-inline">
        <label class="control-label" for="meltOrderTbx">
            <asp:localize runat="server" meta:resourcekey="melt_order_label" />
        </label>
        <div class="input-prepend input-append " style="margin-top:4px;margin-right:15px;">
            <input type="text" id="meltOrderTbx" style="width:150px;" data-bind="value: trim(meltOrderName), events: ['change', 'keyup',]" placeholder="<asp:Localize runat=server meta:resourcekey=melt_order_place_holder />" data-select-on-focus/>
            <%--<label class="btn btn-search-show" id="showSearchEquipmentsBtn" for="searchEquipmentsTbx"><i class="fa fa-caret-down"></i></label>--%>
        </div>
        <label class="control-label" for="gradeTbx">
            <asp:localize runat="server" meta:resourcekey="gradeName_label" />
        </label>
        <div class="input-prepend input-append " style="margin-top:4px;margin-right:15px;">
            <input type="text" id="gradeTbx" style="width:150px;" data-bind="value: trim(gradeName), events: ['change', 'keyup',]" placeholder="<asp:Localize runat=server meta:resourcekey=grade_place_holder />" data-select-on-focus/>
            <%--<label class="btn btn-search-show" id="showSearchEquipmentsBtn" for="searchEquipmentsTbx"><i class="fa fa-caret-down"></i></label>--%>
        </div>
        <label class="control-label" for="materialSizeTbx">
            <asp:localize runat="server" meta:resourcekey="materialSize_label" />
        </label>
        <div class="input-prepend input-append " style="margin-top:4px;margin-right:15px;">
            <input type="text" id="materialSizeTbx" style="width:150px;" data-bind="value: trim(materialSizeSearch), events: ['change', 'keyup',]" placeholder="<asp:Localize runat=server meta:resourcekey=materialSize_place_holder />" data-select-on-focus/>
            <%--<label class="btn btn-search-show" id="showSearchEquipmentsBtn" for="searchEquipmentsTbx"><i class="fa fa-caret-down"></i></label>--%>
        </div>
        <button id="refreshBtn" class="btn btn-primary" style="margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
            <i class="fa fa-refresh"></i>
        </button>
    </div>
</div>

<div class="row-fluid screen-content" id="content">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }," style="height: 500px;">
        <div class="row-fluid" style="position: relative; top: 100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size: 115px;"></i>
        </div>
        <div class="row-fluid" style="position: relative; top: 115px;">
            <h3 style="font-size: 50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    
    <div class="row-fluid items-grid-container infinite-container" style="margin-top:-50px;z-index:950" id="gridContainer" data-bind="classes: { hide: any(not(hasData), isLoading), },"></div>
    <div id="lastrow" style="height: 100px;"></div>
</div>


<script id="actions_cell_template" type="text/x-handlebars-template">
    <div class="row-fluid">
        <div style="width: 100%; text-align: center;">
            {{HBExp '#ifEquals isLoading true'}}
            <div class="popover-on-icon" style="float: left; margin-left: 15px; height: 31px; cursor: default;">
                <img style="width: 30px; height: 30px;" src="<%= ResolveUrl("~/assets/img/spinner22.gif")%>" /></div>
            {{HBExp 'else'}}
            <div class="btn-group">
                <!--<button type="button" class="configure-source-btn btn"></button>-->

               <%-- <button class="configure-source-btn btn-dropdown-config-option btn" data-option="moveUp" style="font-size: 12px;"> <i class="fa fa-arrow-up" data-option="moveUp"></i>  </button>
                <button class="configure-source-btn btn-dropdown-config-option btn" data-option="moveDown" style="font-size: 12px;"> <i class="fa fa-arrow-down" data-option="moveDown"></i> </button>
               --%> 
                <button class="configure-source-btn btn btn-dropdown-config-option" data-option="opt-show-details" style="font-size: 12px;">
                    <asp:localize runat="server" meta:resourcekey="change_position_button_label" />
                </button>
            </div>

            {{HBExp '/ifEquals'}}
        </div>
    </div>
</script>


<script id="melt_order_details_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: format('<asp:Localize runat=server meta:resourcekey=melt_order_details_modal_title />', meltOrderNumber)"></h3>
    </div>
    <div style="max-height: 350px; padding-bottom: 0; padding-top: 0;" class="modal-body">
        <div style="max-height: 300px; padding-bottom: 0;" class="modal-body">
            <div class="row-fluid">
                <div class="form-horizontal text-left">
                    <div class="control-group span6 no-margin-bottom" style="margin-left:0px">
                        <label class="" style="font-weight:bold; display:inline-block;">
                            <asp:Localize runat=server meta:resourcekey=meltOrder_label />
                        </label>
                        <label class="" style="margin-left:10px; display:inline-block;" data-bind="text: trim(meltOrderNumber)"></label>
                    </div> 
                    <div class="control-group span6 no-margin-bottom" style="margin-left:0px">
                        <label class="" style="font-weight:bold; display:inline-block;">
                            <asp:Localize runat=server meta:resourcekey=grade_label />
                        </label>
                        <label class="" style="margin-left:10px;display:inline-block;" data-bind="text: trim(gradeName)"></label>
                    </div> 
                    <div class="control-group span6 no-margin-bottom" style="margin-left:0px">
                        <label class="" style="font-weight:bold;display:inline-block;">
                            <asp:Localize runat=server meta:resourcekey=heat_size_label />
                        </label>
                        <label class="" style=" margin-left:10px;display:inline-block;" data-bind="text: trim(heatSize)"></label>
                    </div> 
                    <div class="control-group span6 no-margin-bottom"  style="margin-left:0px">
                        <label class="" style="font-weight:bold;display:inline-block;">
                            <asp:Localize runat=server meta:resourcekey=material_size_label />
                        </label>
                        <label class="" style=" margin-left:10px;display:inline-block;" data-bind="text: trim(materialSize)"></label>
                    </div> 
                    <div class="control-group span6 no-margin-bottom"  style="margin-left:0px">
                        <label class="" style="font-weight:bold;display:inline-block;">
                            <asp:Localize runat=server meta:resourcekey=TWI_label />
                        </label>
                        <label class="" style=" margin-left:10px;display:inline-block;" data-bind="text: trim(meltSequence)"></label>
                    </div> 
                    <div class="control-group span6 no-margin-bottom"  style="margin-left:0px">
                        <label class="" style="font-weight:bold;display:inline-block;">
                            <asp:Localize runat=server meta:resourcekey=melt_sequence_label />
                        </label>
                        <label class="" style=" margin-left:10px;display:inline-block;" data-bind="text: trim(meltSequence)"></label>
                    </div> 
                    <div class="control-group span12" style="margin-left:0px">
                        <h4><asp:localize runat="server" meta:resourcekey="heats_label" /></h4>
                        <div class="details-grid-container infinite-container" style="margin-bottom:10px"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal">
            <asp:localize runat="server" meta:resourcekey="close_btn_label" />
        </button>
    </div>
</script>


<script id="actions_cell_template_drag" type="text/x-handlebars-template">
        <span><i class="fa fa-bars"></i></span>
</script>

