﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jquery.contextMenu/jquery.contextMenu.css") %>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar" style="margin-bottom: 0px; max-height:0px !important;">
</div>

<div class="screen-content">
    <div class="unjustified-delays-container"
        data-bind="classes: { hide: not(showUnjustifiedDelaysContainer) }">

        <!-- CAS 1 -->
        <div class="unjustified-delays-banner unjustified-left"
            data-bind="toggle: hasUnjustifiedDelaysCas1">

        <i class="fa fa-exclamation-triangle"></i>
        CAS 1:
        <span class="count" data-bind="text: unjustifiedDelaysCas1"></span>
        unjustified delays

        <button id="btnJustifyCas1" class="btn btn-small btn-primary banner-btn">
            JUSTIFY
        </button>
        </div>
        <!-- CAS 2 -->
        <div class="unjustified-delays-banner unjustified-right"
            data-bind="toggle: hasUnjustifiedDelaysCas2">

        <i class="fa fa-exclamation-triangle"></i>
        CAS 2:
        <span class="count" data-bind="text: unjustifiedDelaysCas2"></span>
        unjustified delays

        <button id="btnJustifyCas2" class="btn btn-small btn-primary banner-btn">
            JUSTIFY
        </button>
        </div>

    </div>



    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-position-container-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    
        <div
        class="main-content"
        data-bind="classes: { hide: any(not(hasData), isLoading), hasBanner: any(hasUnjustifiedDelaysCas1, hasUnjustifiedDelaysCas2) }">


        <table style="width:100%" id="main-div">
            <tr class="hide">
                <th></th>              
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
            </tr>
            <tr>
                <td>
                    <button id="TWIBtn" class="button-4" <%--style="width:80px;height:30px;top:0px !important;margin-left:10px"--%>>TWI</button>
                </td>
                <td><h5 class="position-labels" style="text-align: right;"><asp:localize runat="server" meta:resourcekey="eaf_a" /></h5></td>
                <td class="cells-dimension"> 
                    <div class="dropable drop-positon-container" id="pos1"></div>                
                </td>
                <td colspan="4">
                        <div class="top-grid-container" id="topGrid"></div>        
                </td>
                <td  class="cells-dimension">
                    <div class="dropable drop-positon-container" id="pos3"></div>   
                </td>
                <td><h5 class="position-labels" style="text-align: left;margin-left:10px"><asp:localize runat="server" meta:resourcekey="eaf_b" /></h5></td>
                <td colspan="2"></td>            
            </tr>
            <tr>
                <td rowspan="2" class="cells-dimension">
                    <h5 class="position-labels"><asp:localize runat="server" meta:resourcekey="pourback_car" /></h5>
                    <div class="dropable drop-positon-container  positions-with-widget-only" id="pos53"></div>
                </td>
                 <td rowspan="2"  class="cells-dimension"> 
                    <h5 class="position-labels"><asp:localize runat="server" meta:resourcekey="hold_stand_4" /></h5>
                    <div class="dropable drop-positon-container positions-with-widget-only" id="pos61"></div>
                   
                </td>
                <td rowspan="2" class="cells-dimension">
                    <h5 class="position-labels"><asp:localize runat="server" meta:resourcekey="eaf_a_tap_car" /></h5>
                    <div class="dropable drop-positon-container  positions-with-widget-only" id="pos2"></div>     
                </td>
                 <td  rowspan="2" class="cells-dimension">
                    <h5 class="position-labels"><asp:localize runat="server" meta:resourcekey="lmf_car_2_east_west_out" /></h5>
                    <div class="dropable drop-positon-container positions-with-widget-only" id="pos7"></div>
                   
                </td>
                 <td rowspan="2"  class="cells-dimension">
                     <h5 class="position-labels"><asp:localize runat="server" meta:resourcekey="hold_stand_2" /></h5>
                    <div class="dropable drop-positon-container  positions-with-widget-only" id="pos14"></div>
               
                </td>
                <td  rowspan="2" class="cells-dimension">
                    <h5 class="position-labels"><asp:localize runat="server" meta:resourcekey="hold_stand_1" /></h5>
                    <div class="dropable drop-positon-container positions-with-widget-only" id="pos13"></div>
                </td>        
                <td></td>
                <td rowspan="2" class="cells-dimension">                    
                    <h5 class="position-labels"><asp:localize runat="server" meta:resourcekey="eaf_b_tap_car" /></h5>
                    <div class="dropable drop-positon-container  positions-with-widget-only" id="pos4"></div>
                </td>
                <td></td>
               <td rowspan="2" colspan="2">
                    <h5 class="position-labels">Maintenance</h5>
                    <div class="drop-maintenance-container dropable" id="pos70" data-bind="collection: $positions, itemView: 'positionsView'"></div>
                </td>
            </tr>
            <tr>        
                <td></td>
                <td></td>
            
            </tr>
            <tr>
                <td rowspan="1"  class="cells-dimension">
                    <h5 class="position-labels"><asp:localize runat="server" meta:resourcekey="caster_1_in_transit" /></h5>
                    <div class="dropable drop-positon-container positions-with-widget-only" id="pos31"></div>
                   
                </td>
                <td  rowspan="1" <%--class="cells-dimension"--%>>
                    <h5 class="position-labels"><asp:localize runat="server" meta:resourcekey="hold_stand_3" /></h5>
                    <div class="dropable drop-positon-container positions-with-widget-only" id="pos60"></div>
                </td>
                <td rowspan="1" class="cells-dimension">
                    <h5 class="position-labels"><asp:localize runat="server" meta:resourcekey="lmf_car_1_south_out" /></h5>
                    <div class="dropable drop-positon-container positions-with-widget-only" id="pos6"></div>
                   
                </td>
            
                <td rowspan="1" class="cells-dimension">
                    <h5 class="position-labels" data-bind="classes: { hide: not(LMF1_WithoutCar), }"><asp:localize runat="server" meta:resourcekey="lmf_1_south"/></h5>
                    <div class="dropable drop-positon-container" id="pos10" data-bind="classes: { hide: not(LMF1_WithoutCar), }"></div>
                    
                    <h5 class="position-labels" data-bind="classes: { hide: not(LMF1_Car1), }"><asp:localize runat="server" meta:resourcekey="lmf_1_south_car_1_in" /></h5>
                    <div class="dropable drop-positon-container" id="pos16" data-bind="classes: { hide: not(LMF1_Car1), }"></div>
                        
                    
                    <h5 class="position-labels" data-bind="classes: { hide: not(LMF1_Car2), }"><asp:localize runat="server" meta:resourcekey="lmf_1_south_car_2_in" /></h5>    
                    <div class="dropable drop-positon-container" id="pos17" data-bind="classes: { hide: not(LMF1_Car2), }"></div>
                    
                </td>
          
                  <td rowspan="1" class="cells-dimension">                   
                    <h5 class="position-labels"><asp:localize runat="server" meta:resourcekey="lmf_car_3_middle_out" /></h5>
                    <div class="dropable drop-positon-container positions-with-widget-only" id="pos8">
                    </div>
                </td>
                <td rowspan="1" class="cells-dimension">                   
                    <h5 class="position-labels" data-bind="classes: { hide: not(LMF2_WithoutCar), }"><asp:localize runat="server" meta:resourcekey="lmf_2_north" /></h5>
                    <div class="dropable drop-positon-container"  id="pos20"  data-bind="classes: { hide: not(LMF2_WithoutCar), }"></div>
                   
                   
                    <h5 class="position-labels" data-bind="classes: { hide: not(LMF2_Car3), }"><asp:localize runat="server" meta:resourcekey="lmf_2_north_car_3_in" /></h5>
                    <div class="dropable drop-positon-container" id="pos28" data-bind="classes: { hide: not(LMF2_Car3), }"></div>
                    
                   
                    <h5 class="position-labels" data-bind="classes: { hide: not(LMF2_Car4), }"><asp:localize runat="server" meta:resourcekey="lmf_2_north_car_4_in" /></h5>
                    <div class="dropable drop-positon-container" id="pos29" data-bind="classes: { hide: not(LMF2_Car4), }"></div>
                    
                </td>
                <td rowspan="1"  class="cells-dimension">
                    <h5 class="position-labels"><asp:localize runat="server" meta:resourcekey="lmf_car_4_north_out" /></h5>
                    <div class="dropable drop-positon-container positions-with-widget-only" id="pos9"></div>
                </td>
            
                <td rowspan="1" class="cells-dimension">
                    <h5 class="position-labels"><asp:localize runat="server" meta:resourcekey="vtd_tank_1" /></h5>
                    <div class="dropable drop-positon-container" id="pos11"></div>
                </td>
                <td rowspan="1" class="cells-dimension">
                    <h5 class="position-labels"><asp:localize runat="server" meta:resourcekey="vtd_tank_2" /></h5>
                    <div class="dropable drop-positon-container" id="pos12"></div>
                </td>
                <td></td>
                <td  rowspan="1"  class="cells-dimension">
                    <h5 class="position-labels"><asp:localize runat="server" meta:resourcekey="caster_2_in_transit" /></h5>
                    <div class="dropable drop-positon-container positions-with-widget-only" id="pos41"></div>
                </td>
            </tr>
               <!---CASTERS POSITIONS-->
            <tr>
                    <td  class="cells-dimension">
                        <h5 class="position-labels" data-bind="classes: { hide: not(show_cas1_pos1), },text:  coalesce(cas1_pos1_label, '-'),"></h5>
                        <div class="dropable drop-positon-container" data-bind="classes: { hide: not(show_cas1_pos1), }" id ="pos1cas1"></div>
                    </td>
                    <td rowspan="3" colspan="9">                       
                        <div style="margin-top:-240px;" class="row-fluid">
                            <div class="span4" style="display:flex;justify-content:left">
                                <span 
                                     style="color: #354e58 !important; font-weight: bold;margin-left: 20px;margin-right: 5px;margin-top: 5px;">
                                     CAS 1 Remaining Heats
                                 </span>                            
                                 <input 
                                   type="number" 
                                   style="width: 90px;margin-bottom: -20px;text-align: center;font-weight: bold;font-size: 18px;" 
                                   data-bind="value: remainingHeatsCaster1" 
                                   id="remainingHeatsCaster1"
                                   disabled
                                   />                          
                                   <button 
                                       data-toggle="tooltip" 
                                       class="btn btn-cell-action btn-small btn-save" 
                                       id="editRemainingHeatsCaster1" 
                                       style="height: 29px;margin-left: 5px;">
                                       <i class="fa fa-edit"></i>
                                   </button>
                            </div>
                            <div class="span4"></div>
                            <div class="span4" style="display:flex;justify-content:right">
                                  <button 
                                      data-toggle="tooltip" 
                                      class="btn btn-cell-action btn-small btn-save" 
                                      id="editRemainingHeatsCaster2" 
                                      style="height: 29px;margin-right: 5px;">
                                      <i class="fa fa-edit"></i>
                                  </button>
                                 <input 
                                   type="number" 
                                   style="width: 90px;margin-bottom: -20px;text-align: center;font-weight: bold;font-size: 18px;" 
                                   data-bind="value: remainingHeatsCaster2" 
                                   id="remainingHeatsCaster2"
                                   disabled
                                   /> 
                                    <span 
                                     style="color: #354e58 !important; font-weight: bold;margin-right: 20px;margin-left: 5px;margin-top: 5px;">
                                    CAS 2 Remaining Heats
                                 </span>        
                            </div>
                         
                          </div>
                        <div class="status-grid-container" id="grid"></div>  
                    </td>
                    <td  class="cells-dimension">
                        <h5 class="position-labels" data-bind="classes: { hide: not(show_cas2_pos1), }, text:  coalesce(cas2_pos1_label, '-'),"></h5>
                        <div class="dropable drop-positon-container"  data-bind="classes: { hide: not(show_cas2_pos1), }" id ="pos1cas2"></div>
                    </td>
                </tr>
            <tr>
                <td  class="cells-dimension">
                    <h5 class="position-labels" data-bind="classes: { hide: not(show_cas1_pos2), }, text:  coalesce(cas1_pos2_label, '-'),"></h5>
                    <div class="dropable drop-positon-container" data-bind="classes: { hide: not(show_cas1_pos2), }" id ="pos2cas1"></div>
                </td>
                <td  class="cells-dimension">
                    <h5 class="position-labels" data-bind="classes: { hide: not(show_cas2_pos2), }, text:  coalesce(cas2_pos2_label, '-'),"></h5>
                    <div class="dropable drop-positon-container" data-bind="classes: { hide: not(show_cas2_pos2), }" id ="pos2cas2"></div>
                </td>
            </tr>
            <tr>
                <td  class="cells-dimension">
                    <h5 class="position-labels" data-bind="classes: { hide: not(show_cas1_pos3), }, text:  coalesce(cas1_pos3_label, '-'),"></h5>
                    <div class="dropable drop-positon-container" data-bind="classes: { hide: not(show_cas1_pos3), }" id ="pos3cas1"></div>
                </td>
                <td  class="cells-dimension">
                    <h5 class="position-labels" data-bind="classes: { hide: not(show_cas2_pos3), }, text:  coalesce(cas2_pos3_label, '-'),"></h5>
                    <div class="dropable drop-positon-container" data-bind="classes: { hide: not(show_cas2_pos3), }" id ="pos3cas2"></div>
                </td>
            </tr>
            <tr>
                <td  class="cells-dimension">
                    <h5 class="position-labels" data-bind="classes: { hide: not(show_cas1_pos4), }, text:  coalesce(cas1_pos4_label, '-'),"></h5>
                    <div class="dropable drop-positon-container" data-bind="classes: { hide: not(show_cas1_pos4), }" id ="pos4cas1"></div>
                </td>
                <td colspan="9"></td>
                <td  class="cells-dimension">
                    <h5 class="position-labels" data-bind="classes: { hide: not(show_cas2_pos4), }, text:  coalesce(cas2_pos4_label, '-'),"></h5>
                    <div class="dropable drop-positon-container" data-bind="classes: { hide: not(show_cas2_pos4), }" id ="pos4cas2"></div>
                </td>
            </tr>
        </table>
        
        <div data-bind="collection: $attributesCollection, itemView: 'attributesView'"></div>  


    </div>

</div>


<script id="actions_cell_twi_template" type="text/x-handlebars-template">
    <div>
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="TWI" title="<asp:Localize runat=server meta:resourcekey=download_title />" class="btn btn-cell-action btn-small btn-twi hide"><i class="fa fa-tags" aria-hidden="true"></i></button>
       
    </div>
</script>


<script id="confirmation-modal" type="text/x-handlebars-template">
    <div class="modal-header" >    
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h5>
            <span data-bind="text: title" style="font-weight:bold;"></span>
        </h5>    
    </div>
    <div class="modal-body">
        <div style="padding-bottom:0;" class="modal-body">
            <asp:Localize runat='server' meta:resourcekey='modal_confirmation_msg' />
        </div>
    </div>
    <div class="modal-footer">
        <div class="modal-status-msg-container pull-left">
            <div class="modal-status-msg hide" data-bind="toggle: notEquals(errorMsg, ''),">
                <span data-bind="text: errorMsg, attr: { title: errorMsg, }," style="color:#ff0000;font-size:16px;"></span>
            </div>
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>
        <button id="acceptBtnClick" class="btn btn-primary" data-bind="enabled: not(processing),">
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        <button id="cancelBtn" class="btn" data-dismiss="modal" data-bind="enabled: not(processing),">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>
    </div>
</script>


<script id="LadlesViewTemplate" type="text/x-handlebars-template">
    <h5 data-bind="text:_LadleID, classes: { heatNameInMaintenance: _maintenancePosition, hide: not(_maintenancePosition) }" style="margin-top:-4px;"></h5>   

      <div class="widget-container" data-bind="classes: { hideimg: _maintenancePosition, smallWidget:  _EAFPosition}" draggable="true" >
        <div class="heat-s" data-bind="classes: { 'heat-s-plate-warning': _PlateAssemblyWarning, 'heat-s-plate-danger': _PlateAssemblyDanger }">
            <h5 data-bind="text: _HeatNameWidget,classes: { hideimg: _EAFPosition, }" class="title-s current-heat-name" style="font-size:16px !important;"></h5>
            <h5 data-bind="text: _MeltOrderAndSizeWidget,classes: { hideimg: _EAFPosition, }" class="title-s" style="border-top: 1px solid #ccc;font-size: 0.7rem !important;"></h5>
            <h5 data-bind="text: _GradeNameWidget,classes: { hideimg: _EAFPosition, }" class="title-s" style="border-top: 1px solid #ccc;font-size: 0.7rem !important;"></h5>
            <div class="row-fluid"> 
                <div class="span3 ladleID-widget" >
                    <h3 data-bind="text: _LadleIDWidget" style="line-height:unset !important" class="ladleID-widget-label"></h3>
                </div>
                <div class="span9 heat-details-s box-height-ladle-widget-s">
                    <div class="row-fluid">
                        <div class="span4 heats-mwh-min-labels">
                            <span data-bind="text: Heats" class="label-heats-min-mwh-s"></span>
                            <span><label class="bottom-left-value-label-s" style="margin-bottom: 0px !important;margin-top: -5px !important;">Heats</label></span>

                        </div>
                        <div class="span4 heats-mwh-min-labels">
                            <span data-bind="text: _MinOn" class="label-heats-min-mwh-s"></span>
                            <span><label class="bottom-left-value-label-s" style="margin-bottom: 0px !important;margin-top: -5px !important;">Min</label></span>
                        </div>
                        <div class="span4 heats-mwh-min-labels-right">
                            <span data-bind="text: _HoursSinceLastClose" class="label-heats-min-mwh-s"></span>
                            <span><label class="bottom-left-value-label-s" style="margin-bottom: 0px !important;margin-top: -5px !important;">Hours</label></span>
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </div>





</script>
    


<script id="AttributesViewTemplate" type="text/x-handlebars-template">

    <h4 data-bind="text: _heatName, classes: { hide: not(_show_heatName), }" style="margin-top:2px;margin-bottom:8px; " class="heat-name-ladle-null"></h4>
    <div data-bind="classes: { hide: _show_heatName, }" style="margin-top:2px;margin-bottom:8px; "></div>
    <h5 data-bind="text: _attrs1, classes: { hide: not(_show_attrs1), warningMessage:_warning_attrs1 }" style="margin-top:-5px;margin-bottom:2px; "></h5>
    <h5 data-bind="text: _attrs2, classes: { hide: not(_show_attrs2), warningMessage:_warning_attrs2 }" style="margin-top:-5px;margin-bottom:2px;"></h5>
    <h5 data-bind="text: _attrs3, classes: { hide: not(_show_attrs3), warningMessage:_warning_attrs3 }" style="margin-top:-5px;margin-bottom:2px;"></h5>
    <h5 data-bind="text: _attrs4, classes: { hide: not(_show_attrs4), warningMessage:_warning_attrs4 }" style="margin-top:-5px;margin-bottom:2px;"></h5>
    <h5 data-bind="text: _attrs5, classes: { hide: not(_show_attrs5), warningMessage:_warning_attrs5 }" style="margin-top:-5px;margin-bottom:2px;"></h5>

</script>



<%--<div style="width: 100%; text-align: center;">
    <ul class="dropdown-god-mode dropdown-menu dropdown" id="dropdown-god-mode">
        <li style="cursor:pointer"><a class="btn-dropdown-config-option" data-option="opt-change-position">Change Ladle Position</a></li>  
        <li role="separator" class="divider"></li>                
        
        <li style="cursor:pointer"><a class="btn-dropdown-config-option" data-option="opt-change-heat-weights">Change Heat Weights</a></li>
        
        <li style="cursor:pointer"><a class="btn-dropdown-config-option" data-option="opt-change-melt-order">Change Melt Order Heat</a></li>
      

        <li style="cursor:pointer"><a class="btn-dropdown-config-option" data-option="opt-assign-heat">Assign Heat To Ladle</a></li>
        
        <li role="separator" class="divider"></li>      
        
        <li style="cursor:pointer" data-bind="classes: { hide: not(inSource), },"><a class="btn-dropdown-config-option" data-option="opt-return-ladle">Return Ladle</a></li>
      
        <li style="cursor:pointer"><a class="btn-dropdown-config-option" data-option="opt-reladle">Reladle</a></li>

    </ul>
</div>--%>


<script id="non_free_open_modal_template_melt_shop_overview" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3>
            Quick Shroud | Non Free Open 
        </h3>
    </div>
    <div style="max-height:500px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:450px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=heat_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: trim(heat), enabled: false,"/>
                </div>
            </div>
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    Position
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: trim(position), enabled: false,"/>
                </div>
            </div>
            <div class="row-fluid" style="text-align:center; text-align:right;">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    Quick Shroud
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <select style="width:80px;" data-bind="value: quickShroud, options: quickShroudOptions"></select>                
                </div>
            
            </div>    
            
            <div class="row-fluid" style="text-align:center; text-align:right;">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    Is a Non Free Open?
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <label class="checkbox" style="font-size:14px; margin-left:10px;">
                        <input type="checkbox" name="nonFreeOpen" data-bind="checked: isNonFreeOpen"
                            style="width:18px; height:18px; vertical-align:middle; margin-right:8px;">
                    
                    </label>
                </div>
            
            </div>    

            <!-- Horizontal separator -->
            <hr style="margin-top:10px; margin-bottom:10px; border: none; border-top: 1px solid #ccc;" />

            
            
            
            <div class="row-fluid" style="text-align:center;" data-bind="classes: { hide: not(isNonFreeOpen), }">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    Rods
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="number" style="width:186px;" data-bind="value: trim(rods), enabled: true,"/>
                </div>
            </div>
       


            <div class="row-fluid" style="text-align:center; text-align:left;" data-bind="classes: { hide: not(isNonFreeOpen), }">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=comments_label />
                </div>
            </div>
            <div class="row-fluid" style="text-align:center; text-align:right;" data-bind="classes: { hide: not(isNonFreeOpen), }">
            
                <div style="float:left; width:97%" class="control-group form-inline">
                    <textarea style="width:100%; height:90px;" data-bind="value: comments"></textarea>
                </div>
            </div>
           
        </div>
    </div>
    <div class="modal-footer">
        <button id="acceptBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>


<script id="split_heat_modal_template_melt_shop_overview" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3>
            <asp:Localize runat=server meta:resourcekey=split_heat_modal_title />
        </h3>
    </div>
    <div style="max-height:400px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:350px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=heat_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: trim(heat), enabled: false,"/>
                </div>
            </div>
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=from_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: trim(position), enabled: false,"/>
                </div>
            </div>
            <div class="row-fluid" style="text-align:center; text-align:right;">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=from_ladle_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: trim(ladle), enabled: false,"/>
                </div>
            </div>
            <div class="row-fluid" style="text-align:center; text-align:right;">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=to_ladle_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <select style="width:80px;" data-bind="value: integer(toLadle), options: ladles, enabled: hasLadles,"></select>
                </div>
                <div style="margin-top:5px; padding-top:5px;" class="span1 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=weight_label />
                </div>
                <div style="margin-left:15px; margin-top: 5px; float:left;" class="control-group form-inline">
                     <input type="text" style="width:50px;" data-bind="value: trim(weight), enabled: true,"/>
                </div>
            </div>
             <div class="row-fluid" style="text-align:center; text-align:right;">
               
            </div>
            <div class="row-fluid" style="text-align:center; text-align:right;">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=comments_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                      <textarea style="resize: none; width:185px; height:90px;" data-bind="value: comments,"></textarea>
                </div>
            </div>
           
        </div>
    </div>
    <div class="modal-footer">
        <button id="acceptBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>

<script id="change_position_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: format('<asp:Localize runat=server meta:resourcekey=change_position_modal_title />', ladle)"></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:300px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=heat_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: trim(heat), enabled: false,"/>
                </div>
            </div>
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=from_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: trim(position), enabled: false,"/>
                </div>
            </div>
            <div class="row-fluid" style="text-align:center; text-align:right;">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=to_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <select style="width:200px;" data-bind="value: integer(newPositionId), options: positions, enabled: hasPositions,"></select>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button id="acceptBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>

<script id="change_melt_order_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: format('<asp:Localize runat=server meta:resourcekey=change_melt_order_modal_title />', heat)"></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <table>
                        <tr>
                            <td></td>
                            <td><b><asp:Localize runat=server meta:resourcekey=melt_order_label /></b></td>
                            <td><b><asp:Localize runat=server meta:resourcekey=grade_label /></b></td>
                            <td><b><asp:Localize runat=server meta:resourcekey=dim_label /></b></td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center;">
                                <b><asp:Localize runat=server meta:resourcekey=from_label /></b>
                            </td>
                            <td>
                                <input type="text" data-bind="value: curMeltOrder, enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                            <td>
                                <input type="text" data-bind="value: trim(curGrade), enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                            <td>
                                <input type="text" data-bind="value: trim(curDim), enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center;">
                                <b><asp:Localize runat=server meta:resourcekey=to_label /></b>
                            </td>
                            <td>
                                <select style="width:100px; text-align:center; text-align-last:center;" data-bind="value: newMeltOrder, options: meltOrders, enabled: hasMeltOrders,"></select>
                            </td>
                            <td>
                                <input type="text" data-bind="value: trim(newGrade), enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                            <td>
                                <input type="text" data-bind="value: trim(newDim), enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center; vertical-align:top; padding-top:6px;">
                                <b><asp:Localize runat=server meta:resourcekey=melt_order_sequence_label /></b>
                            </td>
                            <td colspan="3" style="text-align:left; padding:6px;">
                                <input id="inputMeltOrderSequence" type="text" data-bind="value: meltOrderSequence," style="width:100px; text-align:center;" />
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center; vertical-align:top; padding-top:6px;">
                                <b><asp:Localize runat=server meta:resourcekey=comments_label /></b>
                            </td>
                            <td colspan="3" style="text-align:left; padding:6px;">
                                <textarea style="resize: none; width:90%; height:100px;" data-bind="value: comments,"></textarea>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button id="changeMeltOrderSaveBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>

<script id="change_heat_weights_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: format('<asp:Localize runat=server meta:resourcekey=change_heat_weights_modal_title />', heat)"></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <table class="span12">
                    <tr>
                        <td><b><asp:Localize runat=server meta:resourcekey=net_label /></b></td>
                        <td><b><asp:Localize runat=server meta:resourcekey=tare_label /></b></td>
                        <td><b><asp:Localize runat=server meta:resourcekey=alloy_label /></b></td>
                    </tr>
                    <tr>
                        <td style="width:20%;">
                            <input type="text" data-bind="value: net," style="width:85%; text-align:center;" />
                        </td>
                        <td style="width:20%;">
                            <input type="text" data-bind="value: tare," style="width:85%; text-align:center;" />
                        </td>   
                        <td style="width:20%;">
                            <input type="text" data-bind="value: alloy," style="width:85%; text-align:center;" disabled/>
                        </td>    
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button id="changeHeatWeightsSaveBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>

<script id="assign_heat_to_ladle_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: format('<asp:Localize runat=server meta:resourcekey=assign_heat_to_ladle_modal_title />', ladle)"></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:300px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right; font-weight:bold;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=from_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" data-bind="value: heat, enabled: false," style="width:186px;" />
                </div>
            </div>
            <div class="row-fluid" style="text-align:center; text-align:right; font-weight:bold;">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=to_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <select style="width:200px;" data-bind="value: newHeat, options: heats, enabled: hasHeats,"></select>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button id="assignHeatToLadleSaveBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>

<script id="return_ladle_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: format('<asp:Localize runat=server meta:resourcekey=return_ladle_modal_title />', ladle)"></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="span12 control-group form-inline">
                    <table style="width:100%;">
                        <tr>
                            <td style="width:20%;"></td>
                            <td><b><asp:Localize runat=server meta:resourcekey=heat_label /></b></td>
                            <td><b><asp:Localize runat=server meta:resourcekey=position_label /></b></td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center;">
                                <b><asp:Localize runat=server meta:resourcekey=from_label /></b>
                            </td>
                            <td>
                                <input type="text" data-bind="value: trim(heat), enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                            <td>
                                <input type="text" data-bind="value: trim(position), enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center;">
                                <b><asp:Localize runat=server meta:resourcekey=to_label /></b>
                            </td>
                            <td></td>
                            <td>
                                <select style="width:100px; text-align:center; text-align-last:center;" data-bind="value: newPosition, options: positions, enabled: hasPositions,"></select>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center; vertical-align:top; padding-top:6px;">
                                <b><asp:Localize runat=server meta:resourcekey=comments_label /></b>
                            </td>
                            <td colspan="2" style="text-align:left; padding:6px;">
                                <textarea style="resize: none; width:90%; height:100px;" data-bind="value: comments,"></textarea>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button id="returnLadleSaveBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>

<script id="reladle_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: format('<asp:Localize runat=server meta:resourcekey=reladle_modal_title />', heat)"></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="span12 control-group form-inline">
                    <table style="width:100%;">
                        <tr>
                            <td style="width:20%;"></td>
                            <td><b><asp:Localize runat=server meta:resourcekey=position_label /></b></td>
                            <td><b><asp:Localize runat=server meta:resourcekey=ladle_label /></b></td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center;">
                                <b><asp:Localize runat=server meta:resourcekey=from_label /></b>
                            </td>
                            <td>
                                <input type="text" data-bind="value: position, enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                            <td>
                                <input type="text" data-bind="value: ladle, enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center;">
                                <b><asp:Localize runat=server meta:resourcekey=to_label /></b>
                            </td>
                            <td></td>
                            <td>
                                <select style="width:100px; text-align:center; text-align-last:center;" data-bind="value: newLadle, options: ladles, enabled: hasLadles,"></select>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center; vertical-align:top; padding-top:6px;">
                                <b><asp:Localize runat=server meta:resourcekey=comments_label /></b>
                            </td>
                            <td colspan="2" style="text-align:left; padding:6px;">
                                <textarea style="resize: none; width:90%; height:100px;" data-bind="value: comments,"></textarea>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button id="reladleSaveBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>
