﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="main_template" type="text/x-handlebars-template"> 

    <link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/libs/js/bootstrap-colorpicker/css/bootstrap-colorpicker.css") %>" rel="stylesheet" />

    <style>
        .backgrid th{
            font-size:12px !important;
        }

        .backgrid tr{
            font-size:12px !important;
        }

        .backgrid td.actions-cell {
            width:100px !important;
        }

        .backgrid td {
            width:150px !important; 
        }

            .backgrid tr td button{
                font-size:12px !important;
            }

        .span-color-picker-cell > i{
            border:1px solid #000000; 
        }

        .span-color-picker-cell {
            margin-left:0px !important;
        }
    </style>

    <div class="container-fluid">
        <div class="span12">
            <div class="row-fluid">

            </div>
            <div class="row-fluid">
                <div class="categories-grid-container">
                </div>
            </div>
        </div>
    </div>

    <script id="actions_cell_template" type="text/x-handlebars-template">
        <div>
            <button data-toggle="tooltip" data-placement="bottom" data-cell-action="SAVE" title="<asp:Localize runat=server meta:resourcekey=save_title />" class="btn btn-cell-action btn-small btn-save hide"><i class="fa fa-floppy-o"></i></button>
            <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DISCARD" title="<asp:Localize runat=server meta:resourcekey=discard_title />" class="btn btn-cell-action btn-small btn-discard hide"><i class="fa fa-times"></i></button>
            <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DELETE" title="<asp:Localize runat=server meta:resourcekey=remove_batch_title />" class="btn btn-cell-action btn-small btn-remove"><i class="fa fa-trash-o"></i></button>
        </div>
    </script>

</script>

<script id="subnavbar_controls" type="text/x-handlebars-template">
    <div class="span6">
        <div class="subnavbar-toolbar">
            <div style="display:inline-block;" class="subnavbar-button">
                <button class="btn add-item"><asp:Localize runat="server" meta:resourcekey="add_delay_category_btn_label" /></button>
            </div>
        </div>
    </div>
</script>