﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>
<script id="main_template" type="text/x-handlebars-template">

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/delays/delays-2/delays-2.css") %>" rel="stylesheet" />

<style>

    .backgrid th{
        font-size:12px !important;
    }

    .backgrid tr{
        font-size:12px !important;
    }

    .circle{
        display: inline-block;
        position: relative;
        text-align: center;
        margin:0 auto;
    }

    .circle-container {
        text-align:center;
    }

    .circle .main-text-centered-in-circle{
        position: absolute;
        top: 35%;
        left: 0;
        width: 100%;
        text-align: center;
    }

    .circle .sub-text-centered-in-circle{
        position: absolute;
        top: 53%;
        left: 0;
        width: 100%;
        text-align: center;
    }

    .dashboard-font{
        font-family:'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; 
    }

    .font55{
        font-size:55px;
    }

    .font35 {
        font-size:35px;
    }
    
    .font20 {
        font-size:20px;
    }

    .font15 {
        font-size:15px;
    }

    .time-progressbar-container{
        height:10px; 
        /*width:100px;*/
    }

    /*.progress .bar-red{background-color:#f11d1d;background-image:-moz-linear-gradient(top, #f11d1d, #cc0000);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#f11d1d), to(#cc0000));background-image:-webkit-linear-gradient(top, #f11d1d, #cc0000);background-image:-o-linear-gradient(top, #f11d1d, #cc0000);background-image:linear-gradient(to bottom, #f11d1d, #cc0000);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#f11d1d', endColorstr='#cc0000', GradientType=0);}
    .progress .bar-green{background-color:#00ff21;background-image:-moz-linear-gradient(top, #00ff21, #00b300);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#00ff21), to(#00b300));background-image:-webkit-linear-gradient(top, #00ff21, #00b300);background-image:-o-linear-gradient(top, #00ff21, #00b300);background-image:linear-gradient(to bottom, #00ff21, #00b300);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#00ff21', endColorstr='#00b300', GradientType=0);}
    .progress .bar-blue{background-color:#1a1aff;background-image:-moz-linear-gradient(top, #1a1aff, #0000e6);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#1a1aff), to(#0000e6));background-image:-webkit-linear-gradient(top, #1a1aff, #0000e6);background-image:-o-linear-gradient(top, #1a1aff, #0000e6);background-image:linear-gradient(to bottom, #1a1aff, #0000e6);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#1a1aff', endColorstr='#0000e6', GradientType=0);}*/

    .progress .bar-red{background-color:#de2e27;background-image:-moz-linear-gradient(top, #de2e27, #c43c35);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#de2e27), to(#c43c35));background-image:-webkit-linear-gradient(top, #de2e27, #c43c35);background-image:-o-linear-gradient(top, #de2e27, #c43c35);background-image:linear-gradient(to bottom, #de2e27, #c43c35);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#de2e27', endColorstr='#ffc43c35', GradientType=0);}
    .progress .bar-green{background-color:#3aea3a;background-image:-moz-linear-gradient(top, #3aea3a, #57a957);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#3aea3a), to(#57a957));background-image:-webkit-linear-gradient(top, #3aea3a, #57a957);background-image:-o-linear-gradient(top, #3aea3a, #57a957);background-image:linear-gradient(to bottom, #3aea3a, #57a957);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#3aea3a', endColorstr='#ff57a957', GradientType=0);}
    .progress .bar-blue{background-color:#15a1cb;background-image:-moz-linear-gradient(top, #15a1cb, #339bb9);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#15a1cb), to(#339bb9));background-image:-webkit-linear-gradient(top, #15a1cb, #339bb9);background-image:-o-linear-gradient(top, #15a1cb, #339bb9);background-image:linear-gradient(to bottom, #15a1cb, #339bb9);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#15a1cb', endColorstr='#ff339bb9', GradientType=0);}
    .progress .bar-yellow{background-color:#ecee12;background-image:-moz-linear-gradient(top, #ecee12, #f89406);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#ecee12), to(#f89406));background-image:-webkit-linear-gradient(top, #ecee12, #f89406);background-image:-o-linear-gradient(top, #ecee12, #f89406);background-image:linear-gradient(to bottom, #ecee12, #f89406);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#ecee12', endColorstr='#fff89406', GradientType=0);}

    .progress .bar-hover {
    }
    .progress .bar-hover:hover {
        border:2px dashed #2b2b2b; 
        padding:2px; 
    }

    .title-h-condensed {
        margin:4px auto;
    }

        h1.title-h-condensed, h2.title-h-condensed, h3.title-h-condensed, h4.title-h-condensed, h5.title-h-condensed, h6.title-h-condensed{
            line-height:15px;
        }

        h1.title-h-condensed, h2.title-h-condensed, h3.title-h-condensed{
            line-height:30px;
        }

    .title-h-condensed-extra {
        margin:2px auto;
    }
        
        h1.title-h-condensed-extra, h2.title-h-condensed-extra, h3.title-h-condensed-extra, h4.title-h-condensed-extra, h5.title-h-condensed-extra, h6.title-h-condensed-extra {
            line-height:10px;
        }

        h1.title-h-condensed-extra, h2.title-h-condensed-extra, h3.title-h-condensed-extra{
            line-height:20px;
        }

    .green-mode {
        color:#1ad91a; 
    }

    .red-mode {
        color:#de2e27; 
    }

    .yellow-mode {
        color:#ecee12; 
    }

</style>

<div class="dashboard-container dashboard-font">
    <div class="row-fluid" style="display:none;">
        <div class="span12">
            <div class="span9">
                <div class="span4 circle-container">
                    <div data-circle-name="oee" data-circle-size="65" data-circle-thickness="20" data-circle-gradient='["#29D65A", "#5feba3"]' data-circle-value="{{oee}}" class="circle">
                        <span class="font55 main-text-centered-in-circle progress-display"></span>
                        <span class="font35 sub-text-centered-in-circle">OEE</span>
                    </div>
                </div>
                <div class="span8">
                    <div class="row-fluid">
                        <div class="span4 circle-container">
                            <div data-circle-name="ava" data-circle-size="60" data-circle-thickness="10" data-circle-gradient='["#0685c3", "#06c4c1"]' data-circle-value="{{availability}}" class="circle">
                                <span class="font35 main-text-centered-in-circle progress-display"></span>
                                <span class="font20 sub-text-centered-in-circle">AVA</span>
                            </div>
                        </div>
                        <div class="span4 circle-container">
                            <div data-circle-name="per" data-circle-size="60" data-circle-thickness="10" data-circle-gradient='["#0685c3", "#06c4c1"]' data-circle-value="{{performance}}" class="circle">
                                <span class="font35 main-text-centered-in-circle progress-display"></span>
                                <span class="font20 sub-text-centered-in-circle">PER</span>
                            </div>
                        </div>
                        <div class="span4 circle-container">
                            <div data-circle-name="qua" data-circle-size="60" data-circle-thickness="10" data-circle-gradient='["#0685c3", "#06c4c1"]' data-circle-value="{{quality}}" class="circle">
                                <span class="font35 main-text-centered-in-circle progress-display"></span>
                                <span class="font20 sub-text-centered-in-circle">QUA</span>
                            </div>
                        </div>
                    </div>
                    <div style="margin-top:5px;" class="row-fluid">
                        <div class="row-fluid" style="margin-bottom:5px;">
                            <h4 class="title-h-condensed">Product Quantity</h4>
                        </div>
                        <div class="row-fluid">
                            <div style="position:relative;height:25px;">
                                <div class="progressbar-trail" style="height:25px;top:0px;width:100%;background-color:#eee;position:absolute;"></div>
                                <div class="progressbar-target" style="height:25px;top:0px;width:100%;position:absolute;"></div>
                                <div class="progressbar-actual" style="height:25px;top:0px;width:100%;position:absolute;"></div>
                            </div>
                        </div>
                        <div style="margin-top:3px;" class="row-fluid">
                            <div class="span4 pull-left">
                                <h3 class="actual-qty-display title-h-condensed"></h3>
                                <h5 class="title-h-condensed">Actual Quantity</h5>
                            </div>
                            <div class="span4 pull-right">
                                <h3 class="target-qty-display title-h-condensed"></h3>
                                <h5 class="title-h-condensed">Target Quantity</h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="span3">
                <h4 style="margin-top:0px;margin-bottom:0px;">Production Rate</h4>
                <div style="width:100%;height:2px;background-color:#ccc;margin-top:2px;margin-bottom:2px;"></div>
                <div class="row-fluid">
                    <div class="span6">
                        <h5 class="title-h-condensed">Current Rate</h5>
                        <h3 class="half-circle-progress-display title-h-condensed"></h3>
                    </div>
                    <div class="span6" style="text-align:right;">
                        <h5 class="title-h-condensed">Target Rate</h5>
                        <h3 class="title-h-condensed">{{targetProductionRate}}</h3>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span12 circle-container">
                        <div data-circle-name="productionRate" data-circle-value="{{actualProductionRate}}" data-circle-size="85" data-circle-thickness="25" class="half-circle">
                        </div>
                    </div>
                </div>
                <div class="row-fluid">
                    <h4><i style="margin-top:2px;" class="fa in-maintenance-icon fa-circle 
                        {{#ifEquals inMaintenance false}}
                        green-mode 
                        {{else}}
                            {{#ifEquals inMaintenance true}}
                                red-mode
                            {{else}}
                                yellow-mode
                            {{/ifEquals}}
                        {{/ifEquals}}
                        pull-left"></i>Released for Production</h4>                    
                </div>
            </div>
        </div>
    </div>
    <div class="row-fluid">
        <div class="span12">
            <h4><asp:Localize runat="server" meta:resourcekey="time_accounts_title" /></h4>
            <div style="width:100%;height:2px;background-color:#ccc;margin-top:2px;margin-bottom:2px;"></div>
            <div class="row-fluid">
                <div class="time-accounts-grid-container">
                </div>
            </div>
        </div>
        <div class="span12" style="margin: 0 0 0 0;">
            <h4><asp:Localize runat="server" meta:resourcekey="progress_title" /></h4>
            <div style="width:100%;height:2px;background-color:#ccc;margin-top:2px;margin-bottom:2px;"></div>
            <div class="row-fluid">
                <div class="row-fluid">
                    <div style="margin-top:12%;" class="progress-bar-container">
                        <div class="progress">
                        </div>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span12">
                        <small style="position:absolute;left:10%">3 mins</small>
                        <small style="position:absolute;left:20%">6 mins</small>
                        <small style="position:absolute;left:30%">9 mins</small>
                        <small style="position:absolute;left:40%">12 mins</small>
                        <small style="position:absolute;left:50%">15 mins</small>
                        <small style="position:absolute;left:60%">18 mins</small>
                        <small style="position:absolute;left:70%">21 mins</small>
                        <small style="position:absolute;left:80%">24 mins</small>
                        <small style="position:absolute;left:90%">27 mins</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row-fluid" style="display:none;">
        <div class="span4">
            <h4>Information</h4>
            <div class="row-fluid">
                <table class="time-accounts-table table">
                    <thead>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Batch</td>
                            <td><strong>123456</strong></td>
                        </tr>
                        <tr>
                            <td>Start</td>
                            <td><strong>123456</strong></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="span8">
            <h4>Events</h4>
            <div style="width:100%;height:2px;background-color:#ccc;margin-top:2px;margin-bottom:2px;"></div>
            <div class="row-fluid">
                <div style="height:190px;overflow-y:auto;" class="events-grid-container"></div>
            </div>
        </div>
    </div>
</div>

</script>


