﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />

<style>

    .content-inner-container .subnavbar {
        height:59px;
    }

    .content-inner-container .subnavbar .form-inline {
        margin-top: 13px;
        margin-left: 20px;
    }

    .content-inner-container .subnavbar select {
        margin-top:-5px;
    }

    .content-inner-container .subnavbar .btn-excel {
        margin:1px 10px 0 0;
    }

    .fixed-subnavbar + .screen-content {
        margin-top:54px;
        /*width: 1024px;
        left: 50%;
        margin-left: -512px;
        position: relative;*/
    }

    .clickeable-row{
        cursor:pointer; 
    }

    .backgrid th{
        font-size:12px !important;
    }

    .backgrid tr{
        font-size:12px !important;
    }

    /*.backgrid tr td{
        overflow:visible !important; 
    }*/

    .items-grid-container .backgrid th.FixedCol_Comments,
    .items-grid-container .backgrid td.FixedCol_Comments {
        width:300px; 
        overflow: hidden !important;
        -ms-text-overflow: ellipsis !important;
        -o-text-overflow: ellipsis !important;
        text-overflow: ellipsis !important;
        white-space: nowrap !important;
    }

</style>

<div class="row-fluid subnavbar fixed-subnavbar" style="min-width:1305px;">
    <div class="form-inline pull-left">
        <label class="control-label" for="dateStartTbx" style="width:50px;text-align:right;">
            <asp:localize runat="server" meta:resourcekey="date_start_tbx_label" />
        </label>
        <div class="input-prepend" style="margin-left:5px;">
            <label for="dateStartTbx"><span class="add-on"><i class="icon-calendar"></i></span></label>
            <input type="text" id="dateStartTbx" style="width:96px;z-index:1000;" class="input-date" data-bind="value: start">
        </div>
        <label class="control-label" for="dateEndTbx" style="width:50px;text-align:right;">
            <asp:localize runat="server" meta:resourcekey="date_end_tbx_label" />
        </label>
        <div class="input-prepend" style="margin-left:5px;">
            <label for="dateEndTbx"><span class="add-on"><i class="icon-calendar"></i></span></label>
            <input type="text" id="dateEndTbx" style="width:96px;z-index:1000;" class="input-date" data-bind="value: end">
        </div>
    </div>
    <div class="form-inline pull-right" style="margin-top:5px;margin-left:0;margin-right:20px;">
        <div class="toolbar-filter">
            <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="line_combo_label" /></label>
            <select style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: integer(lineId), options: lines" class="input-medium"></select>
        </div>
    </div>
</div>

<div class="row-fluid screen-content">
    <div style="margin-top:7%;" class="row-fluid loading-poster text-center">
        <div style="width:40%; margin: 0 auto;" class="progress progress-striped active">
            <div class="bar" style="width: 100%;"></div>
        </div>
    </div>
    <div class="items-grid-container infinite-container hide">
    </div>
    <div class="infinite-scrolling-loading-poster hide">
        <span>Loading...</span>
    </div>
</div>

