﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>
<script id="main_template" type="text/x-handlebars-template">

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />

<style>

    .clickeable-row{
        cursor:pointer; 
    }

    .backgrid th{
        font-size:12px !important;
    }

    .backgrid tr{
        font-size:12px !important;
    }

    .backgrid tr td{
        overflow:visible !important; 
    }

    .backgrid tr td button{
        font-size:12px !important;
    }

    .toolbar-filter {
        display:inline-block;
    }

        .toolbar-filter.hide {
            display:none !important; 
        }

        .toolbar-filter .radio,
        .toolbar-filter .checkbox {
            padding-left:0;
            margin-left:10px;
            margin-right:0;
        }

    .group-controls-separator {
        margin-left:40px;
    }

    .infinite-scrolling-loading-poster {
        width:100%;
        text-align:center;
        font-size:14px;
        margin-bottom:15px;
    }

    .grayout {
        color: #9b9b9b !important; 
    }

</style>

<div class="container-fluid">
    <div class="span12">
        <div class="row-fluid">
            <div style="margin-top:7%;" class="row-fluid loading-poster text-center hide">
                <div style="width:40%; margin: 0 auto;" class="progress progress-striped active">
                    <div class="bar" style="width: 100%;"></div>
                </div>
            </div>
            <div class="oee-report-grid-container infinite-container">
            </div>
            <div class="infinite-scrolling-loading-poster hide">
                <span>Loading...</span>
            </div>
        </div>
    </div>
</div>

</script>

<script type="text/x-handlebars-template" id="subnavbar_controls">
    <div class="span3">
        <div>
            <div style="width:200px;display:inline-block;top:4px;position:relative;">
                <div style="width:50px;float:left;text-align:right;">
                    <span style="top:5px;position:relative;"><asp:Localize runat="server" meta:resourcekey="from_label" /></span>
                </div>
                <div data-cube-filter="DATE" data-cube-filter-name="from" data-cube-filter-prop-name="from" data-cube-filter-query="[Time].[Date]" style="width:150px;float:left;margin-left:-10px;" class="from-date-control-container">
                </div>
            </div>
            <div style="width:200px;display:inline-block;top:4px;position:relative;">
                <div style="width:50px;float:left;text-align:right;">
                    <span style="top:5px;position:relative;"><asp:Localize runat="server" meta:resourcekey="to_label" /></span>
                </div>
                <div data-cube-filter="DATE" data-cube-filter-name="to" data-cube-filter-prop-name="to" data-cube-filter-query="[Time].[Date]" style="width:150px;float:left;margin-left:-10px;" class="to-date-control-container">
                </div>
            </div>
        </div>
    </div>
    <div class="span9">
        <div class="subnavbar-right-toolbar row-fluid">
            <div class="row-fluid">
                <div class="span10">
                    <div class="row-fluid">
                        <div style="display: inline-block; height: 40px;" class="form-inline pull-right">
                            <div data-bind="classes: { hide: not(all(showAreaIdSelect, inRangeMin(length(areas), 1, false))), }," class="toolbar-filter">
                                <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="area_label" /></label>
                                <select data-cube-filter="CUSTOM" data-group-by-filter-id="group-by-area" data-cube-filter-name="AREA"  data-cube-filter-prop-name="areaId" data-cube-filter-query="[Production Items].[Parent Id]" style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: areaId, options: areas, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_production_items_label />', value: -1 }," id="select6" name="selectbasic" class="input-small">
                                </select>
                            </div>
                            <div data-bind="classes: { hide: not(showLineIdSelect) }" class="toolbar-filter">
                                <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="line_label" /></label>
                                <select data-cube-filter="CUSTOM" data-group-by-filter-id="group-by-line" data-cube-filter-name="LINE"  data-cube-filter-prop-name="lineId" data-cube-filter-query="[Production Items].[Parent Id]" style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: lineId$, options: linesFiltered, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_production_items_label />', value: -1 }" id="select5" name="selectbasic" class="input-small">
                                </select>
                            </div>
                            <div data-bind="classes: { hide: not(showMachineIdSelect) }" class="toolbar-filter">
                                <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="machine_label" /></label>
                                <select data-cube-filter="CUSTOM" data-group-by-filter-id="group-by-machine" data-cube-filter-name="MACHINE" data-cube-filter-prop-name="machineId" data-cube-filter-query="[Production Items].[Parent Id]" style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: machineId$, options: machinesFiltered, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_production_items_label />', value: -1 }," id="select6" name="selectbasic" class="input-small">
                                </select>
                            </div>
                            <div data-bind="classes: { hide: not(showProductIdSelect) }" class="toolbar-filter">
                                <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="product_label" /></label>
                                <select data-cube-filter="CUSTOM" data-group-by-filter-id="group-by-productId" data-cube-filter-name="PRODUCT" data-cube-filter-prop-name="productId" data-cube-filter-query="[Products].[Id]" style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: productId$, options: products, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_products_label />', value: -1 }" id="select3" name="selectbasic" class="input-small">
                                </select>
                            </div>
                            <div data-bind="classes: { hide: not(showShiftIdSelect) }" class="toolbar-filter">
                                <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="shift_label" /></label>
                                <select data-cube-filter="CUSTOM" data-group-by-filter-id="group-by-shift" data-cube-filter-name="SHIFT" data-cube-filter-prop-name="shiftId" data-cube-filter-query="[Shifts].[Shift]" style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: shiftId$, options: shifts, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_shifts_label />', value: -1 }" id="select1" name="selectbasic" class="input-small">
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div style="display: inline-block; height: 30px;" class="form-inline pull-right">
                            <span style="top:2px;position:relative;"><asp:Localize runat="server" meta:resourcekey="group_by_label" /></span>
                            <div class="toolbar-filter">
                                <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
                                    <input data-bind="checked: timestampGroupBy" value="DATE" style="margin-top:-1px;" type="radio" name="timestampGroupByRadios" id="radio1" />
                                    <span><asp:Localize runat="server" meta:resourcekey="group_by_day_label" /></span>
                                </label>
                            </div>
                            <div class="toolbar-filter">
                                <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
                                    <input data-bind="checked: timestampGroupBy" value="WEEK" style="margin-top:-1px;" type="radio" name="timestampGroupByRadios" id="radio2" />
                                    <span><asp:Localize runat="server" meta:resourcekey="group_by_week_label" /></span>
                                </label>
                            </div>
                            <div class="toolbar-filter">
                                <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
                                    <input data-bind="checked: timestampGroupBy" value="MONTH" type="radio" style="margin-top:-1px;" name="timestampGroupByRadios" id="radio3" />
                                    <span><asp:Localize runat="server" meta:resourcekey="group_by_month_label" /></span>
                                </label>
                            </div>
                            <div class="toolbar-filter">
                                <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
                                    <input data-bind="checked: timestampGroupBy" value="YEAR" type="radio" style="margin-top:-1px;" name="timestampGroupByRadios" id="radio4" />
                                    <span><asp:Localize runat="server" meta:resourcekey="group_by_year_label" /></span>
                                </label>
                            </div>
                            <span class="group-controls-separator" style="top:2px;position:relative;"><asp:Localize runat="server" meta:resourcekey="group_by_label" /></span>
                            <div class="toolbar-filter" data-bind="classes: { hide: not(inRangeMin(length(areas), 1, false)), },">
                                <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
                                    <input data-bind="checked: productionItemGroupBy, enabled: all(equals(lineId, -1), equals(machineId, -1))," value="AREA" type="radio" style="margin-top:-1px;" name="productionItemGroupByRadios" id="radio5" />
                                    <span><asp:Localize runat="server" meta:resourcekey="group_by_area_label" /></span>
                                </label>
                            </div>
                            <div class="toolbar-filter">
                                <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
                                    <input data-bind="checked: productionItemGroupBy, enabled: equals(machineId, -1)," value="LINE" type="radio" style="margin-top:-1px;" name="productionItemGroupByRadios" id="radio5" />
                                    <span><asp:Localize runat="server" meta:resourcekey="group_by_line_label" /></span>
                                </label>
                            </div>
                            <div class="toolbar-filter">
                                <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
                                    <input data-bind="checked: productionItemGroupBy, enabled: equals(machineId, -1)," value="MACHINE" type="radio" style="margin-top:-1px;" name="productionItemGroupByRadios" id="radio6" />
                                    <span><asp:Localize runat="server" meta:resourcekey="group_by_machine_label" /></span>
                                </label>
                            </div>
                            <div class="toolbar-filter group-controls-separator">
                                <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
                                    <input data-bind="checked: othersGroupBy, enabled: equals(productId, -1)," value="PRODUCT" type="checkbox" style="margin-top:1px;" name="checks" id="group-by-productId">
                                    <span><asp:Localize runat="server" meta:resourcekey="group_by_product_label" /></span>
                                </label>
                            </div>
                            <div class="toolbar-filter" style="margin-left:10px;">
                                <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
                                    <input data-bind="checked: othersGroupBy, enabled: equals(shiftId, -1)," value="SHIFT" type="checkbox" style="margin-top:1px;" name="checks" id="group-by-shift">
                                    <span><asp:Localize runat="server" meta:resourcekey="group_by_shift_label" /></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="span2">    
                    <div class="row-fluid">
                        <div style="position:relative;top:3px;" class="toolbar-filter">
                            <button style="margin-top:0;" class="btn btn-export-to-excel" type="button">
                                <span class="excel-export-state fa fa-file-excel-o"></span>
                                <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
                            </button>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <button class="btn btn-block btn-refresh btn-success">
                        <asp:Localize runat="server" meta:resourcekey="refresh_btn_label" />
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</script>

