﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
   
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
 
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar not-print" style="min-width:1305px;margin-top: -1px;""> 
    <div class="form-inline pull-left span11" style="min-width:1260px;">  <!--1260--> 
        

        <label class="control-label" id="date_label" for="productionDate" >
            <asp:localize runat="server" meta:resourcekey="production_date_tbx_label" />
        </label>
        <label class="input-prepend" id="date">
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="productionDateTbx" class="input-date" style="width:75px;z-index:1000;" data-bind="value: productionDate, disabled: isLoading ">
        </label>

        
        <label class="control-label" id="shift">
            <asp:localize runat="server" meta:resourcekey="shift_combo_label" />
            <button id="backNavBtn" class="btn btn-primary " style="margin-bottom:5px;margin-left:10px; margin-right:10px;" data-bind="disabled:  isLoading">
                        <asp:Localize runat="server" meta:resourcekey="back_item_btn_label" />
            </button> 
            <input type="text" style="width:20px; text-align:center; margin-top: -5px;" data-bind="value:shiftId"  readonly />
            <button id="forwardNavBtn" class="btn btn-primary" style="margin-bottom:5px;margin-left:10px;" data-bind="disabled:  isLoading">
                        <asp:Localize runat="server" meta:resourcekey="forward_item_btn_label" />
            </button>
        </label>

        <button id="refreshBtn" class="btn btn-primary" style="margin-bottom:5px;margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />"  data-bind=" disabled: isLoading">
            <i class="fa fa-refresh"></i>
        </button>
        <div class="pull-right" style="margin-right:10px;">
            <button id="printBtn" class="btn btn-primary"  style="margin-bottom:5px;margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=print_btn_title />"  data-bind="disabled:  any(not(hasData), isLoading)" >
                <i class="fa fa-print"></i>
            </button>
            
        </div>
        
    </div>
</div>
<div class="row-fluid screen-content" style="min-width:1260px;">
   <div id="pageborder" style="margin-bottom:5px !important"></div>
    <div class="no-data-poster row-fluid text-center animated fadeIn not-print" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div> 
 
    <div class="no-data-poster row-fluid text-center animated fadeIn not-print" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    <div class="row entry-row body-print" style="margin-left:30px;">
        <div class="entry-div-label" data-bind="classes: { hide: any(not(hasData), isLoading), }" >

            <!--STEEL DYNAMICS LOGO HTML-->
            <div class="row fluid">           
                <div id ="img-logo-main" class="span6 not-print" style="max-width:350px; margin-top: 0px; margin-left: 30px;" >
                    <img src='<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + 
                    Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".jpg") %>' />
                </div>
                <div class="span6 page-title not-print " style="font-size:40px; margin-top:20px; margin-left:24%;color:black;  "
                    data-bind="classes: { hide: any(not(hasData), isLoading), }">
                    <h2>
                        <asp:localize runat="server" meta:resourcekey="title_tbx_label" />
                    </h2>
                </div>
            </div>

             <!--STEEL DYNAMICS LOGO PRINT OPTION-->
            <div class="container-logo-title">
                <div class="badge-logo-title">
                    <div id ="img-logo" style="margin-left:-40px; /*margin-top:-100px;*/">
                        <img src='<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + 
                        Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".jpg") %>' />
                    </div>
                </div>
                <div class="badge-logo-title" style="margin-left: 80px; margin-top:100px;">
                    <h2 id="pdf-title">
                        <asp:localize runat="server" meta:resourcekey="title_tbx_label" />
                    </h2>
                </div>
            </div>

             <!--PRODUCTION DATE-->
            <div class="container-label" style="margin-left:-30px; margin-top:10px;float:left !important;margin-right:-80px !important;">
                <div class="badge-label">
                    <label style="font-size:18px; margin-left: 10px;"  class="text-font-general">
                        <asp:localize runat="server" meta:resourcekey="date_tbx_label" />
                    </label>
                </div>
                <div class="badge-label" style="font-size:22px; font-weight:bold; margin-top:5px; margin-left:30px;">
                    <span data-bind="text: productionDate"></span>
                </div>
                <hr class="underline-date"/>
            </div>
            
             <!--SHIFT-->
            <div class="container-label" style="margin-left:-70px !important; margin-top:10px; margin-bottom:5px;float:left !important;">
                <div class="badge-label">
                    <label style="font-size:18px; margin-left: 10px;">
                        <asp:localize runat="server" meta:resourcekey="shift_combo_label" />
                    </label>
                </div>
                <div class="badge-label" style="font-size:22px; font-weight:bold; margin-left: 20px;"> 
                    <span class= "date_label" data-bind="text: shiftId"></span>
                </div>
                
                <hr class="underline-shift"/>
            </div>
            

            <!--CREW-->
            <div class="container-label" style="margin-left:-300px; margin-top:10px; margin-bottom:5px;float:left !important;">
                <div class="badge-label">
                    <label style="font-size:18px; margin-left: 10px;">
                        <asp:localize runat="server" meta:resourcekey="crew_combo_label" />
                    </label>
                </div>
                <div class="badge-label" style="font-size:22px; font-weight:bold; margin-left: 20px;"> 
                    <span class= "date_label" data-bind="text: CREW_ID"></span>
                </div>
                
                <hr class="underline-shift"/>
            </div>
            
            <!-- TOTALS AND AVERAGES-->
            <table style="width:100%;" class="totals-and-averages EAF-averages-chart-print" data-bind="classes: { hide: any(not(hasData_EAF), isLoading_EAF), EAFDataChartPrintAB: any(not(hasData_AllHeats_EAF_A),not(hasData_AllHeats_EAF_B)), }">
                <tr>
                    <th class="big-empty-column"></th>
                    <th class="not-border" style="height:25px; width:150px;"></th>
                    <th class="top-categories">EAF A</th>
                    <th class="top-categories">EAF B</th>
                    <th class="top-categories">TOTAL / AVG</th>
                    <th class="not-border small-empty-column"></th>
                    <th class="not-border" style="height:25px; width:150px;"></th>
                    <th class="top-categories">EAF A</th>
                    <th class="top-categories">EAF B</th>
                    <th class="top-categories">TOTAL / AVG</th>
                    <th class="big-empty-column"></th>
                </tr>
                <tr>
                    <th class="big-empty-column"></th>
                    <td class="left-categories">Total Heats</td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TotalHeats"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TotalHeats"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:TOTAL_TotalHeats"></span></td>
                    <td class="not-border small-empty-column"></td>
                    <td class="left-categories">Total MWH</td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TotalElectricEnergy"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TotalElectricEnergy"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:TOTAL_TotalElectricEnergy"></span></td>
                    <th class="big-empty-column"></th>
                </tr>
                <tr>
                    <th class="big-empty-column"></th>
                    <td class="left-categories">Total Steel Weight</td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TotalSteelWeight"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TotalSteelWeight"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:TOTAL_TotalSteelWeight"></span></td>
                    <td class="not-border small-empty-column"></td>
                    <td class="left-categories">Total Electrode Adds</td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TotalElectrodeAdds"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TotalElectrodeAdds"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:TOTAL_TotalElectrodeAdds"></span></td>
                    <th class="big-empty-column"></th>
                </tr>
                <tr>
                    <th class="big-empty-column"></th>
                    <td class="left-categories">Total Scrap Weight</td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TotalScrapWeight"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TotalScrapWeight"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:TOTAL_TotalScrapWeight"></span></td>
                    <td class="not-border small-empty-column"></td>
                    <td class="left-categories">Electrode Consumption</td>
                    <td class="totals-and-averages-values"><span>-</span></td>
                    <td class="totals-and-averages-values"><span>-</span></td>
                    <td class="totals-and-averages-values"><span>-</span></td>
                    <th class="big-empty-column"></th>
                </tr>
                <tr>
                    <th class="big-empty-column"></th>
                    <td class="left-categories">Steel Weight</td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_A_SteelWeight"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_B_SteelWeight"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:SteelWeightConcat"></span></td>
                    <td class="not-border small-empty-column"></td>
                    <td class="left-categories">KWH/Ton</td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_A_SpecificEnergy"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_B_SpecificEnergy"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:SpecificEnergyConcat"></span></td>
                    <th class="big-empty-column"></th>
                   
                </tr>
                <tr>
                    <th class="big-empty-column"></th>
                    <td class="left-categories">Scrap Weight</td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_A_ScrapWeight"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_B_ScrapWeight"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:ScrapWeightConcat"></span></td>
                    <td class="not-border small-empty-column"></td>
                     <td class="left-categories">Electric Power</td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_A_ElectricPower"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_B_ElectricPower"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:TOTAL_ElectricPower"></span></td>
                    <th class="big-empty-column"></th>
                   
                </tr>
                 <tr>
                    <th class="big-empty-column"></th>
                    <td class="left-categories">Yield (%)</td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_A_Yield"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_B_Yield"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:YieldConcat"></span></td>
                    <td class="not-border small-empty-column"></td>
                    <td class="left-categories">Smart ARC</td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_A_SmartARC"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_B_SmartARC"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:TOTAL_SmartARC"></span></td>
                    <th class="big-empty-column"></th>
                  
                </tr>
                <tr>
                    <th class="big-empty-column"></th>
                    <td class="left-categories">Tap To Tap</td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_A_TapToTap"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_B_TapToTap"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:TapToTapConcat"></span></td>
                    <td class="not-border small-empty-column"></td>
                    <th class="big-empty-column"></th>
                </tr>
                <tr>
                    <th class="big-empty-column"></th>
                    <td class="left-categories">Power On</td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_A_PowerOn"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:EAF_B_PowerOn"></span></td>
                    <td class="totals-and-averages-values"><span data-bind="text:PowerOnConcat"></span></td>
                    <td class="not-border small-empty-column"></td>
                    <th class="big-empty-column"></th>
                </tr>
            </table>

            <!--HEAT GANT CHARTS-->
            <div class="row fluid" style="margin-top:50px;">
                <div class="span10 avoid">
                    <div class="EAF-chart-print" style="margin-left: 13%;" data-bind="classes: { hide: any(not(hasData_AllHeats_EAF_A), isLoading_AllHeats), }">
                        <h4 class="gantt-label">
                            <asp:localize runat="server" meta:resourcekey="EAFA_label"  />
                        </h4>
                        <svg style="margin-top:20px;margin-left:50px;"class="chart-EAF-A center-chart"></svg>
                    </div>
                    <div class="EAF-chart-print" style="margin-left: 13%;" data-bind="classes: { hide: any(not(hasData_AllHeats_EAF_B), isLoading_AllHeats), }">
                        <h4 class="gantt-label">
                            <asp:localize runat="server" meta:resourcekey="EAFB_label"  />
                        </h4>
                        <svg style="margin-top:20px;margin-left:50px;"class="chart-EAF-B center-chart"></svg>
                    </div>
                </div>
                <div class="span2 not-print" data-bind="classes: { hide: any(not(hasDataDelaysOrHeats), isLoading_AllDelays, isLoading_AllHeats), }">
                    <div class="float_left">
                         <h4>
                           <asp:localize runat="server" meta:resourcekey="References_heat_label"  />
                        </h4>
                        <div class="row-fluid" style="margin-top:-50px;float:left;">
                            <div class="span4">
                                <svg>
                                    <rect width="20" height="20" style="fill:#ff5900" transform="translate(40,130)"></rect>
                                    <rect width="20" height="20" style="fill:#f3f317" transform="translate(40,100)"></rect>
                                    <rect width="20" height="20" style="fill:#3ebf3c" transform="translate(40,70)"></rect>
                                </svg>
                            </div>
                            <div class="span8" style="margin-top: -85px; margin-left:70px;">
                                <p>Time < 40 min</p>
                                <p>Time btw 40 & 50 min</p>
                                <p>Time > 50 min</p>
                            </div>
                        </div>
                    </div>
                    <div class="float_left">
                        <h4>
                           <asp:localize runat="server" meta:resourcekey="References_Cat_label"  />
                        </h4>
                        <div class="row-fluid" style="margin-top:-50px; float:left;">
                            <div class="span4">
                                <svg>
                                    <rect width="20" height="20" style="fill:#80ffA0" transform="translate(40,130)"></rect>
                                    <rect width="20" height="20" style="fill:#ff8080" transform="translate(40,100)"></rect>
                                    <rect width="20" height="20" style="fill:#8280fc" transform="translate(40,70)"></rect>
                                </svg>
                            </div>
                            <div class="span8" style="margin-top: -85px; margin-left:70px;">
                                <p>EAF-Charging</p>
                                <p>EAF-Melting</p>
                                <p>EAF-Tapping</p>
                            </div>
                        </div>
                    </div>
                </div>                
             
            </div>

            <div class="row-fluid print" data-bind="classes: { hide: any(not(hasDataDelaysOrHeats), isLoading_AllDelays, isLoading_AllHeats), }" style="margin-top:40px !important;">          
                <div style="float:left;margin-right:50px !important">
                    <table>  
                      <tr>
                          <td colspan="7" style="font-weight:bold; height:30px!important">Heat Duration </td>    
                      </tr>
                      <tr>
                        <td><svg style="height:22px;width:22px;"><rect width="20" height="20" style="fill:#ff5900"></rect></svg></td>
                        <td style="padding-right:5px !important;">Time < 40 min</td>         
                        <td style="padding-right:5px !important;"><svg style="height:22px;width:22px;"><rect width="20" height="20" style="fill:#f3f317"></rect></svg></td>
                        <td style="padding-right:5px !important;">Time btw 40 & 50 min</td>      
                        <td style="padding-right:5px !important;"><svg style="height:22px;width:22px;"><rect width="20" height="20" style="fill:#3ebf3c"></rect></svg></td>
                        <td style="padding-right:5px !important;">Time > 50 min</td>      

                      </tr>  
                    </table>
                </div>

                <div>
                    <table>
                        <tr>
                             <td colspan="7" style="font-weight:bold; height:30px!important">Delay Categories</td>
                        </tr>
                        <tr>                        
                            <td><svg style="height:22px;width:22px;"><rect width="20" height="20" style="fill:#80ffA0"></rect></svg></td>
                            <td style="padding-right:5px !important;">EAF Charging</td>         
                            <td style="padding-right:5px !important;"><svg style="height:22px;width:22px;"><rect width="20" height="20" style="fill:#ff8080"></rect></svg></td>
                            <td style="padding-right:5px !important;">EAF Melting</td>      
                            <td style="padding-right:5px !important;"><svg style="height:22px;width:22px;"><rect width="20" height="20" style="fill:#8280fc"></rect></svg></td>
                            <td style="padding-right:5px !important;">EAF Tapping</td>  
                        </tr>
                    </table>
                </div>
            </div>


            <div class="row-fluid">
                <div class="span6">                    
                        <!---DELAYS EAF A GRID-->
                    <div data-bind="classes: { hide: any(not(hasData_DelaysEAFA), isLoading_DelaysEAFA), }">
                        <h4>EAF A - TOP 3 DELAYS</h4>
                        <div class="items-grid-container-delaysEAFA" style="max-width:95%; font-size:13px;"></div>
                    </div>                        
                </div>
                <div class="span6">                    
                    <!---DELAYS EAF B GRID-->
                    <div  data-bind="classes: { hide: any(not(hasData_DelaysEAFB), isLoading_DelaysEAFB), }">
                        <h4>EAF B - TOP 3 DELAYS</h4>
                        <div class="items-grid-container-delaysEAFB" style="max-width:95%; font-size:13px;"></div>
                    </div> 
                </div>                       
            </div>

            
            <%--<div class="pagebreak"> </div>--%>
            <!---BUCKET FLUXES-->
            
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px;">
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_bucket_fluxes_EAFA)), }">
                    <label class="print-label">EAF A - BUCKET FLUXES</label>
                    <div style="margin-left: 0%;" class="bucket_fluxes_EAFA"></div>
                </div>  
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_bucket_fluxes_EAFB)), }">
                    <label class="print-label">EAF B - BUCKET FLUXES</label>
                    <div style="margin-left: 0%;" class="bucket_fluxes_EAFB"></div>
                </div>
            </div>

 

            <!---KWH/Ton-->
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px;">
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_injection_fluxes_EAFA)), }">
                    <label class="print-label">EAF A - KWH/Ton</label>
                    <div style="margin-left: 0%;" class="injection_fluxes_EAFA"></div>
                </div>  
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_injection_fluxes_EAFB)), }">
                    <label class="print-label">EAF B - KWH/Ton</label>
                    <div style="margin-left: 0%;" class="injection_fluxes_EAFB"></div>
                </div>
            </div>

         

            <!--TEMPERATURE CHARTS-->
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px;">
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_temperature_EAFA)), }">
                    <label class="print-label">EAF A - TEMPERATURE</label>
                    <div style="margin-left: 0%;" class="temperature_EAFA"></div>
                </div>  
                <div class="span6 set-margin-top print-chart" data-bind="classes: { hide: any(not(hasData_temperature_EAFB)), }">
                    <label class="print-label">EAF B - TEMPERATURE</label>
                    <div style="margin-left: 0%;" class="temperature_EAFB"></div>
                </div>
            </div>
            

            <!--OXYGEN CHARTS-->
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px;">
                <div class="span6 print-chart"  data-bind="classes: { hide: any(not(hasData_temperature_EAFA_2)), }">
                    <label class="print-label">EAF A - OXYGEN</label>
                    <div style="margin-left: 0%;" class="temperature_EAFA_2"></div>
                </div>  
                <div class="span6 print-chart"  data-bind="classes: { hide: any(not(hasData_temperature_EAFB_2)), }">
                    <label class="print-label">EAF B - OXYGEN</label>
                    <div style="margin-left: 0%;" class="temperature_EAFB_2"></div>
                </div>
            </div>
            


            <!---RESIDUAL CHARTS 1-->
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px">
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_residuals_EAFA)), }">
                    <label class="print-label">EAF A - RESIDUAL GRAPH 1</label>
                    <div style="margin-left: 0%;" class="residuals_EAFA"></div>
                </div> 
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_residuals_EAFB)), }">
                    <label class="print-label">EAF B - RESIDUAL GRAPH 1</label>
                    <div style="margin-left: 0%;" class="residuals_EAFB"></div>
                </div>
            </div>
            
           

            <!---RESIDUAL CHARTS 2-->
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px;">
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_residuals_EAFA_2)), }">
                    <label class="print-label">EAF A - RESIDUAL GRAPH 2</label>
                    <div style="margin-left: 0%;" class="residuals_EAFA_2"></div>
                </div>  
                <div class="span6 print-chart" data-bind="classes: { hide: any(not(hasData_residuals_EAFB_2)), }">
                    <label class="print-label">EAF B - RESIDUAL GRAPH 2</label>
                    <div style="margin-left: 0%;" class="residuals_EAFB_2"></div>
                </div>
            </div>

            
            

            <div class="pagebreak"> </div>
            
            <!--- Baghouse-->
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px;">
                <div class="span12 print-chart" data-bind="classes: { hide: any(not(hasData_baghouse)), }">
                    <label class="print-label">Baghouse</label>
                    <div style="margin-left: 0%;" class="baghouse"></div>
                </div>
            </div>




            <!--- ------------------------------------PRINT GRAPH----------------------------------------------------------------------------->
            <!---EAF A GRAPH--->

            <div data-bind="classes: { hide: not(hasData_EAF_A), }">
                <div class="row fluid print" style="margin-bottom:50px;margin-top:50px;margin-left:-50px;">
                    <div style="float:left;" data-bind="classes: { hide: any(not(hasData_bucket_fluxes_EAFA)), }">
                        <label class="print-label">EAF A - BUCKET FLUXES</label>
                        <div class="bucket_fluxes_EAFA_print"></div>
                    </div>  
                    <div data-bind="classes: { hide: any(not(hasData_injection_fluxes_EAFA)), }">
                        <label class="print-label">EAF A - KWH/Ton</label>
                        <div class="injection_fluxes_EAFA_print"></div>
                    </div> 
            
                </div>


                <div class="row fluid print" style="margin-bottom:50px;margin-top:50px;margin-left:-50px;">
                    <div style="float:left;" data-bind="classes: { hide: any(not(hasData_temperature_EAFA)), }">
                        <label class="print-label">EAF A - TEMPERATURE</label>
                        <div class="temperature_EAFA_print"></div>
                    </div>
                    <div data-bind="classes: { hide: any(not(hasData_temperature_EAFA_2)), }">
                         <label class="print-label">EAF A - OXYGEN</label>
                        <div class="temperature_EAFA_2_print"></div>
                    </div>  
            
                </div>
            
            
                 <div class="row fluid print" style="margin-bottom:50px;margin-top:50px;margin-left:-50px;">
                    <div style="float:left;" data-bind="classes: { hide: any(not(hasData_residuals_EAFA)), }">
                        <label class="print-label">EAF A - RESIDUAL GRAPH 1</label>
                        <div class="residuals_EAFA_print"></div>
                    </div>  
                    <div  data-bind="classes: { hide: any(not(hasData_residuals_EAFA_2)), }">
                        <label class="print-label">EAF A - RESIDUAL GRAPH 2</label>
                        <div class="residuals_EAFA_2_print"></div>
                    </div>  
                </div>
            
            </div>

         
            <!---EAF B GRAPH--->

            <div class="row fluid print" style="margin-left:-50px;">
                <div style="float:left;" data-bind="classes: { hide: any(not(hasData_bucket_fluxes_EAFB)), }">
                    <label class="print-label">EAF B - BUCKET FLUXES</label>
                    <div class="bucket_fluxes_EAFB_print"></div>
                </div>
                <div data-bind="classes: { hide: any(not(hasData_injection_fluxes_EAFB)), }">
                    <label class="print-label">EAF B - KWH/Ton</label>
                    <div class="injection_fluxes_EAFB_print"></div>
                </div>
            </div>

            
            <div class="row fluid print" style="margin-bottom:50px;margin-top:50px;margin-left:-50px;">
                    <div style="float:left;"  data-bind="classes: { hide: any(not(hasData_temperature_EAFB)), }">
                    <label class="print-label">EAF B - TEMPERATURE</label>
                    <div class="temperature_EAFB_print"></div>
                </div>
                <div  data-bind="classes: { hide: any(not(hasData_temperature_EAFB_2)), }">
                    <label class="print-label">EAF B - OXYGEN</label>
                    <div class="temperature_EAFB_2_print"></div>
                </div>
            </div>

            

            <div class="row fluid print" style="margin-bottom:50px;margin-top:50px;margin-left:-50px;">            
                <div style="float:left;" data-bind="classes: { hide: any(not(hasData_residuals_EAFB)), }">
                    <label class="print-label">EAF B - RESIDUAL GRAPH 1</label>
                    <div class="residuals_EAFB_print"></div>
                </div>
                <div  data-bind="classes: { hide: any(not(hasData_residuals_EAFB_2)), }">
                    <label class="print-label">EAF B - RESIDUAL GRAPH 2</label>
                    <div class="residuals_EAFB_2_print"></div>
                </div>
            </div>

            
            <div class="pagebreak"> </div>

            <div class="row fluid print" style="margin-bottom:50px;margin-top:50px;margin-left:-50px;">   
                <div  data-bind="classes: { hide: any(not(hasData_baghouse)), }">
                    <label class="print-label">Baghouse</label>
                    <div class="baghouse_print"></div>
                </div>
            </div>



            
            <!---SLAG CHEMISTRY TABLE-->
            <div style="margin-bottom:50px;margin-top:50px;" class="row-fluid screen-content" data-bind="classes: { hide: any(not(hasData_Slag), isLoading_Slag), }">
                <span class="not-print-label" style="margin-left: 0%;">
                        <asp:localize runat="server" meta:resourcekey="chemistry_slag_label"  />
                </span>
               <table style="width:70%">
                  
                  <tr>
                    <td class="not-border" style="width:30%"></td>
                    <td class="not-border">
                        <label>
                            <strong>
                                <asp:localize runat="server" meta:resourcekey="structural_aims" />
                            </strong>
                        </label>
                    </td>
                    <td class="not-border">
                        <label>
                            <strong>
                                B3ratio:
                            </strong>
                            <span data-bind="text: Structural_B3"></span>
                        </label>
                    </td>
                    <td class="not-border">
                        <label>
                            <strong>
                                MgO:
                            </strong>
                            <span data-bind="text: Structural_MgO"></span>
                        </label>

                    </td>
                    <td class="not-border">
                        <label>
                            <strong>
                                FeO:
                            </strong>
                            <span data-bind="text: Structural_FeO"></span>
                        </label>
                    </td>
                  </tr>
                  <tr>
                    <td class="not-border" style="width:30%"></td>
                    <td class="not-border">
                        <label>
                            <strong>
                                <asp:localize runat="server" meta:resourcekey="rail_aims" />
                            </strong>
                        </label>
                    </td>
                    <td class="not-border">
                        <label>
                            <strong>
                                B3ratio:
                            </strong>
                            <span data-bind="text: Rail_B3"></span>
                        </label>
                    </td>
                    <td class="not-border">
                        <label>
                            <strong>
                                MgO:
                            </strong>
                            <span data-bind="text: Rail_MgO"></span>
                        </label>

                    </td>
                    <td class="not-border">
                        <label>
                            <strong>
                                FeO:
                            </strong>
                            <span data-bind="text: Rail_FeO"></span>
                        </label>
                    </td>
                  </tr>
            </table>
            </div>
            <div class="items-grid-container-slag" style="margin-top:20px"></div>



            <div class="row fluid">
                <!---RECIPES GRID-->
                <div class="span6" data-bind="classes: { hide: any(not(hasData_Recipes), isLoading_Recipes), }">
                    <h4>RECIPES</h4>
                    <div class="items-grid-container-recipes" style="margin-left:25px; max-width:100%; font-size:13px;"></div>
                </div>
                <div class="span6">                        
                    <!---LOG BOOK GRID-->
                    <div data-bind="classes: { hide: any(not(hasData_LogBook), isLoading_LogBook), }">
                        <h4>LOG BOOK</h4>
                        <div class="items-grid-container-itemsLogBook" style="max-width:95%; font-size:13px;"></div>
                    </div>
                    <!---Pourback GRID-->
                    <div data-bind="classes: { hide: any(not(hasData_Pourback), isLoading_Pourback), }">
                        <h4>POURBACK</h4>
                        <div class="items-grid-container-itemsPourback" style="max-width:95%; font-size:13px;"></div>
                    </div>
                </div>
            </div>          

            
            <%--<div class="pagebreak"> </div>--%>



        </div>
    </div>   
   

</div>