﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
   
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
 
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/bootstrap-timepicker/css/bootstrap-timepicker.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/autocomplete/backbone.autocomplete.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />


<div class="row-fluid subnavbar fixed-subnavbar" style="min-width:1305px;"> 
    <div class="form-inline pull-left span11" style="min-width:1500px;"> 
        <label class="control-label">
            <asp:localize runat="server" meta:resourcekey="search_label" />
            <input type="text" class="input-large clear-search" id="search" style="margin-top:-4px; width:200px;" data-bind="value: trim(searchText)," placeholder="<asp:Localize runat=server meta:resourcekey=search_place_holder />" />
        </label>

        
        <label class="control-label">
            <div class="float-left"><asp:localize runat="server" meta:resourcekey="process_data_entry_label" /></div>
        </label>
        <label class="control-label">
            <div id="processes-picker-multi-select"></div>
       </label>
        
        <label class="control-label">
            <div class="float-left"><asp:localize runat="server" meta:resourcekey="grade_group_data_entry_label" /></div>
        </label>
        <label class="control-label">
            <div id="grade-groups-picker-multi-select"></div>
       </label>


        <label class="control-label">
            <div class="float-left"><asp:localize runat="server" meta:resourcekey="grade_data_entry_label" /></div>
        </label>
        <label class="control-label">
            <div id="grades-picker-multi-select"></div>
       </label>

        <label class="control-label">
            <div class="float-left"><asp:localize runat="server" meta:resourcekey="size_data_entry_label" /></div>
        </label>
        <label class="control-label">
            <div id="sizes-picker-multi-select"></div>
       </label>


        <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
            <input type="checkbox"  class="big-checkbox" id="picker-checkbox" data-bind="checked: archived," style="margin-left: 55px;margin-top:-0.5%">
            <span>
                <asp:Localize runat="server" meta:resourcekey="include_archived_label" />
            </span>
        </label>

        <button id="addItemBtn" style="width:120px !important; height:35px !important;" class="btn btn-primary pull-right" data-bind="classes: { hideAll: not(hasPermission), }">
                <asp:Localize runat="server" meta:resourcekey="add_item_btn_label" />
        </button>
   
        
    </div>
</div>
<div class="split-left left" style="margin-top:6.1%">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    <div id="grid-twi-management" class="items-grid-container backgrid-container" data-bind="classes: { hideAll: any(not(hasData), isLoading), }"></div>
</div>
       
<div class="split-right right">
    <div data-bind="classes: { hide: (showDataEntryMode), }">     
        <div class="row-fluid" style="margin-top:20%">
            <i class="fw-icon-arrow-left" style="font-size:180px;margin-left:10%;"></i>
        </div>
        <div class="row-fluid" style="text-align: center;">
            <h3 style="font-size:50px;line-height:50px;">
                <asp:localize runat="server" meta:resourcekey="no_item_selected" />
            </h3>
        </div>
    </div> 
    <div id="outer" data-bind="classes: { hideAll: not(showDataEntryMode), }" style="background-color:#e5eaf6">
        <div id="inner_fixed_top" style="margin-left:20px">
          
            <div class="row entry-row">
                <div class="span2 entry-div-label">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="author_data_entry_label" />
                    </label>
                </div>
                <div class="span3">
                    <input type="text" class="input-large clear-search" style="width:150px;" data-bind="value: itemAuthor" disabled />
            
                </div>   
                <div class="span2 entry-div-label">
                     <label class="control-label col-class entry-label" style="padding-right: 0px;">
                         <asp:Localize runat="server" meta:resourcekey="archived_label" />
                    </label>
                </div>
                <div class="span2">                    
                     <input type="checkbox"  class="big-checkbox" data-bind="checked: itemArchived," >
                </div>            
             
            </div>
            <div class="row entry-row">                 
                 <div class="span2 entry-div-label">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="name_data_entry_label" />
                    </label> 
                </div>
                 <div class="span9" >
                    <input type="text" id="input-name" class="input-large clear-search" style="margin-top:-4px; width:100%;" data-bind="value: trim(itemName)" placeholder="<asp:Localize runat=server meta:resourcekey=title_data_entry_place_holder />" />
                </div>
            </div>
            <div class="row entry-row"> 
                <div class="span2 entry-div-label">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="mo_data_entry_label" />
                    </label> 
                </div>
                 <div class="span3" >
                    <input type="text" class="input-large clear-search" id="input-meltorder" style="margin-top:-4px; width:150px;" data-bind="value: trim(itemMO)" placeholder="<asp:Localize runat=server meta:resourcekey=title_data_entry_place_holder />" />
                </div>
               <div class="span2 entry-div-label" >
                    <label class="control-label col-class entry-label" for="expirationDateEntry" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="date_expiration_tbx_label" />
                    </label>
                </div>
                <div class="span2">
                    <label class="input-prepend">
                        <span class="add-on"><i class="icon-calendar"></i></span>
                        <input type="text" id="expirationDateEntry" class="input-date" style="width:75px;z-index:1000;" data-bind="value: itemEndDate">
                    </label>   
                </div>

         
               
            </div>
            <div class="row entry-row">
                <div class="span2 entry-div-label">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="process_data_entry_label" />
                    </label>
                </div>
                <div class="span3">
                    <div id="processes-form-multi-select"></div>
                </div>     
              
                <div class="span2 entry-div-label">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="size_data_entry_label" />
                    </label>
                </div>
                <div class="span3">
                    <div id="sizes-form-multi-select"></div>
                </div>  
            </div> 
            <div class="row entry-row">
                <div class="span2 entry-div-label">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="grade_group_data_entry_label" />
                    </label>
                </div>
                <div class="span3">
                     <div id="grade-groups-form-multi-select"></div>
                </div>

                 <div class="span2 entry-div-label">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="grade_data_entry_label" />
                    </label>
                </div>
                <div class="span2">
                     <div id="grades-form-multi-select"></div>
                </div>
                
            </div>
        </div>    
        <div id="inner_remaining">
            <div class="row entry-row" style="border-bottom: 1px solid lightgray; width:95%;margin-left:2%"></div>
            
            <div class="row entry-row">                  
                    <div class="span2 entry-div-label hide">
                        <input type="file" data-bind="value: newFileName, " id="FileBtn" style="width:0px;" class="hidden"/>            
                        <label class="control-label col-class entry-label" style="padding-right: 0px;">
                            <asp:localize runat="server" meta:resourcekey="file_document_data_entry_label" />
                        </label> 
                    </div>
                    <div class="span5 hide">
                        <input type="text" id="fileName" data-bind="value: inputFileName, " style="width:350px;" class="form-field-value" placeholder="File Name" disabled />
                    </div>
                    <div class="span6"></div>
                    <div class="span4">
                        <label for="FileBtn" style="width:120px !important; height:20px !important;" class="btn btn-primary pull-right" >Select File</label>
                    </div>
            </div>

            <div class="row entry-row">
                <div class="span12">              
                     <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData_files, isLoading_files), }" style="height:300px;">
                        <div class="row-fluid" style="position:relative;top:100px;">
                            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
                        </div>
                        <div class="row-fluid" style="position:relative;top:115px;">
                            <h3 style="font-size:50px;">
                                <asp:localize runat="server" meta:resourcekey="no_data_available" />
                            </h3>
                        </div>
                    </div>
                    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading_files), }" style="height:300px;">
                        <div class="row-fluid" style="position:relative;top:100px;">
                            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                        </div>
                        <div class="row-fluid" style="position:relative;top:115px;">
                            <h3 style="font-size:50px;">
                                <asp:localize runat="server" meta:resourcekey="loading_data" />
                            </h3>
                        </div>
                    </div>
                    <div id="items-files-grid-container" class="items-files-grid-container backgrid-container" data-bind="classes: { hideAll: any(not(hasData_files), isLoading_files), }" style="max-height:350px;width:80%;margin-left:10%;background-color:white"></div>
                </div>

            </div>

        </div>
        <div id="inner_fixed_bottom">
            <div class="row entry-row" data-bind="classes: { hideAll: not(hasPermission), }" style="border-top: 1px solid lightgray; width:95%;margin-left:2%">
                <div class="span1"></div>
                <div class="span6">
                        <button id="saveItemBtn" class="btn btn-primary">
                            <asp:Localize runat="server" meta:resourcekey="save_item_btn_label" />
                        </button>
                    </div>
                    <div class ="span4">
                        <button id="deleteItemBtn" class="btn btn-danger">
                            <asp:Localize runat="server" meta:resourcekey="delete_item_btn_label" />
                        </button>
                    </div>
            </div>
        </div>
    
    </div>
</div>

<script id="actions_cell_template" type="text/x-handlebars-template">
    <div>
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DOWNLOAD" title="<asp:Localize runat=server meta:resourcekey=download_title />" class="btn btn-cell-action btn-small btn-download hide"><i class="fa fa-download" aria-hidden="true"></i></button>
        <i class="fa fa-cog fw-icon-4x fa-spin loading-row hide" style="font-size:25px;"></i>
    </div>
</script>

<script id="actions_cell_remove_template" type="text/x-handlebars-template">
    <div>
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DELETE" title="<asp:Localize runat=server meta:resourcekey=remove_batch_title />" class="btn btn-cell-action btn-small btn-remove"><i class="fa fa-trash-o"></i></button>
    </div>
</script>

<script id="equipment_declare_modal" type="text/x-handlebars-template">
    <div class="modal-header" style="min-width:700px !important;">    
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times; </button>
        <h3><asp:Localize runat=server meta:resourcekey=equipment_declare_modal_title /></h3>
    </div>
    <div style="padding-bottom:0;padding-top:0; min-width:700px;" class="modal-body">
        <div style="max-height:500px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid">
                <form class="form-horizontal" style="margin-bottom:0;">
                        <div style="height:330px;overflow:auto;" class="equipment-codes-tree cursor-pointer"></div>
                </form>
           </div>
        </div>
    </div>
    <div class="modal-footer" style="min-width:700px;">
        <button id="acceptBtn" class="btn btn-primary" > 
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        <button id="cancelBtn" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>
    </div>
</script>

    