﻿define([
  'app',
  'modules/catalog/catalog',
],
function (app, Catalog) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Models.Catalog;
        superProto = superRef.prototype;

        Main.Models.GradeSpec = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    gradeId: null,
                    gradeName: null,
                    gradeVersionId: null,
                    gradeVersionNumber: null,
                    gradeVersionTimestamp: null,
                    typeCode: null,
                }
            ),
            procedures: {
                get: app.DatabaseNames.MES + '.CAT.GetGradeSpecs',
            },

            parse: function (obj) {
                var elements = {};

                _.each(app.chemistryElements, function (el) {
                    elements[el] = obj[el];
                });

                return _.extend(
                    superProto.parse.apply(this, arguments),
                    {
                        gradeId: obj.GradeId,
                        gradeName: obj.GradeName,
                        gradeVersionId: obj.GradeVersionId,
                        gradeVersionNumber: obj.GradeVersionNumber,
                        gradeVersionTimestamp: obj.GradeVersionTimestampString,
                        typeCode: obj.SpecTypeCode,
                    },
                    elements
                );
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Collections.Catalogs;
        superProto = superRef.prototype;

        Main.Collections.GradeSpecs = classRef = superRef.extend({
            model: Main.Models.GradeSpec,
        });
        _.extend(classRef, {
            fetch: function (options) {
                var opt = _.extend(
                        { error: function () { }, success: function () { }, },
                        options
                    );

                classRef.prototype.getData.apply(classRef.prototype, [_.extend(
                    {},
                    opt,
                    {
                        success: function (resp) {
                            if (resp.Table) {
                                opt.success(_.map(resp.Table, classRef.prototype.model.prototype.parse));
                            }
                            else {
                                var msg = (resp.Message) ? resp.Message : 'Can not fetch grade specs.';

                                console.error(new Error(msg).stack);
                                opt.error(msg);
                            }
                        },
                    }
                )]);
            },
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});