﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
protected override void InitializeCulture()
{

    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<div class="ihdatasources-dropdown">
    <div data-bind="toggle: hasDataSources" style="display:inline-block;margin-top:7px;">
        <label><asp:Localize runat="server" meta:resourcekey="ihdatasource_combo_label" /></label>
        <select data-bind="value: integer(id), options: ihDataSourcesNoLocal, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=local_ihid_label />', value: localId, }" id="selectbasic" name="selectbasic" class="input-medium">
        </select>
    </div>
</div>


            

