﻿define([
    'modules/modal',
],
function (Modal) {

    Modal.Views.SimpleModal = Backbone.Epoxy.View.extend({
        attributes: {
            tabindex: '-1', //Leave this to close modal with escape key.
        },
        className: 'modal hide fade',
        events: function () {
            return {
                'click #acceptBtn': this.acceptBtn_click,
                'shown.bs.modal': this.modal_shown,
                'hidden.bs.modal': this.modal_hidden,
            };
        },

        notFinishing: false,
        finished: false,
        container: null,
        isRendered: false,
        parent: null,
        template: null,

        bindEvents: function () {
            //this function should be in every view that uses listenTo anywhere
            //all the model bindings or view-model binding should be here, to manage
            //the show/hide view easily
            this.listenToOnce(this, 'render', this.view_render);
        },
        finish: function (result) {
            this.finished = true;

            this.trigger('finish', this, result);
        },
        hide: function (remove) {
            //To prevent remove and unbind on hidden handler.
            //Used when the modal is hided to show another modal but then will be displayed again.
            if (remove === false)
                this.notFinishing = true; 

            this.$el.modal('hide');
        },
        render: function (container) {
            if (container)
                this.container = container;

            if (this.template) {
                var attrs = (this.model) ? this.model.toJSON() : {};

                this.$el.html(this.template(attrs));
                this.applyBindings();

                this.isRendered = true;

                this.trigger('render');
            }
            else {
                throw new Error('Modal template is null.');
            }
        },
        show: function () {
            if (!this.isRendered) {
                this.render();
            }
            else {
                this.$el.modal({
                    keyboard: true,
                    backdrop: 'both',
                });
            }

            return this;
        },

        acceptBtn_click: function (e) {
            console.error('Accept button handler not implemented.');
        },
        modal_hidden: function (e) {
            try {
                if (this.notFinishing == false) {
                    if (this.finished == false)
                        this.finish('CANCEL');

                    //Trigger event to implement common interface of other modals in the system.
                    this.trigger('hidden', this, e);

                    this.remove();
                    this.unbind();
                }
                else {
                    this.notFinishing = false;
                }
            }
            catch (Error) { console.error(Error.stack); }
        },
        modal_shown: function (e) {
            try {
                //Trigger event to implement common interface of other modals in the system.
                this.trigger('shown', this, e);

                //Focus automatically an object with the class autofocus.
                this.$el.find('.autofocus').focus();
            }
            catch (Error) { console.error(Error.stack); }
        },
        view_render: function () {
            try {
                this.show();
            }
            catch (Error) { console.error(Error.stack); }
        },
    });

    // Required, return the module for AMD compliance.
    return Modal;

});