﻿define([
  'app',
  'modules/base/base',
],
function (app, Base) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Models.Base;
        superProto = superRef.prototype;

        Main.Models.ProcessAddition = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    id: null,

                    processId: null,

                    materialId: null,
                    materialName: null,
                    weight: null,
                    timestamp: null,
                }
            ),

            parse: function (obj) {
                return {
                    id: obj.Id,

                    processId: obj.ProcessId,

                    materialId: obj.MaterialId,
                    materialName: obj.MaterialName,
                    weight: obj.Weight,
                    timestamp: obj.TimestampString,
                };
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Collections.Base;
        superProto = superRef.prototype;

        Main.Collections.ProcessAdditions = classRef = superRef.extend({
            model: Main.Models.ProcessAddition,
            comparator: 'timestamp',
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});