﻿define([
  'app',
  'modules/base/base',
],
function (app, Base) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Models.Base;
        superProto = superRef.prototype;

        Main.Models.ProcessTemperature = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    id: null,

                    processId: null,

                    oxygen: null,
                    carbon: null,
                    temperature: null,
                    timestamp: null,
                }
            ),

            parse: function (obj) {
                return {
                    id: obj.Id,

                    processId: obj.ProcessId,

                    oxygen: obj.Oxygen,
                    carbon: obj.Carbon,
                    temperature: obj.Temperature,
                    timestamp: obj.TimestampString,
                };
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Collections.Base;
        superProto = superRef.prototype;

        Main.Collections.ProcessTemperatures = classRef = superRef.extend({
            model: Main.Models.ProcessTemperature,
            comparator: 'timestamp',
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});