-------------
-- ROLES
-------------
	USE [IHBoxSystem]
	GO
	CREATE ROLE cr_read AUTHORIZATION dbo 
	GO  

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'cr_read', 'admin'
	GO

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'cr_read', 'SDI/australtek'
	GO

	USE [IHBoxSystem]
	GO
	CREATE ROLE cr_write AUTHORIZATION dbo 
	GO  
		USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'cr_write', 'admin'
	GO

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'cr_write', 'SDI/australtek'
	GO



-------------------
-- Menu and Route
-------------------
	declare @parent int, @result_routeId INT
	select @parent=id from [FrontEnd].[Menu] where [Name] = 'Caster' and Parent is null

	INSERT INTO [FrontEnd].[Routes]
			   ([Route]
			   ,[ModuleName]
			   ,[ModulePath]
			   ,[RequiredRole]
		   )
		 VALUES 
			   (
			   '!/covers-report(/:start)(/:end)(/)'
			   , 'covers-report'
			   , 'pages/caster/covers-report/'
			   , 'cr_read'           
			   )
			   SET @result_routeId = @@IDENTITY
	INSERT INTO [FrontEnd].[Menu]
			   ([Parent]
			   ,[Name]
			   ,[RouteID]
			   ,[SortOrder]
			   ,[Enabled]
			   ,[Visible]
			   ,[RequiredRole]
			   ,[Group]
			  )
		 VALUES
			   (
			   @parent
			   ,'Covers Report'
			   ,@result_routeId 
			   ,1
			   ,1
			   ,1
			   ,'cr_read'
			   ,NULL
			 )
	GO


-------------------
-- SP Permissions
-------------------
EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [cr_read] -- The role
,@name = N'securedsp-CAS.GetCoversReport' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [cr_write] -- The role
,@name = N'securedsp-CAS.UpdateCoverHeat' -- the procedure
,@value = N'SendCurrentUser=TRUE' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [cr_read] -- The role
,@name = N'securedsp-CAS.GetAvailableCovers' -- the procedure
,@value = N'' 
GO

-------------------
--	Profiles
-------------------
	USE [IHBoxSystem]
	GO

	DECLARE @ModuleId INT

	INSERT INTO [SECURITY].[Modules]([Code],[Name])
	VALUES('cr_read','Covers Report')

	SET @ModuleId = @@IDENTITY


	INSERT INTO [SECURITY].ModuleActions(ModuleId,Code,[Name],[Role])
	VALUES (@ModuleId,'covers-report-read','Read','cr_read')

		USE [IHBoxSystem]
	GO

	DECLARE @ModuleId INT

	INSERT INTO [SECURITY].[Modules]([Code],[Name])
	VALUES('cr_write','Covers Report')

	SET @ModuleId = @@IDENTITY


	INSERT INTO [SECURITY].ModuleActions(ModuleId,Code,[Name],[Role])
	VALUES (@ModuleId,'covers-report-write','Write','cr_write')




-- ---- Change route:
-- update top(1) FrontEnd.Routes
-- 	set ModulePath = 'pages/caster/covers-report/'
-- 	where ModulePath = 'custom-screens/covers-report/'
