<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>
  <%@ Import Namespace="System.IO" %>
    <%@ Import Namespace="System.Threading" %>
      <%@ Import Namespace="System.Globalization" %>

        <script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    // Override InitializeCulture to read a "siteLanguage" cookie (fallback = "en")
    protected override void InitializeCulture()
          {
        HttpCookie lang = Request.Cookies["siteLanguage"];
        String selectedLanguage = (lang != null) ? lang.Value : "en";
            UICulture = selectedLanguage;
            Culture = selectedLanguage;
            Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
            Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
            base.InitializeCulture();
          }
        </script>

        <% // Prevent browser caching of templates (especially on IE)
          Response.Cache.SetCacheability(HttpCacheability.NoCache);
          Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

          <!-- Tailwind CSS and other style imports -->
          <link href="<%= ResolveUrl("~/assets/tailwind/tailwind.min.css") %>" rel="stylesheet" />
          <link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
          <link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
          <link href="<%= ResolveUrl("~/assets/libs/js/autocomplete/backbone.autocomplete.css") %>" rel="stylesheet" />
          <link href="<%= ResolveUrl("~/app/pages/eaf/ladle-wall-overview/ladle-wall-overview.css") %>" rel="stylesheet" />
          <link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />
          <link href="<%= ResolveUrl("~/assets/libs/js/select2/select2.min.css") %>" rel="stylesheet" />

        <div class="min-h-screen flex mt-4">
  <div class="w-full mx-auto px-6">

    <!-- MAIN CONTENT -->
    <main class="space-y-8">

      <%
        const int LADLES = 15;
        string[] rows = new string[] {
            "Heat Number",
            "Tap Time",
            "Campaign",
            "Plate Assembly",
            "Upper Nozzle",
            "Working Lining",
            "Porous Plug North",
            "Porous Plug South"
        };
      %>

      <!-- Title + actions -->
      <div class="flex items-center justify-between">
        <h1 class="text-2xl font-semibold text-gray-800 tracking-tight">Ladle Wall Overview</h1>
        <div class="flex gap-3">
          <button id="refreshBtn" class="px-4 h-10 rounded-lg bg-blue-600 text-white font-medium hover:bg-blue-700 shadow-sm">
            Refresh
          </button>
        </div>
      </div>

      <!-- Card -->
      <section class="bg-white border border-gray-200 rounded-xl shadow-sm">
        <div class="overflow-x-auto rounded-xl">
          <table id="ladleWallGrid" class="w-full table-fixed border-separate border-spacing-0 text-center text-base">
            <thead class="bg-blue-600 text-white">
              <tr>
                <!-- centered, tall header cell -->
                <th class="sticky-left w-56 h-16 md:h-20 lg:h-20 px-4 text-center align-middle font-semibold border-r border-blue-700">
                  Last
                </th>
                <% for (int i = 1; i <= LADLES; i++) { %>
                  <th class="h-20 px-4 align-middle font-semibold border-b border-blue-700">
                    Ladle <%= i %>
                  </th>
                <% } %>
              </tr>
            </thead>

            <tbody id="gridSkeleton">
  <% foreach (var label in rows) { %>
  <tr class="odd:bg-white even:bg-gray-50">
    <!-- First column skeleton -->
    <td class="sticky-left h-16 md:h-20 lg:h-20 px-4 text-center align-middle font-semibold text-gray-800 border-r border-b border-gray-200 bg-gray-100">
      <span class="skeleton-block skeleton-label"></span>
    </td>
    <!-- 15 ladle skeleton cells -->
    <% for (int i = 1; i <= LADLES; i++) { %>
      <td class="h-16 md:h-20 lg:h-20 px-3 align-middle border-b border-r border-gray-200">
        <span class="skeleton-block"></span>
      </td>
    <% } %>
  </tr>
  <% } %>
</tbody>

<tbody id="gridBody" class="hidden">
  <% foreach (var label in rows) { %>
  <tr class="odd:bg-white even:bg-gray-50 hover:bg-blue-50/60 transition-colors">
    <td class="sticky-left h-16 md:h-20 lg:h-20 px-4 text-center align-middle font-semibold text-gray-800 border-r border-b border-gray-200 bg-gray-100">
      <%= label %>
    </td>
    <% for (int i = 1; i <= LADLES; i++) { %>
      <td class="h-16 md:h-20 lg:h-20 px-3 align-middle border-b border-r border-gray-200"
          data-row="<%= label %>"
          data-col="Ladle-<%= i %>">
      </td>
    <% } %>
  </tr>
  <% } %>
</tbody>

          </table>
        </div>
      </section>

    </main>
  </div>
</div>
