USE [IHBoxSystem]
GO
CREATE ROLE lwo_r AUTHORIZATION dbo 
GO  

USE [IHBoxSystem]
GO
CREATE ROLE lwo_w AUTHORIZATION dbo 
GO  

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'lwo_r', 'admin'
GO

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'lwo_w', 'admin'
GO





EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [lwo_r] -- The role
,@name = N'securedsp-LAD.GetLadleWallOverview' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [lwo_r] -- The role
,@name = N'securedsp-LAD.GetLadleInfo' -- the procedure
,@value = N'' 
GO


declare @parent int, @result_routeId INT
SELECT TOP 1 @parent=Id FROM FrontEnd.Menu WHERE [Name] = 'Ladles'

INSERT INTO [FrontEnd].[Routes]
		   ([Route]
		   ,[ModuleName]
		   ,[ModulePath]
		   ,[RequiredRole]
	   )
	 VALUES
		   (
		   '!/ladle-wall-overview(/)'
		   , 'ladle-wall-overview'
		   , 'pages/eaf/ladle-wall-overview/'
		   , 'lwo_r'           
		   )
		   SET @result_routeId = @@IDENTITY
INSERT INTO [FrontEnd].[Menu]
		   ([Parent]
		   ,[Name]
		   ,[RouteID]
		   ,[SortOrder]
		   ,[Enabled]
		   ,[Visible]
		   ,[RequiredRole]
		   ,[Group]
		  )
	 VALUES
		   (
		   @parent
		   ,'Ladle Wall Overview'
		   ,@result_routeId 
		   ,1
		   ,1
		   ,1
		   ,'lwo_r'
		   ,NULL
		 )
GO


INSERT INTO [SECURITY].[Modules]([Code],[Name])
VALUES('ladle_wall_overview','Ladle Wall Overview')

SET @ModuleId = @@IDENTITY

INSERT INTO [SECURITY].[ModuleActions]([ModuleId],[Code],[Name],[Role])
VALUES(@ModuleId,'readWrite','Read/Write','lwo_w')


INSERT INTO [SECURITY].ModuleActions(ModuleId,Code,[Name],[Role])
VALUES (@ModuleId,'read','Read','lwo_r')



