﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<div class="container">
    <div class="hero-unit text-center">
        <h1><asp:Localize runat="server" meta:resourcekey="itworks" /></h1>
        <p class="lead"><asp:Localize runat="server" meta:resourcekey="itworks_sub" /></p>
        <a id="getstarted_btn" class="btn btn-large btn-success" href="#"><asp:Localize runat="server" meta:resourcekey="getstarted_btn" /></a>
    </div>
</div>

<script id="getstarted_modal_template" type="text/x-handlebars-template">
    <h4>Quick start:</h4>
    <div>
        <span>
            All you need to know to start creating new screens and components can be found commented inline with code.
            The two main boilerplates that you need to read and comprehend are the ones located at:
            <code>
                /app/modules/view-boilerplate.js
            </code>
            and
            <code>
                /app/screens/screen-boilerplate/
            </code>.
        </span>
    </div>
    <h4>Technologies used in this boilerplate:</h4>
    <div>
        <span>
            This boilerplate is using several new and constantly updating technologies that are quite new in the web-development world.
            All of them real-life tested in production enviroments.
            Libraries and frameworks in list-form:
        </span>
        <br />
        <br />
        <span><strong>front-end frameworks and libs</strong></span>
        <ul>
            <li>backbone.js</li>
            <li>underscore.js</li>
            <li>require.js</li>
            <li>jQuery 1.9.1</li>
            <li>template-loader.js</li>
            <li>handlebars.js</li>
            <li>Industrial Dashboard</li>
            <li>jed.js</li>
            <li>Bootstrap from Twitter</li>
        </ul>
        <br />
        <span><strong>deployment tools and maintainance</strong></span>
        <ul>
            <li>jam.js</li>
            <li>r.js (require js node version, formerly Require Optimizer)</li>
        </ul>
        <br />
    </div>
</script>