﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"];
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />


<script id="modal_change_melt_order" type="text/x-handlebars-template">            
    <link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />
    
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <span style="font-weight:bold;font-size: 22px;" data-bind="text: ModalTitle"> </span> 
    </div>
    <div style="height:500px;padding-bottom:0;padding-top:0;max-height: 800px !important" class="modal-body">
        <div style="min-height:450px;padding-bottom:0;max-height: 800px !important" class="modal-body">      
                      
            <div class="change-to-mo" style="text-align:center">
                <div class="row-fluid">
                    <div class="span3"></div>
                    <div class="span6" style="font-weight:bold;margin-top:10px;font-size:18px;">
                        <asp:Localize runat=server meta:resourcekey=change_to />
                    </div>
                </div>
                <%--<div class="row-fluid">
                    <div class="span1"></div>
                    <div class="span2" style="font-weight:bold;margin-top:10px">
                        <asp:Localize runat=server meta:resourcekey=melt_order_label />
                    </div>
                    <div class="span6">                    
                        <div id="meltOrders" style="margin-left:13px"></div>
                    </div>
                </div>  --%>
                   <div class="row-fluid">
                    <div class="span1"></div>
                    <div class="span2" style="font-weight:bold;margin-top:10px">
                        <asp:Localize runat=server meta:resourcekey=melt_order_label />
                    </div>
                    <div class="span6">   
                        <div id="melt-order-picker-multi-select" style="margin-left:13px"></div>                    
                    </div>
                </div>  
                <div class="row-fluid" style="margin-top:5px;"> 
                    <div class="span1"></div>
                    <div class="span2" style="font-weight:bold">
                         <asp:Localize runat=server meta:resourcekey=grade_label />
                    </div>
                    <div class="span6">  
                        <input type="text" id="gradeName" style="width:230px; text-align:left;margin-left:12px" data-bind="value: GradeName,"  disabled/>                      
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span1"></div>
                    <div class="span2" style="font-weight:bold">
                         <asp:Localize runat=server meta:resourcekey=size_label />
                    </div>
                    <div class="span6">  
                        <input type="text" id="size" style="width:230px; text-align:left;margin-left:12px" data-bind="value: Size,"  disabled/>                     
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span1"></div>
                    <div class="span2" style="font-weight:bold">
                        <asp:Localize runat=server meta:resourcekey=comments_label />
                    </div>
                    <div class="span6">  
                        <textarea id="change-melt-order-comments" data-bind="value: Comments," style="resize: none;width: 234px;height: 100px;margin-left: 10px;"></textarea>
                                          
                    </div>       
                </div>

            </div>

          
            <hr />

            <div class="change-to-mo" style="text-align:center">
                <div class="row-fluid">
                    <div class="span3"></div>
                    <div class="span6" style="font-weight:bold;margin-top:10px;font-size:18px;">
                        <asp:Localize runat=server meta:resourcekey=from_mo />
                    </div>
                </div>

                  <div class="row-fluid" style="margin-top:5px;"> 
                    <div class="span1"></div>
                    <div class="span2" style="font-weight:bold">
                         <asp:Localize runat=server meta:resourcekey=melt_order_label />
                    </div>
                    <div class="span6">  
                        <input type="text" style="width:230px; text-align:left;margin-left:12px" data-bind="value: FromMeltOrder,"  disabled/>                      
                    </div>
                </div>
                 <div class="row-fluid" style="margin-top:5px;"> 
                    <div class="span1"></div>
                    <div class="span2" style="font-weight:bold">
                         <asp:Localize runat=server meta:resourcekey=grade_label />
                    </div>
                    <div class="span6">  
                        <input type="text" style="width:230px; text-align:left;margin-left:12px" data-bind="value: FromGradeName,"  disabled/>                      
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span1"></div>
                    <div class="span2" style="font-weight:bold">
                         <asp:Localize runat=server meta:resourcekey=size_label />
                    </div>
                    <div class="span6">  
                        <input type="text"  style="width:230px; text-align:left;margin-left:12px" data-bind="value: FromMaterialSize,"  disabled/>                     
                    </div>
                </div>

            </div>


        </div>
   
    </div>
    <div class="modal-footer">
        <button id="acceptBtn" class="btn btn-primary pull-left" style="width:200px;height:50px;">
            <asp:Localize runat='server' meta:resourcekey='save_btn_label' />
        </button>
        <button id="cancelBtn" class="btn btn-secondary" data-dismiss="modal" style="height:50px">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>
    </div>
</script>
