﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx).
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here--%>
<div class="row-fluid">
    <div class="row-fluid">
        <div class="row-fluid">
            <div class="span12 text-center">
                <img src="<%= ResolveUrl("~/assets/img/error-frown.png") %>" />
            </div>
        </div>
        <div class="row-fluid">
            <div class="span12 text-center">
                <h1><asp:Localize runat="server" meta:resourcekey="notFound_mainTitle" /></h1>
            </div>
        </div>
    </div>
    <div class="row-fluid text-center muted">
        <h4><asp:Localize runat="server" meta:resourcekey="notFound_subtitleLeft" /><a href="!/trending"><asp:Localize runat="server" meta:resourcekey="notFound_backHome" /></a></h4>
    </div>
</div>