﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<style type="text/css">

    .nb-container {
        width:100%;
        border-radius:3px; 
        background-color: rgba(0,0,0,.05);
        background-clip: padding-box;
        border: solid transparent;
        border-width: 1px 1px 1px 6px;
        height:auto; 
        padding: 1px 1px 1px 1px;
        box-shadow: inset 1px 1px 1px rgba(0,0,0,.1),inset 0 -1px 0 rgba(0,0,0,.07); 
    }

        .nb-container .nb-select-multiple {
            width:100%;            
            max-height:42px;
            border:0; 
            margin-bottom:0; 
        }

            .nb-container .nb-select-multiple .nb-select-option {
                
            }

                .nb-container .nb-select-multiple .nb-select-option.red {
                    color:red; 
                }

                .nb-container .nb-select-multiple .nb-select-option.blue {
                    color:blue; 
                }
                
                .nb-container .nb-select-multiple .nb-select-option.purple {
                    color:purple; 
                }

                .nb-container .nb-select-multiple .nb-select-option.brown {
                    color:brown; 
                }

</style>

<div id="notification_bar_container" class="nb-container">
    <select class="nb-select-multiple" size="2" multiple>
        <option class="nb-select-option red">Notification 1</option>
        <option class="nb-select-option blue">Notification 2</option>
        <option class="nb-select-option purple">Notification 3</optio>
        <option class="nb-select-option brown">Notification 4</option>
    </select>
</div>