﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class landing_signup_api_recover : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string action = (string.IsNullOrEmpty(Request.Form["action"])) ? String.Empty : Request.Form["action"];
        action = action.ToUpper();

        switch (action)
        {
            case "RECOVERCODE":
                ProcessRecoverCode(); 
                break;
        }
    }

    private void ProcessRecoverCode()
    {
        bool failed = false; string json = "";

        try
        {
            String code = (string.IsNullOrEmpty(Request.Form["code"])) ? String.Empty : Request.Form["code"];
            if (!string.IsNullOrEmpty(code))
            {
                string path = ConfigurationManager.AppSettings.Get("licenseFolder");
                if (path != null)
                {
                    Guid g = Guid.NewGuid();
                    string filename = Path.Combine(path, g.ToString() + ".recover_temp");
                    StreamWriter sw = File.CreateText(filename);
                    sw.Write(code);

                    sw.Close();
                    sw.Dispose();

                    FileInfo finfo = new FileInfo(filename);
                    finfo.MoveTo(Path.ChangeExtension(filename, ".recover"));

                    json = "{\"status\":\"OK\", \"fileGUID\":\"" + g.ToString() + "\"}";
                    Response.Clear();
                    Response.ContentType = "application/json; charset=utf-8";
                    Response.Write(json);
                    Response.End();
                }
                else
                {
                    failed = true;
                }
            }
            else
            {
                failed = true;
            }
        }
        catch (Exception ex)
        {
            failed = true;
        }

        if (failed)
        {
            json = "{\"status\":\"FAILED\"}";
            Response.Clear();
            Response.ContentType = "application/json; charset=utf-8";
            Response.Write(json);
            Response.End();
        }
    }
}