﻿<%@ Page Language="C#" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
    string siteLang = "EN";
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        siteLang = (lang != null) ? lang.Value : siteLang;
        UICulture = siteLang;
        Culture = siteLang;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(siteLang);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(siteLang);
        base.InitializeCulture();
    }
</script>

<!DOCTYPE html>

<script runat="server">
    protected void Page_Load(object sender, EventArgs e)
    {
        Session.Clear(); 
    }
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Login</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <meta charset="utf-8" />
    <meta name="description" content="" />
    
        <link rel="shortcut icon" href="<% 
        if (!Server.MachineName.Contains("L2S-MLT-MES"))
        {
            Response.Write(ResolveUrl("~/favicondev.ico"));
        }
        else
        {
            Response.Write(ResolveUrl("~/favicon.ico"));
        }
         %>" />    

    <% bool debug = true; %>

    <!-- industrial dashboard css & js -->
    <script src="<%
        
        if (debug == true)
        {
            Response.Write(ResolveUrl("../../../IndustrialDashboard/Scripts/IndustrialDashboard-debug.js"));
        }
        else
        {
            Response.Write(ResolveUrl("../../../IndustrialDashboard/Scripts/IndustrialDashboard.js"));
        }
        
        %>" type="text/javascript"></script>
    <%--<link type="text/css" href="<%= ResolveUrl("../../../IndustrialDashboard/Styles/IndustrialDashboard.css") %>" rel="stylesheet" />--%>

    <%--jquery--%>
    <script src="<%= ResolveUrl("~/assets/libs/jam/jquery/dist/jquery.js") %>"></script>

    <script src="<%= ResolveUrl("~/assets/libs/js/require.js") %>"></script>

    <script>
        var configPath = "<%= ResolveUrl("~/app/")%>";
        //settings the baseURL for the requirejs
        require.config({
            baseUrl: configPath,
            paths: {
                "moment": "../assets/libs/js/moment/moment", //add .min at the end to get minified version
            },
            packages: [
                {
                    "name": "handlebars",
                    "location": "../assets/libs/jam/handlebars",
                    "main": "handlebars.js"
                },
                {
                    "name": "jed",
                    "location": "../assets/libs/jam/jed",
                    "main": "./jed"
                },
                {
                    "name": "underscore",
                    "location": "../assets/libs/jam/underscore",
                    "main": "underscore.js"
                },
            ],
            shim: {
                "handlebars": {
                    "exports": "Handlebars"
                }
            }
        });
    </script>

    <script>
        var param_username = "<% = !string.IsNullOrEmpty(Request.Form["username"]) ? Request.Form["username"] : "" %>"; 
        var param_password = "<% = !string.IsNullOrEmpty(Request.Form["password"]) ? Request.Form["password"] : "" %>"; 
        var param_callback_url = "<% = !string.IsNullOrEmpty(Request.Form["callback_url"]) ? Request.Form["callback_url"] : "" %>"; 
        var url_referrer = "<% = (Request.UrlReferrer != null) ? Request.UrlReferrer.ToString() : "" %>"; 

        var callback_url = (param_callback_url.length > 0) ? param_callback_url : url_referrer;
        var params_login = true; 
    </script>

    <script src="<%= ResolveUrl("login.js?v=1.0.0.1") %>"></script>

    <script type="text/javascript">
        var _Includer = new window.Includer({
            Widgets: [
                'SecurityLogin'
            ]
            , ExternalWidgets: [
            ]
            , XML: { Available: false }
        });
    </script>

</head>
<body>
    <span style="font-size:15px;font-family:Arial;margin-left:3px;">Logging in ...</span>
</body>
</html>
