﻿var window_height = null; 
Core.DOM.Ready(function () {
    Core.Include({
        Widgets: []
        , Events: {
            onLoad: function () {
                initialize();

                window_height = $(window).height(); 
                $(window).on("resize", _.debounce(windowResized, 800)); 
            }
        }
        , ExternalWidgets: [
        ]
        , Theme: "DZSupervision"
    });
});

function initialize() {
    try {

        $("#trending_widget_container").empty(); 

        var tsv = [{ text: '1 minute', value: 1 }
                        , { text: '3 minutes', value: 3 }
                        , { text: '6 minutes', value: 6 }
                        , { text: '1/4 hour', value: 1 * 15 }
                        , { text: '1/2 hour', value: 1 * 30 }
                        , { text: '1 hour', value: 1 * 60 }
                        , { text: '6 hours', value: 1 * 60 * 6 }
                        , { text: '8 hours', value: 1 * 60 * 8 }
                        , { text: '12 hours', value: 1 * 60 * 12 }
                        , { text: '1 day', value: 1 * 60 * 24 }
                        , { text: '2 days', value: 1 * 60 * 24 * 2 }
                        , { text: '4 days', value: 1 * 60 * 24 * 4 }
                        , { text: '1 week', value: 1 * 60 * 24 * 7 }
                        , { text: '10 days', value: 1 * 60 * 24 * 10 }
                        , { text: '2 weeks', value: 1 * 60 * 24 * 7 * 2 }
                        , { text: '1 month', value: 1 * 60 * 24 * 7 * 4 }
        ];

        var timezone = 'ART'; //getParameterByName('timezone');
        var QP = new Core.Database.QueryParameter('@TimeZone', 'CHAR', (timezone != "") ? timezone : null);

        var defaultViews = [];

        var view = getParameterByName('view');

        var viewparam = false;
        if (view != undefined && view != null && view != "") {
            viewparam = true;
            defaultViews.push(view);
        }

        defaultViews.push("Demo");

        var connectionString = "TRENDING_MOBILE"; //getParameterByName('connstring');
        var catalog = "IH_100516"; //getParameterByName('catalog');

        var options = {
            DatabaseParameters: {
                ConnectionStringName: connectionString, Catalog: catalog
                , Fixed: [QP]
            }
            //, Export: { OutputFileName: "Trending", Source: "SERVERCURRENTVIEW" }
            , View: {
                Title: " "
                , ViewNames: defaultViews
                , ForceView: viewparam
                , Mode: 'Range'
            }
            , Configuration: {
                TimeSpanValues: tsv, SelectedIndex: 10, AutoRefresh: true
                , Value: 5, MinValue: 1, Unit: "s"
                , Views: {
                    GlobalViews: true
                    , GlobalViewsByDefault: false
                }
                , PersistStateCookies: true

                , ShowSaveView: false
                , ShowResetView: false
                , ShowViewConfiguration: false

                , ShowDisplayValues: false
                , ShowCloudModes: false
                , ShowDisplayScales: true
                , ShowUndo: false
                , ShowRedo: false

                , AllowAddView: false
                , ShowZoomPanControls: true
            }
            , Debug: { Available: false, LogItems: { Times: true } }
            , Events: {
                onViewChanged: function () { }
            }
        };

        window.icc = new IndustrialChartConfiguration(
            document.getElementById("trending_widget_container")
            , options
        );

    } catch (Error) { }
}

function windowResized() {
    if ($(window).height() != window_height) {
        initialize();
        window_height = $(window).height();
    }
}

function getParameterByName(name) {
    name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
    var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
        results = regex.exec(location.search);
    return results == null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
}