﻿using System.Collections.Generic;

namespace DotPrograms
{
    public class FunctionResult : IStackValue
    {
        #region Properties

        public object LocalValue { get; set; }
        public Operation Operation { get; protected set; }
        public bool ResolvedLocally { get; set; }
        public byte StackPosition { get; set; }


        #endregion

        #region Constructors

        public FunctionResult()
        {
            this.ResolvedLocally = true;
        }
        public FunctionResult(Operation operation)
            : this()
        {
            this.Operation = operation;
        }

        #endregion
    }
}
