﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>
<link href="<%= ResolveUrl("~/app/custom-screens/IHConfiguration/audit/audit.css") %>" rel="stylesheet" />

<div style="margin-left:25%;min-width:800px;" class="row-fluid subnavbar span9 offset3 fixed-subnavbar">
    <div style="line-height:59px;">
        <div class="form-inline pull-left">
            <label class="control-label" for="dateStartTbx">
                <asp:localize runat="server" meta:resourcekey="date_start_tbx_label" />
            </label>
            <label class="input-prepend">
                <span class="add-on"><i class="icon-calendar"></i></span>
                <input type="text" id="dateStartTbx" style="width:75px;z-index:1000;" class="input-date" data-bind="value: start">
            </label>
            <label class="control-label" for="dateEndTbx">
                <asp:localize runat="server" meta:resourcekey="date_end_tbx_label" />
            </label>
            <label class="input-prepend">
                <span class="add-on"><i class="icon-calendar"></i></span>
                <input type="text" id="dateEndTbx" style="width:75px;z-index:1000;" class="input-date" data-bind="value: end">
            </label>
            <label class="control-label">
                <asp:localize runat=server meta:resourcekey="search_label" />
                <input type="text" id="searchTbx" class="input-medium clear-search" data-bind="value: search,events:['keyup']" placeholder="<asp:Localize runat=server meta:resourcekey=search_place_holder />" />
            </label>
            <button id="refreshBtn" class="btn btn-primary" style="margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                <i class="fa fa-refresh"></i>
            </button>
        </div>
        <div class="form-inline pull-right">
            <button class="btn add-item" style="margin-right:10px;"><asp:Localize runat="server" meta:resourcekey="add_item_btn_label" /></button>
            <button id="excelBtn" class="btn btn-excel" title="<asp:localize runat=server meta:resourcekey=excel_btn_title />">
                <i class="fa fa-file-excel-o"></i>
            </button>
        </div>
    </div>
</div>

<div class="row-fluid screen-content">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    <div class="row-fluid" data-bind="classes: { hide: not(all(hasData, not(isLoading))), }">
        <div class="items-grid-container span12 infinite-container"></div>
    </div>
</div>    

<script id="add_new_modal_template" type="text/x-handlebars-template">

    <%--<div class="modal hide fade add-new-modal"> Classes to be added on the className prop of the view definition.--%>
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat=server meta:resourcekey=add_new_modal_title /></h3>
    </div>
    <div style="max-height:500px;" class="modal-body">
        <div class="row-fluid">
            <div class="control-group">
                <label class="control-label">
                    <asp:localize runat="server" meta:resourcekey="add_new_modal_message" />
                    <div class="controls">
                        <textarea style="width:400px;height:70px;" data-bind="value: message, events: ['change', 'keyup'], enabled: not(processing),"></textarea>
                    </div>
                </label>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <div class="modal-status-msg-container pull-left">
            <%--<div class="modal-status-msg text-3dots hide" data-bind="toggle: notEquals(errorMsg, ''),">
                <span data-bind="text: errorMsg, attr: { title: errorMsg, }," style="color:#ff0000;font-size:16px;"></span>
            </div>--%>
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='add_new_modal_processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>
        <button id="acceptBtn" data-bind="enabled: all(message, notEquals(processing, true))," class="btn btn-primary">
            <asp:Localize runat='server' meta:resourcekey='add_new_modal_accept_btn_label' />
        </button>
        <button data-bind="enabled: notEquals(processing, true)" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='add_new_modal_cancel_btn_label' />
        </button>
    </div>
</script>


