﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<% 
    if (Session["SecurityData"] == null)
    {
        Session["SecurityData"] = WebApp.GetSecurityData();
    }
    
    WebApp.SecurityData securityData = (WebApp.SecurityData) Session["SecurityData"]; 
%>

<%--view template starts here (will be appended inside a row-fluid)--%>

<% Boolean isLocalDebugging = false; %>
<script id="main_template" type="text/x-handlebars-template">

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/backgrid-select-all.css") %>" rel="stylesheet" />

<style type="text/css">
    .modal-wider {
        width:780px;
        margin-left:-390px;
        margin-top:-30px;
    }

    .backgrid th{
        font-size:12px !important;
    }

    .error-status > td{
        background-color:#d34b4b; 
    }

    .table tbody tr.disabled-ds-status>td{background-color:#cbcbcb;color:#808080;}
    .table-hover tbody tr.disabled-ds-status:hover>td{background-color:#cbcbcb;color:#808080;}

    .table tbody tr.unregistered-ds-status>td{background-color:#fff;color:#808080;}
    .table-hover tbody tr.unregistered-ds-status:hover>td{background-color:#fff;color:#808080;}

    .table tbody tr.disconnected-dash-ds-status>td{background-color:#fff;color:#808080;}
    .table-hover tbody tr.disconnected-dash-ds-status:hover>td{background-color:#fff;color:#808080;}

    .table tbody tr.missing-dash-ds-status>td{background-color:#fff;color:#bababa;}
    .table-hover tbody tr.missing-dash-ds-status:hover>td{background-color:#fff;color:#bababa;}

    .backgrid tr{
        font-size:12px !important;
    }

        .backgrid tr td{
            overflow:visible !important; 
        }

        .backgrid tr td button{
            font-size:12px !important;
        }

    /*.backgrid .friendlyName{
        min-width:100px !important; 
    }

    .backgrid .server {
        min-width:50px !important; 
    }

    .backgrid .lastContactTime{
        min-width:130px !important;
    }

    .backgrid .hostName{
        min-width:100px !important;
    }*/

    .table tbody tr.locked-row>td{background-color:#cbcbcb;color:#808080;}
    .table-hover tbody tr.locked-row:hover>td{background-color:#cbcbcb;color:#808080;}
    .clickeable-row {
        cursor:pointer; 
    }
    .locked-row{
        cursor:default; 
    }

    a.disabled-link,
    a.disabled-link:visited ,
    a.disabled-link:active,
    a.disabled-link:hover {
        background-color:#d9d9d9 !important;
        color:#aaa !important;
    }

    .datasources-subnavbar-button{
        margin-left:5px;
        margin-right:5px;
    }

    .configuretd{
        max-width:350px !important;
        width:270px;
        text-align:center;
    }

</style>

<div>
    <!--add source section-->
    <div class="row-fluid">
        <div class="data-sources-container span12">

        </div>
    </div>
    <!--/add source section-->
</div>

<script id="configure_cell_template" type="text/x-handlebars-template">
    <div style="width:300px;" class="row-fluid">
        <div class="span4">
            {{HBExp '#ifEqualsAny type "OPC" "PLC" "DASH"'}}
                <div class="btn-group 
                    {{HBExp '#ifEquals registered false'}} hide {{HBExp '/ifEquals'}}
                    {{HBExp '#ifEqualsM type "DASH" typeClass "GPRS"'}} hide {{HBExp '/ifEqualsM'}}
                    ">
                    <button {{HBExp '#ifEquals enabled false'}} disabled="disabled" {{HBExp '/ifEquals'}} class="configure-source-btn btn dropdown-toggle" data-toggle="dropdown" data-open="false">
                        <asp:Localize runat="server" meta:resourcekey="configure_button_label" /> <span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu" style="font-size: 12px;">
                        {{HBExp '#ifEquals type "OPC"'}}
                            {{HBExp '#ifEquals typeExtended "DMT"'}}
                            {{HBExp 'else'}}
                            <li style="cursor: pointer;"><a class="btn-dropdown-config-option opc-option-connection" data-option="opc-connection"><asp:Localize runat="server" meta:resourcekey="connection_button_label" /></a></li>
                            {{HBExp '/ifEquals'}}
                        {{HBExp '/ifEquals'}}
                        {{HBExp '#ifEquals type "PLC"'}}
                        <li style="cursor: pointer;"><a class="btn-dropdown-config-option plc-option-connection" data-option="plc-connection"><asp:Localize runat="server" meta:resourcekey="connection_button_label" /></a></li>
                        <li style="cursor: pointer;"><a class="btn-dropdown-config-option plc-option-select-dbs" data-option="plc-select-dbs"><asp:Localize runat="server" meta:resourcekey="select_dbs_label" /></a></li>
                        <li class="li-plc-option-mnemonic-import" style="cursor: pointer;"><a title="" class="btn-dropdown-config-option plc-option-mnemonic-import disabled-link" data-original-title="" data-option="plc-mnemonic-import"><asp:Localize runat="server" meta:resourcekey="mnemonics_import_button_label" /></a></li>
                        {{HBExp '/ifEquals'}}
                        {{HBExp '#ifEqualsM type "DASH" typeClass "WIFI"'}}
                        <li style="cursor: pointer;">
                            <a class="btn-dropdown-config-option dash-wifi-option-wifi-network {{HBExp '#ifEquals connected false'}}disabled-link{{HBExp '/ifEquals'}}" data-option="dash-wifi-network"><asp:Localize runat="server" meta:resourcekey="wifi_network_button_label" /></a>
                        </li>
                        {{HBExp '/ifEqualsM'}}
                        {{HBExp '#ifEquals typeExtended "DMT"'}}
                        <li style="cursor: pointer;">
                            <a class="btn-dropdown-config-option dmt-configure-edit-option" data-option="dmt-edit" href="!/ih/configuration/scriptsstatus/{{HBExp 'id'}}"><asp:Localize runat="server" meta:resourcekey="edit_button_label" /></a>
                        </li>
                        {{HBExp '/ifEquals'}}
                    </ul>
                </div>
            {{HBExp '/ifEqualsAny'}}
        </div>
        <div class="span4">
            {{HBExp '#ifEquals locked false'}}
            <div class="btn-group">
                <button class="action-source-btn btn dropdown-toggle" data-toggle="dropdown" data-open="false">
                    <i style="font-size:16px;position:relative;top:3px;" class="fa fa-ellipsis-h"></i> <%--<span class="caret"></span>--%>
                </button>
                <ul class="dropdown-menu action-source-dropdown" style="font-size: 12px;">
                    {{HBExp '#ifEqualsM registered true enabled true'}}
                        {{HBExp '#ifEqualsAny type "CUSTOM" "OPC" "PLC"'}}
                            {{HBExp '#ifEquals typeExtended "DMT"'}}
                            <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-disable disabled-link" data-option=""><asp:Localize runat="server" meta:resourcekey="disable_button_label" /></a></li>
                            {{HBExp 'else'}}
                            <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-disable" data-option="ds-disable"><asp:Localize runat="server" meta:resourcekey="disable_button_label" /></a></li>
                            {{HBExp '/ifEquals'}}
                        {{HBExp '/ifEqualsAny'}}
                    {{HBExp '/ifEqualsM'}}
                    {{HBExp '#ifEqualsM registered true enabled false'}}
                        {{HBExp '#ifEqualsAny type "CUSTOM" "OPC" "PLC"'}}
                            {{HBExp '#ifEquals typeExtended "DMT"'}}
                            <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-enable disabled-link" data-option=""><asp:Localize runat="server" meta:resourcekey="enable_button_label" /></a></li>
                            {{HBExp 'else'}}
                            <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-enable" data-option="ds-enable"><asp:Localize runat="server" meta:resourcekey="enable_button_label" /></a></li>
                            {{HBExp '/ifEquals'}}
                        {{HBExp '/ifEqualsAny'}}
                    {{HBExp '/ifEqualsM'}}
                    
                    {{HBExp '#ifEqualsAny type "CUSTOM" "OPC" "PLC"'}}
                    <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-clear-data" data-option="ds-clear-data"><asp:Localize runat="server" meta:resourcekey="clear_data_button_label" /></a></li>
                    {{HBExp '/ifEqualsAny'}}

                    {{HBExp '#ifEqualsM type "DASH" hasDOTS true'}}
                        {{HBExp '#ifEquals status "NOT" "UNREGISTERED"'}}
                            {{HBExp '#ifEquals status "NOT" "PENDINGREGISTRATION"'}}
                                <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-clear-data" data-option="ds-clear-data"><asp:Localize runat="server" meta:resourcekey="clear_dots_data_button_label" /></a></li>
                            {{HBExp '/ifEquals'}}
                        {{HBExp '/ifEquals'}}
                    {{HBExp '/ifEqualsM'}}

                    {{HBExp '#ifEquals local false'}}
                        {{HBExp '#ifEqualsAny type "CUSTOM" "OPC" "PLC"'}}
                            {{HBExp '#ifEquals typeExtended "DMT"'}}
                                {{HBExp '#ifEquals registered true'}}
                                    <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-migrate disabled-link" data-option=""><asp:Localize runat="server" meta:resourcekey="migrate_button_label" /></a></li>
                                {{HBExp 'else'}}
                                    <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-migrate disabled-link" data-option=""><asp:Localize runat="server" meta:resourcekey="download_agent_button_label" /></a></li>
                                {{HBExp '/ifEquals'}}
                            {{HBExp 'else'}}
                                {{HBExp '#ifEquals registered true'}}
                                    <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-migrate" data-option="ds-migrate"><asp:Localize runat="server" meta:resourcekey="migrate_button_label" /></a></li>
                                {{HBExp 'else'}}
                                    <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-migrate" data-option="ds-migrate"><asp:Localize runat="server" meta:resourcekey="download_agent_button_label" /></a></li>
                                {{HBExp '/ifEquals'}}
                            {{HBExp '/ifEquals'}}
                            
                            
                            
                        {{HBExp '/ifEqualsAny'}}
                    {{HBExp '/ifEquals'}}

                    {{HBExp '#ifEqualsAny type "CUSTOM" "OPC" "PLC"'}}
                        {{HBExp '#ifEquals typeExtended "DMT"'}}
                        <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-remove disabled-link" data-option=""><asp:Localize runat="server" meta:resourcekey="remove_button_label" /></a></li>
                        {{HBExp 'else'}}
                        <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-remove" data-option="ds-remove"><asp:Localize runat="server" meta:resourcekey="remove_button_label" /></a></li>
                        {{HBExp '/ifEquals'}}
                    {{HBExp '/ifEqualsAny'}}

                    {{HBExp '#ifEquals type "DASH"'}}
                        {{HBExp '#ifEquals hasDOTS false'}}                            
                            <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-remove" data-option="ds-remove"><asp:Localize runat="server" meta:resourcekey="unregister_button_label" /></a></li>
                        {{HBExp 'else'}}
                            {{HBExp '#ifEquals connected false'}}
                                {{HBExp '#ifEquals status "NOT" "PENDINGREGISTRATION"'}}
                                    <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-remove" data-option="ds-remove"><asp:Localize runat="server" meta:resourcekey="remove_button_label" /></a></li>
                                {{HBExp '/ifEquals'}}
                            {{HBExp '/ifEquals'}}
                        {{HBExp '/ifEquals'}}
                    {{HBExp '/ifEquals'}}

                    {{HBExp '#ifEquals type "DOT"'}}
                        <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-clear-data" data-option="ds-clear-data"><asp:Localize runat="server" meta:resourcekey="clear_dot_data_button_label" /></a></li>
                        <%--<li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-clear-data" data-option="ds-migrate"><asp:Localize runat="server" meta:resourcekey="migrate_button_label" /></a></li>--%>
                        {{HBExp '#ifEquals connected false'}}
                        <li style="cursor:pointer;"><a class="btn-dropdown-action-option ds-option-remove" data-option="ds-remove"><asp:Localize runat="server" meta:resourcekey="remove_button_label" /></a></li>
                        {{HBExp '/ifEquals'}}
                    {{HBExp '/ifEquals'}}
                </ul>
            </div>
            {{HBExp 'else'}}
                {{HBExp '#ifEquals connected true'}}
                <div>
                    <div style="height:33px;cursor:default;float:left;margin-left:5px;"><img style="width:32px;height:32px;" src="<%= ResolveUrl("~/assets/img/spinner32.gif") %>" /></div>
                </div>
                {{HBExp 'else'}}
                <div>
                    <div><i data-toggle="popover" data-trigger="hover" data-placement="top" data-content="<asp:Localize runat="server" meta:resourcekey="last_action_will_be_completed_label" />" style="margin-top:5px;margin-left:8px;color: #000000;font-size:22px; cursor:default;" class="fa fa-circle-thin"></i></div>
                </div>
                {{HBExp '/ifEquals'}}
            {{HBExp '/ifEquals'}}
        </div>
    </div>
</script>

<script id="migrate_datasource_modal" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="migrate_datasource_modal_title" /></h3>
    </div>
    <div class="modal-body">
        <div data-step="0" class="section-step hide">
            <div class="hero-unit">
                <h2>Welcome to the Migration Wizard <i class="fa fa-2x fa-magic"></i></h2>
                <p>
                    This will guide you through the steps to migrate an existing data source
                    agent from its current computer to a new one.
                </p>
            </div>
        </div>
        <div data-step="1" class="section-step hide">
            <div class="hero-unit" style="padding:30px;">
                <p class="text-center">
                    <i class="fa fa-trash" style="font-size:6em;"></i><br />
                </p>
                <p>
                    To continue with the migration you need to uninstall the agent from the host machine [hostname]. <br />
                    The data sent by this agent will NOT be deleted from the system. <br />
                    After uninstalling the agent, come back to this wizard (or keep this window open) and you'll be able to download a new custom agent
                    to finish the migration.
                </p>    
            </div>
            <span>If you don't have access to the computer where the agent is installed <a class="a-remote-deactivation" style="cursor:pointer;">click here to deactivate the agent remotely.</a></span>
        </div>
        <div data-step="1-alt" class="section-step hide">
            <div class="hero-unit" style="padding:30px;">
                <p class="text-center">
                    <i class="fa fa-exclamation" style="font-size:6em;"></i>
                    <i class="fa fa-laptop" style="font-size:6em;"></i><br />
                </p>
                <p>
                    The agent will be remotely deactivated to be sure that no more data is sent to the system. <br />
                    Installed files on the host machine will not be deleted, to delete the remaining files you need to 
                    uninstall the agent from the host machine.
                </p>
            </div>
        </div>
        <div data-step="2" class="section-step hide">
            <div class="hero-unit" style="padding:30px;">
                <p class="text-center">
                    <span style="font-size:6em;">
                        <i class="fa fa-laptop"></i>
                        <i class="fa fa-arrows-h"></i>
                        <i class="fa fa-laptop"></i><br />
                    </span>
                </p>
                <p>
                    The migration wizard will move the current data from the agent to a new agent, after the migration is completed
                    a new custom installer will be generated. <br />
                    Use the new installer to install the agent on a new machine.
                </p>
            </div>
        </div>
        <div data-step="3" class="section-step hide">
            <div class="hero-unit" style="padding:30px;">
                <p class="text-center">
                    <i style="font-size:6em;" class="fa fa-laptop"></i>
                    <i style="top: -12px; font-size: 4em; margin-right: 10px; margin-left: 10px; position: relative;" class="fa fa-refresh fa-spin"></i>
                    <i style="font-size:6em;" class="fa fa-laptop"></i><br />
                </p>
                <p>
                    <div class="row-fluid">
                        <div class="progress progress-info progress-striped active offset3 span6">
                            <div class="bar" style="width: 100%;"></div>
                        </div>
                    </div>
                </p>
            </div>
        </div>
        <div data-step="4" class="section-step hide">
            <div class="hero-unit">
                <p class="text-center">
                    <i class="fa fa-download-big-icon fa-download" style="font-size:6em;"></i><br />
                </p>
                <p>                    
                    Install the agent on the new computer, in order to do this we'll generate a custom download prepared to migrate
                    your existing agent.
                </p>
            </div>
            <div class="download-custom-agent-section">
                <div class="row-fluid download-custom-agent-button-section">
                    <div class="span6 offset3">
                        <button class="btn btn-large btn-block btn-primary btn-generate-download">Download Agent for Migration</button>
                    </div>
                </div>
                <div class="row-fluid download-custom-agent-progress-section hide">
                    <div class="progress progress-info progress-striped active offset3 span6">
                        <div class="bar generate-download-progress-bar" style="width: 100%"></div>
                    </div>
                </div>
                <div style="font-size:18px;" class="starting-download row-fluid text-center hide">
                    <span class="text-success"><asp:Localize runat="server" meta:resourcekey="install_agent_modal_starting_download" /></span>
                    <a href="#" data-bypass="true" class="download-direct-link"><span><asp:Localize runat="server" meta:resourcekey="install_agent_modal_if_download_doesnt_start" /></span></a>
                </div>
                <div style="font-size:18px;" class="download-failed text-center hide">
                    <span class="text-error"><asp:Localize runat="server" meta:resourcekey="install_agent_modal_download_error" /></span>
                    <button class="btn btn-try-again"><asp:Localize runat="server" meta:resourcekey="install_agent_modal_download_try_again_btn" /></button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button class="btn btn-primary btn-next">Next</button>
        <button class="btn btn-cancel">Cancel</button>
        <button class="btn btn-close hide">Close</button>
    </div>
    <form class="form-generate-download" method="post" action="<%= ResolveUrl("~/app/custom-screens/IHConfiguration/install-agent/generate-download/generate-download.aspx") %>">
    </form>
</script>

<script id="remove_datasource_modal" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="remove_datasource_modal_title" /></h3>
    </div>
    <div class="modal-body">
        <div data-screen="prompt_uninstall" class="section-screen hide">
            <div class="hero-unit" style="padding:30px;">
                <p class="text-center">
                    <i class="fa fa-trash" style="font-size:6em;"></i><br />
                </p>
                <p>
                    To remove the data source from the system, uninstall the agent from the host machine [hostname].
                    After uninstalling the data source, you can choose whether you want to keep the data sent by this data source
                    to the system or remove all the existing data.
                </p>
            </div>
            <span>If you don't have access to the computer where the agent is installed <a class="a-remote-deactivation" style="cursor:pointer;">click here to deactivate the agent remotely.</a></span>
        </div>
        <div data-screen="remote_deactivation_explanation" class="section-screen hide">
            <div class="hero-unit" style="padding:30px;margin-bottom:10px;">
                <p class="text-center">
                    <i class="fa fa-exclamation" style="font-size:6em;"></i>
                    <i class="fa fa-laptop" style="font-size:6em;"></i><br />
                </p>
                <p>
                    The agent will be remotely deactivated to be sure that no more data is sent to the system. <br />
                    Installed files on the host machine will not be deleted, to delete the remaining files you need to 
                    uninstall the agent from the host machine.
                </p>
            </div>
            <div class="alert alert-error">
                All the data sent to the system by this agent will be permanently removed. If you wish to move
                this data source to another host instead of removing it, then use the "Migrate" option.
            </div>
        </div>
        <div data-screen="keep_delete_data" class="section-screen hide">
            <div class="hero-unit" style="padding:30px;margin-bottom:10px;">
                <p class="text-center">
                    <i class="fa fa-database" style="font-size:4em;"></i><br />
                    <span style="top:4px;position:relative;">The data source is already unregistered</span>
                </p>
                <p>
                    The data sent by this source to the system (if any) has not been deleted, do you want to delete
                    the remaining data for this data source?
                </p>
            </div>
            <div class="alert alert-error">
                When all the data from the data source is removed, the data source will also be removed from the list. If you are
                planning on keeping the data or migrating this data source to a new host then use the "Migrate" option.
            </div>
        </div>
    </div>
    <div class="modal-footer footer-1 hide">
        <button class="btn btn-close">Close</button>
    </div>
    <div class="modal-footer footer-2 hide">
        <button class="btn btn-danger btn-deactivate-and-remove">Deactivate and Remove</button>
        <button class="btn btn-close">Cancel</button>
    </div>
    <div class="modal-footer footer-3 hide">
        <button class="btn btn-danger btn-remove-all-data">Remove All Data</button>
        <button class="btn btn-close">Cancel</button>
    </div>
</script>

<script id="remove_clear_dash_modal" type="text/x-handlebars-template">
    <div class="modal-header header-1 hide">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="remove_dash_modal_title" /></h3>
    </div>
    <div class="modal-header header-2 hide">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="clear_dash_modal_title" /></h3>
    </div>
    <div class="modal-body">
        <div data-screen="clear_dash_data" class="section-screen hide">
            <div class="hero-unit" style="padding:30px;">
                <p class="text-center">
                    <i class="fa fa-trash" style="font-size:6em;"></i><br />
                </p>
                <p class="text-center">
                    Do you want to clear all the data sent by the DOTs connected to this DASH?
                </p>
            </div>
            <div class="dots-list">
                <h4>Associated DOTs</h4>
                <div class="dots-list-container"></div>
            </div>
        </div>
        <div data-screen="remove_dash" class="section-screen hide">
            <div class="hero-unit" style="padding:30px;margin-bottom:10px;">
                <p class="text-center">
                    <i class="fa fa-trash" style="font-size:6em;"></i><br />
                </p>
                <p class="text-center">
                    Do you want to remove the DASH and its associated DOTs from the system?
                </p>
            </div>
            <div class="alert alert-error">
                All the data sent to this DASH by the DOTs and all the tags associated to the DOTs will be deleted.
            </div>
            <div class="dots-list">
                <h4>Associated DOTs</h4>
                <div class="dots-list-container"></div>
            </div>
        </div>
    </div>
    <div class="modal-footer footer-1 hide">
        <button class="btn btn-danger btn-clear-dash-data">Clear DOTs Data</button>
        <button class="btn btn-close">Cancel</button>
    </div>
    <div class="modal-footer footer-2 hide">
        <button class="btn btn-danger btn-remove-dash">Remove DASH and associated DOTs</button>
        <button class="btn btn-close">Cancel</button>
    </div>
</script>

<script id="opc_configuration_modal" type="text/x-handlebars-template">

    <style type="text/css">
        .table-hover tbody tr:hover>td,.table-hover tbody tr:hover>th{
            background-color:rgb(237, 237, 237); 
        }
    </style>

    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="select_opc_server_modal_title" /></h3>
    </div>
    <div class="modal-body">
        <table class="table table-hover select-opc-server-table">
            <thead>
                <tr>
                    <th><asp:Localize runat="server" meta:resourcekey="opc_configuration_modal_description_column_title" /></th>
                    <th><asp:Localize runat="server" meta:resourcekey="opc_configuration_modal_classID_column_title" /></th>
                    <th><asp:Localize runat="server" meta:resourcekey="opc_configuration_modal_progID_column_title" /></th>
                </tr>
            </thead>
            <tbody>
                {{#if rows}}
                {{#each rows}}
                <tr class="clickeable-row" data-opcagentid="{{OPCServerDetectedID}}">
                    <td class="span5">{{Description}}</td>
                    <td class="span10">{{ClassID}}</td>
                    <td class="span3">{{ProgID}}</td>
                </tr>
                {{/each}}
                {{/if}}
            </tbody>
        </table>
    </div>
    <div class="modal-footer">
        <span class="applying-config-msg pull-left hide"><asp:Localize runat='server' meta:resourcekey='opc_configuration_applying_changes_msg' /></span>
        <span class="agent-disconnected-msg pull-left hide"><asp:Localize runat='server' meta:resourcekey='opc_configuration_agent_disconnected_msg' /></span>
        <span class="locked-agent-msg pull-left hide"><asp:Localize runat='server' meta:resourcekey='opc_configuration_locked_agent_msg' /></span>
    </div>
</script>

<script id="subnavbar_controls" type="text/x-handlebars-template">
    <div class="datasources-subnavbar-toolbar">
        <%--<span style="position:relative;top:4px;font-size:16px;font-weight:200;">Add sources: </span>--%>
        <%--<span style="position:relative;top:4px;">Add sources: </span>--%>
        <%--<div style="display:inline-block;" class="datasources-subnavbar-button">
            <% if (securityData.GetModuleActionValue("ihconfiguration_data_sources", "write"))
               { %>
                <button class="btn add-source-pre-btn"><asp:Localize runat="server" meta:resourcekey="add_dash_btn_label" /></button>
            <% } %>
        </div>--%>
        <div style="display:inline-block;" class="datasources-subnavbar-button">
            <% if (securityData.GetModuleActionValue("ihconfiguration_data_sources", "write"))
               { %>
                <button class="btn add-local-plc-pre-btn"><asp:Localize runat="server" meta:resourcekey="add_local_plc_pre_btn_label" /></button>
            <% } %>
        </div>
        <% if (!Request.IsLocal || isLocalDebugging){ %>
            <% if (securityData.GetModuleActionValue("ihconfiguration_data_sources", "write"))
                   { %>
                <div style="display:inline-block;" class="datasources-subnavbar-button">
                    <button class="btn install-agent-btn"><asp:Localize runat="server" meta:resourcekey="install_agent_btn_label" /></button>
                </div>
            <% } %>
        <% } %>
    </div>
    <form id="addLocalPLC_form" style="top:10px;position:relative;" class="form-inline hide">
        <div id="cg_addLocalPLC" class="control-group">
            <label class="control-label" for="sourceNumber_input">
                <asp:Localize runat="server" meta:resourcekey="add_local_plc_label" />
            </label>
            <input {{#unless editable}} disabled="disabled" {{/unless}} id="addLocalPLC_input" maxlength=17 type="text" class="input-medium" placeholder="<asp:Localize runat='server' meta:resourcekey='add_local_plc_input_place_holder' />"/>
            <button {{#unless editable}} disabled="disabled" {{/unless}} id="addLocalPLC_btn" type="submit" style="margin-top:0;" class="btn btn-primary">
                <asp:Localize runat="server" meta:resourcekey="add_local_plc_btn" />
            </button>
            <button type="button" style="margin-top:0;" class="btn btn-add-local-plc-cancel"><asp:Localize runat="server" meta:resourcekey="add_local_plc_cancel_btn" /></button>
        </div>
    </form>
    <div id="addLocalPLC_loading" class="hide">
        <div style="height:31px;cursor:default;float:left;margin-left:5px;"><img style="width:30px;height:30px;" src="<%= ResolveUrl("~/assets/img/spinner22.gif") %>" /></div>
        <span style="font-weight:bold;top:5px;margin-left:10px;position:relative;"><asp:Localize runat="server" meta:resourcekey="add_local_plc_loading" /></span>
    </div>
    <form id="addSource_form" style="top:10px;position:relative;" class="form-inline hide">
        <div id="cg_addSource" class="control-group">
            <label class="control-label" for="sourceNumber_input">
                <asp:Localize runat="server" meta:resourcekey="add_new_source_label" />
            </label>
            <input {{#unless editable}} disabled="disabled" {{/unless}} id="sourceNumber_input" maxlength=17 type="text" class="input-medium" placeholder="<asp:Localize runat='server' meta:resourcekey='add_new_source_input_place_holder' />"/>
            <button {{#unless editable}} disabled="disabled" {{/unless}} id="addSource_btn" type="submit" style="margin-top:0;" class="btn btn-primary">
                <asp:Localize runat="server" meta:resourcekey="add_new_source_btn" />
            </button>
            <button type="button" style="margin-top:0;" class="btn btn-add-source-cancel"><asp:Localize runat="server" meta:resourcekey="add_new_source_cancel_btn" /></button>
        </div>
    </form>
</script>

<script id="delete_source_modal" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3>{{modal_title}}</h3>
    </div>
    <div class="modal-body">
        {{modal_body}}
    </div>
    <div class="modal-footer">
        <%--<button id="unregister_delete_data" class="btn"><asp:Localize runat="server" meta:resourcekey="delete_source_modal_btn_delete_data" /></button>--%>
        <button id="unregister_continue" class="btn btn-danger"><asp:Localize runat="server" meta:resourcekey="delete_source_modal_btn_continue_delete" /></button>
        <%--<button id="unregister_keep_data" class="btn"><asp:Localize runat="server" meta:resourcekey="delete_source_modal_btn_keep_data" /></button>--%>
        <button id="unregister_cancel" class="btn"><asp:Localize runat="server" meta:resourcekey="delete_source_modal_btn_cancel" /></button>
    </div>
</script>

<script id="install_agent_modal" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="install_agent_modal_title" /></h3>
    </div>
    <div class="modal-body">
        <div class="main-download-center">
            <div style="padding:20px;line-height:25px;margin-bottom:12px;" class="hero-unit">
                <h4>Agents<asp:Localize runat="server" meta:resourcekey="install_agent_modal_hero_title" /></h4>
                <p>
                    <asp:Localize runat="server" meta:resourcekey="install_agent_modal_hero_description" />
                </p>
            </div>
            <div style="width:100%;height:1px;background-color:#ccc;margin-top:2px;margin-bottom:2px;"></div>
            <div style="background-color:#f5f5f5; width:100%;height:auto;">
                <h4><asp:Localize runat="server" meta:resourcekey="install_agent_modal_available_downloads" /></h4>
                <h5 class="muted"><asp:Localize runat="server" meta:resourcekey="install_agent_modal_choose_download" /></h5>
                <div style="overflow:auto;">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th></th>
                                <th><asp:Localize runat="server" meta:resourcekey="install_agent_modal_th_name" /></th>
                            </tr>
                        </thead>
                        <tbody>
                            {{#each downloads}}
                            <tr data-downloadid="{{id}}">
                                <td><input class="downloads-table-radio" name="downloads_table_radio" id="r{{@index}}" type="radio" /></td>
                                <td><label for="r{{@index}}">{{name}}</label></td>
                            </tr>
                            {{/each}}
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="generate-and-download hide">
            <div class="row-fluid" style="text-align:center;">
                <i class="fa fa-download-big-icon fa-download" style="font-size:12em;"></i>
            </div>
            <div class="row-fluid generating-download-text">
                <div class="row-fluid text-center">
                    <h4><asp:Localize runat="server" meta:resourcekey="install_agent_modal_generating_download_message" /></h4>
                </div>
                <div class="row-fluid">
                    <div class="progress progress-info progress-striped active offset3 span6">
                        <div class="bar generate-download-progress-bar" style="width: 100%"></div>
                    </div>
                </div>
            </div>
            <div style="font-size:18px;" class="starting-download row-fluid text-center hide">
                <span class="text-success"><asp:Localize runat="server" meta:resourcekey="install_agent_modal_starting_download" /></span>
                <a href="#" data-bypass="true" class="download-direct-link"><span><asp:Localize runat="server" meta:resourcekey="install_agent_modal_if_download_doesnt_start" /></span></a>
            </div>
            <div style="font-size:18px;" class="download-failed text-center hide">
                <span class="text-error"><asp:Localize runat="server" meta:resourcekey="install_agent_modal_download_error" /></span>
                <button class="btn btn-try-again"><asp:Localize runat="server" meta:resourcekey="install_agent_modal_download_try_again_btn" /></button>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button disabled="disabled" class="btn btn-primary btn-download">
            <i class="fa fa-download"></i>
            <asp:Localize runat="server" meta:resourcekey="install_agent_modal_download_btn" />
        </button>
        <button class="btn btn-close"><asp:Localize runat="server" meta:resourcekey="install_agent_modal_close_btn" /></button>
    </div>
    <form id="form-generate-download" method="post" action="<%= ResolveUrl("~/app/custom-screens/IHConfiguration/install-agent/generate-download/generate-download.aspx") %>">
    </form>
</script>

<%--<script id="dash_wifi_configuration_modal" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="dash_wifi_configuration_modal_title" /></h3>
    </div>
    <div style="max-height:500px;" class="modal-body">
        <div class="row-fluid">
            <form method="post" id="dash_wifi_configuration_form">
                <fieldset>
                    <legend><asp:Localize runat="server" meta:resourcekey="network_configuration_modal_legend" /></legend>
                </fieldset>
                <div class="row-fluid">
                    <div id="cg_SSID" class="control-group">
                        <label class="control-label"><asp:Localize runat="server" meta:resourcekey="dash_wifi_configuration_wifi_label" /></label>
                        <div class="controls">
                        <input name="SSID" id="wifiSSID" type="text" placeholder="<asp:Localize runat='server' meta:resourcekey='dash_wifi_configuration_network_name_placeholder' />">        
                        </div>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="horizontal-form">
                        <div class="row-fluid">
                            <div class="control-group span6">
                                <label class="control-label" for="networkType"><asp:Localize runat='server' meta:resourcekey='dash_wifi_configuration_network_type_label' /></label>
                                <div class="controls">
                                    <select disabled="disabled" name="NetworkType" id="networkType" class="selectpicker">
                                        <option value="0">IBSS Joiner</option>
                                        <option value="1">IBSS Creator</option>
                                        <option selected="selected" value="2">Infrastructure</option>
                                    </select>
                                    <input type="hidden" name="NetworkType" value="2" />
                                </div>
                            </div>
                            <div class="control-group span6">
                                <label class="control-label" for="IPProtocol"><asp:Localize runat='server' meta:resourcekey='dash_wifi_configuration_ip_protocol_label' /></label>
                                <div class="controls">
                                    <select disabled="disabled" name="IPProtocolMode" id="IPProtocol" class="selectpicker">
                                        <option value="0">UDP</option>
                                        <option selected="selected" value="1">TCP</option>
                                    </select>
                                    <input type="hidden" name="IPProtocolMode" value="1" />
                                </div>
                            </div>
                        </div>
                        <div class="row-fluid">
                            <div class="control-group span6">
                                <label class="control-label" for="addressMode"><asp:Localize runat='server' meta:resourcekey='dash_wifi_configuration_address_mode_label' /></label>
                                <div class="controls">
                                    <select disabled="disabled" name="IPAddressMode" id="addressMode" class="selectpicker">
                                        <option selected="selected" value="0">DHCP</option>
                                        <option value="1">Static</option>
                                    </select>
                                    <input type="hidden" name="IPAddressMode" value="0" />
                                </div>
                            </div>
                            <div class="control-group span6">
                                <label class="control-label" for="TCPTimeout"><asp:Localize runat='server' meta:resourcekey='dash_wifi_configuration_tcp_timeout_label' /></label>
                                <div class="controls">
                                    <input disabled="disabled" name="TCPTimeout" id="TCPTimeout" type="text" value="170">
                                    <input type="hidden" name="TCPTimeout" value="170" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <fieldset>
                    <legend>Security Configuration</legend>
                </fieldset>
                <div class="row-fluid">
                    <div class="horizontal-form">
                        <div class="row-fluid">
                            <div class="control-group span6">
                                <label class="control-label" for="encryptionType"><asp:Localize runat='server' meta:resourcekey='dash_wifi_configuration_encryption_type_label' /></label>
                                <div class="controls">
                                    <select name="EncryptionType" id="encryptionType" class="selectpicker">
                                        <option value="0"><asp:Localize runat='server' meta:resourcekey='dash_wifi_configuration_no_security_option_label' /></option>
                                        <option value="1">WPA</option>
                                        <option value="2">WPA2</option>
                                        <option value="3">WEP</option>
                                    </select>
                                </div>
                            </div>
                            <div id="cg_SECURITYKEY" class="control-group span6">
                                <label class="control-label" for="securityKey"><asp:Localize runat='server' meta:resourcekey='dash_wifi_configuration_security_key_label' /></label>
                                <div class="controls">
                                    <div class="input-append">
                                    <input disabled="disabled" maxlength="0" type="password" name="SecurityKey" id="securityKey" type="text">
                                    <a id="securityKey_icon_popover" data-toggle="popover" data-placement="top" data-content="" class="btn add-on"><i class="fw-icon-question"></i></a>
                                    </div>
                                    <label class="checkbox">
                                        <input id="checkbox_securityKey_showChars" type="checkbox"> <asp:Localize runat='server' meta:resourcekey='dash_wifi_configuration_show_characters_label' />
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="modal-footer">        
        <button type="submit" id="dash_wifi_configuration_btn_save" class="btn btn-primary"><asp:Localize runat='server' meta:resourcekey='dash_wifi_configuration_save_btn_label' /></button>
        <button id="dash_wifi_configuration_btn_cancel" class="btn"><asp:Localize runat='server' meta:resourcekey='dash_wifi_configuration_cancel_btn_label' /></button>
    </div>
    <form method="post" action="<%= ResolveUrl("~/app/custom-screens/IHConfiguration/data-sources-configuration-v2/api/DashWifiConfiguration.aspx") %>" id="data_hidden_form">
        <input id="data_input_hidden_form" name="Data" type="hidden" value=""/>
    </form>
</script>--%>

<script id="dash_wifi_configuration_modal" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="dash_wifi_configuration_modal_title" /></h3>
    </div>
    <div style="max-height:650px;" class="modal-body">
        <div class="row-fluid">
            <iframe id="widget-frame" frameBorder="0" style="border:none;height:580px;" class="span12" src="<%= ResolveUrl("dash-wifi-configuration/form.html") %>"></iframe>
        </div>
    </div>
</script>
<script id="dash_wifi_configuration_modal_loading" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="dash_wifi_configuration_modal_title" /></h3>
    </div>
    <div style="max-height:650px;min-height:500px;" class="modal-body">
        <div class="row-fluid">
            <div style="text-align:center;margin-top:10px;">
                <i class="fa fa-5x fa-cog fa-spin"></i><br />
                <span><asp:Localize runat="server" meta:resourcekey="loading_label" /></span>
            </div>
        </div>
    </div>
</script>
<script id="dash_wifi_configuration_modal_sending_configuration" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="dash_wifi_configuration_modal_title" /></h3>
    </div>
    <div style="max-height:650px;min-height:500px;" class="modal-body">
        <div class="row-fluid">
            <div style="text-align:center;margin-top:10px;">
                <i class="fa fa-5x fa-cog fa-spin"></i><br />
                <asp:Localize runat="server" meta:resourcekey="dash_wifi_sending_configuration" />
            </div>
        </div>
    </div>
</script>
<script id="dash_wifi_configuration_modal_configuration_saved" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="dash_wifi_configuration_modal_title" /></h3>
    </div>
    <div style="max-height:650px;" class="modal-body">
        <div class="row-fluid">
            <iframe id="widget-frame" frameBorder="0" style="border:none;height:580px;" class="span12" src="<%= ResolveUrl("dash-wifi-configuration/display.html") %>"></iframe>
        </div>
    </div>
</script>

<script id="plc_configuration_modal" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="plc_configuration_modal_title" /> [{{plc_name}}]</h3>
    </div>
    <div style="max-height:500px;" class="modal-body">
        <div class="row-fluid">
            <form method="post" id="plc_configuration_form">
                <div class="row-fluid">
                    <div class="control-group form-horizontal">
                        <label style="width:auto !important;" class="control-label" for="ConnectionType"><asp:Localize runat="server" meta:resourcekey="plc_configuration_protocol_label" /></label>
                        <div style="margin-left:70px !important;" class="controls">
                            <select disabled="disabled" name="ConnectionType" class="span8 selectpicker connection-type-select">
                                <option selected="selected" value="0">Select a Connection Type</option>
                                <option value="1">MPI over Serial Adapter</option>
                                <%--<option value="2">MPI over Serial Adapter Andrews Version without STX</option>
                                <option value="3">MPI over Serial Adapter Step 7 Version</option>
                                <option value="4">MPI over Serial Adapter Andrews Version with STX</option>
                                <option value="10">PPI over Serial Adapter</option>
                                <option value="20">AS 511</option>--%>
                                <option value="50">Use Step7 DLL</option>
                                <option value="122">ISO over TCP</option>
                                <option value="123">ISO over TCP (CP243)</option>
                                <%--<option value="223">Netlink lite</option>
                                <option value="224">Netlink lite PPI</option>
                                <option value="230">Netlink pro</option>--%>
                            </select>
                        </div>
                    </div>
                </div>
                <hr />
                <div class="plc_inner_form_container"></div>
            </form>
        </div>
    </div>
    <div class="modal-footer">        
        <div class="pull-left" style="height:40px;">
            <div class="applying-config-msg hide">
                <span style="font-size:14px;font-weight:bold;margin-top:8px;" class="pull-left"><asp:Localize runat='server' meta:resourcekey='plc_configuration_applying_changes_msg' /></span>
                <div style="height:31px;cursor:default;float:left;margin-left:5px;"><img style="width:30px;height:30px;" src="<%= ResolveUrl("~/assets/img/spinner22.gif") %>" /></div>
            </div>
            <span style="font-size:14px;font-weight:bold;" class="agent-disconnected-msg pull-left hide"><asp:Localize runat='server' meta:resourcekey='plc_configuration_agent_disconnected_msg' /></span>
            <span style="font-size:14px;font-weight:bold;" class="locked-agent-msg pull-left hide"><asp:Localize runat='server' meta:resourcekey='plc_configuration_locked_agent_msg' /></span>
            <div class="agent-status-msj pull-left hide"></div>
        </div>
        <button type="submit" id="plc_configuration_btn_edit" class="btn btn-primary"><asp:Localize runat='server' meta:resourcekey='plc_configuration_edit_btn_label' /></button>
        <button type="submit" id="plc_configuration_btn_save" class="btn btn-primary hide"><asp:Localize runat='server' meta:resourcekey='plc_configuration_save_btn_label' /></button>
        <button id="plc_configuration_btn_close" class="btn"><asp:Localize runat='server' meta:resourcekey='plc_configuration_close_btn_label' /></button>
        <button id="plc_configuration_btn_cancel" class="btn hide"><asp:Localize runat='server' meta:resourcekey='plc_configuration_cancel_btn_label' /></button>
    </div>
    <form method="post" action="<%= ResolveUrl("~/app/custom-screens/IHConfiguration/data-sources-configuration-v2/api/PLCConfiguration.aspx") %>" id="plc_data_hidden_form">
        <input id="plc_data_input_hidden_form" name="Data" type="hidden" value=""/>
    </form>
    <style>
        .spinner {
          position: absolute;
          top: 50%;
          left: 50%;
          margin-left: -60px;
          margin-top: -60px;
          overflow: visible;
          opacity: 0;
        }
        .line {
          stroke: #0083FF;
          stroke-width: 10;
          stroke-dasharray: 120, 37;
          stroke-linecap: square;
          stroke-linejoin: round;
          fill: transparent;
        }
        .arrow {
          fill: #0083FF;
        }
        .tick {
          opacity: 0;
        }
    </style>
</script>

<script id="plc_inner_configuration_modal" type="text/x-handlebars-template">
    <div class="row-fluid">
        <div class="horizontal-form">
            <div class="row-fluid">
                <div class="control-group span6 form-horizontal">
                    <label style="width:100px;" class="control-label" for="EntryPoint"><asp:Localize runat='server' meta:resourcekey='plc_configuration_entry_point' /></label>
                    <div style="margin-left:110px;" class="controls">
                        <input value="{{entryPoint}}" {{#if entryPoint_disabled}} disabled="disabled" {{/if}} {{#unless editMode}} disabled="disabled" {{/unless}} name="EntryPoint" type="text" class="span8" />
                    </div>
                </div>
                <div class="control-group span6 form-horizontal">
                    <label style="width:100px;" class="control-label" for="TimeoutIPConnect"><asp:Localize runat='server' meta:resourcekey='plc_configuration_timeout_ip_connect' /></label>
                    <div style="margin-left:110px;" class="controls">
                        <input {{#if timeoutIPConnect_disabled}} disabled="disabled" {{/if}} {{#unless editMode}} disabled="disabled" {{/unless}} value="{{timeoutIPConnect}}" class="span4" name="TimeoutIPConnect" type="text" />
                    </div>
                </div>
            </div>
            <div class="row-fluid">
                <div class="control-group span6 form-horizontal">
                    <label style="width:100px;" class="control-label" for="CPURack"><asp:Localize runat='server' meta:resourcekey='plc_configuration_cpu_rack' /></label>
                    <div style="margin-left:110px;" class="controls">
                        <input {{#if cpuRack_disabled}} disabled="disabled" {{/if}} {{#unless editMode}} disabled="disabled" {{/unless}} value="{{cpuRack}}" class="span4" name="CPURack" type="text" />
                    </div>
                </div>
                <div class="control-group span6 form-horizontal">
                    <label style="width:100px;" class="control-label" for="Timeout"><asp:Localize runat='server' meta:resourcekey='plc_configuration_timeout' /></label>
                    <div style="margin-left:110px;" class="controls">
                        <input {{#if timeout_disabled}} disabled="disabled" {{/if}} {{#unless editMode}} disabled="disabled" {{/unless}} value="{{timeout}}" class="span6" name="Timeout" type="text" />
                    </div>
                </div>
            </div>
            <div class="row-fluid">
                <div class="control-group span6 form-horizontal">
                    <label style="width:100px;" class="control-label" for="CPUSlot"><asp:Localize runat='server' meta:resourcekey='plc_configuration_cpu_slot' /></label>
                    <div style="margin-left:110px;" class="controls">
                        <input {{#if cpuSlot_disabled}} disabled="disabled" {{/if}} {{#unless editMode}} disabled="disabled" {{/unless}} value="{{cpuSlot}}" class="span4" name="CPUSlot" type="text" />
                    </div>
                </div>
                <div class="control-group span6 form-horizontal">
                    <label style="width:100px;" class="control-label" for="LokalMPI"><asp:Localize runat='server' meta:resourcekey='plc_configuration_lokal_mpi' /></label>
                    <div style="margin-left:110px;" class="controls">
                        <input {{#if lokalMpi_disabled}} disabled="disabled" {{/if}} {{#unless editMode}} disabled="disabled" {{/unless}} value="{{lokalMpi}}" class="span6" name="LokalMPI" type="text" />
                    </div>
                </div>
            </div>
            <div class="row-fluid">
                <div class="control-group span6 form-horizontal">
                    <label style="width:100px;" class="control-label" for="CPU_MPI"><asp:Localize runat='server' meta:resourcekey='plc_configuration_cpu_MPI' /></label>
                    <div style="margin-left:110px;" class="controls">
                        <input {{#if cpuMpi_disabled}} disabled="disabled" {{/if}} {{#unless editMode}} disabled="disabled" {{/unless}} value="{{cpuMpi}}" class="span4" name="CPU_MPI" type="text" />
                    </div>
                </div>
                <div class="control-group span6 form-horizontal">
                    <label style="width:100px;" class="control-label" for="COMPort"><asp:Localize runat='server' meta:resourcekey='plc_configuration_COM_port' /></label>
                    <div style="margin-left:110px;" class="controls">
                        <input {{#if comPort_disabled}} disabled="disabled" {{/if}} {{#unless editMode}} disabled="disabled" {{/unless}} value="{{comPort}}" class="span4" name="COMPort" type="text" />
                    </div>
                </div>
            </div>
            <div class="row-fluid">
                <div class="control-group span6 form-horizontal">
                    <label style="width:100px;" class="control-label" for="IPAddress"><asp:Localize runat='server' meta:resourcekey='plc_configuration_ip_address' /></label>
                    <div style="margin-left:110px;" class="controls">
                        <input {{#if cpuIP_disabled}} disabled="disabled" {{/if}} {{#unless editMode}} disabled="disabled" {{/unless}} value="{{cpuIP}}" class="span6" name="IPAddress" type="text" />
                    </div>
                </div>
                <div class="control-group span6 form-horizontal">
                    <label style="width:100px;" class="control-label" for="COMPortSpeed"><asp:Localize runat='server' meta:resourcekey='plc_configuration_COM_speed' /></label>
                    <div style="margin-left:110px;" class="controls">
                        <select {{#if comPortSpeed_disabled}} disabled="disabled" {{/if}} {{#unless editMode}} disabled="disabled" {{/unless}} class="span4" name="COMPortSpeed">
                            <option {{selected comPortSpeed "75"}} value="75">75</option>
                            <option {{selected comPortSpeed "110"}} value="110">110</option>
                            <option {{selected comPortSpeed "134"}} value="134">134</option>
                            <option {{selected comPortSpeed "150"}} value="150">150</option>
                            <option {{selected comPortSpeed "300"}} value="300">300</option>
                            <option {{selected comPortSpeed "600"}} value="600">600</option>
                            <option {{selected comPortSpeed "1200"}} value="1200">1200</option>
                            <option {{selected comPortSpeed "1800"}} value="1800">1800</option>
                            <option {{selected comPortSpeed "2400"}} value="2400">2400</option>
                            <option {{selected comPortSpeed "4800"}} value="4800">4800</option>
                            <option {{selected comPortSpeed "7200"}} value="7200">7200</option>
                            <option {{selected comPortSpeed "9600"}} value="9600">9600</option>
                            <option {{selected comPortSpeed "14400"}} value="14400">14400</option>
                            <option {{selected comPortSpeed "19200"}} value="19200">19200</option>
                            <option {{selected comPortSpeed "38400"}} value="38400">38400</option>
                            <option {{selected comPortSpeed "57600"}}n value="57600">57600</option>
                            <option {{selected comPortSpeed "115200"}} value="115200">115200</option>
                            <option {{selected comPortSpeed "128000"}} value="128000">128000</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="row-fluid">
                <div class="control-group span6 form-horizontal">
                    <label style="width:100px;" class="control-label" for="Port"><asp:Localize runat='server' meta:resourcekey='plc_configuration_port' /></label>
                    <div style="margin-left:110px;" class="controls">
                        <input {{#if port_disabled}} disabled="disabled" {{/if}} {{#unless editMode}} disabled="disabled" {{/unless}} value="{{port}}" class="span5" name="Port" type="text" />
                    </div>
                </div>
                <div class="control-group span6 form-horizontal">
                    <label style="width:100px;" class="control-label" for="COMPortParity"><asp:Localize runat='server' meta:resourcekey='plc_configuration_COM_parity' /></label>
                    <div style="margin-left:110px;" class="controls">
                        <select {{#if comPortParity_disabled}} disabled="disabled" {{/if}} {{#unless editMode}} disabled="disabled" {{/unless}} class="span4" name="COMPortParity">
                            <option {{selected comPortParity "n"}} value="n">none</option>
                            <option {{selected comPortParity "e"}} value="e">even</option>
                            <option {{selected comPortParity "o"}} value="o">odd</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="row-fluid">
                <div class="control-group span6 form-horizontal">
                    <label style="width:100px;" class="control-label" for="MPI_DP_Speed"><asp:Localize runat='server' meta:resourcekey='plc_configuration_MPI_DP_speed' /></label>
                    <div style="margin-left:110px;" class="controls">
                        <select {{#if busSpeed_disabled}} disabled="disabled" {{/if}} {{#unless editMode}} disabled="disabled" {{/unless}} class="span6" name="MPI_DP_Speed" >
                            <option {{selected busSpeed "0"}} value="0">Speed 9k</option>
                            <option {{selected busSpeed "1"}} value="1">Speed 19k</option>
                            <option {{selected busSpeed "2"}} value="2">Speed 187k</option>
                            <option {{selected busSpeed "3"}} value="3">Speed 500k</option>
                            <option {{selected busSpeed "4"}} value="4">Speed 1500k</option>
                            <option {{selected busSpeed "5"}} value="5">Speed 45k</option>
                            <option {{selected busSpeed "6"}} value="6">Speed 93k</option>
                        </select>
                    </div>
                </div>
                <div class="control-group span6 form-horizontal">
                    <label style="width:100px;" class="control-label" for="NetlinkReset"><asp:Localize runat='server' meta:resourcekey='plc_configuration_reset_netlink_on_connection' /></label>
                    <div style="margin-left:110px;" class="controls">
                        <input {{#if netlinkReset_disabled}} disabled="disabled" {{/if}} {{#unless editMode}} disabled="disabled" {{/unless}} name="NetlinkReset" type="checkbox" />
                    </div>
                </div>
            </div>
        </div>
    </div>
</script>

<script id="plc_mnemonics_import_modal" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="plc_mnemonics_import_title" /></h3>
    </div>
    <div style="max-height:500px;" class="modal-body">
        <div class="row-fluid">
            <div class="row-fluid">
                <div class="span12">
                    <div style="margin-left:auto; margin-right:auto;width:395px;">
                        <div>
                            <input type="text" class="input-project-filename input-large" style="margin-bottom:0px !important;" />
                            <span style="margin-left:5px;clear:right;" class="btn btn-success fileinput-button">
                                <i class="glyphicon glyphicon-plus"></i>
                                <span><asp:Localize runat="server" meta:resourcekey="plc_mnemonics_import_browse_btn_label" /></span>
                                <input accept=".zip" id="project_fileinput" style="position:absolute;top:-100px;left:0px;" type="file" name="files[]">
                            </span>
                            <div style="margin-top:2px;"><small style="clear:both;color:#666;"><asp:Localize runat="server" meta:resourcekey="plc_mnemonics_import_zip_file_instructions" /></small></div>
                        </div>
                    </div>
                </div>
            </div>
            <div style="margin-top:10px;" class="row-fluid project-upload-progress hide">
                <div class="row-fluid">
                    <div class="span6 offset3">
                        <div class="progress progress-info progress-striped active">
                            <div class="bar project-upload-progress-bar" style="width: 0%"></div>
                        </div>
                    </div>
                </div>
                <div class="row-fluid">
                </div>
            </div>
        </div>
        <hr />
        <div class="row-fluid text-center project-folder-selector hide">
            <h5><asp:Localize runat="server" meta:resourcekey="multiproject_detected_label" /></h5>
            <div class="form-inline">
                <span><asp:Localize runat="server" meta:resourcekey="select_a_project_multiproject_label" /></span>
                <select class="selectpicker mnemonics-project-folder-select">
                </select>
                <button class="btn btn-primary btn-select-project-folder">Select</button>
            </div>
        </div>
        <div class="row-fluid text-center getting-dbs-from-project-file-loading-bar-section hide">
            <div class="span6 offset3">
                <h5><asp:Localize runat="server" meta:resourcekey="getting_dbs_from_project_file_label" /></h5>
                <div class="progress progress-info progress-striped active">
                    <div class="bar" style="width: 100%"></div>
                </div>
            </div>
        </div>
        <div class="row-fluid datablocks-section hide">
            <div class="row-fluid">
                <div style="margin-bottom:5px;" class="form-inline">
                    <span style="font-size: 18px; font-weight: bold; top: 2px; position: relative;" class="datablocks-section-project-name"></span>
                    <button style="margin-left:5px;" class="btn btn-mini btn-change-multiproject-project">Change project</button>
                </div>
            </div>
            <div class="row-fluid">
                <div class="datablocks-table span8 offset2">

                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">        
        <a download="error-report.txt" target="_blank" data-bypass="bypass" id="plc_mnemonics_import_btn_download_error_report" class="btn btn-danger pull-left hide"><asp:Localize runat='server' meta:resourcekey='plc_mnemonics_import_download_error_report_btn_label' /></a>
        <button disabled="disabled" id="plc_mnemonics_import_btn_analyze_project" class="btn btn-primary"><asp:Localize runat='server' meta:resourcekey='plc_mnemonics_import_analyze_project_btn_label' /></button>
        <button disabled="disabled" id="plc_mnemonics_import_btn_import" class="btn btn-primary"><asp:Localize runat='server' meta:resourcekey='plc_mnemonics_import_import_btn_label' /></button>
        <button id="plc_mnemonics_import_btn_cancel" class="btn"><asp:Localize runat='server' meta:resourcekey='plc_mnemonics_import_cancel_btn_label' /></button>
    </div>
    <form method="post" action="<%= ResolveUrl("~/app/custom-screens/IHConfiguration/data-sources-configuration-v2/api/import-plc-project.aspx") %>" id="plc_mnemonics_import_hidden_form">
    </form>
</script>

<script id="conflicted_datablocks_modal" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="conflicted_datablocks_title" /></h3>
    </div>
    <div style="max-height:500px;" class="modal-body">
        <div class="row-fluid datablocks-section">
            <div class="row-fluid">
                <h5></h5>
            </div>
            <div class="row-fluid">
                <div class="datablocks-table span8 offset2"></div>
            </div>
            <div class="no-data-poster row-fluid text-center hide animated fadeIn">
                <div class="row-fluid"><i class="fw-icon-circle-blank fw-icon-4x"></i></div>
                <div class="row-fluid"><h3><asp:Localize runat="server" meta:resourcekey="conflicted_datablocks_no_conflicts_legend" /></h3></div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button disabled="disabled" type="submit" id="conflicted_datablocks_btn_delete" class="btn btn-primary"><asp:Localize runat='server' meta:resourcekey='conflicted_datablocks_delete_btn_label' /></button>
        <button id="conflicted_datablocks_btn_cancel" class="btn"><asp:Localize runat='server' meta:resourcekey='conflicted_datablocks_cancel_btn_label' /></button>
    </div>
</script>

<script id="plc_select_dbs_modal" type="text/x-handlebars-template">

    <style>
        .status-icon-container{
            width:250px; 
            margin-left:auto; 
            margin-right:auto; 
        }

        .status-message-text {
            width:200px;
            float:left; 
            margin-left:18px;
            line-height:30px;
        }
    </style>

    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="plc_select_dbs_title" /></h3>
    </div>
    <div style="max-height:450px;" class="modal-body noselect">
        <div class="row-fluid datablocks-section">
            <div class="row-fluid">
                <div class="datablocks-table span8 offset2">
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer noselect">        
        <button id="plc_monitor_dbs_apply_btn" class="btn btn-primary"><asp:Localize runat='server' meta:resourcekey='monitor_dbs_btn_label' /></button>
        <button id="plc_monitor_dbs_close_btn" class="btn"><asp:Localize runat='server' meta:resourcekey='plc_monitor_dbs_close_label' /></button>
    </div>
    <form method="post" action="<%= ResolveUrl("~/app/custom-screens/IHConfiguration/data-sources-configuration-v2/api/import-plc-project.aspx") %>" id="Form1">
    </form>
</script>