﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />

<style>
    .ui-datepicker {
        z-index:1052 !important;
    }

    /*.table-layout-fixed{
        table-layout:fixed; 
    }*/

    .backgrid th{
        font-size:12px !important;
    }

    .backgrid tr{
        font-size:12px !important;
    }


    .affix-theader{
        position:fixed;
    }

    .affix-theader th{
        width:50px;
    }

    .config-form {
        margin: 0 0 10px 0 !important;
    }
    .config-group {
        float:left;
        margin-right:20px;
    }
    .config-form label.control-label {
        float:left;
        width: auto;
        margin-top: 4px;
        margin-right: 5px;
    }
    .config-form input[type='text'],
    .config-form select {
        float:left;
        /*margin-left:6px;*/
    }
    .config-form input[type='text'] {
        width:60px;
    }
    .config-form span {
        width:60px;
        float:left;
        margin:4px 7px 0 7px;
    }

    .nomargin {
        margin:0 !important;
    }

    .viewport-out {
        position: absolute;
        top: -10000px;
        left: -10000px;
        visibility: hidden;
    }

    .error {
        color: #F14848;
    }
    .ok {
        color: #0B9E0B;
    }
    .timeout {
        color: #479DC4;
    }

    .toggleExportCfgBtn {
        float: left;
        margin-top: 5px;
        width:16px;
        cursor: pointer;
    }

</style>

<div class="row-fluid">
    <div class="offset3 span9 subnavbar fixed-subnavbar" style="background-color:#fff;">
        <div id="generalExportCfgContainer" class="row-fluid"></div>
        <div class="row-fluid" style="margin-top:10px;">
            <div class="row-fluid">
                <h4 class="pull-left"><asp:Localize runat="server" meta:resourcekey="tags_config_title" /></h4>
            </div>
            <div id="subnavbarLeft" class="nomargin span6 pull-left"></div>   
            <div id="subnavbarRight" class="nomargin span6 pull-right"></div>
        </div>
    </div>
</div>

<div class="row-fluid exportCfgCollapse">
    <div style="height:152px;width:100%;"></div>
</div>
<div class="row-fluid content-under-fixed-subnavbar" style="margin-top:120px;">
    <div style="display:none;margin-top:7%;" class="row-fluid loading-poster text-center">
        <h4 style="display:none" class="loading-text" ><asp:Localize runat="server" meta:resourcekey="loading_text" /></h4>
        <h4 style="display:none" class="searching-text" ><asp:Localize runat="server" meta:resourcekey="searching_text" /></h4>
        <div style="width:40%; margin: 0 auto;" class="progress progress-striped active">
            <div class="bar" style="width: 100%;"></div>
        </div>
    </div>
    <div class="infinite-container tags-grid-container" style="margin-top:10px;"></div>
</div>

<script id="subnav_buttons_left_template" type="text/x-handlebars-template">
    <div class="row-fluid">
        <div class="span6">
            <div id="cg_search" style="margin-top:5px;" class="control-group form-inline">
                <label class="control-label" style="margin-right:2px;" for="searchTerm_input">
                    <asp:Localize runat="server" meta:resourcekey="search_input_label" />
                </label>
                <input value="{{searchTerm}}" type="text" id="searchTerm_input" class="input-medium">
            </div>
        </div>
        <div class="span6">
            <div style="position: relative; top: 10px;">
                <label class="checkbox"><input {{checked showOnlyExportingTags}} id="show_only_exporting_tags_checkbox" type="checkbox"> 
                    <asp:Localize runat="server" meta:resourcekey="show_only_exporting_tags_checkbox_label" />
                </label>
            </div>
        </div>
    </div>        
</script>

<script id="subnav_buttons_right_template" type="text/x-handlebars-template">
    <div class="row-fluid">
        <button style="margin-right:20px;" {{#unless editable}}disabled="disabled" title="<asp:Localize runat="server" meta:resourcekey="readonly_saveconfiguration_label" />"{{/unless}} data-loading-text="<asp:Localize runat='server' meta:resourcekey='saveConfiguration_btn_loading' />" id="saveConfiguration_button" class="btn btn-primary pull-right"><asp:Localize runat="server" meta:resourcekey="saveConfiguration_btn" /></button>
        <div class="span7 pull-right" style="margin-right:5px;">
            <select id="agentsSelect" class="selectpicker span12" ></select>
        </div>
    </div>
</script>

<script id="generalExportConfigTemplate" type="text/x-handlebars-template">
    <div class="row-fluid" style="border-bottom: 1px solid #ccc;">
        <h4 class="pull-left"><asp:Localize runat="server" meta:resourcekey="general_config_title" /></h4>
        <div style="margin:5px 0 0 10px;float:left;">
            <div class="toggleExportCfgBtn exportCfgCollapse" title="Colapsar">
                <i class="fa fa-chevron-down"></i>
            </div>
            <div class="toggleExportCfgBtn exportCfgExpand" title="Expandir" style="display:none;">
                <i class="fa fa-chevron-right"></i>
            </div>
            <div style="float:left;margin-left:30px;">
                <button id="editGeneralCfgBtn" class="btn btn-default" data-bind="clickSet: 'editing', clickSetValue: true, classes: { hide: editing, }">
                    <i class="fw-icon-edit fw-icon-large"></i>
                </button>
                <div class="pull-left" data-bind="classes: { hide: not(editing), }">
                    <button id="saveGeneralCfgBtn" style="margin-left:10px;" class="btn btn-success">
                        <asp:Localize runat="server" meta:resourcekey="save_general_cfg_btn_label" />
                    </button>
                    <button id="cancelGeneralCfgBtn" data-bind="clickSet: 'editing', clickSetValue: false," style="margin-left:10px;" class="btn btn-default">
                        <asp:Localize runat="server" meta:resourcekey="cancel_general_cfg_btn_label" />
                    </button>
                </div>
            </div>
        </div>
        <div style="margin:5px 0 0 10px;float:right;" data-bind="classes: { error: equals(lastExportStatus, 'ERROR'), ok: equals(lastExportStatus, 'OK'), timeout: equals(lastExportStatus, 'TIMEOUT'), },">
            <i class="fa pull-left no-text-select" data-bind="classes: { 'fa-times': equals(lastExportStatus, 'ERROR'), 'fa-check': equalsAny(lastExportStatus, 'OK', 'TIMEOUT'), }," style="margin-right:0;font-size:32px;"></i>
            <div class="pull-left text-3dots" style="margin-left:10px;height:32px;line-height:32px;">
                <span data-bind="text: format('<asp:localize runat=server meta:resourcekey=last_export_msg_label />: $1, $2', momentFormat(lastExportTimestamp, 'YYYY-MM-DD HH:mm:ss.SSS', 'YYYY-MM-DD HH:mm'), lastExportMessageText), attr: { title: lastExportMessageText, },"></span>
            </div>
        </div>
    </div>
    <div class="row-fluid exportCfgCollapse" style="margin-top:10px;">
        <div class="span12">
            <div class="form pull-left span12">
                <div class="form-inline span12 config-form">
                    <div class="config-group">
                        <label class="control-label" data-bind="classes: { hide: editing, },">
                            <i class="fa" data-bind="classes: { 'fa-check-square-o': active, 'fa-square-o': not(active), },"></i>
                            <asp:localize runat="server" meta:resourcekey="config_active_label" />
                        </label>
                        <label class="control-label" data-bind="classes: { hide: not(editing), },">
                            <input type="checkbox" data-bind="checked: active" style="margin-top:-2px;" />
                            <asp:localize runat="server" meta:resourcekey="config_active_label" />
                        </label>
                    </div>
                    <div class="config-group">
                        <label class="control-label" for="intervalTbx">
                            <asp:localize runat="server" meta:resourcekey="config_interval_label" />:
                        </label>
                        <input type="text" id="intervalTbx" data-bind="value: read(intervalFormated), classes: { hide: not(editing), }," placeholder="<asp:Localize runat='server' meta:resourcekey='config_interval_place_holder' />" title="<asp:Localize runat='server' meta:resourcekey='config_interval_title' />" />
                        <span data-bind="text: intervalFormated, classes: { hide: editing, show: not(editing), },"></span>
                    </div>
                    <div class="config-group">
                        <label class="control-label" for="timeoutTbx">
                            <asp:localize runat="server" meta:resourcekey="config_timeout_label" />:
                        </label>
                        <input type="text" id="timeoutTbx" data-bind="value: read(timeoutFormated), classes: { hide: not(editing), }," placeholder="<asp:Localize runat='server' meta:resourcekey='config_timeout_place_holder' />" title="<asp:Localize runat='server' meta:resourcekey='config_timeout_title' />" />
                        <span data-bind="text: timeoutFormated, classes: { hide: editing, show: not(editing), },"></span>
                    </div>
                    <div class="config-group">
                        <label class="control-label" for="timeoutTbx">
                            <asp:localize runat="server" meta:resourcekey="config_target_type_label" />:
                        </label>
                        <select data-bind="classes: { hide: not(editing), },">
                            <option><asp:localize runat="server" meta:resourcekey="config_type_opt_oracle_label" /></option>
                        </select>
                        <span data-bind="classes: { hide: editing, show: not(editing), }," style="width:220px;">
                            <asp:localize runat="server" meta:resourcekey="config_type_opt_oracle_label" />
                        </span>
                    </div>
                    <div class="config-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="config_volume_label" />:
                        </label>
                        <span data-bind="text: format('$1 MB', select(notEquals(volume, 0), decimalFixed(mathDiv(mathMul(volume, interval), 1000000), 2), 0))," style="width:100px;"></span>
                    </div>
                </div>
                <div class="form-inline span12 nomargin">
                    <label class="control-label nomargin" for="targetConnectionStringTbx">
                        <asp:localize runat="server" meta:resourcekey="config_target_con_string_label" />:
                    </label>
                    <button id="testConnectionBtn" class="btn btn-default" style="padding:2px 8px;" data-loading-text="<asp:localize runat=server meta:resourcekey=test_connection_btn_loading_lbl />">
                        <asp:localize runat=server meta:resourcekey=test_connection_btn />
                    </button>
                    <span data-bind="text: targetConnectionString, classes: { hide: editing, }," style="float:left;width:98%;height:40px;padding:5px 0;margin-top:5px;"></span>
                    <textarea id="targetConnectionStringTbx" data-bind="value: targetConnectionString, classes: { hide: not(editing), }," style="float:left;margin-top:5px;width:98%;height:40px;"></textarea>
                </div>
            </div>
        </div>
    </div>
</script>
