﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="main_template" type="text/x-handlebars-template">

<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />

<style>
    .blocker {
        position:absolute;
        top:0; 
        left:0; 
        width:100%;
        height:100%;
        background-color:#ccc; 
        opacity:0.4;
        z-index:99999999; 
    }
</style>

<div class="container-fluid">
    <div class="row-fluid">
        <div class="span4">
            <h5><asp:Localize runat="server" meta:resourcekey="lines_and_machines_title" /></h5>
            {{#if addRemoveEnabled}}
            <div style="margin-bottom:5px;">
                <button class="btn btn-mini btn-add-line"><asp:Localize runat="server" meta:resourcekey="add_line_label" /></button>
                <button disabled="disabled" class="btn btn-mini btn-add-machine"><asp:Localize runat="server" meta:resourcekey="add_machine_label" /></button>
            </div>
            {{/if}}
            <div style="height:500px;overflow-y:auto;" class="tree">
            </div>
        </div>
        <div class="span8">
            <%--<div class="machine-configuration-messages row-fluid hide">
                <span style="font-size:14px;">Seleccione una máquina para configurar.</span>
            </div>--%>
            <div class="machine-configuration-container row-fluid">
            </div>
        </div>
    </div>
</div>

</script>

<script id="machine_configuration" type="text/x-handlebars-template">
    <div class="container-fluid">
        <div class="row-fluid">
            <h5><asp:Localize runat="server" meta:resourcekey="configuration_title" /></h5>
        </div>
        <div data-bind="toggle: hasBatchOpened" class="row-fluid batch-opened-message">
            <div class="alert alert-info">
                <span>
                    <asp:Localize runat="server" meta:resourcekey="batch_opened_on_machine_msg" />
                </span>
            </div>
        </div>
        <div style="position:relative;" class="row-fluid">
            <div data-bind="toggle: hasBatchOpened" class="blocker"></div>
            <div class="row-fluid">
                <h5><asp:Localize runat="server" meta:resourcekey="availability_title" /></h5>
            </div>
            <div class="row-fluid">
                <form class="form-horizontal">
                    <div class="control-group">
                        <label class="control-label" for="selectbasic"><asp:Localize runat="server" meta:resourcekey="line_running_tag_label" /></label>
                        <div class="controls">
                            <select data-bind="value: integer(runningTag), options: tagsBindingDigital, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_option_label />', value: -1 }" id="selectbasic" name="selectbasic" class="input-xlarge">
                            </select>
                            <div style="margin-top:2px;">
                                <label class="checkbox" for="checkboxes-0">
                                    <asp:Localize runat="server" meta:resourcekey="ascending_flank_running" />
                                    <input data-bind="checked: not(runningTagAscendingFlank)" type="checkbox" name="checkboxes" id="checkboxes-0">
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="textinput"><asp:Localize runat="server" meta:resourcekey="micro_delays" /></label>
                        <div class="controls">
                            <input data-bind="value: microDelayValue, events: ['keyup']" id="textinput" name="textinput" type="text" class="input-mini">
                            <select data-bind="value: microDelayTime, optionsDefault: 'DEFAULT'" class="input-medium">
                                <option value='DEFAULT'>...</option>
                                <option value='SECOND'><asp:Localize runat="server" meta:resourcekey="seconds_option_label" /></option>
                                <option value='MINUTE'><asp:Localize runat="server" meta:resourcekey="minutes_option_label" /></option>
                            </select>
                        </div>
                    </div>
                </form>
            </div>
            {{#if showQualityConfiguration}}
            <div class="row-fluid">
                <h5>Calidad</h5>
            </div>
            <div class="row-fluid">
                <form class="form-horizontal">
                    <div class="control-group">
                        <label class="control-label" for="selectbasic"><asp:Localize runat="server" meta:resourcekey="good_products_tag" /></label>
                        <div class="controls">
                            <select data-bind="value: integer(unitProducedTagId), options: tagsBinding, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_option_label />', value: -1 }" id="select1" name="selectbasic" class="input-xlarge">
                            </select>
                            <div style="margin-top:0px;">
                                <label class="checkbox" for="checkbox-only-good-units">
                                    <asp:Localize runat="server" meta:resourcekey="counts_only_good_units" />
                                    <input data-bind="checked: not(unitProducedIncludesBadUnits)" type="checkbox" name="checkboxes" id="checkbox-only-good-units">
                                </label>
                            </div>
                            <div data-bind="css:{ visibility: select(equals(unitProducedTagType, 'DIGITAL'), 'visible', 'hidden') }" style="margin-top:2px;">
                                <label class="checkbox" for="checkboxes-1">
                                    <asp:Localize runat="server" meta:resourcekey="ascending_flank_counter" />
                                    <input data-bind="checked: not(unitProducedTagAscendingFlank)" type="checkbox" name="checkboxes" id="checkboxes-1">
                                </label>
                            </div>
                        </div>
                    </div>
                    <div style="position:relative;top:-25px;margin-bottom:0px;" data-bind="css: { display: select(all(equals(unitProducedTagType, 'REAL'), notEquals(unitProducedAgentType, 'DASH')), 'inline-block', 'none') }" class="counter-resets-at control-group">
                        <label class="control-label" for="textinput"><asp:Localize runat="server" meta:resourcekey="counter_resets_at" /></label>
                        <div class="controls">
                            <input data-bind="value: unitProducedTagResetsAt, events: ['keyup']" name="textinput" type="text" class="input-medium">
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="selectbasic"><asp:Localize runat="server" meta:resourcekey="bad_products_tag" /></label>
                        <div class="controls">
                            <select data-bind="value: integer(badUnitProducedTagId), options: tagsBinding, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_option_label />', value: -1 }" id="select2" name="selectbasic" class="input-xlarge">
                            </select>
                            <div data-bind="css: { visibility: select(equals(badUnitProducedTagType, 'DIGITAL'), 'visible', 'hidden') }" style="margin-top:2px;">
                                <label class="checkbox" for="checkboxes-2">
                                    <asp:Localize runat="server" meta:resourcekey="ascending_flank_counter" />
                                    <input data-bind="checked: not(badUnitProducedTagAscendingFlank)" type="checkbox" name="checkboxes" id="checkboxes-2">
                                </label>
                            </div>
                        </div>
                    </div>
                    <div style="position:relative;top:-25px;margin-bottom:0px;" data-bind="css: { display: select(all(equals(badUnitProducedTagType, 'REAL'), notEquals(badUnitProducedAgentType, 'DASH')), 'inline-block', 'none') }" class="control-group">
                        <label class="control-label" for="textinput"><asp:Localize runat="server" meta:resourcekey="counter_resets_at" /></label>
                        <div class="controls">
                            <input data-bind="value: badUnitProducedTagResetsAt, events: ['keyup']" name="textinput" type="text" class="input-medium">
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="selectbasic"><asp:Localize runat="server" meta:resourcekey="maintenance_tag" /></label>
                        <div class="controls">
                            <select data-bind="value: integer(maintenanceModeTagId), options: tagsBindingDigital, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_option_label />', value: -1 }" id="select5" name="selectbasic" class="input-xlarge">
                            </select>
                            <div style="margin-top:2px;">
                                <label class="checkbox" for="checkboxes-3">
                                    <asp:Localize runat="server" meta:resourcekey="ascending_flank_maintenance" />
                                    <input data-bind="checked: not(maintenanceModeTagAscendingFlank)" type="checkbox" name="checkboxes" id="checkboxes-3">
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="selectbasic"><asp:Localize runat="server" meta:resourcekey="maintenance_delay_code_id" /></label>
                        <div class="controls">
                            <select data-bind="value: integer(maintenanceModeDelayCodeId), options: delayCodesBinding, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_option_label />', value: -1 }" id="select6" name="selectbasic" class="input-xlarge">
                            </select>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        {{/if}}
        <div style="margin-top:8px;" class="row-fluid">
            <div class="span6 offset3">
                <div class="span6">
                    <button disabled="disabled" class="btn btn-primary btn-block btn-save"><asp:Localize runat="server" meta:resourcekey="save_label" /></button>
                </div>
                <div class="span6">
                    <button disabled="disabled" class="btn btn-block btn-cancel"><asp:Localize runat="server" meta:resourcekey="cancel_label" /></button>
                </div>
            </div>
        </div>
    </div>
</script>