﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />


<div class="row-fluid subnavbar fixed-subnavbar" id="subnavbar_controls" style="margin-bottom: 0px;height:5px !important;">
    <div class="row-fluid form-inline">
        
         <button id="refreshBtn" class="btn btn-primary pull-right" style="margin-right: 10px;margin-bottom: -5px !important;margin-top: -5px !important;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
            <i class="fa fa-refresh"></i>
        </button>
    </div>

</div>

<div class="row-fluid screen-content">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(not(hasData), not(isLoading))), }," style="height:500px;">
    <div class="row-fluid" style="position:relative;top:100px;">
        <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:115px;">
        <h3 style="font-size:50px;">
            <asp:localize runat=server meta:resourcekey="no_data_available" />
        </h3>
    </div>
</div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(isLoading)), }," style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat=server meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>

    <div class="row-fluid"  data-bind="classes: { hide: not(all(hasData, not(isLoading))), },">
        <div class="span6">        
             <label class="title-strand">Strand 1</label>
            <div class="row-fluid items-grid-container-strand1"></div>
        </div>
        <div class="span6">        
             <label class="title-strand">Strand 2</label>
            <div class="row-fluid items-grid-container-strand2"></div>
        </div>
    </div>
    <div class="row-fluid" style="margin-top:10px;" data-bind="classes: { hide: not(all(hasData, not(isLoading))), },">
       <div class="span6">        
            <label class="title-strand">Strand 3</label>
            <div class="row-fluid items-grid-container-strand3"></div>
        </div>
        <div class="span6">        
             <label class="title-strand">Strand 4</label>
            <div class="row-fluid items-grid-container-strand4"></div>
        </div>
    </div>
          
    <div class="row-fluid" style="margin-top:10px; width:95%;margin-left:2%"  data-bind="classes: { hide: not(all(hasData, not(isLoading))), },">
           <div class="span6 row-fluid">
                <div class="span4"></div>
                <div class="span4">
                    <button id="saveBtn" class="btn btn-primary" style="width: 100%;height: 50px;">
                        SAVE
                    </button>
                </div>
           </div>
           <div class="span6 row-fluid">
                <div class="span4"></div>
                <div class="span4">
                  <button id="cancelBtn" class="btn btn-secondary" style="width: 100%;height: 50px;">
                    CANCEL
                </button>
                </div>
           </div>
      
        </div>
          
</div>



<%--<script id="subnavbar_controls_caster_equipments" type="text/x-handlebars-template">
    <div class="span12">
        <div class="subnavbar-toolbar form-inline">
            <button id="refreshBtn" class="btn btn-primary pull-right" style="margin-right: 10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                <i class="fa fa-refresh"></i>
            </button>
        </div>
    </div>
</script>--%>




<script id="actions_cell_template_caster_equipment_no_type" type="text/x-handlebars-template">
    <div class="text-center">
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DONE" class="btn btn-cell-action btn-small btn-done btn-success">Done</button>
     </div>
</script>
