﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<%--<link href="<%= ResolveUrl("~/app/custom-screens/melt-shop-overview/melt-shop-overview.css")%>" rel="stylesheet" />--%>
<link href="<%= ResolveUrl("~/assets/libs/js/jquery.contextMenu/jquery.contextMenu.css") %>" rel="stylesheet" />

<div class="row-fluid screen-content">
    <div>
        <button id="BackToSupervisionScreen" class="btn btn-primary">❮❮ Back to Supervision Screen</button>
    </div>
    <hr />

    <div class="no-data-poster row-fluid text-center animated fadeIn not-print" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    <div class="processes-grid-container"  data-bind="classes: { hide: isLoading, }"></div>    
</div>

<script id="assign_heats_torch_modal" type="text/x-handlebars-template">
    <div class="modal-header" >    
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4>
            <span data-bind="text: title" style="font-weight:bold;"></span>
        </h4>    
    </div>
    <div class="modal-body">
        <div style="padding-bottom:0;" class="modal-body">
            <div class="row-fluid">                 
                
                <div class="pull-left" style="width:100%;margin-left:0;">  
                        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:350px;">
                            <div class="row-fluid" style="position:relative;top:100px;">
                                <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
                            </div>
                            <div class="row-fluid" style="position:relative;top:115px;">
                                <h3 style="font-size:50px;">
                                    <asp:localize runat="server" meta:resourcekey="no_data_available" />
                                </h3>
                            </div>
                        </div>
                        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:350px;">
                            <div class="row-fluid" style="position:relative;top:100px;">
                                <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                            </div>
                            <div class="row-fluid" style="position:relative;top:115px;">
                                <h3 style="font-size:50px;">
                                    <asp:localize runat="server" meta:resourcekey="loading_data" />
                                </h3>
                            </div>
                        </div>
                </div>
               
                <div class="last-heats-grid-container row-fluid infinite-container" data-bind="classes: { hide: any(not(hasData), isLoading), }"></div>   

            </div>
        </div>
    </div>
    <div class="modal-footer">
        <div class="modal-status-msg-container pull-left">
            <div class="modal-status-msg hide" data-bind="toggle: notEquals(errorMsg, ''),">
                <span data-bind="text: errorMsg, attr: { title: errorMsg, }," style="color:#ff0000;font-size:16px;"></span>
            </div>
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>
        <button  id="unassignBtn" class="btn btn-primary btn-danger" data-bind="enabled: not(processing), classes: { hide: not(show_unassign_btn), }">
            <asp:Localize runat='server' meta:resourcekey='unassign_btn_label' />
        </button>
        <button id="acceptBtn" class="btn btn-primary" data-bind="enabled: all(not(processing), selectedHeatId),">
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        
        <button id="cancelBtn" class="btn" data-dismiss="modal" data-bind="enabled: not(processing),">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>


    </div>
</script>



