﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jquery.contextMenu/jquery.contextMenu.css") %>" rel="stylesheet" />
<div class="row-fluid subnavbar fixed-subnavbar" id="subnavbar_controls" style="margin-bottom: 0px;height:18px !important;">
    <div class="row-fluid form-inline">
        <div class="row-fluid">
            <div class="span2 pull-right">                
                <button id="TWIBtn" class="btn btn-primary" style="width:50%;height:50%">TWI</button>
            </div>
            <div class="span2 pull-right">                
                <button id="LadleOpenBtn" class="btn btn-primary" style="width:70%;height:50%">Manual Ladle Open</button>
            </div>
        </div>
    </div>
</div>
<div class="row-fluid screen-content">
    <div class="pull-left" style="width:100%;margin-left:0;">  
        <div class="row-fluid" style="margin-bottom:2%">
            <div class="span8">
                
                <div class="processes-grid-container" style="margin-top:20px"></div>

                <div style="margin-top: 5px !important;">
                    <table id="#products">
                    <tr>
                        <th style="width:15% !important"></th>
                        <th style="width:51.2% !important"></th>
                        <th style="width:4.25% !important">Speed</th>
                        <th style="width:4.25% !important">Preset</th>
                        <th style="width:4.25% !important">Measured</th>
                        <th style="width:4.25% !important">Solid Rem.</th>
                        <th style="width:4.25% !important">Tundish Rem.</th>
                        <th style="width:4.25% !important">Total Rem.</th>
                        <th style="width:2.05% !important"></th>

                    </tr>
            
                    <tr>
                        <td><svg height="50px" id="graph1_p"  style="width:100% !important"></svg></td>
                        <td><svg height="50px" id="graph1"  style="width:100% !important"></svg></td>  
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:Speed_S1"  readonly /></td>
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:SP_S1"  readonly /></td>    
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:Mesured_S1"  readonly /></td>         
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:RemainingSolid_S1"  readonly /></td>                
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:RemainingLiquid_S1"  readonly /></td>           
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:TotalRemaining_S1"  readonly /></td>
                        <td>S1</td>
                

                    </tr>    
                    <tr>
                
                        <td><svg height="50px" id="graph2_p" style="width:100% !important"></svg></td>
                        <td><svg height="50px" id="graph2"  style="width:100% !important"></svg></td>       
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:Speed_S2"  readonly /></td>
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:SP_S2"  readonly /></td>   
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:Mesured_S2"  readonly /></td>     
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:RemainingSolid_S2"  readonly /></td>                
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:RemainingLiquid_S2"  readonly /></td>        
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:TotalRemaining_S2"  readonly /></td>
                        <td>S2</td>


            
                    </tr>
                    <tr>
                        <td><svg height="50px" id="graph3_p"  style="width:100% !important"></svg></td>
                        <td><svg height="50px" id="graph3" style="width:100% !important"></svg></td>     
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:Speed_S3"  readonly /></td>
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:SP_S3"  readonly /></td> 
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:Mesured_S3"  readonly /></td>   
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:RemainingSolid_S3"  readonly /></td>                
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:RemainingLiquid_S3"  readonly /></td>        
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:TotalRemaining_S3"  readonly /></td>
                
                        <td>S3</td>

                
                    </tr>
                    <tr>
                
                        <td><svg height="50px" id="graph4_p"  style="width:100% !important"></svg></td>
                        <td><svg height="50px" id="graph4"  style="width:100% !important"></svg></td>         
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:Speed_S4"  readonly /></td>
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:SP_S4"  readonly /></td>  
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:Mesured_S4"  readonly /></td>   
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:RemainingSolid_S4"  readonly /></td>                
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:RemainingLiquid_S4"  readonly /></td>        
                        <td style="text-align:center"><input type="text" style="width:50px; text-align:center;" data-bind="value:TotalRemaining_S4"  readonly /></td>
                        <td>S4</td>
          
                    </tr>
                </table>
                </div>
            </div>
            <div class="span4 row-fluid">
                <div class="row-fluid">
                    <div class="span5">
                        <label class="control-label" style="font-weight: bold;">
                            <asp:localize runat="server" meta:resourcekey="search_label" />
                            <input type="text" style="width:160px;" id="search" data-bind="value: search," placeholder="<asp:Localize runat=server meta:resourcekey=search_place_holder />"/>           
                        </label>
                    </div>
                    <div class="span5">                        
                         <label class="control-label" style="font-weight: bold;">
                            <asp:localize runat="server" meta:resourcekey="strand_combo_label" />
                            <select style="width:100px;" id="strands" data-bind="value: strandId, options: strands, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=strand_combo_all_opt />', value: '-' },disabled:  disabledStrandPicker "></select> 
                        </label>
                    </div>
                    <div class="span2">
                        <button class="btn btn-primary pull-right" id="backToRealTime" style="width:112px;margin-top:5px" data-bind="disabled:  realTime">Go Real Time</button>
                    </div>
                </div>
               

                <div class="products-grid-container" id="main-div" style="margin-top:20px" data-bind="classes: { hide: isLoading_products, }" ></div>
                <div class="no-data-poster row-fluid text-center animated fadeIn not-print" data-bind="classes: { hide: not(isLoading_products), }" style="height:500px;">
                    <div class="row-fluid" style="position:relative;top:100px;">
                        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                    </div>
                    <div class="row-fluid" style="position:relative;top:115px;">
                        <h3 style="font-size:50px;">
                            <asp:localize runat="server" meta:resourcekey="loading_data" />
                        </h3>
                    </div>
                </div>




                <div  data-bind="classes: { hide: not(showNewProductGrid), }" style="margin-top:20px">
                    <label class="control-label col-class entry-label" style="padding-right: 0px;">
                        <asp:localize runat="server" meta:resourcekey="new_product_label" />
                    </label> 
                </div>
                <div class="new-products-grid-container" style="margin-top:20px"  data-bind="classes: { hide: not(showNewProductGrid), }"></div>  
                <div class="span6" data-bind="classes: { hide: not(showNewProductGrid), }" style="margin-top:10px;">
                    <button id="saveBtn" class="btn btn-primary" style="width:100%; height:50px;">
                        <asp:Localize runat="server" meta:resourcekey="save_item_btn_label" />
                    </button>
                </div>
                <div class ="span4" data-bind="classes: { hide: not(showNewProductGrid), }" style="margin-top:10px;">
                    <button id="hideNewProductGridBtn" class="btn btn-secondary" style="width:100%">
                        <asp:Localize runat="server" meta:resourcekey="cancel_item_btn_label" />
                    </button>
                </div>


            </div>
        </div>

       
    </div>
</div>


<script id="actions_cell_template" type="text/x-handlebars-template">
    <div class="text-center">
         <button data-toggle="tooltip" data-placement="bottom" data-cell-action="EDIT_DETAILS" title="<asp:Localize runat=server meta:resourcekey=edit_details_title />" class="btn btn-cell-action btn-small btn-edit-details"><i class="fa fa-pencil"></i></button>
    </div>
</script>

<script id="assign_heats_torch_modal" type="text/x-handlebars-template">
    <div class="modal-header" >    
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4>
            <span data-bind="text: title" style="font-weight:bold;"></span>
        </h4>    
    </div>
    <div class="modal-body">
        <div style="padding-bottom:0;" class="modal-body">
            <div class="row-fluid">                 
                
                <div class="pull-left" style="width:100%;margin-left:0;">  
                        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:350px;">
                            <div class="row-fluid" style="position:relative;top:100px;">
                                <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
                            </div>
                            <div class="row-fluid" style="position:relative;top:115px;">
                                <h3 style="font-size:50px;">
                                    <asp:localize runat="server" meta:resourcekey="no_data_available" />
                                </h3>
                            </div>
                        </div>
                        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:350px;">
                            <div class="row-fluid" style="position:relative;top:100px;">
                                <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                            </div>
                            <div class="row-fluid" style="position:relative;top:115px;">
                                <h3 style="font-size:50px;">
                                    <asp:localize runat="server" meta:resourcekey="loading_data" />
                                </h3>
                            </div>
                        </div>
                </div>
               
                <div class="last-heats-grid-container row-fluid infinite-container" data-bind="classes: { hide: any(not(hasData), isLoading), }"></div>   

            </div>
        </div>
    </div>
    <div class="modal-footer">
        <div class="modal-status-msg-container pull-left">
            <div class="modal-status-msg hide" data-bind="toggle: notEquals(errorMsg, ''),">
                <span data-bind="text: errorMsg, attr: { title: errorMsg, }," style="color:#ff0000;font-size:16px;"></span>
            </div>
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>
        <button  id="unassignBtn" class="btn btn-primary btn-danger" data-bind="enabled: not(processing), classes: { hide: not(show_unassign_btn), }">
            <asp:Localize runat='server' meta:resourcekey='unassign_btn_label' />
        </button>
        <button id="acceptBtn" class="btn btn-primary" data-bind="enabled: all(not(processing), selectedHeatId),">
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        
        <button id="cancelBtn" class="btn" data-dismiss="modal" data-bind="enabled: not(processing),">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>


    </div>
</script>


<script id="split_product_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat='server' meta:resourcekey='split_product_modal_title' /></h3>        
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:300px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=product_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;"data-bind="value: productNumber" disabled>
                </div>
            </div>
          <%--  <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=length_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: length" disabled/>
                </div>
            </div>--%>
            <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=piece_length_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: pieceLength" />
                </div>
            </div>
            <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=scrap_length_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" <%--data-bind="value: trim(heat), enabled: false,"--%> data-bind="value: scrapLength" />
                </div>
            </div>
        </div>
      
    </div>
    <div class="modal-footer">
    <%--    <button id="acceptBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_split_product_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_split_product_btn_label /></button>--%>

           <button id="acceptBtn" class="btn btn-primary" >
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        
        <button id="cancelBtn" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>

    </div>
</script>