﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
   
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
 
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<%--<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />--%>
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />


<%-- SOURCE CODE IDEA --%>
<%--https://medium.com/@Idan_Co/the-ultimate-print-html-template-with-header-footer-568f415f6d2a--%>
<%--https://plnkr.co/edit/lWk6Yd?preview--%>


<%-- PDF --%>
<div class="print">
    <div id="pageborder"></div>
    <div class="contentborder"></div>
    <div class="screen-content">

        <div class="page-header" style="text-align: center">
            <div class="img-logo">
                <img src='<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" +"sdi-logo.svg") %>' />
            </div>
            <div class="sdi-company-name">               
                <img src='<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" +"sdi.svg") %>' class="img-company-name"/>
            </div>
            <div class="sdi-division">               
                <img src='<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" +"sdi-division.svg") %>' class="img-sdi-division"/>
            </div>

            <div class="report-name-container">                
                <span class="report-name">Caster Shift Report</span>             
            </div>
            <div class="line-division-top"></div>
            <div class="shift-container">        
               <span class="shift-name" id="shift-name"></span>
            </div>
    
            <div class="line-division-bottom"></div>
        </div>

        <div class="page-footer">
   
        </div>

        <table style="width:100%">

            <thead>
                <tr>
                    <td>
                        <div class="page-header-space"></div>
                    </td>
                </tr>
            </thead>

            <tbody>
                <tr>
                <td>
                    <div class="page first-page">
                                             

                        <div class="flex-container">  
                            <div>
                                <div class="items-grid-container-shift-resume items-grid-container"></div>
                                <div class="items-grid-container-warehouse-costs items-grid-container"></div>

                            </div>
                    
                            <div class="items-grid-container-products-cast items-grid-container"></div>
                  
                        </div>
                
                        <div class="items-grid-container-log-book items-grid-container"></div>

                    </div>
               
                    <div class="page page-caster-1" > 
                        <div data-bind="classes: { hide: not(showCaster1Data), }">
                            <div class="items-grid-container-shift-resume-caster-1 items-grid-container" ></div>
                            <div class="items-grid-container-uncut-tails-caster-1 items-grid-container" data-bind="classes: { hide: not(showCaster1UncutTails), }"></div>
                            <svg style="margin-top:20px;width:100% !important;margin-left: 2px;" class="caster1-gantt"></svg>
                                <div id="refs-caster1" style="display:flex; justify-content:center;margin-top:10px;margin-bottom:0px;"></div>
                                <div id="refs-caster1-categories" style="display:flex; justify-content:center;margin-top:0px;margin-bottom:0px;"></div>
                             <div class="items-grid-container-delays1 items-grid-container"  data-bind="classes: { hide: not(showDelaysCaster1Data), }" ></div>
                            <div class="items-grid-container-melt-order-caster-1 items-grid-container"></div>
                        </div>
                        <div style="display:flex;justify-content:center">
                            <label data-bind="classes: { hide: showCaster1Data, }">Caster 1 - data no available</label>
                        </div>
                    </div>
                    <div class="page page-caster-2">
                        <div data-bind="classes: { hide: not(showCaster2Data), }">
                            <div class="items-grid-container-shift-resume-caster-2 items-grid-container"></div> 
                            <svg style="margin-top:20px;width:100% !important;margin-left: 2px;" class="caster2-gantt"></svg>                            
                            <div id="refs-caster2" style="display:flex; justify-content:center;margin-top:10px;margin-bottom:0px;"></div>
                            <div id="refs-caster2-categories" style="display:flex; justify-content:center;margin-top:0px;margin-bottom:0px;"></div>
                            <div data-bind="classes: { hide: not(showDelaysCaster2Data), }" class="items-grid-container-delays2 items-grid-container" ></div>
                            <div class="items-grid-container-melt-order-caster-2 items-grid-container"></div>   
                        </div>
                        <div style="display:flex;justify-content:center">
                            <label data-bind="classes: { hide: showCaster2Data, }">Caster 2  - data no available</label>
                        </div>
                    </div>

                </td>
                </tr>
            </tbody>

            <tfoot>
                <tr>
                <td>
                    <div class="page-footer-space"></div>
                </td>
                </tr>
            </tfoot>

        </table>
    </div>
</div>




<%-- SCREEN --%>

<%-- PICKERS --%>
<div class="not-print">
    <div class="row-fluid subnavbar fixed-subnavbar" style="min-width:1305px;margin-top: -1px;height: 45px !important;"> 
        <div class="form-inline pull-left span12" style="min-width:1260px;"> 
      
        
            <label class="control-label" id="shift">
                <button id="backNavBtn" class="btn btn-primary " style="margin-bottom:5px;margin-right:5px;" data-bind="disabled:  isLoading">
                            <asp:Localize runat="server" meta:resourcekey="back_item_btn_label" />
                </button> 
  
                <label class="input-prepend" id="date" style="margin-bottom:5px;">
                    <span class="add-on"><i class="icon-calendar"></i></span>
                    <input type="text" id="productionDateTbx" class="input-date" style="width:75px;z-index:1000;" data-bind="value: productionDate, disabled: isLoading ">
                </label>
            
                <input type="text" style="width:20px; text-align:center; margin-top: -5px;" data-bind="value:shiftId"  readonly />
                <button id="forwardNavBtn" class="btn btn-primary" style="margin-bottom:5px;margin-left:10px;" data-bind="disabled:  isLoading">
                            <asp:Localize runat="server" meta:resourcekey="forward_item_btn_label" />
                </button>
            </label>
        
            <button id="refreshBtn" class="btn btn-primary" style="margin-bottom:5px;margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />"  data-bind=" disabled: isLoading">
                <i class="fa fa-refresh"></i>
            </button>

            <div class="pull-right" style="margin-right:10px;">
                <button id="printBtn" class="btn btn-primary"  style="margin-bottom:5px;margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=print_btn_title />"  data-bind="disabled:  any(not(hasData), isLoading)" >
                    <i class="fa fa-print"></i>
                </button>
                <button style="margin-top:0; margin-left:10px; margin-right:10px;" class="btn btn-export-to-excel pull-right hide" type="button">
                    <span class="excel-export-state fa fa-file-excel-o"></span>
                    <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
                </button>
            </div>
        
        </div>
    </div>
</div>


<%-- LOADING and NO DATA AVAILABLE --%>
<div class="row-fluid screen-content">
    <div class="no-data-poster row-fluid text-center animated fadeIn not-print" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:200px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:215px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div> 
    <div class="no-data-poster row-fluid text-center animated fadeIn not-print" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:200px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:215px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
</div>


<%-- SCREEN CONTENT --%>
<div class="not-print screen-content" data-bind="classes: { hide: any(not(hasData), isLoading), }">   
    
    <div style="margin-top:50px;">
        <h3>Main Data</h3>
        <div class="row-fluid ">  
            <div class="span5">                    
                <div class="items-grid-container-warehouse-costs-screen items-grid-container"></div>
                <div class="items-grid-container-shift-resume-screen items-grid-container"></div> 
                <div class="items-grid-container-products-cast-screen items-grid-container"></div>
             
            </div>
            <div class="span7">
                 <div class="items-grid-container-log-book-screen items-grid-container" ></div>
            </div>              
        </div>   
       
        <div class="row-fluid" style="margin-top:10px">

            <div data-bind="classes: { hide: not(showCaster1Data), }">                
                <h3>Caster 1</h3>
                <div style="display:flex; justify-content:center;margin-top:20px;margin-bottom:20px;"> 
                    <svg class="caster1-gantt-screen"></svg>                    
                </div>
                     <div id="refs-screen-caster1" style="display:flex; justify-content:center;margin-top:10px;margin-bottom:0px;"></div>
                    <div id="refs-screen-caster1-categories" style="display:flex; justify-content:center;margin-top:0px;margin-bottom:0px;"></div>
                 <div class="row-fluid">
                    <div class="span3">
                    </div>
                    <div class="span6">
                        <div class="items-grid-container-delays1-screen items-grid-container"  data-bind="classes: { hide: not(showDelaysCaster1Data), }" ></div>   

                    </div>
                </div>  
                <div class="row-fluid">                  
                    <div class="span5">
                        <div class="items-grid-container-shift-resume-caster-1-screen items-grid-container"></div> 
                        <div class="items-grid-container-uncut-tails-caster-1-screen items-grid-container" data-bind="classes: { hide: not(showCaster1UncutTails), }"></div>  
                    </div>
                    <div class="span7">
                        <div class="items-grid-container-melt-order-caster-1-screen items-grid-container" id="caster1-production"></div>
                    </div>
                </div>  
            </div>
           
        </div>
      

        <div class="row-fluid" style="margin-top:10px">

            <div data-bind="classes: { hide: not(showCaster2Data), }">  
            <h3>Caster 2</h3>               
                <div style="display:flex; justify-content:center;margin-top:20px;margin-bottom:20px;"> 
                    <svg class="caster2-gantt-screen"></svg>                    
                </div>
                    <div id="refs-screen-caster2" style="display:flex; justify-content:center;margin-top:10px;margin-bottom:0px;"></div>
                    <div id="refs-screen-caster2-categories" style="display:flex; justify-content:center;margin-top:0px;margin-bottom:0px;"></div>
                 <div class="row-fluid">
                    <div class="span3">
                    </div>
                    <div class="span6">
                        <div class="items-grid-container-delays2-screen items-grid-container"  data-bind="classes: { hide: not(showDelaysCaster2Data), }" ></div>   

                    </div>
                </div>  
                <div class="row-fluid">                  
                    <div class="span5">
                        <div class="items-grid-container-shift-resume-caster-2-screen items-grid-container"></div>                
                    </div>
                    <div class="span7">
                        <div class="items-grid-container-melt-order-caster-2-screen items-grid-container" id="caster2-production"></div>
                    </div>
                </div>      
            </div>   
        </div>
      
    </div>
                   


</div>