﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<!-- 8 -->
<div class="row-fluid subnavbar fixed-subnavbar">
    <div class="row-fluid form-inline">
        <div class="span12">
            <label class="control-label" for="dateStartTbx">
                <asp:localize runat="server" meta:resourcekey="date_start_tbx_label" />
            </label>
            <label class="input-prepend">
                <span class="add-on"><i class="icon-calendar"></i></span>
                <input type="text" id="dateStartTbx" class="input-date" style="z-index: 1000;" data-bind="value: momentFormat(start$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
            </label>
            <label class="control-label" for="dateEndTbx">
                <asp:localize runat="server" meta:resourcekey="date_end_tbx_label" />
            </label>
            <label class="input-prepend">
                <span class="add-on"><i class="icon-calendar"></i></span>
                <input type="text" id="dateEndTbx" class="input-date" style="z-index: 1000;" data-bind="value: momentFormat(end$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
            </label>
            <label style="margin-left: 10px; margin-bottom: 0 !important;">
                <asp:localize runat="server" meta:resourcekey="furnace_label" />
                <select data-bind=" value: furnaceCode, options: furnaces, optionsDefault: { label: 'A', value: 1 }" style="width: 100px; margin-top: 0px;">
                </select>
            </label>
            <button id="refreshBtn" class="btn btn-primary" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                <i class="fa fa-refresh"></i>
            </button>
             <button style="margin-top:0; margin-left:10px; margin-right:10px;" class="btn btn-export-to-excel pull-right" type="button">
                <span class="excel-export-state fa fa-file-excel-o"></span>
                <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
            </button>
        </div>


    </div>
  
</div>

<div class="row-fluid screen-content">
      <div <%--class=" infinite-container"--%> style="margin-top: 20px">
        <div class="row-fluid">
            <div class='span12'>
                <div id="chart" style="min-width: 310px; width: 50%; margin: 0 auto"></div>
            </div>
        </div>
        <div class="row-fluid">
            <div class='span4'>
                <h3>Phase A</h3>
                <div class="grid-container1 " style="margin-top: 20px"></div>
            </div>
            <div class='span4'>
                <h3>Phase B</h3>
                <div class="grid-container2 " style="margin-top: 20px"></div>
            </div>
            <div class='span4'>
                <h3>Phase C</h3>
                <div class="grid-container3 " style="margin-top: 20px"></div>
            </div>

        </div>
    </div>
</div>